$(function () {


    $('body').on('click', '[target=ajax]', function () {
        $(this).ajax();
        return false;
    });

    layui.form.on('submit', function (data) {
        var form = data.form || $(data.elem).is('form') ? data.elem : null
        if (!$.validatorFunc(form)) return false;
        $(form).ajax();
        return false;
    });

    layui.uploadRender = function (options) {
        options = $.isPlainObject(options) ? options : {};
        return layui.upload.render($.extend({
            elem: '[lay-upload]',
            accept: 'file',
            before: function (obj) {
                this.loadlayer = $.loading.show({
                    content: '<i class="pa up-progress" style="bottom: -20px;left:50%;transform: translateX(-50%);color:#8cf118">0%</i>',
                });
            },
            progress: function (n, elem, res, index) {
                $('i.up-progress', '#layui-layer' + this.loadlayer).html(n + '%');
            },
            done: function (res, index, upload) {
                $.loading.hide();
                var item = this.item,
                    callback = $(item).data('callback') || options.callback;
                if (callback && callback.call(item, res) === false) return;
                res && res.msg && $.showMsg(res.code, res.msg);
                if (res && res.url) {
                    var $p = $(item).parent();
                    $('[lay-upvalue]', $p).val(res.url);
                    $('[lay-uphref]', $p).attr('href', res.url);
                    $('[lay-upsrc]', $p).attr('src', res.url);
                }
            },
            error: function () {
                $.loading.hide();
            }
        }, options));
    };

    layui.uploadRender();

    layui.render = function ($container) {
        layui.element.render();
        layui.form.render();
        layui.uploadRender();
    };
});