-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.6
-- Date : 2022-01-12 17:19:03
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1641976280', '127.0.0.1', '299', '', '0', '1', 'cn', '1', '1', '1586479354', '1636420548');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', '', 'guanyuwomen', '0', '', '1', '1', '1', '1001', 'single_about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '关于我们', '', '', '<div class=\"row\">\r\n	<img src=\"/storage/images/20220112/1-1510161145111P.jpg\" style=\"width: 80%;\" title=\"人人站CMS健身\" />\r\n	<p>\r\n		厦门人人站CMS健身中心占地面积2800平方米，俱乐部配备力健、星驰等国际著名品牌的健身和测试设备，拥有一大批高水平、高素质的教练队伍和管理团队，属厦门最壕健身中心之一。人人站CMS健身是一个为追求中国梦的健身达人创造有品位、理念 、价值、人性化服务的健身中心，拥有先进的健身俱乐部管理模式和国际时尚的健身体验，凭借着国际化会员管理制度，完善有效的时尚健身项目，国际优秀的专业队伍，舒适开阔的运动环境和人人站CMS健身品牌动感时尚的号召力，成为时尚健身运动的首选场所。</p>\r\n</div>\r\n<br />\r\n', '', 'true', '1641976298');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '健身房', '', 'jianshenfang', '0', '', '2', '1', '2', '1002', 'single_about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '健身房', '', '', '<div class=\"row\">\r\n	<div class=\"projects\">\r\n		<div class=\"span6 element category01\">\r\n			<div class=\"hover_img\">\r\n				<img src=\"/storage/images/20220112/1-151016114I0634.jpg\" title=\"跑步机\" /></div>\r\n			<div class=\"item_description\">\r\n				<h5>\r\n					厦门人人站CMS健身房跑步机渲染图</h5>\r\n			</div>\r\n		</div>\r\n		<div class=\"span6 element category01\">\r\n			<div class=\"hover_img\">\r\n				<img src=\"/storage/images/20220112/1-151016114J5153.jpg\" title=\"踩踏机\" /></div>\r\n			<div class=\"item_description\">\r\n				<h5>\r\n					厦门人人站CMS健身房踩踏机渲染图</h5>\r\n			</div>\r\n		</div>\r\n		<div class=\"span6 element category01\">\r\n			<div class=\"hover_img\">\r\n				<img src=\"/storage/images/20220112/1-151016114P5I8.jpg\" title=\"瑜伽室\" /></div>\r\n			<div class=\"item_description\">\r\n				<h5>\r\n					厦门人人站CMS健身房瑜伽室渲染图</h5>\r\n			</div>\r\n		</div>\r\n		<div class=\"span6 element category01\">\r\n			<div class=\"hover_img\">\r\n				<img src=\"/storage/images/20220112/1-151016114Q6409.jpg\" title=\"休闲区\" /></div>\r\n			<div class=\"item_description\">\r\n				<h5>\r\n					厦门人人站CMS健身房休闲区渲染图</h5>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<br />\r\n', '', 'true', '1641976298');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '课程安排', '', 'kechenganpai', '0', '', '3', '1', '3', '1003', 'kecheng', 'kc', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '课程安排', '', '', '&nbsp;', '', 'true', '1641976298');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '新闻动态', '', 'xinwendongtai', '0', '', '4', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '新闻动态', '', '', '', '', 'true', '1641976298');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '加入我们', '', 'jiaruwomen', '0', '', '5', '1', '5', '1005', 'single_about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '加入我们', '厦门最壕的健身中心 - 厦门人人站CMS健身期待您的加入！教练经理招聘人数：1人薪资待遇：5000～7000底薪+抽成+奖金教练主管招聘人数：4人薪资待遇：3000～5000底薪+抽成+上课课时费+奖金教练成员招聘人数：15人薪资待遇：2000～30', '', '<div class=\"container recruitment\"><h4>\r\n		厦门最壕的健身中心 - 厦门人人站CMS健身期待您的加入！</h4><ul class=\"mainBox clearfix bnNote\"><li class=\"mBox \"><h5 class=\"title\">\r\n				教练经理</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：5000～7000底薪+抽成+奖金</p></li><li class=\"mBox\"><h5 class=\"title\">\r\n				教练主管</h5><p>\r\n				招聘人数：4人</p><p>\r\n				薪资待遇：3000～5000底薪+抽成+上课课时费+奖金</p></li></ul><ul class=\"mainBox clearfix bnNote\"><li class=\"mBox\"><h5 class=\"title\">\r\n				教练成员</h5><p>\r\n				招聘人数：15人</p><p>\r\n				薪资待遇：2000～3000底薪+上课抽成+奖金</p></li><li class=\"mBox\"><h5 class=\"title\">\r\n				巡场教练</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：2500～3000底薪</p></li></ul><ul class=\"mainBox clearfix \"><li class=\"mBox\"><h5 class=\"title\">\r\n				高尔夫球教练</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：3000～5000底薪+上课抽成+奖金</p><p>\r\n				其它说明：有2年以上的高尔夫培训、教学经验</p></li><li class=\"mBox\"><h5 class=\"title\">\r\n				儿童区域老师</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：底薪+抽成+奖金（面议）</p><p>\r\n				其它说明：有耐心、亲和力、专业体校毕业、有儿童体育经验者优先</p></li></ul><ul class=\"mainBox clearfix bnNote\"><li class=\"mBox \"><h5 class=\"title\">\r\n				健身顾问经理</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：5000～7000底薪+抽成+奖金</p></li><li class=\"mBox\"><h5 class=\"title\">\r\n				健身顾问主管</h5><p>\r\n				招聘人数：4人</p><p>\r\n				薪资待遇：3000～5000底薪+抽成+奖金</p></li></ul><ul class=\"mainBox clearfix \"><li class=\"mBox \"><h5 class=\"title\">\r\n				健身顾问</h5><p>\r\n				招聘人数：50人</p><p>\r\n				薪资待遇：2000～2500底薪+抽成（最高20个点）+奖金</p></li></ul><ul class=\"mainBox clearfix \"><li class=\"mBox \"><h5 class=\"title\">\r\n				客服主管</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：3000～5000底薪+抽成+奖金</p><p>\r\n				其它说明：有星级酒店管理经验、培训经验者优先</p></li><li class=\"mBox\"><h5 class=\"title\">\r\n				前台</h5><p>\r\n				招聘人数：1人</p><p>\r\n				薪资待遇：2500～3000底薪+抽成+奖金</p><p>\r\n				其它说明：有酒店服务经验、会所服务经验者优先</p></li></ul><ul class=\"mainBox clearfix bnNote\"><li class=\"mBox\"><h5 class=\"title\">\r\n				美容师</h5><p>\r\n				招聘人数：若干名</p><p>\r\n				薪资待遇：底薪+手工+提成（面议）</p><p>\r\n				其它说明：形象好，气质佳，在18到30岁之间；有一年以上美容美体/纤体，仪器操作经验；沟通理解能力强、技术手法好，有服务意识；有美容师资格证术或者中医证书优先考虑</p></li></ul><div class=\"caveatInfo\"><p>\r\n			厦门人人站CMS健身引进国际知名品牌器械：力健、星驰。提供多样化的服务包括室内标准高尔夫球场、童体适能、VIP私教室、VIP美容美体、VIP休息区、VIP淋浴房、汗蒸房、八角笼等。</p><p>\r\n			公司未来发展方向：在2015年～2016年期间将在厦门开4～6家高档运动中心.结合国内大城市、国外健身规模，打造全厦门独一无二的新规模运动中心！</p><p>\r\n			公司地址：广州市禾祥西路267号之20繁荣广场一、二层</p><p>\r\n			招聘联系人：陈先生</p><p>\r\n			联系电话：159-000-4841</p></div></div><p><br/>\r\n </p>', '', 'true', '1641978117');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '联系我们', '', 'lianxiwomen', '0', '', '6', '1', '6', '1006', 'single_about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '联系我们', '微信公众号：rrzcms_com联系电话：0898-00000详细地址：广东省广州市思明之十繁荣广场一二层网站地址：http://www.rrzcms.com/', '', '<div class=\"wrap\"><div class=\"container\"><div class=\"row\"><div class=\"pagination-centered\"><p><img src=\"http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png\" style=\"width: 172px;\" title=\"动心健身\"/></p><p><span class=\"red\">微信公众号：</span>rrzcms_com</p><p><span class=\"red\">联系电话：</span>0898-00000</p><p><span class=\"red\">详细地址：</span>广东省广州市思明之十繁荣广场一二层</p><p>网站地址：<a>http://www.rrzcms.com/</a></p></div></div></div></div><p><br/></p>', '', 'true', '1641978158');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '3', '综合训练', '', '', '', '<h3 class=\"week\" style=\"margin: 15px 0px 0px; padding: 10px; font-weight: 500; color: rgb(0, 0, 0); font-size: 1.1em; line-height: 25px; border-top-width: 1px; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: rgb(221, 221, 221); font-family: \'Microsoft YaHei\'; background: rgb(236, 247, 255);\">\r\n	综合训练<span class=\"gray\" style=\"color: rgb(153, 153, 153);\">周课表</span></h3>\r\n<table class=\"table table-striped\" style=\"max-width: 100%; border-collapse: collapse; border-spacing: 0px; width: 1170px; margin-bottom: 0px; border-radius: 0px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px; border-left-width: 0px !important; border-right-width: 0px !important;\">\r\n	<colgroup>\r\n		<col width=\"100\" />\r\n		<col />\r\n	</colgroup>\r\n	<thead>\r\n		<tr>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				星期</th>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				时间</th>\r\n		</tr>\r\n	</thead>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				星期一</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				18:20-18:50</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important;\">\r\n				星期四</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important;\">\r\n				18:20-18:50</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				星期五</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				18:20-18:50</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<div class=\"promptTxtBox\" style=\"height: 20px; line-height: 20px; margin: 15px 0px; padding: 10px; color: rgb(255, 255, 255); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(53, 140, 220);\">\r\n	星期一 授课教练：Danny</div>\r\n<div class=\"promptTxtBox\" style=\"height: 20px; line-height: 20px; margin: 15px 0px; padding: 10px; color: rgb(255, 255, 255); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(53, 140, 220);\">\r\n	星期四 授课教练：Jelly</div>\r\n<div class=\"promptTxtBar\" style=\"padding: 10px; line-height: 20px; border-left-width: 3px; border-left-style: solid; border-left-color: rgb(53, 140, 220); color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(243, 243, 243);\">\r\n	<p style=\"margin: 3px 0px; padding: 0px; line-height: 24px; text-indent: 28px;\">\r\n		综合训练</p>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1444968699', '1444968699', 'true', '', '综合训练 周课表 星期 时间 星期一 18:20-18:50 星期四 18:20-18:50 星期五 18:20-18:50 星期一 授课教练：Danny 星期四 授课教练：Jelly 综合训练', '综合,训练,综合,训练,周课表,周,课表,星期,', '157', '1444968688', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '3', '有氧舞蹈', '', '', '', '<h3 class=\"week\" style=\"margin: 15px 0px 0px; padding: 10px; font-weight: 500; color: rgb(0, 0, 0); font-size: 1.1em; line-height: 25px; border-top-width: 1px; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: rgb(221, 221, 221); font-family: \'Microsoft YaHei\'; background: rgb(236, 247, 255);\">\r\n	有氧舞蹈<span class=\"gray\" style=\"color: rgb(153, 153, 153);\">周课表</span></h3>\r\n<table class=\"table table-striped\" style=\"max-width: 100%; border-collapse: collapse; border-spacing: 0px; width: 1170px; margin-bottom: 0px; border-radius: 0px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px; border-left-width: 0px !important; border-right-width: 0px !important;\">\r\n	<colgroup>\r\n		<col width=\"100\" />\r\n		<col />\r\n	</colgroup>\r\n	<thead>\r\n		<tr>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				星期</th>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				时间</th>\r\n		</tr>\r\n	</thead>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				星期五</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				19:00-20:00</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<div class=\"promptTxtBox\" style=\"height: 20px; line-height: 20px; margin: 15px 0px; padding: 10px; color: rgb(255, 255, 255); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(53, 140, 220);\">\r\n	授课教练：Jelly</div>\r\n<div class=\"promptTxtBar\" style=\"padding: 10px; line-height: 20px; border-left-width: 3px; border-left-style: solid; border-left-color: rgb(53, 140, 220); color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(243, 243, 243);\">\r\n	<p style=\"margin: 3px 0px; padding: 0px; line-height: 24px; text-indent: 28px;\">\r\n		有氧舞蹈（AEROBIC DANCE）是配合音乐有节奏地舞动的有氧运动，有氧舞蹈一方面能消耗较多热量，一方面能把许多舞蹈动作健美操化，通过有氧健美操的锻炼形式，反复或进行组合练习。有氧舞蹈动作不象健美操动作比较操化，有氧舞蹈有许多风格，其音乐与舞蹈的结合紧密，锻炼时能达到愉悦身心，同时人的创造、想象、表现和艺术修养等综合能力都能达到提高。</p>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1444968717', '1444968717', 'true', '', '有氧舞蹈 周课表 星期 时间 星期五 19:00-20:00 授课教练：Jelly 有氧舞蹈（AEROBIC DANCE）是配合音乐有节奏地舞动的有氧运动，有氧舞蹈一方面能消耗较多热量，一方面能把许多舞蹈动作健', '有氧,舞蹈,有氧,舞蹈,周课表,周,课表,星期,', '134', '1444968708', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '3', 'HIP-HOP', '', '', '', '<h3 class=\"week\" style=\"margin: 15px 0px 0px; padding: 10px; font-weight: 500; color: rgb(0, 0, 0); font-size: 1.1em; line-height: 25px; border-top-width: 1px; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: rgb(221, 221, 221); font-family: \'Microsoft YaHei\'; background: rgb(236, 247, 255);\">\r\n	HIP-HOP<span class=\"gray\" style=\"color: rgb(153, 153, 153);\">周课表</span></h3>\r\n<table class=\"table table-striped\" style=\"max-width: 100%; border-collapse: collapse; border-spacing: 0px; width: 1170px; margin-bottom: 0px; border-radius: 0px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px; border-left-width: 0px !important; border-right-width: 0px !important;\">\r\n	<colgroup>\r\n		<col width=\"100\" />\r\n		<col />\r\n	</colgroup>\r\n	<thead>\r\n		<tr>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				星期</th>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				时间</th>\r\n		</tr>\r\n	</thead>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				星期六</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				16:00-17:00</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<div class=\"promptTxtBox\" style=\"height: 20px; line-height: 20px; margin: 15px 0px; padding: 10px; color: rgb(255, 255, 255); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(53, 140, 220);\">\r\n	授课教练：帽子</div>\r\n<div class=\"promptTxtBar\" style=\"padding: 10px; line-height: 20px; border-left-width: 3px; border-left-style: solid; border-left-color: rgb(53, 140, 220); color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(243, 243, 243);\">\r\n	<p style=\"margin: 3px 0px; padding: 0px; line-height: 24px; text-indent: 28px;\">\r\n		hiphop街舞是一件有趣又让人激动的事情。Hip hop可以是时髦亦可以很性感，它很考验编舞蹈创造力。</p>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1444969043', '1444969043', 'true', '', 'HIP-HOP 周课表 星期 时间 星期六 16:00-17:00 授课教练：帽子 hiphop街舞是一件有趣又让人激动的事情。Hip hop可以是时髦亦可以很性感，它很考验编舞蹈创造力。', 'HIP-HOP,HIP-HOP,周课表,周,课表,星期,时间', '70', '1444969006', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '3', '中国风', '', '', '', '<h3 class=\"week\" style=\"margin: 15px 0px 0px; padding: 10px; font-weight: 500; color: rgb(0, 0, 0); font-size: 1.1em; line-height: 25px; border-top-width: 1px; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: rgb(221, 221, 221); font-family: \'Microsoft YaHei\'; background: rgb(236, 247, 255);\">\r\n	中国风<span class=\"gray\" style=\"color: rgb(153, 153, 153);\">周课表</span></h3>\r\n<table class=\"table table-striped\" style=\"max-width: 100%; border-collapse: collapse; border-spacing: 0px; width: 1170px; margin-bottom: 0px; border-radius: 0px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px; border-left-width: 0px !important; border-right-width: 0px !important;\">\r\n	<colgroup>\r\n		<col width=\"100\" />\r\n		<col />\r\n	</colgroup>\r\n	<thead>\r\n		<tr>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				星期</th>\r\n			<th style=\"padding: 8px; line-height: 20px; vertical-align: bottom; border-top-width: 0px; border-radius: 0px; text-align: center !important;\">\r\n				时间</th>\r\n		</tr>\r\n	</thead>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				星期六</td>\r\n			<td style=\"padding: 8px; line-height: 20px; vertical-align: top; border-top-style: solid; border-top-color: rgb(221, 221, 221); border-radius: 0px; text-align: center !important; background-color: rgb(249, 249, 249);\">\r\n				17:10-18:10</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<div class=\"promptTxtBox\" style=\"height: 20px; line-height: 20px; margin: 15px 0px; padding: 10px; color: rgb(255, 255, 255); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(53, 140, 220);\">\r\n	授课教练：洋洋</div>\r\n<div class=\"promptTxtBar\" style=\"padding: 10px; line-height: 20px; border-left-width: 3px; border-left-style: solid; border-left-color: rgb(53, 140, 220); color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; background: rgb(243, 243, 243);\">\r\n	<p style=\"margin: 3px 0px; padding: 0px; line-height: 24px; text-indent: 28px;\">\r\n		FOC的全称为Face Of China，FOC中国风健身课程体系是运用中国传统文化结合中国传统养生学以及有氧运动理论来诠释21世纪全新科学化的健身方式和健身理念，这是我们中国的民族艺术及传统的养生之道与国际先进、科学的健身方式接轨，打造出的具有中国特色的健身课程体系。FOC课程体系共有I-DANCE和I-NNERGY两部分组成。</p>\r\n</div>\r\n<br />\r\n', '', 'admin', '', '1444969057', '1444969057', 'true', '', '中国风 周课表 星期 时间 星期六 17:10-18:10 授课教练：洋洋 FOC的全称为Face Of China，FOC中国风健身课程体系是运用中国传统文化结合中国传统养生学以及有氧运动理论来诠释21世纪全新科', '中,国风,中,国风,周课表,周,课表,星期,时间,', '199', '1444969049', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '4', '如何选择健身房', '', '/storage/images/20220112/1-151016113H5Q0.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	其实健身房美不美、好不好都不是最重要的。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	选择健身房的关键和核心在于如何让你可以经常去锻炼、而且是高效的锻炼。要以这两点为核心，找到足以满足自己诉求的健身房。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	在健身房中健身的大部分是为了达到某种目的，比如减肥、保持身材、增强体质等，很少一部分是因为喜欢健身而坚持去健身房的，</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	这种因为非兴趣爱好办了健身卡的人，多数会由于各种各样的主客观原因，导致去健身房的次数逐渐减少。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	为了最大化的排除各种因素的干扰，让上班族可以更方便的在健身房健身，上班族在选择健身房的时候一定要满足以下这个条件：</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	健身房要么离家近、要么离单位近，而且越近越好。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	据我多年的观察，交通的便捷性是影响去健身房次数最大的原因。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	健身效果能否达到的一个基本条件就是去的次数要多，上班族本身的时间和精力就比较有限，所以我强烈建议上班族仅按这一个指标进行选择就可以了。至于其他方面，比如健身房的器械、环境等等都不是最重要的。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	当然也有一些健身者有特殊的要求，比如就特别在意健身房的环境、操课、氛围等等，那就另当别论了。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	还有一种就是专业的指导教练，很大一部分人过去健身房都有点盲目，花费较长的时间达不到健身的目的，有时还会搞得身心疲惫，导致健身兴趣逐渐递减，所以有好的教练指导规划能达到事半功倍的效果，厦门动心健身就有一对一专门的教练指导，每个会员都可享受尊贵服务。</p>\r\n', '', 'admin', '', '1444965997', '1444965997', 'true', '', '其实健身房美不美、好不好都不是最重要的。 选择健身房的关键和核心在于如何让你可以经常去锻炼、而且是高效的锻炼。要以这两点为核心，找到足以满足自己诉求的健身房。 在健', '如何,选择,健身房,其实,健身房,美不美,、,', '56', '1444966638', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '4', '运动前是否需要进食', '', '/storage/images/20220112/1-151016113G1Y4.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	我们很多人运动其实都是为了减肥，因此我们有不少人都选择空腹运动，认为节食加健身的减肥效果更好，还有人认为空腹运动会有心理补偿作用，运动后反而吃得更多，那到底真相如何？厦门动心健身顾问团来为你解开这个答案。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	1、运动前最好选择一些温性的食物，有利于加快代谢速度</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	假如想要使体内脂肪的代谢速度加快，那么可以在做运动之前的一个小时选择食用温热性的食品，就能有效提高身体的基础代谢率，如红萝卜、洋葱、韭菜、辣椒、姜、葱、蒜头、胡椒等，但如果肠胃道不适的人，最好不要食用太多刺激性的温热食材，如辣椒、胡椒等。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	2、运动前要适量补充碳水化合物</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	尽管在减肥的过程当中，热量的控制是非常重要的，不过减肥者也千万不要认为饿着肚子运动会让你更瘦，由于运动会消耗体内的热量与水分，如果空腹运动，反而会让心理有补偿作用，运动后反而吃得更多。因此，如果不是饭后1-1.5小时后运动，最好在运动前1小时，补充适量的碳水化合物，如高纤饼干、优酪乳、新鲜水果等容易消化的食物，除了可避免运动过后血糖过度下降的不适症状外，也能增加运动的持久性与降低运动过后的疲劳感与饥饿感。而如果运动前还是觉得饿，亦可饮用低糖的饮品，如蜂蜜水或低糖、低脂豆奶等。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	3、运动前应该根据运动时间长短饮用500cc以上的温开水</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	在运动的过程中，减肥者的血液的循环速度会有所加快，即使觉得饿，也千万不要马上吃东西，以免血液快速流到肠胃道中，影响脂肪燃烧的速率。因运动时身体较容易流失大量的水分与电解质，如果不适当适时的补充水分，很有可能会产生脱水现象，危害身体健康。因此，每隔10-15分钟补充一次水分是必须的，最好的选择就是温开水，才能让热热的身体快速吸收不足的水分，切忌饮用冰水，有碍身体的热量代谢率。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	4、运动前1小时吃些高纤食品</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	最好在运动前1到2小时之间吃些高纤饼干，或是优酪乳、葡萄干，或是新鲜的水果。这样会让你运动时更有劲。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	5、运动前适当吃些醣类食物</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	如水果、面包、饭和面，既容易消化、又提供醣类，如此一来运动才有能量。醣类食物中，升糖指数较低的食物被消化成醣类的速度比较缓慢，可以长时间为活动的肌肉供应醣类。</p>\r\n', '', 'admin', '', '1444966011', '1444966011', 'true', '', '我们很多人运动其实都是为了减肥，因此我们有不少人都选择空腹运动，认为节食加健身的减肥效果更好，还有人认为空腹运动会有心理补偿作用，运动后反而吃得更多，那到底真相如', '运动,前,是否,需要,进食,我们,很多人,运动,', '74', '1444966626', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '4', '梨形身材如何减脂', '', '/storage/images/20220112/1-151016113F0a7.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	梨形身材主要是指脂肪堆积在下半身，特别是臀部和腿部。大多数东方女性都是梨形身材。梨形身材怎么减肥呢？梨形身材需要坚持长时间的运动，这样下半身的赘肉才会逐渐减少。今天动心健身顾问详细为大家介绍梨形身材减腿部的方法。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	梨形身材的人最需要注意的是密切留意脂肪的摄入量，其实身体存储脂肪是轻而易举的事情，但是要把摄入的碳水化合物和脂肪存储起来则需要消耗大量的能量，所以梨形身材的人要时刻留意脂肪的摄入量。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	运动方案：要点要把运动放在有氧运动上面来，比如跑步与骑自行车之类的训练，既能训练下半身，还能燃烧能量；每周至少做3次有氧运动，每次30分钟。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	除了上述运动之外，每周还需要再增加两次针对上半身的力量训练，既能使上半身和下半身变得更加协调，还会增加肌肉组织的代谢水平。</p>\r\n<span style=\"color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px; line-height: 18px;\">　　 　　</span>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	饮食方案：每天总热量为1500千卡，其中750千卡来自碳水化合物，375千卡来自脂肪，375千卡来自蛋白质；推荐的饮食配餐方案：早餐(8点到9点)：1包速溶燕麦片，一根中等大小的香蕉，半杯橙汁；上午加餐（10点）： 6块全麦饼干，1块奶酪；午餐（12点到13点）：一块三明治，5根小胡萝卜，半杯葡萄；下午加餐（下午3点）：一杯低脂酸奶，一个小苹果；晚餐（18点到19点）：120克脱皮鸡胸肉，一杯毛豆，一杯蔬菜沙拉，一块全麦面包。</p>\r\n', '', 'admin', '', '1444966026', '1444966026', 'true', '', '梨形身材主要是指脂肪堆积在下半身，特别是臀部和腿部。大多数东方女性都是梨形身材。梨形身材怎么减肥呢？梨形身材需要坚持长时间的运动，这样下半身的赘肉才会逐渐减少。今', '梨形,身材,如何,减脂,梨形,身材,主要,是指,', '107', '1444966615', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '4', '健身推荐的10大快速燃脂运动', '', '/storage/images/20220112/1-151016113649233.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	1.游泳：每天10分钟的自由泳，可以消耗差不多1000KJ的热量，只要每周进行3-4次，就可以远离肥胖的困扰。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	2.散步：每天坚持一万步的行走，当然是要比正常走路快点的速度，这样跟每天10分钟的自由泳效果相当。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	3.拉伸运动：拉伸运动主要在坚持，如果没坚持在减肥成功的情况，会产生反弹效果。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	4.慢跑：慢跑属于有氧运动，慢跑正常得进行20分钟才会开始有效果，20分钟后开始消耗体内脂肪。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	5.热水泡浴：热水浸泡可激活体内新陈代谢细胞，加快体内的新陈代谢。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	6.穴位按摩：正确的穴位按摩可以有效的控制食欲。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	7.芭蕾舞站姿：提起脚尖站立，这是美化腿步的方法，达到脚腕纤细健美。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	8.跳舞：坚持每天在动心健身房里跳一小时的舞，这消耗的卡路里是以上运动的三倍，最佳的燃脂效果。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	9.多咀嚼：吃饭的时候每口咀嚼20下-多多咀嚼，可有效减去脸部脂肪。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	10.按压耳部穴位：5秒钟按压耳部穴位5下，能控制食欲-每日按压5下左右，可有效减少食欲。5秒钟按压5下，最好在饭前30分钟进行，效果更佳。</p>\r\n', '', 'admin', '', '1444966041', '1444966041', 'true', '', '1.游泳：每天10分钟的自由泳，可以消耗差不多1000KJ的热量，只要每周进行3-4次，就可以远离肥胖的困扰。 2.散步：每天坚持一万步的行走，当然是要比正常走路快点的速度，这样跟每天', '健身,推荐,的,大,快速,燃脂,运动,游泳,每天,', '114', '1444966603', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '4', '健身教你如何勾搭一个健身搭档', '', '/storage/images/20220112/1-151016112J0935-lp.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	先说说健身房拍档的主要功能，其一，保护你的人生安全。其二，计算自己的休息时间。其三，在训练过程中吹吹牛逼。但是很多人似乎都把健身搭档的功能用反了。所以，如果你找健身搭档的目的是为了去开房啪啪啪做40分钟的床上有氧运动的话，后面的内容还请你不用往下看了。</p>\r\n<p class=\"pagination-centered\" style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; text-align: center; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<img src=\"/storage/images/20220112/1-151016112J0935.jpg\" style=\"max-width: 100%; vertical-align: top; border: 0px; outline: 0px; width: 350px; height: 230px;\" title=\"动心健身教你如何勾搭一个你专属的健身搭档\" /></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动心健身教你搭档黄金法则第一条：健身搭档一定一定要找同性，记住了，男找男，女找女。</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	这跟私人教练可不一样，因为不同性别训练部位以及训练计划、训练重量都是不同的。男人主攻的是腿，股四头肌。女人主攻的是臀，以及股二头肌。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动心健身教你健身搭档黄金法则第二条：不要对陌生人说你练得不好</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	说健身房是一个充满雄性激素的竞技场，一点也不为过，所有男人都跃跃欲试的想告诉全世界他是最牛掰的，特别是那些成天霸占卧推架，使用各种错误的姿势做动作，然后还练得什么也不是，你们就知道他们的自尊心有多么的脆弱了，只允许他们纠正别人的错误，决不允许别人说他们有的错。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	所以请牢记健身房黄金法则第二条，永远不要对陌生人说他某个动作做得不对或者身体练得不够好等等之类的话。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	这里再多废话两句为什么一定要找健身搭档呢，因为我们健身后期的时候需要找到RM值的临界点。你拿着一个数量，你只能做到6个，那么第7个你就做不起来，那么第7个就是临界点。必须有健身搭档在你的身边保护你，你才敢做第7个。假设你能做7.5个怎么办？最后一个能起来半个，但是没有健身搭档在的话，你就要被杠铃压住起不来了。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	那为什么又要做到临界点呢？道理其实很简单，前几个能做完的都没有训练效果，最后那个做不完的才真正练到，明白了吧。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	那么我们又是如何用健身搭档来计算自己的休息时间的呢？假设我们每组动作之间的休息时间为3分钟，高手的话一般是90秒左右。这就等于你做完一组，拆装卸重量，然后你的搭档做一组，你再换成你的重量，你就可以直接开始了，完全不需要额外的休息时间。轮流交替训练，休息时间正好等于对方做动作的时间。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>前面废话了那么多，现在重点来了。如何勾搭一个健身搭档呢？</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>第一步：Say Hi。</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	请你在每天去健身房的时间段，找一个你看着顺眼的同性，打个招呼，说声Hi。然后请坚持这个习惯4、5次。也就是4、5次之后，你们的聊天内容就不止Hi了。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	原因：为什么要打招呼那么天呢？因为在这里你必须要保证你的健身搭档跟你拥有一样的健身习惯，你绝对不想找一个健身搭档，训练一次就消失了吧？同时你也记得，健身房之所以不倒闭，就是因为有99%的人办了健身卡来了一次就再也不来了。你不希望你的健身搭档是他们中的一个吧</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>第二步，在你跟他/她打招呼4、5次之后，开始说第二句，那就是，哥们/姐们，你练得不错啊。</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	这句话绝对是谎话，但是你也要从人家身上找到点优点夸夸人家。说人家练得不错。这样两个人的话匣子就打开了。此时会分成两种情况，一种是实抬举的，说没有，您客气了什么的，这样你就可以继续进一步。“请问你是否有兴趣我们以后一起训练啊什么的”。情况二，你遇见傻逼了，你夸他/她练得不错。他/她就会说那当然，我当年是什么地方训练过的，或者我是谁谁谁的徒弟呢。遇见这种傻逼，直接绕行。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	如何从傻跑族里拉一个姑娘/哥们来当健身搭档？</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	我们都知道每个健身房都有一堆傻跑族，来了之后就直奔跑步机或者各种有氧器械单车课，出一身汗之后洗澡回家。这种姑娘大部分是没救的，但是也不乏有的姑娘/哥们是想训练，但是因为没有方法或者没有人教，所以他们不得不上跑步机来消磨时光。如何甄别出来这种姑娘/哥们呢？你看一个姑娘/哥们经常在你训练的时段来健身房做傻跑族，你只需要训练结束后，跟她打个招呼，你就说，您好，您练得不错啊（没错，就是前两步）。这个时候她/他一般会谦虚一下（我也遇见过不会谦虚的，说我就是练得不错，想当年我怎么怎么牛逼来着。如果遇见此种傻逼，请立刻转身换下一个对象）。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>第三步：你好，我现在想做仰卧起坐，需要一个人帮我按住脚，不知道你是否方便一起做做呢？</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	如果她很担心时间，你就跟她说只需要15分钟或者5分钟就够了。如果她真的很担心时间，你可以把我们的仰卧起坐360压缩到五分钟里做完，就是毫无休息时间。累死她。如果她犹豫别的事情，你就用平坦的小腹，人鱼线什么的诱惑她。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	不过还是不太推荐从傻跑族里找搭档，成功率比较低。总是有一些妹子喜欢自己拿着垫子做仰卧起坐的，你多从这种姑娘里找。慢慢的教她什么叫做翘臀，什么叫做深蹲。一定记得慢慢来，否则立刻吓跑她，你就没有搭档了。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	此处我要说一个猜想，就叫做自带健身搭档猜想。这种事儿就是一种猜想，你想跟你最好的朋友或者同事什么人，一起办健身卡来健身房健身？一切计划的都很美好对吧？</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	抽自己两个大耳光吧，别逗了，人才的出现来自于选拔，不在于培养。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	你除非带着10个人一起来健身，大家接二连三的放弃，消失，就跟美国恐怖电影似的，演员越来越少，最后留下来的那个人就是你的健身搭档，剩下的9个全都放弃了，死在了通往美丽的路上。如果你只带着一个人来健身，结果很恐怖，不但她一定会放弃，到了最后她还会来着你一起放弃。说我们一起运动了这么久，你看我们都这么累了，走吧，我们一起出去，出去吃个海底捞补偿一下自己嘛！</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	所以想都不要想，自己乖乖办卡，自己乖乖在人海中寻觅健身搭档吧。</p>\r\n', '', 'admin', '', '1444966062', '1444966062', 'true', '', '先说说健身房拍档的主要功能，其一，保护你的人生安全。其二，计算自己的休息时间。其三，在训练过程中吹吹牛逼。但是很多人似乎都把健身搭档的功能用反了。所以，如果你找健', '健,身教,你,如何,勾搭,一个,健身,搭档,先,', '96', '1444966047', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '4', '健身教你瘦腰收腹最有效的方法', '', '/storage/images/20220112/1-151016113H5Q0.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>简单12个动作操，甩掉小肚腩，爱美的MM赶紧看过来了！秋冬季最容易积聚脂肪，一不留神，小肚腩就跑出来了！不用怕，动心健身教你12招，轻松甩掉小肚腩！</strong></p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作1：</strong>保持平躺仰卧的姿势，两脚打开与肩同宽，先将右脚向上抬起10CM，脚尖往里勾起并停顿一秒，再轻轻放下，注意脚后跟不能靠在床上。完成后换左脚再重复同样的动作。一组动作重复5次。效果：不仅可以有效减去肚子两侧的坠肉，还能收紧腿部，使下半身更苗条。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作2：</strong>向左上方尽可能抬高右脚，在空中停顿一秒钟再放下，完成后再换左脚。注意膝盖不能用力，才能达到预期的瘦腿效果，也不要过于勉强以免拉伤腿部肌肉。重复这组动作5—7次。效果：可以紧实腹部及腿部肌肉。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作3：</strong>保持仰卧姿势，双手抱紧膝盖，大腿向腹部曲伸，并抬起上半身再轻轻躺下。重复此动作5—10次。效果：能有效强化胸部及腰部力量，收缩腰部坠肉。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作4：</strong>保持平躺仰卧的姿势，两腿打开与肩同宽。手臂曲伸成90度直角贴紧地面，手心朝上。弯曲左腿膝盖，直起上身，使得右手肘部能够碰触左腿膝盖。换右腿重复同样的动作为一组。重复2—3组，每组10次。效果：增强腹部力量，紧实大腿肌肉。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作5：</strong>保持平躺仰卧的姿势，两腿打开与肩同宽。两手握紧哑铃并向胸部正上方举起，注意膝盖保持笔直不能弯曲。接着调整呼吸，上身慢慢向左右两侧扭转。左右各10次为一组，重复2—3组。效果：拉伸腹部两侧肌肉，改善腹部松弛。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作6：</strong>身体侧卧，运用腿肚力量夹住靠垫。双手贴地以保持身体平衡。抬起头部，眼睛直视前方。调整呼吸，双腿夹住靠垫并向上抬起，动作要慢才能达到理想的瘦身效果。10次动作为一组，重复10组。效果：强效收缩腹部、大腿及小腿部位的肌肉，让腿部更纤细苗条。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作7：</strong>平躺仰卧，两腿伸直，脚跟并拢。双手叉腰，眼睛直视上方，调整好呼吸并慢慢将两腿膝盖曲起至胸前位置，最后再慢慢放下并伸直双腿。15次为一组，重复2—3组。效果：使小肚肌肉更加紧实，有效改善腹部松弛</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作8：</strong>平躺仰卧，两腿打开与肩同宽。两臂伸直，肘部贴近耳朵部位，分别抬起左腿和右手并直起上身，使得右手触碰左腿脚尖，左右各7次为一组，重复2—3组。效果：有效消除小腹突起。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作9：</strong>准备好两副橡皮圈。两腿打开与肩同宽。接着两脚各踩住一副橡皮圈的一端，再将橡皮圈左右交叉，两手分别握紧两副橡皮圈的另一端。保持下半身不动，左右扭转上半身。注意挺直腰杆，身体不能前倾。20次为一组，重复3—4组。效果：拉伸腰部肌肉，使腰部更加紧实纤细。以下三组需要进行准备活动：全身放松，下半身保持不动，上半身轻轻向左右扭转。左右各重复16次。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作10：</strong>平躺仰卧，双手打开放在身体两侧，掌心向下。保持上半身不动，曲膝并垂直向上抬起。接着两腿膝盖并拢并向左侧摆动并贴地，右肩部位必须紧贴地面不能抬起。恢复仰卧姿势后再遵循相同的要领向右侧摆动双膝。左右各一次为一组，重复8组。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作11：</strong>两手自然放置身体两侧。利用手部及腹部力量慢慢向上伸直双腿直至与地面成90度直角。腰部不好的人曲膝即可。重复此动作8组。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作12：</strong>采用脸朝下的姿势趴下，两腿微微张开。调整好呼吸，弯曲双腿并向上蹬起，运用胸部及腹部力量尽力使双手触碰腿部。尽量使腿部抬高，瘦身效果会更加明显。效果：这三套动作都是针对腹部设计，将三者有机结合可强效收腹，对于腰部脆弱的人也能起到一定的保健作用。</p>\r\n', '', 'admin', '', '1444966078', '1444966078', 'true', '', '动作1：保持平躺仰卧的姿势，两脚打开与肩同宽，先将右脚向上抬起10CM，脚尖往里勾起并停顿一秒，再轻轻放下，注意脚后跟不能靠在床上。完成后换左脚再重复同样的动作。一组动作重复', '健,身教,你瘦,腰,收腹,最,有效,的,方法,简单,', '139', '1444966461', '0', '0', '1', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '4', '厦门人人站CMS健身年卡火爆预售中', '', '/storage/images/20220112/1-151016113H5Q0.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作9：</strong>准备好两副橡皮圈。两腿打开与肩同宽。接着两脚各踩住一副橡皮圈的一端，再将橡皮圈左右交叉，两手分别握紧两副橡皮圈的另一端。保持下半身不动，左右扭转上半身。注意挺直腰杆，身体不能前倾。20次为一组，重复3—4组。效果：拉伸腰部肌肉，使腰部更加紧实纤细。以下三组需要进行准备活动：全身放松，下半身保持不动，上半身轻轻向左右扭转。左右各重复16次。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作10：</strong>平躺仰卧，双手打开放在身体两侧，掌心向下。保持上半身不动，曲膝并垂直向上抬起。接着两腿膝盖并拢并向左侧摆动并贴地，右肩部位必须紧贴地面不能抬起。恢复仰卧姿势后再遵循相同的要领向右侧摆动双膝。左右各一次为一组，重复8组。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作11：</strong>两手自然放置身体两侧。利用手部及腹部力量慢慢向上伸直双腿直至与地面成90度直角。腰部不好的人曲膝即可。重复此动作8组。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	<strong>动作12：</strong>采用脸朝下的姿势趴下，两腿微微张开。调整好呼吸，弯曲双腿并向上蹬起，运用胸部及腹部力量尽力使双手触碰腿部。尽量使腿部抬高，瘦身效果会更加明显。效果：这三套动作都是针对腹部设计，将三者有机结合可强效收腹，对于腰部脆弱的人也能起到一定的保健作用。</p>\r\n', '', 'admin', '', '1444966104', '1444966104', 'true', '', '动作9：准备好两副橡皮圈。两腿打开与肩同宽。接着两脚各踩住一副橡皮圈的一端，再将橡皮圈左右交叉，两手分别握紧两副橡皮圈的另一端。保持下半身不动，左右扭转上半身。注意挺直腰', '厦门,健身,年卡,火爆,预,售中,动作,准备好,', '90', '1444966448', '0', '0', '1', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '4', '厦门健身，即将开业', '', '/storage/images/20220112/1-151016113H5Q0.jpg', '', '<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	厦门人人站CMS健身中心占地面积2800平方米，俱乐部配备力健、星驰等国际著名品牌的健身和测试设备，拥有一大批高水平、高素质的教练队伍和管理团队，属厦门最壕健身中心之一。</p>\r\n<p style=\"margin: 10px 0px 5px; padding: 0px; line-height: 30px; color: rgb(49, 49, 49); font-family: \'Microsoft YaHei\'; font-size: 14px;\">\r\n	人人站CMS健身是一个为追求中国梦的健身达人创造有品位、理念 、价值、人性化服务的健身中心，拥有先进的健身俱乐部管理模式和国际时尚的健身体验，凭借着国际化会员管理制度，完善有效的时尚健身项目，国际优秀的专业队伍，舒适开阔的运动环境和动心健身品牌动感时尚的号召力，成为时尚健身运动的首选场所。</p>\r\n', '', 'admin', '', '1444966140', '1444966140', 'true', '', '厦门人人站CMS健身中心占地面积2800平方米，俱乐部配备力健、星驰等国际著名品牌的健身和测试设备，拥有一大批高水平、高素质的教练队伍和管理团队，属厦门最壕健身中心之一。 人人站', '厦门,健身,即将,开业,厦门,人人站,健身,中心,', '191', '1444966111', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某网站 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', 'ICP备*******号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式健身房信息展示网站人人站模板', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'email@rrzcms.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某区某某地', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '39.903970449129694,116.39786991534426', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '2', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '3', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '1300000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_suffix', 'html', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('53', 'app_debug', '2', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '执行顺序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_code` (`code`),
  KEY `idx_status` (`status`),
  KEY `idx_ishome` (`ishome`),
  KEY `idx_isload` (`isload`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '健身房', '', 'jianshenfang', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '课程安排', '', 'kechenganpai', '0', '4', '1', '/node/3.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '新闻动态', '', 'xinwendongtai', '0', '5', '1', '/node/4.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '加入我们', '', 'jiaruwomen', '0', '6', '1', '/node/5.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '联系我们', '', 'lianxiwomen', '0', '7', '1', '/node/6.html', '7', '1007', 'false', '');
