<?php
/**
 * 人人站CMS
 * ============================================================================
 * 版权所有 2015-2030 山东康程信息科技有限公司，并保留所有权利。
 * 网站地址: http://www.rrzcms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */

namespace think\template\taglib;

use think\template\TagLib;


class Rrz extends Taglib
{
    // 标签定义
    protected $tags = [
        // 标签定义： attr 属性列表 close 是否闭合（0 或者1 默认1） alias 标签别名 level 嵌套层次
        'env' => ['attr' => 'name,empty', 'close' => 0,],
        'skin' => ['attr' => 'href', 'close' => 0,],//皮肤静态文件加载
        'menu' => ['attr' => '',],//菜单信息
        'menus' => ['attr' => '',],//导航菜单列表
        'sons' => ['attr' => '',],//导航或分类的子集获取
        'crumbs' => ['attr' => '', 'close' => 0,],//导航路径
        'cat' => ['attr' => '',],//商品分类信息
        'cats' => ['attr' => '',],//商品分类列表
        'goods' => ['attr' => 'item,key,limit,orderby,empty',],//商品列表
        'good' => ['attr' => '',],//商品信息
        'articles' => ['attr' => 'item,key,limit,orderby,empty',],//文章列表
        'list' => ['attr' => '',],//获取列表，用来代替 goods 和 articles 标签
        'filter' => ['attr' => '',],//筛选列表数据
        'article' => ['attr' => '',],//文章信息
        'node' => ['attr' => 'id,empty',],//文章分类信息
        'nodes' => ['attr' => '',],//文章分类列表
        'links' => ['attr' => '',],//友情链接
        'page' => ['attr' => '', 'close' => 0,],//分页
        'pre' => ['attr' => '',],//上一个
        'next' => ['attr' => '',],//下一个
        'form' => ['attr' => 'id',],//表单信息
        'search' => ['attr' => '',],//查询列表
        'hotwords' => ['attr' => '',],//HOT热门搜索
        'sidebar' => ['attr' => '',],//当前页面分类导航
        'break' => ['attr' => '', 'close' => 0,],//跳出循环
        'continue' => ['attr' => '', 'close' => 0,],//跳过当前循环
        'each' => ['attr' => 'list', 'alias' => ['imgs'],],//图片集字符处理
        'brands' => ['attr' => '',],//品牌列表
        'top' => ['attr' => ''],//获取上级分类信息
        'tags' => ['attr' => ''],//获取Tag标签
        'user' => ['attr' => ''],//获取会员信息
    ];

    public function tagUser(array $tag, string $content): string {
        $type = !empty($tag['type']) ? $tag['type'] : 'info';
        $parseStr = '<?php $libUser= new \app\home\lib\User($rrz??[],$env??[]); ';
        $parseStr .= '$user=$libUser->getUserInfo("' . $type . '");';
        $parseStr .= 'if($user): ?>';
        $parseStr .= $content;
        $parseStr .= '<?php unset($user); endif; ?>';
        return $parseStr;
    }

    public function tagTags(array $tag, string $content): string {
        $name = !empty($tag['name']) ? $tag['name'] : '__LIST__';
        $id = !empty($tag['rid']) ? $this->varOrvalue($tag['rid']) : 0;
        $typeid = !empty($tag['typeid']) ? $this->varOrvalue($tag['typeid']) : 0;
        $page = isset($tag['page']) ? $tag['page'] : 'article';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $getall = !empty($tag['getall']) ? $this->varOrvalue($tag['getall']) : 0;

        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';

        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $order = !empty($tag['order']) ? $tag['order'] : '';

        $name = '$' . $name;
        $parseStr = '<?php ' . $name . '=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libTags= new \app\home\lib\Tags($rrz,$env); ';
        $parseStr .= $name . '=$libTags->getList(' . $id . ',"' . $page . '",' . $typeid . ',' . $limit . ',"' . $order . '",' . $getall . '); ';

        $parseStr .= 'if( count(' . $name . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1;';
        $parseStr .= 'foreach(' . $name . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset(' . $name . ',$' . $item . ',$' . $key . '); endif;?>';
        return $parseStr;
    }

    /**
     * 自动识别构建变量，传值可以使变量也可以是值
     * @access private
     * @param string $value 值或变量
     * @return string
     */
    private function varOrvalue($value) {
        $flag = substr($value, 0, 1);
        if ('$' == $flag || ':' == $flag) {
            $value = $this->autoBuildVar($value);
        } elseif (!is_numeric($value)) {
            $value = str_replace('"', '\"', $value);
            $value = '"' . $value . '"';
        }
        return $value;
    }

    /**
     * 配置信息获取
     * 格式： <rrz:env name="website.favicon" />
     * 获取后台配置信息
     */
    public function tagEnv(array $tag): string {
        $name = $this->varOrvalue($tag['name']);
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        return '<?php $libEnv= new \app\home\lib\Env(); echo $libEnv->getEnv(' . $name . ')?: htmlspecialchars_decode("' . $empty . '"); ?>';
    }

    /**
     * 加载模板静态文件
     * @param array $tag
     * @return string
     */
    public function tagSkin(array $tag): string {
        $file = isset($tag['file']) ? $tag['file'] : $tag['href'];
        $parseStr = '';
        // 文件方式导入
        $array = explode(',', $file);
        foreach ($array as $val) {
            $type = strtolower(substr(strrchr($val, '.'), 1));
            $val = preg_replace('/^skin\//', '__SKIN__', $val);
            $val .= '?v=' . C('config.version');
            switch ($type) {
                case 'js':
                    $parseStr .= '<script type="text/javascript" src="' . $val . '"></script>';
                    break;
                case 'css':
                    $parseStr .= '<link rel="stylesheet" type="text/css" href="' . $val . '" />';
                    break;
            }
        }
        return $parseStr;
    }

    /**
     * 菜单信息
     * 格式：{menu id="0" empty="" }{/menu}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagMenu(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $type = isset($tag['type']) ? $tag['type'] : '';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $pageInfo = isset($tag['info']) ? $this->varOrvalue($tag['info']) : 0;

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libMenus = new \app\home\lib\Menus($rrz,$env); ';
        if ($type == 'top') {
            $parseStr .= '$menu=$libMenus->getInfo(isset($env["menu"])?$env["menu"]["topId"]:0,' . $pageInfo . ');';
        } else if (!$id) {
            $parseStr .= '$menu=$libMenus->getInfo(isset($env["menu"]["id"])?$env["menu"]["id"]:0,' . $pageInfo . ');';
        } else {
            $parseStr .= '$menu=$libMenus->getInfo(' . $id . ',' . $pageInfo . ');';
        }
        $parseStr .= 'if(!$menu) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: unset($_menu); ?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php unset($menu); endif; ?>';
        return $parseStr;
    }

    /**
     * 获取当前页面顶级分类信息
     * 格式： {rrz:top grade="1" sons="0"}{/rrz:top}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagTop(array $tag, string $content) {
        $grade = !empty($tag['grade']) ? $this->varOrvalue($tag['grade']) : 1;//顶级分类的等级，默认1级可指定
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $sons = !empty($tag['sons']) ? $this->varOrvalue($tag['sons']) : 0;//是否获取下级

        $name = !empty($tag['name']) ? $tag['name'] : 'top';
        $name = '$' . $name;
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libMenus = new \app\home\lib\Menus($rrz,$env); ';
        $parseStr .= $name . '=$libMenus->getTopType($rrz,$env["page"],' . $grade . ',' . $sons . '); ';
        $parseStr .= 'if(!' . $name . ') : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        //内容
        $parseStr .= $content;
        $parseStr .= '<?php unset(' . $name . '); endif; ?>';

        return $parseStr;
    }

    /**
     * 导航或分类的子集获取
     * 格式： {sons id="" type="" limit=""}{/sons}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagSons(array $tag, string $content) {
        $name = !empty($tag['name']) ? $tag['name'] : 'sons';
        $type = $this->varOrvalue(!empty($tag['type']) ? $tag['type'] : '');
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $son = $this->varOrvalue(isset($tag['son']) ? $tag['son'] : 'son');

        $name = '$' . $name;
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libMenus = new \app\home\lib\Menus($rrz,$env); ';
        if (!$id) {
            $parseStr .= 'if(isset($_menu["id"])): ' . $name . '=$libMenus->getSons($_menu,"menu",' . $son . ',' . $limit . ',$env["page"],$rrz);';
            $parseStr .= 'elseif(isset($menu["id"])): ' . $name . '=$libMenus->getSons($menu,"menu",' . $son . ',' . $limit . ',$env["page"],$rrz);';
            $parseStr .= 'elseif(isset($cat)&&$cat): ' . $name . '=$libMenus->getSons($cat,"cat",' . $son . ',' . $limit . ',$env["page"],$rrz);';
            $parseStr .= 'elseif(isset($node)&&$node): ' . $name . '=$libMenus->getSons($node,"node",' . $son . ',' . $limit . ',$env["page"],$rrz);';
            $parseStr .= 'elseif(isset($item["type"])&&in_array($item["type"],["menu","node","cat"])): ' . $name . '=$libMenus->getSons($item,$item["type"],' . $son . ',' . $limit . ',$env["page"],$rrz);';
            $parseStr .= 'else: ' . $name . '=$libMenus->getSons(' . $id . ',' . $type . ',' . $son . ',' . $limit . ',$env["page"],$rrz); ';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= $name . '=$libMenus->getSons(' . $id . ',' . $type . ',' . $son . ',' . $limit . ',$env["page"],$rrz); ';
        }
        $parseStr .= '?>';
        $parseStr .= $content;
        $parseStr .= '<?php unset(' . $name . '); ?>';
        return $parseStr;
    }

    /**
     * 导航菜单列表
     * 格式： {menus key="" item="" empty=""}{/menus}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagMenus(array $tag, string $content): string {
        $name = !empty($tag['name']) ? $tag['name'] : '__LIST__';
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $type = isset($tag['type']) ? $tag['type'] : '';
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $pageInfo = isset($tag['info']) ? $this->varOrvalue($tag['info']) : 0;

        $name = '$' . $name;
        $parseStr = '<?php ' . $name . '=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libMenus= new \app\home\lib\Menus($rrz,$env); ';
        if ($type) {
            if (!$id) {
                $parseStr .= 'if(isset($_menu["id"])): ' . $name . '=$libMenus->getSonList($_menu["id"],' . $limit . ',"' . $type . '",' . $pageInfo . ');';
                $parseStr .= 'elseif(isset($menu["id"])): ' . $name . '=$libMenus->getSonList($menu["id"],' . $limit . ',"' . $type . '",' . $pageInfo . ');';
                $parseStr .= 'else: ' . $name . '=$libMenus->getSonList($env["menu"]["id"]??-1,' . $limit . ',"' . $type . '",' . $pageInfo . ');';
                $parseStr .= 'endif;';
            } else {
                $parseStr .= $name . '=$libMenus->getSonList(' . $id . '??-1,' . $limit . ',"' . $type . '",' . $pageInfo . ');';
            }
        } else {
            $parseStr .= $name . '=$libMenus->getList(' . $id . ',' . $pageInfo . '); ';
        }

        $parseStr .= 'if( count(' . $name . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1;';
        $parseStr .= 'foreach(' . $name . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset(' . $name . ',$' . $item . ',$' . $key . '); endif;?>';
        return $parseStr;
    }

    /**
     * 菜单路径
     * {crumbs class=""/}
     * @param array $tag
     * @return string
     */
    public function tagCrumbs(array $tag): string {
        $class = !empty($tag['class']) ? $tag['class'] : '';
        $index = $this->varOrvalue(!empty($tag['index']) ? $tag['index'] : '首页');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libMenus = new \app\home\lib\Menus($rrz,$env); echo $libMenus->getCrumbs("' . $class . '",' . $index . ',$env["page"],$rrz) ?>';
        return $parseStr;
    }

    /**
     * 文章分类信息
     * 格式：{cat id="0" empty="" }{/cat}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagCat(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $_id=' . $id . '; ' . "\r\n";
        $parseStr .= '(function()use($rrz,$env,$_id){ ' . "\r\n";
        $parseStr .= '$libGoods=new \app\home\lib\Goods($rrz,$env); $cat=$libGoods->getCatInfo($_id); ' . "\r\n";
        $parseStr .= 'if(!$cat) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php endif; })(); unset($_id); ?>';
        return $parseStr;
    }

    /**
     * 商品分类列表
     * 格式： {cats type="" id=""}{/cats}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagCats(array $tag, string $content): string {
        $name = !empty($tag['name']) ? $tag['name'] : '__LIST__';
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');

        $type = isset($tag['type']) ? $tag['type'] : 'son';
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $name = '$' . $name;
        $parseStr = '<?php ' . $name . '=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libGoods=new \app\home\lib\Goods($rrz,$env);';
        if (!$id) {
            $parseStr .= 'if(isset($cat["id"])): ' . $name . '=$libGoods->getCatList($cat["id"],' . $limit . ',"' . $type . '",$env["page"]=="cat"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif(isset($_menu["cat_id"])): ' . $name . '=$libGoods->getCatList($_menu["cat_id"],' . $limit . ',"' . $type . '",$env["page"]=="cat"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif(isset($menu["cat_id"])): ' . $name . '=$libGoods->getCatList($menu["cat_id"],' . $limit . ',"' . $type . '",$env["page"]=="cat"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif($env["page"]=="item"&&$rrz["typeId"]): ' . $name . '=$libGoods->getCatList($rrz["typeId"],' . $limit . ',"' . $type . '",$rrz["typeId"]);';
            $parseStr .= 'elseif($env["page"]=="cat"): ' . $name . '=$libGoods->getCatList($rrz["id"],' . $limit . ',"' . $type . '",$rrz["id"]);';
            $parseStr .= 'else: ' . $name . '=$libGoods->getCatList(0,' . $limit . ',"' . $type . '",0);';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= $name . '=$libGoods->getCatList(' . $id . ',' . $limit . ',"' . $type . '",$env["page"]=="cat"?$rrz["id"]??0:0);';
        }
        $parseStr .= 'if( count(' . $name . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1;';
        $parseStr .= 'foreach(' . $name . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset(' . $name . ',$' . $item . ',$' . $key . ');  endif;  ?>';
        return $parseStr;
    }

    /**
     * 商品列表
     * 格式：{goods key="key" item="item"  limit="6" order="id desc" catid="0" }{/goods}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagGoods(array $tag, string $content): string {
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $flag = isset($tag['flag']) ? $tag['flag'] : '';
        $filter = !empty($tag['filter']) ? $this->varOrvalue($tag['filter']) : 0;

        $catId = !empty($tag['catid']) ? $this->varOrvalue($tag['catid']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $order = !empty($tag['order']) ? $tag['order'] : '';
        $page = !empty($tag['page']) ? $this->varOrvalue($tag['page']) : 0;

        $parseStr = '<?php $__DATA__=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libGoods=new \app\home\lib\Goods($rrz,$env);';
        if (!$catId) {
            $parseStr .= 'if(isset($_cat["id"])): $__DATA__=$libGoods->getList($_cat["id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif(isset($cat["id"])): $__DATA__=$libGoods->getList($cat["id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif(isset($_menu["cat_id"])):  $__DATA__=$libGoods->getList($_menu["cat_id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif(isset($menu["cat_id"])):  $__DATA__=$libGoods->getList($menu["cat_id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif($env["page"]=="cat"):  $__DATA__=$libGoods->getList($rrz["id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'else: $__DATA__=$libGoods->getList(0,"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= ' $__DATA__=$libGoods->getList(' . $catId . ',"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
        }

        $parseStr .= 'if(!$__DATA__||$__DATA__["count"]==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1;';
        $parseStr .= 'foreach($__DATA__["list"] as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset($' . $item . ',$' . $key . '); endif; ?>';

        return $parseStr;
    }

    /**
     * 文章列表
     * 格式：{articles key="key" item="item"  limit="6" order="id desc" nodeid="0" }{/articles}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagArticles(array $tag, string $content): string {
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $flag = isset($tag['flag']) ? $tag['flag'] : '';
        $filter = !empty($tag['filter']) ? $this->varOrvalue($tag['filter']) : 0;

        $nodeId = !empty($tag['nodeid']) ? $this->varOrvalue($tag['nodeid']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $order = !empty($tag['order']) ? $tag['order'] : '';
        $page = !empty($tag['page']) ? $this->varOrvalue($tag['page']) : 0;

        $parseStr = '<?php $__DATA__=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libArticles=new \app\home\lib\Articles($rrz,$env);';
        if (!$nodeId) {
            $parseStr .= 'if(isset($node["id"])): $__DATA__=$libArticles->getList($node["id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif(isset($_menu["node_id"])):  $__DATA__=$libArticles->getList($_menu["node_id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif(isset($menu["node_id"])):  $__DATA__=$libArticles->getList($menu["node_id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif($env["page"]=="node"):  $__DATA__=$libArticles->getList($rrz["id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'elseif($env["page"]=="article"&&isset($rrz["node_id"])&&$rrz["node_id"]):  $__DATA__=$libArticles->getList($rrz["node_id"],"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'else: $__DATA__=$libArticles->getList(0,"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= ' $__DATA__=$libArticles->getList(' . $nodeId . ',"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
        }

        $parseStr .= 'if(!$__DATA__||$__DATA__["count"]==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else:  $i=1; ';
        $parseStr .= 'foreach($__DATA__["list"] as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset($' . $item . ',$' . $key . '); endif; ?>';

        return $parseStr;
    }

    /**
     * 获取列表数据
     * 格式：{list key="key" item="item"  limit="6" order="id desc" typeid="0" }{/list}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagList(array $tag, string $content): string {
        $type = $this->varOrvalue(!empty($tag['type']) ? $tag['type'] : '');
        $typeId = !empty($tag['typeid']) ? $this->varOrvalue($tag['typeid']) : 0;

        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $order = !empty($tag['order']) ? $tag['order'] : '';
        $page = !empty($tag['page']) ? $this->varOrvalue($tag['page']) : 0;

        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $flag = isset($tag['flag']) ? $tag['flag'] : '';
        $filter = !empty($tag['filter']) ? $this->varOrvalue($tag['filter']) : 0;

        $parseStr = '<?php $__DATA__=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libArcList=new \app\home\lib\ArcList($rrz,$env);';
        if (!$type || !$typeId) {
            $parseStr .= 'if(isset($_node["id"])&&isset($_node["type"])): $listType=$_node["type"]; $listTypeId=$_node["id"];';
            $parseStr .= 'elseif(isset($node["id"])&&isset($node["type"])): $listType=$node["type"]; $listTypeId=$node["id"];';
            $parseStr .= 'elseif(isset($_menu["node_id"])): $listType=$_menu["page"]; $listTypeId=$_menu["node_id"]; ';
            $parseStr .= 'elseif(isset($menu["node_id"])): $listType=$menu["page"]; $listTypeId=$menu["node_id"]; ';

            $parseStr .= 'elseif(isset($_cat["id"])&&isset($_cat["type"])): $listType=$_cat["type"]; $listTypeId=$_cat["id"];';
            $parseStr .= 'elseif(isset($cat["id"])&&isset($cat["type"])): $listType=$cat["type"]; $listTypeId=$cat["id"];';
            $parseStr .= 'elseif(isset($_menu["cat_id"])): $listType=$_menu["page"]; $listTypeId=$_menu["cat_id"]; ';
            $parseStr .= 'elseif(isset($menu["cat_id"])): $listType=$menu["page"]; $listTypeId=$menu["cat_id"]; ';

            $parseStr .= 'elseif($env["page"]=="node"&&isset($rrz)): $listType=$env["page"]; $listTypeId=$rrz["id"]; ';
            $parseStr .= 'elseif($env["page"]=="cat"&&isset($rrz)): $listType=$env["page"]; $listTypeId=$rrz["id"]; ';
            $parseStr .= 'elseif($env["page"]=="article"&&isset($rrz["node_id"])&&$rrz["node_id"]): $listType="node"; $listTypeId=$rrz["node_id"]; ';
            $parseStr .= 'elseif($env["page"]=="item"&&isset($rrz["cat_id"])&&$rrz["cat_id"]): $listType="cat"; $listTypeId=$rrz["cat_id"]; ';
            $parseStr .= 'else: $listType=' . $type . '; $listTypeId=' . $typeId . ';';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= '$listType=' . $type . '; $listTypeId=' . $typeId . ';';
        }
        $parseStr .= 'if($env["page"]=="search"&&empty($node)&&empty($cat)): $__DATA__=$libArcList->search($listTypeId,$listType?:($_GET["t"]??"article"),' . $limit . ',' . $page . '?:I("p",1),"' . $flag . '",' . $filter . ');';
        $parseStr .= 'else:';
        $parseStr .= ' $__DATA__=$libArcList->getList($listTypeId,$listType,"' . $order . '",' . $limit . ',' . $page . '?:I("p",1)' . ',"' . $flag . '",' . $filter . ');';
        $parseStr .= 'endif;';

        $parseStr .= 'if(!$__DATA__||$__DATA__["count"]==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach($__DATA__["list"] as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; endif; unset($listType,$listTypeId,$' . $key . ',$' . $item . '); ?>';

        return $parseStr;
    }

    /**
     * 列表筛选
     * 格式：{filter empty="" }{/filter}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagFilter(array $tag, string $content): string {
        $field = $this->varOrvalue(!empty($tag['field']) ? $tag['field'] : 'all');//attr（产品参数），field（模型字段）
        $mid = $this->varOrvalue(!empty($tag['mid']) ? $tag['mid'] : 0);//模型id
        $tid = $this->varOrvalue(!empty($tag['tid']) ? $tag['tid'] : 0);//分类id
        $mtype = $this->varOrvalue(!empty($tag['mtype']) ? $tag['mtype'] : '');//模型类别
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= '$libForms=new \app\home\lib\Forms($rrz,$env);';
        $parseStr .= '$filter=$libForms->getFilter($rrz,' . $mtype . '?:$env["page"],' . $field . ',' . $mid . ',' . $tid . '); ';

        $parseStr .= 'if(!$filter) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        //循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php unset($filter); endif; ?>';
        return $parseStr;
    }

    /**
     * 产品信息
     * 格式：{good id="0" empty="" }{/good}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagGood(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $field = $this->varOrvalue(!empty($tag['field']) ? $tag['field'] : '*');
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= '$libGoods=new \app\home\lib\Goods($rrz,$env);';
        if (!$id) {
            $parseStr .= 'if(isset($_menu["item_id"])): $good=$libArticles->getInfo($_menu["item_id"],' . $field . ');';
            $parseStr .= 'elseif(isset($menu["item_id"])):$good=$libArticles->getInfo($menu["item_id"],' . $field . ');';
            $parseStr .= 'else:$good=$libGoods->getInfo(0,' . $field . ');';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= '$good=$libGoods->getInfo(' . $id . ',' . $field . '); ';
        }

        $parseStr .= 'if(!$good) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php unset($good); endif; ?>';
        return $parseStr;
    }

    /**
     * 文章信息
     * 格式：{article id="0" empty="" }{/article}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagArticle(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= '$libArticles=new \app\home\lib\Articles($rrz,$env);';
        if (!$id) {
            $parseStr .= 'if(isset($_menu["article_id"])): $article= $libArticles->getInfo($_menu["article_id"]);';
            $parseStr .= 'elseif(isset($menu["article_id"])):$article= $libArticles->getInfo($menu["article_id"]);';
            $parseStr .= 'else:$article= $libArticles->getInfo(0);';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= '$article=$libArticles->getInfo(' . $id . '); ';
        }

        $parseStr .= 'if(!$article) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php unset($article); endif; ?>';
        return $parseStr;
    }

    /**
     * 文章分类信息
     * 格式：{node id="0" empty="" }{/node}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagNode(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $_id=' . $id . ';' . "\r\n";
        $parseStr .= '(function()use($rrz,$env,$_id){ ' . "\r\n";
        $parseStr .= ' $libArticles= new \app\home\lib\Articles($rrz,$env); $node=$libArticles->getNodeInfo($_id); ' . "\r\n";
        $parseStr .= 'if(!$node) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php endif; })(); unset($_id); ?>' . "\r\n";;
        return $parseStr;
    }

    /**
     * 文章分类列表
     * 格式：{nodes id="0" empty="" }{/nodes}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagNodes(array $tag, string $content): string {
        $name = !empty($tag['name']) ? $tag['name'] : '__LIST__';
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');

        $type = isset($tag['type']) ? $tag['type'] : 'son';
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $name = '$' . $name;
        $parseStr = '<?php ' . $name . '=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libArticles=new \app\home\lib\Articles($rrz,$env);';
        if (!$id) {
            $parseStr .= 'if(isset($node["id"])): ' . $name . '=$libArticles->getNodeList($node["id"],' . $limit . ',"' . $type . '",$env["page"]=="node"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif(isset($_menu["node_id"])): ' . $name . '=$libArticles->getNodeList($_menu["node_id"],' . $limit . ',"' . $type . '",$env["page"]=="node"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif(isset($menu["node_id"])): ' . $name . '=$libArticles->getNodeList($menu["node_id"],' . $limit . ',"' . $type . '",$env["page"]=="node"?$rrz["id"]??0:0);';
            $parseStr .= 'elseif($env["page"]=="article"&&$rrz["typeId"]): ' . $name . '=$libArticles->getNodeList($rrz["typeId"],' . $limit . ',"' . $type . '",$rrz["typeId"]);';
            $parseStr .= 'elseif($env["page"]=="node"): ' . $name . '=$libArticles->getNodeList($rrz["id"],' . $limit . ',"' . $type . '",$rrz["id"]);';
            $parseStr .= 'else: ' . $name . '=$libArticles->getNodeList(0,' . $limit . ',"' . $type . '",0);';
            $parseStr .= 'endif;';
        } else {
            $parseStr .= $name . '=$libArticles->getNodeList(' . $id . ',' . $limit . ',"' . $type . '",$env["page"]=="node"?$rrz["id"]??0:0);';
        }
        $parseStr .= 'if( count(' . $name . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach(' . $name . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach;  unset(' . $name . ',$' . $item . ',$' . $key . '); endif;  ?>';
        return $parseStr;
    }

    /**
     * 友情链接列表
     * 格式： {links}{/links}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagLinks(array $tag, string $content): string {
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $var = '$_' . uniqid();
        $parseStr .= '$libLinks=new \app\home\lib\Links($rrz,$env); ';
        $parseStr .= $var . '=$libLinks->getList(' . $limit . '); ';

        $parseStr .= 'if( count(' . $var . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach(' . $var . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset(' . $var . ',$' . $item . ',$' . $key . '); endif; ?>';
        return $parseStr;
    }

    /**
     * 分页
     * 格式 {page item="index,pre,pageno,next,end" size="2"/}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagPage(array $tag, string $content): string {
        $item = !empty($tag['item']) ? $tag['item'] : 'info,index,end,pre,next,pageno';
        $size = (isset($tag['size']) && is_numeric($tag['size'])) ? intval($tag['size']) : 2;
        $style = !empty($tag['style']) ? $tag['style'] : (!empty($tag['class']) ? $tag['class'] : 'cur');
        $wrap = !empty($tag['tag']) ? $tag['tag'] : (!empty($tag['wrap']) ? $tag['wrap'] : '');
        $lang = $this->varOrvalue(!empty($tag['lang']) ? $tag['lang'] : '$env.lang');

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libPage=new \app\home\lib\Paginator($__DATA__,"' . $style . '","' . $wrap . '",' . $lang . ',$rrz,$env);';
        $parseStr .= ' echo $libPage->render("' . $item . '",' . $size . ');';
        $parseStr .= '?>';
        return $parseStr;
    }

    /**
     * 上一个内容
     * 格式 {pre empty="" }{/pre}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagPre(array $tag, string $content): string {
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $field = $this->varOrvalue(!empty($tag['field']) ? $tag['field'] : '');

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= ' $libEnv=new \app\home\lib\Env($rrz,$env);';
        $parseStr .= ' $pre=$libEnv->getPre($rrz,$env["page"],' . $field . ');';
        $parseStr .= 'if(!$pre) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else:   ';
        $parseStr .= '?>';
        $parseStr .= $content;
        $parseStr .= '<?php unset($pre); endif; ?>';
        return $parseStr;
    }

    /**
     * 下一个内容
     * 格式 {next empty="" }{/next}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagNext(array $tag, string $content): string {
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $field = $this->varOrvalue(!empty($tag['field']) ? $tag['field'] : '');

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= ' $libEnv=new \app\home\lib\Env($rrz,$env);';
        $parseStr .= ' $next=$libEnv->getNext($rrz,$env["page"],' . $field . ');';
        $parseStr .= 'if(!$next) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else:   ';
        $parseStr .= '?>';
        $parseStr .= $content;
        $parseStr .= '<?php unset($next); endif; ?>';
        return $parseStr;
    }

    /**
     * 表单配置信息
     * 格式 {form id="0" empty="" type='' }{/form}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagForm(array $tag, string $content): string {
        $id = !empty($tag['id']) ? $this->varOrvalue($tag['id']) : 0;
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $type = !empty($tag['type']) ? $tag['type'] : 'config';
        if ($type == 'data' && is_numeric($id)) {
            $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
            $key = !empty($tag['key']) ? $tag['key'] : 'key';
            $item = !empty($tag['item']) ? $tag['item'] : 'item';

            $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
            $var = '$_' . uniqid();
            $parseStr .= '$libForm=new \app\home\lib\Forms($rrz,$env); ';
            $parseStr .= $var . '=$libForm->getFormData(' . $id . ',' . $limit . '); ';

            $parseStr .= 'if( count(' . $var . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
            $parseStr .= 'else: $i=1; ';
            $parseStr .= 'foreach(' . $var . ' as $' . $key . '=>$' . $item . '): ';
            $parseStr .= '?>';

            // 循环体中的内容
            $parseStr .= $content;
            $parseStr .= '<?php $i++; endforeach; unset(' . $var . ',$' . $item . ',$' . $key . '); endif; ?>';

        } else {
            $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
            $parseStr .= ' $libForm=new \app\home\lib\Forms($rrz,$env);';
            $parseStr .= ' $form=$libForm->getInfo(' . $id . ');';
            $parseStr .= 'if(!$form) : echo htmlspecialchars_decode("' . $empty . '") ;';
            $parseStr .= 'else:   ';
            $parseStr .= '?>';
            $parseStr .= $content;
            $parseStr .= '<?php unset($form); endif; ?>';
        }
        return $parseStr;
    }

    /**
     * 查询列表
     * 格式{search type="item" keywords="" limit="5" page="1" empty="" }{/search}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagSearch(array $tag, string $content): string {
        $type = isset($tag['type']) ? $tag['type'] : '';
        $typeId = !empty($tag['typeid']) ? $this->varOrvalue($tag['typeid']) : 0;
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $page = !empty($tag['page']) ? $this->varOrvalue($tag['page']) : 0;

        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';

        $parseStr = '<?php $__DATA__=[]; $rrz=$rrz??[];$env=$env??[]; ';
        $parseStr .= '$libArcList=new \app\home\lib\ArcList($rrz,$env); ';
        $parseStr .= '$__DATA__=$libArcList->search(' . $typeId . ',"' . $type . '"?:$_GET["t"]??"article",' . $limit . ',' . $page . '?:$_GET["p"]??1); ';
        $parseStr .= 'if(!$__DATA__||$__DATA__["count"]==0 ) : echo htmlspecialchars_decode("' . $empty . '") ; ';
        $parseStr .= 'else: $i=1;  ';
        $parseStr .= 'foreach($__DATA__["list"] as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset($' . $item . ',$' . $key . '); endif; ?>';

        return $parseStr;
    }

    /**
     * HOT热门搜索词
     * {hotwords limit="5" maxlength=""}{/hotwords}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagHotwords(array $tag, string $content): string {
        $limit = !empty($tag['limit']) && is_numeric($tag['limit']) ? intval($tag['limit']) : (!empty($tag['row']) && is_numeric($tag['row']) ? intval($tag['row']) : 5);

        $maxlength = !empty($tag['maxlength']) && is_numeric($tag['maxlength']) ? intval($tag['maxlength']) : 10;
        $days = !empty($tag['days']) && is_numeric($tag['days']) ? intval($tag['days']) : 30;

        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; ';
        $var = '$_' . uniqid();
        $parseStr .= '$libForm=new \app\home\lib\Forms($rrz,$env); ';
        $parseStr .= $var . '=$libForm->getHotwords(' . $limit . ',' . $maxlength . ',' . $days . '); ';

        $parseStr .= 'if( count(' . $var . ')==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach(' . $var . ' as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; unset($var,$' . $item . ',$' . $key . ');  endif; ?>';
        return $parseStr;
    }

    /**
     * 当前页面分类导航数据
     * {sidebar}{/sidebar}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagSidebar(array $tag, string $content): string {
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $libMenus = new \app\home\lib\Menus($rrz,$env); ';
        $parseStr .= '$sidebar=$libMenus->getSidebar($env["page"],$rrz,' . $limit . '); ';
        $parseStr .= 'if(!$sidebar) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: ?>';
        $parseStr .= $content;
        $parseStr .= '<?php unset($sidebar); endif; ?>';
        return $parseStr;
    }

    /**
     * {break /}
     * @param array $tag
     * @return string
     */
    public function tagBreak(array $tag): string {
        return '<?php break; ?>';
    }

    /**
     * {continue /}
     * @param array $tag
     * @return string
     */
    public function tagContinue(array $tag): string {
        return '<?php continue; ?>';
    }

    /**
     * {each list='/s.png,/.t.png'} {/each}
     * @param array $tag
     * @return string
     */
    public function tagEach(array $tag, string $content): string {
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $list = $this->varOrvalue(!empty($tag['list']) ? $tag['list'] : '');
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');

        $parseStr = '<?php  $rrz=$rrz??[];$env=$env??[]; $_list=' . $list . '; ' . "\r\n";
        $parseStr .= '(function()use($rrz,$env,$_list){ ' . "\r\n";
        $parseStr .= '$_list=(is_string($_list)&&$_list) ? array_filter(explode(",",$_list)) : (is_array($_list)?$_list:[]);' . "\r\n";;

        $parseStr .= 'if( count($_list)==0 ) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach($_list as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';
        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach; endif; })(); unset($_list); ?>';
        return $parseStr;
    }

    /**
     * 品牌列表
     * 格式： {brands}{/brands}
     * @param array $tag
     * @param string $content
     * @return string
     */
    public function tagBrands(array $tag, string $content): string {
        $key = !empty($tag['key']) ? $tag['key'] : 'key';
        $item = !empty($tag['item']) ? $tag['item'] : 'item';
        $empty = htmlspecialchars(isset($tag['empty']) ? $tag['empty'] : '');
        $limit = !empty($tag['limit']) ? $this->varOrvalue($tag['limit']) : $this->varOrvalue(!empty($tag['row']) ? '0,' . $tag['row'] : 0);
        $page = !empty($tag['page']) ? $this->varOrvalue($tag['page']) : 0;


        $parseStr = '<?php $__DATA__=[]; $rrz=$rrz??[];$env=$env??[];';
        $parseStr .= '$libGoods=new \app\home\lib\Goods($rrz,$env);';
        $parseStr .= ' $__DATA__=$libGoods->getBrandList(' . $limit . ',' . $page . '?:I("p",1)' . ',$rrz,$env);';

        $parseStr .= 'if(!$__DATA__||$__DATA__["count"]==0) : echo htmlspecialchars_decode("' . $empty . '") ;';
        $parseStr .= 'else: $i=1; ';
        $parseStr .= 'foreach($__DATA__["list"] as $' . $key . '=>$' . $item . '): ';
        $parseStr .= '?>';

        // 循环体中的内容
        $parseStr .= $content;
        $parseStr .= '<?php $i++; endforeach;unset($' . $item . ',$' . $key . '); endif; ?>';

        return $parseStr;
    }

}