-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.2.7
-- Date : 2021-07-14 11:34:03
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1626230859', '127.0.0.1', '172', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', '', '', '0', '/storage/images/20210712/57739ffecbd6b515a2ec92d3e03a6683.jpg', '1', '1', '1', '1001', 'single', '', '', '10专注废气废水处理及环保工程服务商', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">某某环保治理有限公司成立于中国品牌咨询和设计行业开始崛起的上世纪90年代，至今已发展成为中国颇具规模和影响力的综合性品牌战略咨询和设计公司。不同于管理咨询公司和单纯的设计公司，某某专注于为客户创造和管理品牌，提供从品牌资产研究、市场洞察、品牌机会分析、品牌战略、品牌组合规划、命名和语词创作、设计（包括品牌识别设计、环境空间导示设计、包装设计、网络设计）到内部品牌导入、品牌管理制度建设的综合性服务，以提升客户在海内外的品牌影响力。某某总部设在北京，全公司拥有700多名员工。某某的客户均为各个行业的领导品牌，涵盖从B2B到B2C的不同领域。<br style=\"color: rgb(102, 102, 102); font-family: &quot;Microsoft Yahei&quot;, Helvetica, sans-serif; font-size: 14px; text-align: justify; text-indent: 28px; background-color: rgb(248, 248, 248);\"/>品牌源于专业，某某拥有从策略到设计、再到制作落地的完整产业链，我们的核心服务是通过科学有效的、国际化的设计和品牌管理之道，帮助客户构建卓越的品牌体系，协助更多的中国企业塑造国际化的品牌形象，在世界范围内树立属于中国企业的优秀的品牌形象和人文风格。 我们信仰专业的力量，用优秀的设计帮助客户降低企业运营成本，创造超越竞争对手的品牌竞争力，以深度拓展设计的商业价值，用品牌的力量使客户实现商业目标，用品牌的力量驱动企业的持续发展。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">某某集结了中国颇具实力与创新力的有为之士，拥有一个汇聚国内外知名专家学者教授及众多知名院校毕业的拥有资深行业经验的视觉设计和品牌咨询精英组成的优秀团队。通过每年定期进行的与欧洲顶尖品牌设计公司设计师互换互访计划，有效的确保我们的设计和品牌管理理念与国际领先水平保持同步。 某某拥有由24个国际联盟合作伙伴组成的全球跨领域合作网络，全面覆盖从品牌研究、视觉设计、产品造型到空间规划的顶尖力量，强强联手，为客户创造世界领先的品牌价值。同时，欢迎热爱设计的朋友们加盟某某，共同实现人生价值，为中国设计的发展作出我们的贡献。<br style=\"color: rgb(102, 102, 102); font-family: &quot;Microsoft Yahei&quot;, Helvetica, sans-serif; font-size: 14px; text-align: justify; text-indent: 28px; background-color: rgb(248, 248, 248);\"/>二十年来，我们始终以&quot;信仰专业&quot;为图腾，矢志不渝的维护着某某乃至中国设计的风骨；二十年来，我们用专业的力量，改变着中国企业的品牌形象，成就了某某发展为中国创意设计标杆的理想。 未来，某某将继续专注于设计和品牌管理，希望通过我们的专业力量为中国软实力的提升添砖加瓦，展现中国文化创意之美，加速提升中国品牌在国际上的影响力。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><div style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; text-align: center;\"><p><img src=\"/storage/images/20210710/327e21169312fd988764cbc5a2fb0d7e.jpg\"/></p></div><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '              ', 'true', '1626156880');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '新闻中心', '', '', '0', '', '2', '1', '2', '1002', '', '', '', '以匠心匠艺铸就环保工程', '', '    ', '    ', 'true', '1626069152');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '合作案例', '', '', '0', '', '3', '1', '3', '1003', 'img', '', '', '以务实为基础，以创新为导向，以质量为生命，以市场谋发展', '', '        ', '        ', 'true', '1626081478');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '人才招聘', '', '', '0', '', '4', '1', '4', '1004', 'single', '', '', '', '', '<p><img src=\"/storage/images/20210710/b9a1fd15b07f318ab51329e0538c45fe.jpg\"/></p><p><br/></p>', '    ', 'true', '1626075340');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '在线留言', '', '', '0', '', '5', '1', '5', '1005', 'liuyan', '', '', '  ', '', '    ', '    ', 'true', '1626082134');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '联系我们', '', '', '0', '', '6', '1', '6', '1006', 'single', '', '', '咨询热线：020-88888888QQ：88888888地址：广东省广州市番禺经济开发区', '', '<p style=\"color: rgb(0, 0, 0); white-space: normal; margin-top: 5px; margin-bottom: 5px; font-family: sans-serif; text-align: center;\">咨询热线：020-88888888</p><p style=\"color: rgb(0, 0, 0); white-space: normal; margin-top: 5px; margin-bottom: 5px; font-family: sans-serif;\"><br/></p><p style=\"color: rgb(0, 0, 0); white-space: normal; margin-top: 5px; margin-bottom: 5px; font-family: sans-serif; text-align: center;\">QQ：88888888</p><p style=\"color: rgb(0, 0, 0); white-space: normal; margin-top: 5px; margin-bottom: 5px; font-family: sans-serif;\"><br/></p><p style=\"color: rgb(0, 0, 0); white-space: normal; margin-top: 5px; margin-bottom: 5px; font-family: sans-serif; text-align: center;\">地址：广东省广州市番禺经济开发区</p><p><iframe class=\"ueditor_baidumap\" src=\"/plugins/wxeditor/ueditor/dialogs/map/show.html#center=116.404,39.915&zoom=10&width=100%&height=400&markers=116.404,39.915&markerStyles=l,A\" frameborder=\"0\" width=\"100%\" height=\"400\"></iframe></p>', '    ', 'true', '1626075353');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '公司资讯', '', '', '2', '', '2,7', '2', '1', '10021001', '', '', '', '', '', '  ', '  ', 'true', '1625900049');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '行业动态', '', '', '2', '', '2,8', '2', '2', '10021002', '', '', '', '', '', '  ', '  ', 'true', '1625900055');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '常见问题', '', '', '2', '', '2,9', '2', '3', '10021003', '', '', '', '', '', '  ', '  ', 'true', '1625900061');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '废水治理工程', '', '', '3', '/storage/images/20210712/7dc1f8fc6d52ff4eff61bedea52a2850.jpg', '3,10', '2', '1', '10031001', 'img', '', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '<p>专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p>', '        ', 'true', '1626081487');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '粉尘治理工程', '', '', '3', '/storage/images/20210712/1300c267a662a25666e08c7d83b4172c.jpg', '3,11', '2', '2', '10031002', 'img', '', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '<p>专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p>', '      ', 'true', '1626081493');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '噪音处理工程', '', '', '3', '/storage/images/20210712/930460a1e8fdf47bde676c891c74999e.jpg', '3,12', '2', '3', '10031003', 'img', '', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '<p>专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p>', '      ', 'true', '1626081499');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '废气处理工程', '', '', '3', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '3,13', '2', '4', '10031004', 'img', '', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '<p>专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p>', '        ', 'true', '1626081505');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', '以环保节能为根本', 'BOOTH DESIGN INNOVATION', '', '0', '', '14', '1', '7', '1007', '', '', '', '事实胜于雄辩，服务创造价值', '', '  ', '  ', 'true', '1626059827');
INSERT INTO `rrz_article_nodes` VALUES ('15', '0', '加工技术', '3000 square meters production base', '', '14', '/storage/images/20210712/89150c96b4984cda046764312602021d.jpg', '14,15', '2', '1', '10071001', '', '', '', '上万平米的厂房，生产布局合理，面积可以有效使用。轻松承接大型项目无压力，常年上百款岗亭现货储备，大大提升出货率。上百个岗亭项目有：杭州报刊亭、上海公交、世博文化中心、杭州阿里巴巴总部、杭州高速交警岗亭等。', '', '      ', '      ', 'true', '1626146239');
INSERT INTO `rrz_article_nodes` VALUES ('16', '0', '工艺技术', 'Delivery in 3 days', '', '14', '/storage/images/20210712/4af38d0e069d73d021b764c792a3abca.jpg', '14,16', '2', '2', '10071002', '', '', '', ' 深知质量、效率对生产企业的重要性，坚持把生产环节成本降低回馈广大客户。我们坚持用高科技设备来提高生产效率。公司拥有进口剪板机、折弯机、刨槽机、大型开平机、数控车床、冲床、激光切割机等，形成完善的工业化生产流水线。', '', '    ', '    ', 'true', '1626146260');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', '技术能力强', 'More than 99% of the shipment quality', '', '14', '/storage/images/20210712/6f99e48cd04f8e67df729b0d64f2b0ab.jpg', '14,17', '2', '3', '10071003', '', '', '', '拥有10多人设计研发团队，从构思到设计，再到专人跟踪和团队支持服务，专业的设计能力，有效满足广大用户多样化定制需求。', '', '    ', '    ', 'true', '1626146275');
INSERT INTO `rrz_article_nodes` VALUES ('18', '0', '售后无忧', '24 hours door-to-door treatment', '', '14', '/storage/images/20210712/41b48578068b3007aa7b25743d4f524c.jpg', '14,18', '2', '4', '10071004', '', '', '', ' 公司提供全年7*24小时电话咨询服务，对于电话沟通不能及时解决的状况，公司将有针对性的派出服务团队（项目经理、技术技工）到工地服务，在短时间内为客户解决问题。做到从产品质量、客户感受、售后无忧的一站式服务。', '', '    ', '    ', 'true', '1626146290');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '7', '如何选用除尘设备？', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626069640', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('2', '7', '如何选用除尘设备？二', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626069634', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('3', '7', '如何选用除尘设备？三', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626069628', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('4', '7', '如何选用除尘设备？四', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626069623', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('5', '7', '如何选用除尘设备？五', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626069617', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('6', '7', '如何选用除尘设备？六', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626080167', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '1', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('7', '7', '如何选用除尘设备？七', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626080175', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '1', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('8', '7', '如何选用除尘设备？八', '/storage/images/20210712/fd7d23779b509bdae7873d95d8a9b3d1.jpg', '', '<p><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">如何选用除尘设备？</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">2、要充分了解含尘废气体中的尘粒的颗粒大小，理化性质，入口处废气的浓度，以及废气的温度等等，将这些信息告知除尘设备供货商，以便供货商具有针对性的为您选择除尘效率好的除尘设备。在这里需要提醒下，对于处理高温、高腐蚀性废气，要对设备进行防腐蚀处理。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">3、由于粉尘的黏性不一、如果粉尘容易粘结到除尘设备上，就不要采用干法除尘方式；对于电阻偏离正常值的烟粉尘，不要选择静电除尘； 具有憎水性质或者纤维性质的粉尘，也不要用湿法除尘。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">4、由于粉尘粒径差异化，而不同类型的除尘器设备也要对应所能捕捉的粒径粉尘，根据除尘分级选购除尘设备。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">5、由于除尘过程中只是将气体中的颗粒粉尘，转移成固体或者液体的状态，像湿式除尘器需要设有废水处理系统，湿法除尘过程中粉尘进入到液体中，所形成的泥浆和废水需要再次处理，防止二次污染。&nbsp;</span><br style=\"white-space: normal; color: rgb(65, 65, 65); font-family: &quot;microsoft yahei&quot;, 宋体; font-size: 12px;\"/><span style=\"color: rgb(0, 0, 0); font-family: sans-serif;\">6、订购除尘器的一些因素了解了，那么定制完成后的设备如何安放呢?设备的位置要根据当前可利用的空间，以及周围的环境等因素，还要考虑其安装是否经济，设备是否便于今后的操作及维护。</span></p>', '', '', '', '1626080171', '1625901284', 'true', '', '如何选用除尘设备？1、先了解下国家及当地有关部门制定的废气排放标准，比方说浓度范围值区间是多少，但是由于锅炉的安装及运行时间长短不一、排放的标准也会不同；一般而言，在一个车间内所排放的烟粉尘浓度应低于车间所能容纳的粉尘浓度值。2、要充分了解含尘废气体', '', '0', '1625901284', '0', '0', '1', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('9', '8', '矿山除尘器存在问题', '/storage/images/20210712/969c7243a8a4e312058052092c6a7d9b.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大幅增加，通风能力下降，扬尘严重。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">工艺布置看，粉尘进入除尘器的管道，其入口管处的弯头使系统阻力增大，弯头部位易被粉尘磨损和堵塞。采用螺旋输送机和分格轮输送袋式除尘器捕集下来的粉尘，电耗增加，机械维护工作量加大；经常需要拆卸分格轮下料器，久而久之，下料器法兰盘漏风，加剧灰斗漏风。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">皮带机上的物料在下落过程中，空气与物料一起进入密闭的除尘罩内，含尘气体通过罩壁上的缝隙和孔口向罩外扩散，污染环境。另外，由于皮带机转角处除尘点设置不当，除尘器无论是开与停对下级皮带机的落差扬尘几乎无影响。因此，6号破碎机运行以来，该矿山除尘器就没有运行过，下级皮带机一直处在粉尘弥漫之中&gt;其工艺布置。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">为了减少因破碎机壳体漏风造成的扬尘，在实际生产中，当物料干燥时经常在破碎机入口处淋水，其结果加剧袋式除尘器的滤袋糊袋和下料器堵塞。由于袋式除尘器是间歇性清灰，当除尘器正常工作时，分格轮的漏风也是个不容忽视的问题。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">布袋收尘器及配套件的故障较多，不仅影响正常的除尘，而且增加设备的维护工作量。从设备检修的统计情况看，配备件质量差是引起设备故障较多的重要原因。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069693', '1625901361', 'true', '', '矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大', '', '0', '1625901361', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('10', '8', '矿山除尘器存在问题二', '/storage/images/20210712/969c7243a8a4e312058052092c6a7d9b.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大幅增加，通风能力下降，扬尘严重。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">工艺布置看，粉尘进入除尘器的管道，其入口管处的弯头使系统阻力增大，弯头部位易被粉尘磨损和堵塞。采用螺旋输送机和分格轮输送袋式除尘器捕集下来的粉尘，电耗增加，机械维护工作量加大；经常需要拆卸分格轮下料器，久而久之，下料器法兰盘漏风，加剧灰斗漏风。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">皮带机上的物料在下落过程中，空气与物料一起进入密闭的除尘罩内，含尘气体通过罩壁上的缝隙和孔口向罩外扩散，污染环境。另外，由于皮带机转角处除尘点设置不当，除尘器无论是开与停对下级皮带机的落差扬尘几乎无影响。因此，6号破碎机运行以来，该矿山除尘器就没有运行过，下级皮带机一直处在粉尘弥漫之中&gt;其工艺布置。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">为了减少因破碎机壳体漏风造成的扬尘，在实际生产中，当物料干燥时经常在破碎机入口处淋水，其结果加剧袋式除尘器的滤袋糊袋和下料器堵塞。由于袋式除尘器是间歇性清灰，当除尘器正常工作时，分格轮的漏风也是个不容忽视的问题。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">布袋收尘器及配套件的故障较多，不仅影响正常的除尘，而且增加设备的维护工作量。从设备检修的统计情况看，配备件质量差是引起设备故障较多的重要原因。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069687', '1625901361', 'true', '', '矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大', '', '0', '1625901361', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('11', '8', '矿山除尘器存在问题三', '/storage/images/20210712/969c7243a8a4e312058052092c6a7d9b.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大幅增加，通风能力下降，扬尘严重。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">工艺布置看，粉尘进入除尘器的管道，其入口管处的弯头使系统阻力增大，弯头部位易被粉尘磨损和堵塞。采用螺旋输送机和分格轮输送袋式除尘器捕集下来的粉尘，电耗增加，机械维护工作量加大；经常需要拆卸分格轮下料器，久而久之，下料器法兰盘漏风，加剧灰斗漏风。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">皮带机上的物料在下落过程中，空气与物料一起进入密闭的除尘罩内，含尘气体通过罩壁上的缝隙和孔口向罩外扩散，污染环境。另外，由于皮带机转角处除尘点设置不当，除尘器无论是开与停对下级皮带机的落差扬尘几乎无影响。因此，6号破碎机运行以来，该矿山除尘器就没有运行过，下级皮带机一直处在粉尘弥漫之中&gt;其工艺布置。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">为了减少因破碎机壳体漏风造成的扬尘，在实际生产中，当物料干燥时经常在破碎机入口处淋水，其结果加剧袋式除尘器的滤袋糊袋和下料器堵塞。由于袋式除尘器是间歇性清灰，当除尘器正常工作时，分格轮的漏风也是个不容忽视的问题。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">布袋收尘器及配套件的故障较多，不仅影响正常的除尘，而且增加设备的维护工作量。从设备检修的统计情况看，配备件质量差是引起设备故障较多的重要原因。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069682', '1625901361', 'true', '', '矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大', '', '0', '1625901361', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('12', '8', '矿山除尘器存在问题四', '/storage/images/20210712/969c7243a8a4e312058052092c6a7d9b.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大幅增加，通风能力下降，扬尘严重。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">工艺布置看，粉尘进入除尘器的管道，其入口管处的弯头使系统阻力增大，弯头部位易被粉尘磨损和堵塞。采用螺旋输送机和分格轮输送袋式除尘器捕集下来的粉尘，电耗增加，机械维护工作量加大；经常需要拆卸分格轮下料器，久而久之，下料器法兰盘漏风，加剧灰斗漏风。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">皮带机上的物料在下落过程中，空气与物料一起进入密闭的除尘罩内，含尘气体通过罩壁上的缝隙和孔口向罩外扩散，污染环境。另外，由于皮带机转角处除尘点设置不当，除尘器无论是开与停对下级皮带机的落差扬尘几乎无影响。因此，6号破碎机运行以来，该矿山除尘器就没有运行过，下级皮带机一直处在粉尘弥漫之中&gt;其工艺布置。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">为了减少因破碎机壳体漏风造成的扬尘，在实际生产中，当物料干燥时经常在破碎机入口处淋水，其结果加剧袋式除尘器的滤袋糊袋和下料器堵塞。由于袋式除尘器是间歇性清灰，当除尘器正常工作时，分格轮的漏风也是个不容忽视的问题。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">布袋收尘器及配套件的故障较多，不仅影响正常的除尘，而且增加设备的维护工作量。从设备检修的统计情况看，配备件质量差是引起设备故障较多的重要原因。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069676', '1625901361', 'true', '', '矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大', '', '0', '1625901361', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('13', '8', '矿山除尘器存在问题五', '/storage/images/20210712/969c7243a8a4e312058052092c6a7d9b.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大幅增加，通风能力下降，扬尘严重。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">工艺布置看，粉尘进入除尘器的管道，其入口管处的弯头使系统阻力增大，弯头部位易被粉尘磨损和堵塞。采用螺旋输送机和分格轮输送袋式除尘器捕集下来的粉尘，电耗增加，机械维护工作量加大；经常需要拆卸分格轮下料器，久而久之，下料器法兰盘漏风，加剧灰斗漏风。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">皮带机上的物料在下落过程中，空气与物料一起进入密闭的除尘罩内，含尘气体通过罩壁上的缝隙和孔口向罩外扩散，污染环境。另外，由于皮带机转角处除尘点设置不当，除尘器无论是开与停对下级皮带机的落差扬尘几乎无影响。因此，6号破碎机运行以来，该矿山除尘器就没有运行过，下级皮带机一直处在粉尘弥漫之中&gt;其工艺布置。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">为了减少因破碎机壳体漏风造成的扬尘，在实际生产中，当物料干燥时经常在破碎机入口处淋水，其结果加剧袋式除尘器的滤袋糊袋和下料器堵塞。由于袋式除尘器是间歇性清灰，当除尘器正常工作时，分格轮的漏风也是个不容忽视的问题。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">布袋收尘器及配套件的故障较多，不仅影响正常的除尘，而且增加设备的维护工作量。从设备检修的统计情况看，配备件质量差是引起设备故障较多的重要原因。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069671', '1625901361', 'true', '', '矿山除尘器的过滤面积选型过小，实际抽风量不足，破碎机下料口的除尘罩和破碎机腔内难以形成微负压，造成岗位环境粉尘较大。当破碎物料湿度较大时-雨后或物料淋水后，进入除尘器的粉尘颗粒较破碎干物料时粗，袋式除尘器易糊袋，下料器易堵塞，致使袋式除尘器通风阻力大', '', '0', '1625901361', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('14', '9', '脉冲布袋收尘器性能比较', '/storage/images/20210712/94fce15767d8ce99f88f7ede84e432d8.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">1)结构形式</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用&nbsp; &nbsp;高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本身，而与入口浓度关系不大，所以布袋数量减少有限。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">2)清灰机理</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">脉冲布袋除尘器的除尘效率受滤料材质和滤料表面粉尘层特性影响。新滤袋直接使用时除尘效率较低，经过一段时间使用后，滤袋上附着的粉尘达到2一3g/mZ时，除尘效率就能超过90%，粉尘达到150g/mz时，除尘效率可超过99%。脉冲清灰后，大部分粉尘从滤袋上剥离，但还会残留一些。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">后，残留的粉尘量会达到动态平衡，除尘效率一般大于99 %，甚至超过99.9 %。正常状态下，脉冲除尘器对粉尘中，粉尘的除尘效率通常大于90 %。因为滤袋表面附着的粉尘层增厚，增加了对细粉尘的过滤效率，同时也增加了部分阻力，过于稀薄的粉尘层会降低收集微细粉尘和重金属的效率。在电袋复合除尘器中，前置电场除去80 %的粉尘，经过电场后的荷电粉尘进入布袋除尘区域。由于荷电粉尘互相排斥，形成的粉尘层较疏松，使2. 5m及以下的微细粉尘容易进入滤料内层，阻塞滤料内层孔隙，增大阻力，且不能通过脉冲喷吹剥离，缩短滤袋寿命，同时部分微细粉尘穿过滤袋造成超标排放。延长滤袋使用寿命的方法是预涂灰，这种方法在电厂中也较常用。但预涂灰劳动强度大，对周边环境有&nbsp; &nbsp;的污染，并不适用于工业用户。另外，布袋收尘器在高过滤风速下，如滤袋表面无&nbsp; &nbsp;厚度的粉尘层，微细粉尘很易穿过滤料的孔隙，这就是在动态过程中，电袋复合除尘器难以捕集微细粉尘的主要原因。一般电袋复合除尘器所选用的扁袋除尘器是单列双层重叠的扁袋结构形式，滤袋之间间隙较小，清灰后上层滤袋剥离的粉尘易落到下层滤袋表面造成二次污染， 影口向清灰效率。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069734', '1625901415', 'true', '', '1)结构形式与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用 高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本', '', '1', '1625901415', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('15', '9', '脉冲布袋收尘器性能比较二', '/storage/images/20210712/94fce15767d8ce99f88f7ede84e432d8.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">1)结构形式</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用&nbsp; &nbsp;高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本身，而与入口浓度关系不大，所以布袋数量减少有限。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">2)清灰机理</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">脉冲布袋除尘器的除尘效率受滤料材质和滤料表面粉尘层特性影响。新滤袋直接使用时除尘效率较低，经过一段时间使用后，滤袋上附着的粉尘达到2一3g/mZ时，除尘效率就能超过90%，粉尘达到150g/mz时，除尘效率可超过99%。脉冲清灰后，大部分粉尘从滤袋上剥离，但还会残留一些。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">后，残留的粉尘量会达到动态平衡，除尘效率一般大于99 %，甚至超过99.9 %。正常状态下，脉冲除尘器对粉尘中，粉尘的除尘效率通常大于90 %。因为滤袋表面附着的粉尘层增厚，增加了对细粉尘的过滤效率，同时也增加了部分阻力，过于稀薄的粉尘层会降低收集微细粉尘和重金属的效率。在电袋复合除尘器中，前置电场除去80 %的粉尘，经过电场后的荷电粉尘进入布袋除尘区域。由于荷电粉尘互相排斥，形成的粉尘层较疏松，使2. 5m及以下的微细粉尘容易进入滤料内层，阻塞滤料内层孔隙，增大阻力，且不能通过脉冲喷吹剥离，缩短滤袋寿命，同时部分微细粉尘穿过滤袋造成超标排放。延长滤袋使用寿命的方法是预涂灰，这种方法在电厂中也较常用。但预涂灰劳动强度大，对周边环境有&nbsp; &nbsp;的污染，并不适用于工业用户。另外，布袋收尘器在高过滤风速下，如滤袋表面无&nbsp; &nbsp;厚度的粉尘层，微细粉尘很易穿过滤料的孔隙，这就是在动态过程中，电袋复合除尘器难以捕集微细粉尘的主要原因。一般电袋复合除尘器所选用的扁袋除尘器是单列双层重叠的扁袋结构形式，滤袋之间间隙较小，清灰后上层滤袋剥离的粉尘易落到下层滤袋表面造成二次污染， 影口向清灰效率。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069729', '1625901415', 'true', '', '1)结构形式与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用 高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本', '', '0', '1625901415', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('16', '9', '脉冲布袋收尘器性能比较三', '/storage/images/20210712/94fce15767d8ce99f88f7ede84e432d8.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">1)结构形式</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用&nbsp; &nbsp;高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本身，而与入口浓度关系不大，所以布袋数量减少有限。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">2)清灰机理</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">脉冲布袋除尘器的除尘效率受滤料材质和滤料表面粉尘层特性影响。新滤袋直接使用时除尘效率较低，经过一段时间使用后，滤袋上附着的粉尘达到2一3g/mZ时，除尘效率就能超过90%，粉尘达到150g/mz时，除尘效率可超过99%。脉冲清灰后，大部分粉尘从滤袋上剥离，但还会残留一些。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">后，残留的粉尘量会达到动态平衡，除尘效率一般大于99 %，甚至超过99.9 %。正常状态下，脉冲除尘器对粉尘中，粉尘的除尘效率通常大于90 %。因为滤袋表面附着的粉尘层增厚，增加了对细粉尘的过滤效率，同时也增加了部分阻力，过于稀薄的粉尘层会降低收集微细粉尘和重金属的效率。在电袋复合除尘器中，前置电场除去80 %的粉尘，经过电场后的荷电粉尘进入布袋除尘区域。由于荷电粉尘互相排斥，形成的粉尘层较疏松，使2. 5m及以下的微细粉尘容易进入滤料内层，阻塞滤料内层孔隙，增大阻力，且不能通过脉冲喷吹剥离，缩短滤袋寿命，同时部分微细粉尘穿过滤袋造成超标排放。延长滤袋使用寿命的方法是预涂灰，这种方法在电厂中也较常用。但预涂灰劳动强度大，对周边环境有&nbsp; &nbsp;的污染，并不适用于工业用户。另外，布袋收尘器在高过滤风速下，如滤袋表面无&nbsp; &nbsp;厚度的粉尘层，微细粉尘很易穿过滤料的孔隙，这就是在动态过程中，电袋复合除尘器难以捕集微细粉尘的主要原因。一般电袋复合除尘器所选用的扁袋除尘器是单列双层重叠的扁袋结构形式，滤袋之间间隙较小，清灰后上层滤袋剥离的粉尘易落到下层滤袋表面造成二次污染， 影口向清灰效率。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069723', '1625901415', 'true', '', '1)结构形式与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用 高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本', '', '1', '1625901415', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('17', '9', '脉冲布袋收尘器性能比较四', '/storage/images/20210712/94fce15767d8ce99f88f7ede84e432d8.jpg', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">1)结构形式</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用&nbsp; &nbsp;高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本身，而与入口浓度关系不大，所以布袋数量减少有限。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">2)清灰机理</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">脉冲布袋除尘器的除尘效率受滤料材质和滤料表面粉尘层特性影响。新滤袋直接使用时除尘效率较低，经过一段时间使用后，滤袋上附着的粉尘达到2一3g/mZ时，除尘效率就能超过90%，粉尘达到150g/mz时，除尘效率可超过99%。脉冲清灰后，大部分粉尘从滤袋上剥离，但还会残留一些。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">后，残留的粉尘量会达到动态平衡，除尘效率一般大于99 %，甚至超过99.9 %。正常状态下，脉冲除尘器对粉尘中，粉尘的除尘效率通常大于90 %。因为滤袋表面附着的粉尘层增厚，增加了对细粉尘的过滤效率，同时也增加了部分阻力，过于稀薄的粉尘层会降低收集微细粉尘和重金属的效率。在电袋复合除尘器中，前置电场除去80 %的粉尘，经过电场后的荷电粉尘进入布袋除尘区域。由于荷电粉尘互相排斥，形成的粉尘层较疏松，使2. 5m及以下的微细粉尘容易进入滤料内层，阻塞滤料内层孔隙，增大阻力，且不能通过脉冲喷吹剥离，缩短滤袋寿命，同时部分微细粉尘穿过滤袋造成超标排放。延长滤袋使用寿命的方法是预涂灰，这种方法在电厂中也较常用。但预涂灰劳动强度大，对周边环境有&nbsp; &nbsp;的污染，并不适用于工业用户。另外，布袋收尘器在高过滤风速下，如滤袋表面无&nbsp; &nbsp;厚度的粉尘层，微细粉尘很易穿过滤料的孔隙，这就是在动态过程中，电袋复合除尘器难以捕集微细粉尘的主要原因。一般电袋复合除尘器所选用的扁袋除尘器是单列双层重叠的扁袋结构形式，滤袋之间间隙较小，清灰后上层滤袋剥离的粉尘易落到下层滤袋表面造成二次污染， 影口向清灰效率。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1626069717', '1625901415', 'true', '', '1)结构形式与脉冲除尘器相比，电袋复合除尘器多了2级电场进行静电除尘，但增加的静电除尘并不能对等减小布袋收尘器的规模，因为布袋数量主要取决于烟气流量和过滤风速，并不取决于含尘浓度。虽然可选用 高过滤风速减少过滤面积，由于布袋的过滤风速基本取决于材料本', '', '10', '1625901415', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('18', '10', '案例展示一', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '', '<p><img src=\"/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg\"/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1625901488', '1625901488', 'true', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '1', '1625901488', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('19', '10', '案例展示二', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '', '<p><img src=\"/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg\"/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1625901488', '1625901488', 'true', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '0', '1625901488', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('20', '10', '案例展示三', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '', '<p><img src=\"/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg\"/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1625901488', '1625901488', 'true', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '0', '1625901488', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('21', '10', '案例展示四', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '', '<p><img src=\"/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg\"/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1625901488', '1625901488', 'true', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '1', '1625901488', '0', '0', '0', '100', '', '');
INSERT INTO `rrz_articles` VALUES ('22', '10', '案例展示五', '/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg', '', '<p><img src=\"/storage/images/20210710/a4029ea6f806975f3261e09746cb295a.jpg\"/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及印刷印染，炼油造纸，化工化纤，电子、汽车、医疗PCB产业等工厂生产过程中产生的废水废气污染。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '', '', '1625901488', '1625901488', 'true', '', '专业制造PP材质系列水喷淋净化塔，PP风管，PP水槽等，以及低温等离子、高能离子除臭设备，生物除臭及废气催化燃烧净化一体化废气废水系统设备。公司废水污染控制团队拥有实操经验及案例，专业净化控制喷涂，酸洗，电镀，金属加工等生产过程中产生的废水油液，以及', '', '3', '1625901488', '0', '0', '0', '100', '', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某官网', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20210710/260b92bcd16a6240ac9f56ee48c48b3b.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20210710/260b92bcd16a6240ac9f56ee48c48b3b.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '环保节能智能空气净化器类网站人人站模板（带手机端）', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某有限公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某开发区', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '22.94703,113.38555', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://www.rrzcms.com/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '留言', 'a:3:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"电话\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:12:\"留言内容\";s:8:\"required\";s:1:\"0\";}}', '1625888608', '0');
INSERT INTO `rrz_forms` VALUES ('2', '首页报名', 'a:2:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"电话\";s:8:\"required\";s:1:\"1\";}}', '1626061576', '0');
INSERT INTO `rrz_forms` VALUES ('3', '产品报名', 'a:5:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"你的姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"联系电话\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"电子邮箱\";s:8:\"required\";s:1:\"0\";}i:3;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"联系地址\";s:8:\"required\";s:1:\"0\";}i:4;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:12:\"留言内容\";s:8:\"required\";s:1:\"0\";}}', '1626078210', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', '产品名称一', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('2', '产品名称二', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('3', '产品名称三', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('4', '产品名称四', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('5', '产品名称五', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('6', '产品名称六', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('7', '产品名称七', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('8', '产品名称八', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '0', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');
INSERT INTO `rrz_goods` VALUES ('9', '产品名称九', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '5', '0', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg', '/storage/images/20210710/2cc33fe9834003efa40dc81bd5f2af09.jpg,/storage/images/20210710/2e327116a5b09a913a6d830f39cc56ef.jpg,/storage/images/20210710/e9bdcc56e91ec4b72618ebfa3d994cf6.jpg', '0.00', '0.00', '999', 'false', '0.00', '', '', '<p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工废气净化等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">一个完整的废气净化系统一般由五部分组成，它们是捕集污染气体的废气收集装置（集气罩），连接系统各组成部分的管道，使污染气体得以净化的净化装置，为气体流动提供动力的通风机，充分利用大气扩散稀释能力 减轻污染的烟囱。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">集气罩</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">污染物的捕集通常是指对设备敞口部位散发的含污染物的气流的控制及收集。通过对污染物的有效捕集，以保证周围良好的生产、生活环境，尽可能使输送及净化的气体量最少，效率最高。集气罩是用来捕集污染物的装置，其性能对局部排气净化系统的技术经济指标有直接影响。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管道</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">管进是废气污染控制系统中不可缺少的组成部分。管道系统在净化系统中 是用来输送气流的，通过管道使系统的设备和部件连成一个整体。合理地设计、 施工和使用管道系统，不仅能充分发挥控制装置的效能，而且直接关系到设计和 运转的经济合理性。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">净化设备</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">气体净化设备是净化系统的核心部分。当排气中污染物含量超过排放标准时，必须先进行净化处理，达到排放标准后才能排入大气。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">通风机是净化系统中气体流动的动力装置。通风机一般都放在净化设备后面，防止通风机的磨损和腐蚀。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br/></p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\">烟囱是净化系统的排气装置。由于净化后的气体中仍然还含有一定浓度的污染物，这些污染物经烟囱排放后在大气中扩散、稀释，并最终沉降到地面。为了保证地面污染物浓度不超过环境空气质从标准，烟囱必须具有一定的高度。 此外，为了保证废气净化系统能够正常运行，根据净化处理对象的不同，在净化系统中往往增设必要的辅助设备。例如：处理高温气体时的冷却装置、余热利用装置，满足钢材热胀冷缩变化的管道补偿器，输送易燃易爆气体时的防爆装置，以及用来调节系统风量和压力平衡的各种阀门，用于测量系统内各种参数的测量仪器、控制仪器和测孔，用于支撑和固定管道、设备的支架，用于降低风机噪 声的消音装置等。</p><p style=\"color: rgb(0, 0, 0); font-size: medium; white-space: normal; margin-top: 5px; margin-bottom: 5px;\"><br style=\"font-family: sans-serif; font-size: 16px;\"/></p><p><br/></p>', '', '0', '1625901168', '0', '0', '1', '0', '19', '100', '', 'true', '', '废气净化（Flue gas purification）主要是指针对工业场所产生的工业废气诸如粉尘颗粒物、烟气烟尘、异味气体、有毒有害气体进行治理的工作。常见的废气净化有工厂烟尘废气净化、车间粉尘废气净化、有机废气净化、废气异味净化、酸碱废气净化、化工', '');

-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat` VALUES ('1', '0', '产品中心', 'PRODUCT', '', '0', '', '1', '1', '1', '1001', '', '', '', '', '', '', '1626076381');
INSERT INTO `rrz_goods_cat` VALUES ('2', '0', '废气设备', '', '', '1', '', '1,2', '2', '1', '10011001', '', '', '', '', '', '', '1625897998');
INSERT INTO `rrz_goods_cat` VALUES ('3', '0', '除尘设备', '', '', '1', '', '1,3', '2', '2', '10011002', '', '', '', '', '', '', '1625898007');
INSERT INTO `rrz_goods_cat` VALUES ('4', '0', '废水处理设备', '', '', '1', '', '1,4', '2', '3', '10011003', '', '', '', '', '', '', '1625898282');
INSERT INTO `rrz_goods_cat` VALUES ('5', '0', '等离子烟气净化器', '', '', '2', '', '1,2,5', '3', '1', '100110011001', '', '', '', '', '', '', '1625898492');
INSERT INTO `rrz_goods_cat` VALUES ('6', '0', '喷淋塔', '', '', '2', '', '1,2,6', '3', '2', '100110011002', '', '', '', '', '', '', '1625898501');
INSERT INTO `rrz_goods_cat` VALUES ('7', '0', '光解净化器', '', '', '2', '', '1,2,7', '3', '3', '100110011003', '', '', '', '', '', '', '1625898514');
INSERT INTO `rrz_goods_cat` VALUES ('8', '0', 'RCO催化燃烧', '', '', '2', '', '1,2,8', '3', '4', '100110011004', '', '', '', '', '', '', '1625898525');
INSERT INTO `rrz_goods_cat` VALUES ('9', '0', '油烟净化器', '', '', '2', '', '1,2,9', '3', '5', '100110011005', '', '', '', '', '', '', '1625898535');
INSERT INTO `rrz_goods_cat` VALUES ('10', '0', '活性炭吸附箱', '', '', '2', '', '1,2,10', '3', '6', '100110011006', '', '', '', '', '', '', '1625899685');
INSERT INTO `rrz_goods_cat` VALUES ('11', '0', '湿式水膜除尘器', '', '', '3', '', '1,3,11', '3', '1', '100110021001', '', '', '', '', '', '', '1625899731');
INSERT INTO `rrz_goods_cat` VALUES ('12', '0', '滤筒除尘器', '', '', '3', '', '1,3,12', '3', '2', '100110021002', '', '', '', '', '', '', '1625899887');
INSERT INTO `rrz_goods_cat` VALUES ('13', '0', '旋风除尘器', '', '', '3', '', '1,3,13', '3', '3', '100110021003', '', '', '', '', '', '', '1625899895');
INSERT INTO `rrz_goods_cat` VALUES ('14', '0', '焊烟净化器', '', '', '3', '', '1,3,14', '3', '4', '100110021004', '', '', '', '', '', '', '1625899902');
INSERT INTO `rrz_goods_cat` VALUES ('15', '0', '废水消毒设备', '', '', '4', '', '1,4,15', '3', '1', '100110031001', '', '', '', '', '', '', '1625899912');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_search_keywords`
-- -----------------------------
INSERT INTO `rrz_search_keywords` VALUES ('1', '案例', 'article', '127.0.0.1', '6', '1626083508');
INSERT INTO `rrz_search_keywords` VALUES ('2', '产品', 'article', '127.0.0.1', '2', '1626166650');
INSERT INTO `rrz_search_keywords` VALUES ('3', '四', 'article', '127.0.0.1', '2', '1626166698');

-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481203', '1590481203');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1590481246', '1591322028');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481266', '1590481266');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1621244482', '1621244482');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1621244551', '1621244551');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '网站首页', '', 'wangzhanshouye', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '产品中心', '', 'chanpinzhongxin', '0', '3', '1', '/cat/1.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '新闻中心', '', 'xinwenzhongxin', '0', '4', '1', '/node/2.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '合作案例', '', 'hezuoanli', '0', '5', '1', '/node/3.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '人才招聘', '', 'rencaizhaopin', '0', '6', '1', '/node/4.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '在线留言', '', 'zaixianliuyan', '0', '7', '1', '/node/5.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '联系我们', '', 'lianxiwomen', '0', '8', '1', '/node/6.html', '8', '1008', 'false', '');
