-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.5
-- Date : 2021-12-01 10:30:28
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1638320864', '127.0.0.1', '233', '', '0', '1', 'cn', '1', '1', '1586479354', '1636420548');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('33', '0', '成功案例', 'case', 'chenggonganli', '0', '', '33', '1', '2', '1002', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('39', '0', '名师团队', 'PINJIA', 'kehupingjia', '0', '', '39', '1', '3', '1003', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '10年来，累计帮助超过500家企业解决扬尘污染问题', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '荣誉资质', 'Honor', 'rongyuzizhi/rongyuzizhi', '0', '', '11', '1', '4', '1004', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '荣誉资质', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('26', '0', '荣誉资质', 'honor', 'rongyuzizhi/rongyuzizhi', '11', '', '11,26', '2', '1', '10041001', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '专业团队', 'Design Team', 'rongyuzizhi/tuandui', '11', '', '11,12', '2', '2', '10041002', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '生产基地', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('15', '0', '新闻动态', 'NEWS', 'xinwendongtai', '0', '', '15', '1', '5', '1005', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '公司新闻', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('16', '0', '公司新闻', 'NEWS', 'gongsixinwen/gongsixinwen', '15', '', '15,16', '2', '1', '10051001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '公司新闻', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('17', '0', '行业动态', 'Industry News', 'gongsixinwen/xingyedongtai', '15', '', '15,17', '2', '2', '10051002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '行业动态', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('18', '0', '常见问题解答', 'FAQ', 'gongsixinwen/changjianwentijieda', '15', '', '15,18', '2', '3', '10051003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '常见问题解答', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('46', '0', '解决方案', '', 'jiejuefangan', '0', '', '46', '1', '6', '1006', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('19', '0', '关于我们', 'ABOUT US', 'guanyuwomen', '0', '/storage/images/20211201/1-1FRG61910M8.jpg', '19', '1', '7', '1007', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '关于我们', '', '', '广东某某机电制造有限公司成立于2003年，位于广东省广州市，占地面积约10亩，厂房面积约3500平方米，拥有卷板机、剪板机、折边机、埋弧自动焊机、CO2气体保护焊机、氩弧焊机、车床、摇臂钻床、自动调心翻转架等先进机械生产加工设备，目前最大起重能力为25吨，设计最大起重能力为36吨，是以铝融解炉，环保设备、水处理设备制造安装为主，其他化工配套设备，管道制造安装为辅的新兴企业，公司注册资本为300万元人民币，总资产约1000万元，现有职工180人，各类专业技术及管理人员19人。公司专业生产和安装各类碳钢，不锈钢、铝合金钛合金设备和管道，并承揽安装过程。<br />\r\n<br />\r\n　　公司在生产过程中按ISO9001系列标准建立质量保证体系，抓实物形态的质量管理，逐步形成了完善的质量保证体系，另外，公司还建立了完善可靠的售后服务保障体系，本着用户第一，顾客至上的原则指导公司的生产管理经营活动。\r\n<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH1144G3O5.jpg\" /></div>\r\n<div style=\"text-align: center;\">\r\n	&nbsp;</div>\r\n', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('21', '0', '企业风采', '', 'guanyuwomen/qiyewenhua', '19', '', '19,21', '2', '1', '10071001', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '企业文化', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('41', '0', '合作伙伴', '', 'guanyuwomen/hezuohuoban', '19', '', '19,41', '2', '2', '10071002', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('40', '0', '企业视频', '', 'guanyuwomen/qiyeshipin', '19', '', '19,40', '2', '3', '10071003', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('44', '0', '教学环境', '', 'guanyuwomen/shengchanjidi', '19', '', '19,44', '2', '4', '10071004', 'img', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('22', '0', '联系我们', ' 联系我们 Contact', 'lianxiwomen', '0', '', '22', '1', '8', '1008', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '联系我们', '', '', '<div style=\"text-align: center;\">\r\n	&nbsp;<span style=\"font-size: 16px; text-align: center;\">&nbsp;地址：这里是您的公司地址 &nbsp;</span></div>\r\n<p style=\"text-align: center;\">\r\n	<span style=\"font-size: 16px;\">电话：400-123-4567&nbsp;&nbsp;<br />\r\n	传真：+86-123-4567&nbsp;<br />\r\n	邮编：000000&nbsp;<br />\r\n	邮箱：这里是您公司的邮箱地址</span></p>\r\n<p style=\"margin: 0px; padding: 0px; font-size: 14px; word-spacing: -1.5px; list-style: none; overflow: hidden; text-align: justify; line-height: 32px; color: rgb(41, 41, 41); border: 0px; font-family: \'Microsoft Yahei\';\">\r\n	&nbsp;</p>\r\n<div style=\"margin: 0px; padding: 0px; font-size: 14px; color: rgb(64, 64, 64); font-family: \'Microsoft YaHei\', 微软雅黑, 宋体, Arial, Helvetica, sans-serif; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH2145I04R.png\" /></div>\r\n', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('31', '0', '人才招聘', '', 'lianxiwomen/rencaizhaopin', '22', '', '22,31', '2', '1', '10081001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH515032G57.jpg\" style=\"width: 700px; height: 934px;\" /></div>\r\n', '', 'true', '1638321009');
INSERT INTO `rrz_article_nodes` VALUES ('25', '0', '手机端首页幻灯', '', 'shoujiduanshouyehuandeng', '0', '', '25', '1', '9', '1009', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'false', '1638321010');
INSERT INTO `rrz_article_nodes` VALUES ('45', '0', '在线留言', '', 'zxly', '0', '', '45', '1', '10', '1010', 'single_liuyan', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638323348');
INSERT INTO `rrz_article_nodes` VALUES ('47', '0', '列表页幻灯', '', 'liebiaoyehuandeng', '0', '', '47', '1', '11', '1011', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'false', '1638321010');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('8', '33', '案例展示一', '', '/storage/images/20211201/1-1FP3154Q70-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP3154Q70-L.jpg\" style=\"width: 700px; height: 466px;\" /></div>\r\n', '', 'admin', '', '1501746506', '1501746506', 'true', '', '', '案例,展示,一,', '171', '1501746440', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '33', '案例展示二', '', '/storage/images/20211201/1-1FP3154S70-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP3154S70-L.jpg\" style=\"width: 700px; height: 466px;\" /></div>\r\n', '', 'admin', '', '1501746526', '1501746526', 'true', '', '', '案例,展示,二,', '231', '1501828805', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '33', '案例展示三', '', '/storage/images/20211201/1-1FP51521350-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51521350-L.jpg\" style=\"width: 316px; height: 210px;\" /></div>\r\n', '', 'admin', '', '1501917719', '1501917719', 'true', '', '', '案例,展示,三,', '64', '1501917671', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '33', '案例展示四', '', '/storage/images/20211201/1-1FP51522110-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51522110-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501917744', '1501917744', 'true', '', '', '案例,展示,四,', '199', '1501917722', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '33', '案例展示五', '', '/storage/images/20211201/1-1FP51522400-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51522400-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501917769', '1501917769', 'true', '', '', '案例,展示,五,', '51', '1501917751', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('13', '33', '案例展示六', '', '/storage/images/20211201/1-1FP51523240-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51523240-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501917815', '1501917815', 'true', '', '', '案例,展示,六,', '138', '1501917773', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('14', '33', '案例展示七', '', '/storage/images/20211201/1-1FP51523560-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51523560-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501917847', '1501917847', 'true', '', '', '案例,展示,七,', '199', '1501917818', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('15', '33', '案例展示八', '', '/storage/images/20211201/1-1FP51524340-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51524340-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501917885', '1501917885', 'true', '', '', '案例,展示,八,', '165', '1501917861', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('16', '33', '案例展示九', '', '/storage/images/20211201/1-1FP51526250-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP51526250-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501918000', '1501918000', 'true', '', '', '案例,展示,九,', '62', '1501917961', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('17', '33', '案例展示十', '', '/storage/images/20211201/1-1FP5152A80-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP5152A80-L.jpg\" style=\"width: 489px; height: 364px;\" /></div>\r\n', '', 'admin', '', '1501918027', '1501918027', 'true', '', '', '案例,展示,十,', '173', '1501918005', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('18', '39', '评价一', '', '/storage/images/20211201/1-1FH11522480-L.jpg', '', '去贵公司参观过，对贵公司有一定了解，一个企业如果没有长远的战略眼光，也许在三年五年之内企业做的如日中天，却在十年之后反而被当初不屑一顾的弱小对手轻易地吃掉。公司能发展到今天，说明贵公司在思考整个行业未来发展趋势并合理调整战略规划，率先做出布局，和这样有战略眼光的公司合作，值得信赖。', '', 'admin', '', '1500621790', '1500621790', 'true', '', '去贵公司参观过，对贵公司有一定了解，一个企业如果没有长远的战略眼光，也许在三年五年之内企业做的如日中天，却在十年之后反而被当初不屑一顾的弱小对手轻易地吃掉。公司能', '评价,一,去,贵公司,参观,过,对,贵,公司有,', '142', '1500621745', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('19', '39', '评价二', '', '/storage/images/20211201/1-1FH11523210-L.jpg', '', '<p>\r\n	产品质量是企业发展的基础，是企业的生命，也是我们共同的追求。和贵公司合作期间，他们以优良的产品质量和完善的服务来满足我们的需求。贵公司注重品牌，品质，诚信和服务，赢得广大客户高度认同。</p>\r\n<div>\r\n	&nbsp;</div>\r\n', '', 'admin', '', '1500621834', '1500621834', 'true', '', '产品质量是企业发展的基础，是企业的生命，也是我们共同的追求。和贵公司合作期间，他们以优良的产品质量和完善的服务来满足我们的需求。贵公司注重品牌，品质，诚信和服务，', '评价,二,产品质量,是,企业发展,的,基础,企业,', '169', '1500621792', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('20', '39', '评价三', '', '/storage/images/20211201/1-1FH11524230-L.jpg', '', '一次偶然的机会，在广交会展上面认识了贵公司，被他们丰富的产品吸引。刚好我们公司需要酒店通风的情况，就抱着试一试的心态先试了小样，然后订购了一批；之后做出来的成品发现质量非常棒，贵公司售后服务这块也非常到位，总而言之，非常满意。', '', 'admin', '', '1500621872', '1500621872', 'true', '', '一次偶然的机会，在广交会展上面认识了贵公司，被他们丰富的产品吸引。刚好我们公司需要酒店通风的情况，就抱着试一试的心态先试了小样，然后订购了一批；之后做出来的成品发现质量非', '评价,三,一次,偶然,的,机会,在,广交,会展,', '73', '1500952844', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('21', '39', '评价四', '', '/storage/images/20211201/1-1FH1152450628.jpg', '', '一直继承和发扬了“诚信为本，以信取利”的商业精髓，为顾客提供完善的售前、售中和售后服务，赢得了广泛的市场美誉和良好的口碑，也因此在这一行里脱颖而出。他们凭借着自己的热情、责任和专注，以及优异的产品质量和差异化的特色，完完全全的折服了我们。加油，我们愿意和你一起再次腾飞！', '', 'admin', '', '1500621873', '1500621873', 'true', '', '一直继承和发扬了“诚信为本，以信取利”的商业精髓，为顾客提供完善的售前、售中和售后服务，赢得了广泛的市场美誉和良好的口碑，也因此在这一行里脱颖而出。他们凭借着自己的热情、', '评价,三,一次,偶然,的,机会,在,广交,会展,', '66', '1500952829', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('22', '26', '荣誉证书一', '', '/storage/images/20211201/1-1FH11356080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11356080-L.jpg\" style=\"width: 1000px; height: 700px;\" /></div>\r\n', '', 'admin', '', '1500616577', '1500616577', 'true', '', '', '荣誉证书,一,', '80', '1500616557', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('23', '26', '荣誉证书二', '', '/storage/images/20211201/1-1FH11356280-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11356280-L.jpg\" style=\"width: 1000px; height: 700px;\" /></div>\r\n', '', 'admin', '', '1500616614', '1500616614', 'true', '', '', '荣誉证书,二,', '153', '1500616580', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('24', '26', '荣誉证书三', '', '/storage/images/20211201/1-1FH1135G40-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH1135G40-L.jpg\" style=\"width: 1000px; height: 700px;\" /></div>\r\n', '', 'admin', '', '1500616643', '1500616643', 'true', '', '', '荣誉证书,三,', '70', '1500616619', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('25', '26', '荣誉证书四', '', '/storage/images/20211201/1-1FH1135I30-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH1135I30-L.jpg\" style=\"width: 1000px; height: 700px;\" /></div>\r\n', '', 'admin', '', '1500616664', '1500616664', 'true', '', '', '荣誉证书,四,', '164', '1505183482', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('26', '12', '生产基地一', '', '/storage/images/20211201/1-1FH11525560-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11525560-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500621965', '1500621965', 'true', '', '', '生产基地,一,', '58', '1500621945', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('27', '12', '生产基地二', '', '/storage/images/20211201/1-1FH11526170-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11526170-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500621987', '1500621987', 'true', '', '', '生产基地,二,', '127', '1500621968', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('28', '12', '生产基地三', '', '/storage/images/20211201/1-1FH11526400-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11526400-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500622004', '1500622004', 'true', '', '', '生产基地,三,生产基地,三,', '187', '1500622033', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('29', '12', '生产基地四', '', '/storage/images/20211201/1-1FH1152A70-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH1152A70-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500622025', '1500622025', 'true', '', '', '生产基地,四,', '154', '1500622007', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('30', '16', '刮着大风的人工智能，躺着赚钱的自动驾驶 | 虎', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	这年头，搞个创业不谈人工智能，根本拿不到钱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	大公司搞人工智能，大公司高管跳槽创业搞人工智能，投资人投人工智能，让人工智能公司毫无疑问成了目前互联网公司中的吸金池，别说靠谱的公司，只要是靠谱的员工，都能拿到一大笔创业资金，够在人工智能的大潮中扑腾一段时间。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但说点实际的，目前这些科技公司人工智能的研究方向其实主要就三个：深度学习，自然语音处理，机器视觉。深度学习是人工智能的必修课，自然语言处理能够直接将技术实用到虚拟智能助手上，而机器视觉，则是直接能转化到自动驾驶技术中来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	搭载虚拟语音助手的智能音箱已经出现挺长一段时间了，不过从消费者的反馈来看，他们并不觉得智能语音助手是个智能的东西，甚至目前是智能音箱看上去有些鸡肋。与智能音箱虽然市场火热但在消费者圈子中遇冷不同，自动驾驶似乎是个无论是投资方还是普通消费者都看好的项目。不少人期待自动驾驶能够改善未来的交通状况，解决目前拥挤低效的交通问题，资本市场也格外青睐自动驾驶公司以及自动驾驶人才。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今早，自动驾驶初创公司 Momenta 宣布获得 B 轮 4600 万美元投资。该轮融资由蔚来资本领投，戴姆勒集团（梅赛德斯-奔驰母公司）、顺为资本、创新工场和九合创投跟投。2016 年，Momenta 获得来自蓝湖资本领投，创新工场和真格基金跟投的 A 轮融资。2017 年初，获得顺为资本领投的 A1 轮融资 。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	公司成立不到一年时间融到多轮资金，B 轮 4600 万也确实算是笔不小的投入，尤其是目前这个公司还没有任何对外的产出。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	来深挖下这家公司吧。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Momenta 是一家北京的自动驾驶公司，于 2016 年 9 月份成立。创始人曹旭东之前就职于微软亚洲研究院和商汤科技。这家公司的目标是要大奥自动驾驶的大脑，核心技术是基于深度学习的环境感知、高精度地图、驾驶决策算法。产品包括不同级别的自动驾驶方案，以及衍生出的大数据服务。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	也就是说，Momenta 是一家自动驾驶方案公司。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对比其他公司，Momenta 的技术优势在于视觉识别。据曹旭东介绍，Momenta有世界顶尖的深度学习专家，图像识别领域最先进的框架Faster R-CNN和ResNet的作者，ImageNet 2015、MS COCO Challenge 2015多项比赛冠军。团队来源于清华大学、麻省理工学院、微软亚洲研究院等，有深厚的技术积累和极强的技术原创力。公司的研发总监任少卿是世界上最广泛使用的物体检测框架Faster RCNN的发明人。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这样的视觉识别技术优势，使得这家公司在自动驾驶方案最为基础的感知部分获得了比较大的优势。因为从目前来看，视觉识别将会成为自动驾驶感知部分的主要方案，相比于自动驾驶车初期大量使用的激光雷达， 摄像头传感器的成本更低，产生的数据也要小于激光雷达测绘周围环境的生成数据，是目前实现自动驾驶或者是驾驶辅助中比较实际的解决方案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是视觉识别的难度就在于高精度的视觉识别算法，只有算法优化的好，车载电脑才能将摄像头收集来的图像进行识别和处理，划分出可行驶区域，行人，路灯等道路交通要素。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而算法，正是 Momenta 所擅长的东西。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是要实现自动驾驶，光有良好的感知能力是不行的，决策和控制都是自动驾驶最为关键的技术模块。要想调整自动驾驶的决策算法，要有大量的实际道路测试数据来对算法进行优化，才能实现最终比较智能安全的自动驾驶控制。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但积累自动驾驶数据是个烧钱的工作，小公司是很难办到的，所以就需要巨大财力和人力的支持。</p>\r\n<p>\r\n	所以可以额回过头来看看 4600 万美元的融资将会用在什么地方。曹旭东表示：“融资将用于三方面：1. 加强人工智能核心能力，包括大数据、大计算和优秀AI人才；2. 产品化基于视觉的环境感知和高精地图技术；3. 研发高频刚需场景的L4无人驾驶技术。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在目前这个各家都在进行自动驾驶技术积累的阶段，人才是最为烧钱的投入，因为各家纷纷都在拉拢自动驾驶技术人才，导致这方面人才的收入水涨船高，很多大公司甚至愿意投下上亿美金，为的就是收购几个技术人员成立的自动驾驶小团队。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另一方面，对于自动驾驶创业公司来说，资本不会允许长期投入无产出的消耗，人人都觉得自动驾驶未来能挣钱，但自动驾驶究竟能挣多少钱，这个钱在自动驾驶尚未普及的时候怎么挣，现在都还是个难题，所以创业公司还是需要将自己的技术逐渐产品化，给投资人足够的信心和公司前景，才能继续投入发展自己的技术。对于像 Momenta 这样擅长机器视觉的自动驾驶公司，初步的产品化计划很有可能是为整车厂提供驾驶辅助的技术支持来进行盈利（从投资方也可以看到，梅赛德斯也参投了，也是为了弥补自家在驾驶辅助的视觉识别上的技术弱势，要知道，奔驰对于驾驶辅助的研发并不比特斯拉晚，但就是视觉识别落后特斯拉较多所以才导致奔驰的高级别驾驶辅助似乎一直在消费者市场不温不火）。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然，各家公司最终的目的还是实现 L4 级别的全自动驾驶。Momenta 给出的目标限定是高频刚需场景的 L4 无人驾驶技术，应对我国的交通状况，很有可能是堵车时的低速自动驾驶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	现在大部分创业公司都在把 L4 级别的全自动自动驾驶作为目标，这样的宏伟目标也格外吸引投资方，但自动驾驶不是个一时半会能搞定的事情，之前各大车厂所预计的 2020 或者是 2021 年也绝对不是一个自动驾驶就能完全盈利的年份。投资人爱玩风口，人工智能和自动驾驶的风能持续刮多久?要看投资圈有多少耐心了。</p>\r\n', '', 'admin', '', '1500620880', '1500620880', 'true', '', '这年头，搞个创业不谈人工智能，根本拿不到钱。\r\n大公司搞人工智能，大公司高管跳槽创业搞人工智能，投资人投人工智能，让人工智能公司毫无疑问成了目前互联网公司中的吸金池，别说靠', '卫浴,行业发展,趋势,提升,的,质量,根据,国际,', '158', '1501126914', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('31', '16', '王健林又悄悄卖了几家万达广场！保险、信托接', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	工商信息显示，该公司投资人由大连万达商业地产股份有限公司变为珠江人寿保险股份有限公司。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	珠江人寿总部位于广东省广州市，于2012年12月28日开业，由珠江投资控股、广州金融控股、广东新南方集团等公司投资成立，注册资本金67亿元人民币。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其中，珠江投资、新南方集团和韩建投资的法人代表分别是朱一航、朱拉伊和朱伟航。他们都是合生创展（0754.HK）董事局主席朱孟依的亲属。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据万达集团官网发布的信息，今年6月23日，南昌西湖万达广场开业，总建筑面积14.78万平方米，开业首日客流27万人次，营业额1400万元。该广场涵盖餐饮、服装、精品、儿童、体验等业态。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而，开业不到半个月，南昌西湖万达广场便“易主”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此外，6月8日，九江万达地产有限公司的实际控股人从“大连万达商业地产股份有限公司”变成“中国民生信托有限公司”；5月27日，抚州万达广场投资有限公司的实际控股人也变成了“中国民生信托有限公司”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而在此之前的4月17日，万达商业持有盐城万达广场的全部股权卖给了中信信托。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于万达商业并没有对这两笔交易的详细信息进行披露，究竟万达卖了多少钱？在股东发生变化后，万达广场具体的运营模式如何？尚不得而知。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过，对标之前万达广场的轻资产运营模式，应该是万达负责品牌运营、设计、招商等，净租金再与投资方进行比例分成。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	截至目前，万达共开业200余座万达广场，重资产模式的万达广场占据万达广场项目总量八成以上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	除了卖掉几家万达广场，王健林还做里一个重大举措，对万达商业100%持有的部分万达广场有限公司进行大幅度减资。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据地产K线独家获悉，从2017年5月9日到2017年6月29日，在两个月时间内，万达商业至少将20家万达广场有限公司的注册资本均减少，而且都是减至清一色的0.5亿元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	根据工商信息显示，这20家万达广场有限公司的减资幅度比较大，其中有9家万达广场注册资本减幅超过90%。减幅最大的是唐山万达广场投资有限公司，其注册资本从24亿减少到0.5亿元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有分析称，一般来说，公司减资的情形有多种，其中一种是被有关行政机关勒令减少注册资本，意思就是被工商、税务查帐后，认为严重亏损或者资金不实，必须减资。减资可以一次性偿付累积债务，并可与增派股息结合，用以弥补累积的亏损。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然还有其它几种情形：资本过剩，即公司正常生产经营或缩小经营规模不需要现有数额的注册资本；公司注册资本逾期仍无法到位；公司虚报、虚假、抽逃注册资本经处罚后仍无法纠正等。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但十分奇怪的是，当万达广场减资时，部分万达城的注册资本却出现了大幅度增加。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	7月10日，万达发布公告要将13个文旅城的91%股权卖给融创，作价335.95亿元（后增加了143亿元）。在随后的7月11日-7月19日，这13个万达城中有6个万达城注册资本均出现了增加。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其中，增资最多的是无锡万达城，注册资本从5亿元增加到40亿元；重庆万达城也从5亿元增加到30亿元；剩下的4座万达城均增资至20亿元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此举被看做融创收购万达城后的一次资本动作，因为增资可以调整股东结构和持股比例，也意味着流动资金的增加。如果融创收购后需要向金融机构贷款的话，其贷款额度也会相应扩大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	王健林是否会陆续卖掉万达广场，万达商业手里还剩有多少牌？又将如何冲刺回A呢？这是一个谜。</p>\r\n', '', 'admin', '', '1500620902', '1500620902', 'true', '', '工商信息显示，该公司投资人由大连万达商业地产股份有限公司变为珠江人寿保险股份有限公司。\r\n珠江人寿总部位于广东省广州市，于2012年12月28日开业，由珠江投资控股、广州金融控股、广', '在,信息化,时代,下,卫浴,企业,转型,升级,成,', '188', '1501126899', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('32', '16', '谈谈用户体验与风控的平衡性', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	之前我说过很多创业者容易犯的错误，过度理想主义，把用户当作好人。我说过一个关键词，不能说坏用户一定很多，可能坏用户真的只有1%，但很可能一个坏用户的破坏，可以抵销一百个好用户的创造。这是很常见的创业困境，因为很小的疏忽，导致极大的损失。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，一些毫无经验的创业者，要有这方面的意识，至少思想上要有风控这个概念，要知道如何规避和防范坏的事情，不要过于理想主义。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但，凡事过犹不及，创业者以及某些大公司还存在另一个极端，那就是对坏的东西非常敏感。非常担心，风控意识非常强大，而导致产品设计上顾虑重重，用户体验直线下降。简单说就是，把所有用户当坏人来防范。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，平衡性才是关键。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我之前也在《那些用力过猛的员工》谈过这个事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实很多大公司都遇到这样的问题，不管你想做什么事情，律师、法务都会告诉你，这个风险很大，那个不能做，这个政策不明确，等等。你什么都不做，他们是最安全的，所以这就是很多创业公司还有机会脱颖而出的原因，光脚的不怕穿鞋的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	网上流传的微信历史传记也提过，腾讯内部多个平台做移动聊天工具，其中微信团队是资源最少，规模最小的，但因为顾忌与电信部门的合作关系，几个核心部门都不敢碰语音聊天，还劝张小龙不要轻举妄动。结果张小龙光脚的不怕穿鞋的，做出来再说，微信一举成为腾讯新的发展引擎。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有的时候我也觉得自己写着写着就前后矛盾，你看，一会说有些创业者头脑发热什么都敢做，风险考虑不周全不对；一会又说创业者不要顾虑太多很多事情还是要尽可能做起来。其实，一切都是度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我总说，创业的路径，不是只有黑和白，不是只有对和错。很多时候我们要找到一个合适的尺度，我的胆子比较小，所以也是我创业很不成功的地方。很多尺度我自己收得非常紧，很多东西不敢碰；但我也认识一些胆子很大的创业者，有的已经经历了牢狱之灾。你非要我划一条线，我做不到，但我想提醒给创业者的是，两边你都要知道。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你可以胆子大一点，但你要知道风控是什么，哪些是你不能碰的高压线，哪些是坏用户可能造成巨大伤害的领域；你也可以胆子小一点，但你要知道如果一昧的拒绝风险，可能很多好的机会就会彻底错过。胆子大，但不能说什么风险都不知道，不是说你可以闭着眼睛往前跑，那不是胆子大，那是作死。胆子小，但不能束手束脚，非要追求绝对安全，就算你找份好工作，也不是说百分百安全没风险的，更何况创业。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果讲政策风险，法律风险，这个话题有点大，而且很容易屏蔽词。只说一点，早期互联网创业者（包括各路巨头在内）在版权方面多少都存在一些问题，这是事实，必须承认的。市场环境都是盗版天下的时候，你规规矩矩做真就是没有一点机会；但市场环境已经规范化，你还不收手那就是找死，这个话题点到为止。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	下面讲讲用户体验层面，面对坏用户的风险，如何将产品体验做到好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	现在很多公司已经成为标配的一个登录体验是这样的，作为一个案例分享，你输入账号密码的时候，第一次输入的时候，只需要输入正确的账号和密码就可以。但如果你连续输入错误两到三次，那么就出现验证码，而且很难认的那种，如果再输入错误几次，账号就锁死了，一段时间内禁止登录。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从用户体验而言，验证码是用户非常反感的，但这个东西确实有意义，因为要应对坏用户的风险。但类似的情况，其实还有很多。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	用户期待便捷，简单与系统风控本身通常是互悖的，完美的解决方案是不存在的，但平衡的原则是有的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	类似如上验证码的策略流程就是一个典型原则，渐进风控，用户最开始登录的时候，系统默认为好用户，但出现异常之后，开始增加防范手段。随着异常的情况，防范手段层进加深，直到账户锁死，当然，用户体验是随着风险系数增加而下降的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	现在大部分优秀的互联网产品都有这样的渐进策略，低风险情况下，用户的操作体验是最优化的，但随着系统判别的风险层级的提升，防范策略开始启动，操作体验开始逐渐下降。 而这个风险层级的评估，就是一个技术挑战，你既不能随意给好用户降低操作体验，又能做到高效防范坏用户的行为。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	除了渐进原则，还有几个关键点可以说一下：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	1、容忍度</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对坏用户，坏行为的容忍度是什么？你说，0容忍，说得容易，其实0容忍是技术不可实现的，相当多坏行为往往是基于数据分析和统计规律获得的。说来惭愧，坏行为数据越丰富，这个识别能力越强。但识别能力的渐进发展，往往是伴随着不断的坏行为得逞的过程。&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	容忍度的基本原则在于，坏行为不能具有规模性，爆发性，以及扩散性。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我们常说，很多常旅客系统里面有羊毛，其实这里也存在一个容忍度的问题，你只要不规模化，不扩散性地去赚这个便宜，人家真的不在乎。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	2、防范策略的友好度</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当风险识别级别提升，防范策略出现的时候，这里其实也存在一个很明确的友好度的话题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这个怎么理解呢，就是风险防范策略出现的时候，这些策略面对的可能是一个坏行为，但也可能是一个好用户。只要系统没有屏蔽这个行为，而是提供了一个防范策略，那么这个策略所面对的，就很有可能是一个好用户。这时候，你要尽量给这个用户的感受是：你尊重他，他不是坏用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	什么意思呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	比如我密码连续输入错误了几次，你出验证码可以，但你的文案要温和，不要直接给这个用户出现粗暴或者不礼貌的文字。因为我经常变换城市，很多app对换城市登录都做了风控处理，这个作为技术出身，我能理解背后的策略。但文案能不能和蔼一些，比如说，“对不起，给您添麻烦了，由于当前地址不属于您的常见登录地址，系统为了保护您的资料不被非法盗用，希望您给予配合输入如下验证码”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	再带一点温和萌化的表情，用户的理解度可能就会好一点。现在我发现很多知名互联网产品，在这种地方往往简单粗暴，出现的提示更像是赤裸裸的警告，看上去让用户很不爽，我估计可能测试也没把这个当回事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，关于风控策略在交互中出现的时候，其中文案和交互视图，对于坏行为，坏用户是没任何意义的，但对于好用户来说，你文案做好一点，也是一种对体验下降的补偿。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	3、风控不能以规模化损害正常业务或降低活跃度为代价</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这是非常关键的原则，风控对业务和用户活跃度会有影响是必然的，但如果规模化的伤害了正常业务，或者降低了用户的活跃度，这是得不偿失的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不能说，我风控我有理，我安全我优先。你业务都完蛋了你安全给谁看呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一个企业的风控部门，安全部门，说到底是保障业务的，为了业务健康发展的，短期内会导致一些业务损失。如果确实有必要，也能理解，但如果以风控为名扼杀业务，让用户流失，这个就非常糟糕了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以前百度空间对屏蔽词的策略就很无语，我一直是百度空间的忠实用户，说来我还在百度空间的产品团队里混过半年多，但我发现想在百度空间发篇长文越来越难，因为不知道哪里就屏蔽词违规了。关键是我要发表的文章，毫无半点政治隐喻和相关的内容，全都是规规矩矩的文字，每次遇到都特别困扰，而且毫无任何修正的提示，只能不断用二分法（切掉一半文字，试试能否发布成功，然后一半的一半，这样层进）来找关键词，找到屏蔽词的酸爽真是一言难尽。后来我就真的不愿意在百度空间发东西了，再后来百度空间也没了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我觉得这就是个典型风控导致用户流失的案例，我觉得这是风控部门最偷懒，最不愿意承担责任的解决方案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另一个典型案例以前也提过，微软的Vista系统，是微软Windows操作系统最失败的一个版本，其实就是因为安全性诉求胜过了便捷性，过犹不及，导致用户无法接受。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	把好用户都挤兑走了，你风控价值何在呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以前我讲过的一句话，用户对个人信息安全产品的诉求是什么，是为了让自己更安全么？错，是为了上网更爽。因为不安全导致了上网不爽，用户才需要安全产品。如果安全产品喧宾夺主，让用户上网不爽，那一定会被卸载掉。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	那么，这些原则说起来容易，实施中为什么会存在障碍呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一，求全责备，领导要求对风险零容忍，或者对坏案例百分百究责。在这样的情况下，相关执行者自然把风控放在了业务的前面，反正业务做不好跟自己没关系，风控出问题了要背锅。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二，部门代沟，各部门只关心自己的职权和责任，我的部门KPI只考虑了系统安全性，我为什么要关心业务的增长，那是你们的问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第三，顾此失彼，今天发现这里出了一个问题，就努力分析问题的原因，找解决方案，出一个补丁；明天发现那里出了一个问题，就努力分析问题的原因，找解决方案，出一个补丁；看上去，都是正确的分析方式，每个方案都是对的。但最后做下来，问题是没有了，用户也没有了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为什么会这样，我们在解决问题的时候，是不是考虑到这个解决方案的负面作用？风控也是如此，我们解决了一个系统风险，是不是导致用户操作体验的下降？这个影响有多大，一个影响不大，两个影响也不大，但是此消彼长，也许竞争对手体验本来跟你差不多，但你这边很努力地解决问题，越解决用户体验越糟糕，到最后你越努力，你的用户流失比竞争对手还快。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	总结一下</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	要对坏用户，坏行为有概念，要对风险，包括系统安全风险，包括薅羊毛的风险，包括政策和法规风险有概念。你可以胆大，但不能无视这些问题，要知道风险在哪里，边界在哪里，这是必须的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在了解这些风险的前提下，要明确知道，在公司范围内明确风控是用来保障业务发展的，而不是遏制业务发展的。风控会导致用户体验下降，这是必然的，但应该遵循一些保障用户体验的原则，比如渐进原则，比如防范策略友好度原则。要对风险容忍度有认识，寻求用户体验与风控的平衡点。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	每个解决风险的方案，要评估对用户体验的伤害，寻求最佳平衡，如果对用户体验的伤害大于风险对系统的威胁，那么这个方案是不可取的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不要求全责备，不要部门各自为政，不要为了解决问题而忽视其他的影响。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以上，是今天希望创业者，以及大公司的创新部门，需要认真面对的话题。</p>\r\n', '', 'admin', '', '1500621000', '1500621000', 'true', '', '之前我说过很多创业者容易犯的错误，过度理想主义，把用户当作好人。我说过一个关键词，不能说坏用户一定很多，可能坏用户真的只有1%，但很可能一个坏用户的破坏，可以抵销一百个好用', '房地产市场,渐热,促,卫浴,行业,渐,发展,4月,', '64', '1501126881', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('33', '16', '比特币价格回稳，但考验才刚刚开始……', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	近几日，阴霾已久的加密数字资产市场迎来久违的晴天。OKCoin币行数据显示，自7月17日起，比特币迎来6连涨，21日更是最高达到19800元人民币的高点。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在一个有效的市场中，大部分有价值的信息都已经反映在K线走势中。就比特币或整个加密数字资产市场而言，比特币分叉风险是此前大跌的重要导火索，而近期的回升也很大程度上在于BIP91方案开始得到主流矿工的认可，短期内，比特币分叉的警报得以解除。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过，警报并未完全解除，BIP91成功激活的3个月内还将迎来2M区块扩容的硬分叉，届时，真正的考验才真正到来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	考验什么呢？考验比特币区块链的坚韧性，若因为几个利益冲突便说分叉就分叉，比特币也不再是大家追捧的比特币，其价值基础必然受到严重损坏，才是大家都不愿看到的结果。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，对比特币的考验，只是刚刚开始。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	区块链分叉风险从何而来？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对大多数投资者而言，区块链分叉依旧是个陌生的词汇。顾名思义，所谓分叉，就是原本一条区块链拆分成两条或多条区块链，鉴于区块链是记录比特币交易的公共账本，既然有多条区块链，意味着有多个不同版本的比特币账本，自然也就视作出现了多种比特币。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	就像以太坊，因为TheDao事件而出现硬分叉，结果分成两条区块链，也就出现了ETH和ETC两款以太币。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	那区块链分叉是怎么产生的呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	要从区块链的共识机制说起。大家都知道，区块链是由点对点的去中心化节点共同维护的，这里没有可以说了算的权威机构，区块链的有序运转靠的就是大家的共识，即对于哪些交易是可以接受的、哪些节点具有记账权等关键事宜，有一套公认的标准。这套标准是部署在区块链底层协议中自动化执行的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	问题来了，当区块链中的节点运行不同版本的底层协议时，就可能出现共识机制的不一致性，即有些区块，部分节点认为是合乎规则的，同意接入区块链，而有些节点认为是不符合规则的，拒绝承认。此时，在节点没有对底层协议进行更新以保持一致的情况下，自然而然地，区块链就分叉成了两条或多条。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有人要问了，为何节点会运行不同版本的底层协议呢？大家都及时更新不就好了吗？看上去就是一个及时更新软件的简单问题，实则不然。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一则是，区块链是去中心化的网络运作模式，各个节点散落在全球各地。所处的时区不同，且有的持续在线，有的经常离线，在同一时间实现节点的全部更新是不可能完成的任务，也因此，区块链的底层协议升级几乎必然导致区块链分叉；二则是，基于各种因素考虑，有些节点就是反对升级，这才是造成区块链长期分叉的根本原因。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	至于为何有些节点会反对呢？并不难理解。商业社会中，要大家百分百同意某种观点或认可某个升级，本身便是不可能完成的任务。有时候，若存在严重的利益冲突，分裂成两派或多派就再正常不过了。不幸的是，比特币底层协议升级与否，社区内就存在严重的冲突。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	利益冲突及暂时的妥协</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	笔者在之前的文章曾经提到过，比特币区块链现行的底层协议存在一些限制，已经严重制约了比特币的发展和繁荣。一是区块大小的限制，当前比特币区块大小为1M，每秒仅能处理7笔交易，严重滞后于发展需要；二是比特币区块链的扩展性较差，难以部署较为复杂的创新应用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	就此次冲突而言，焦点集中在区块扩容上。对区块进行扩容已经成为共识，但如何扩容各方存在不同意见。</p>\r\n<p label=\"小标题\">\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	矿工们的理想方案</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	就矿工而言，希望直接放开对区块的限制，先后提出了8M、4M、2M等不同的扩容方案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	比特币Core团队表示反对，无论是升级到2M还是8M，随着比特币交易的火爆，总有一天还是不够用，意味着还要扩容。而区块越大，对计算能力要求越高，意味着越来越少的节点有能力运行全节点区块链，届时容易造成算力的中心化和垄断化，即区块链只能交由几个大的矿池进行维护。</p>\r\n<p label=\"小标题\">\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	Core团队的理想方案</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	就Core团队而言，希望部署隔离见证SegWit（Segregated Witness），即通过交易信息和验证信息的分离，当部分数据被移除后，就为更多的交易腾出了空间，这样一来整个比特币网络的交易吞吐量也随之提高，变相达到区块扩容的效果。部署隔离见证后，后续还可以引入闪电网络，将小额交易搬离区块链，区块链只承担最终的清算功能，大大降低区块链的负荷。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	矿工们表示反对。隔离见证也好，闪电网络也罢，都将根本上损害矿工的利益。矿工挖矿的动力有二，一是区块记账权带来的比特币发行收益，二是记账的交易手续费收入。若交易被带离区块链，意味着不需要再向矿工缴纳手续费，显然是不能接受的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	问题是，若得不到矿工们的支持，比特币底层协议的升级也就成了空谈。</p>\r\n<p label=\"小标题\">\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	冲突与妥协</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于双方迟迟未能达成一致意见，关于比特币扩容升级，从2015年一直拖到2017年。Core团队率先出手，打算强硬推行BIP148方案，达到部署隔离见证的目的。其激活日期为2017年8月1日凌晨，届时，若矿工代表的节点未能跟进升级BIP148，则比特币网络面临分裂，包括已升级BIP148节点和未升级节点，比特币区块链也将一分为二。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	某种意义上，是耐心被磨光了。既然达不成一致，那么便分叉好了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	鉴于BIP148方案的分叉风险，7月10日开始，比特币交易价格开始出现跳水，短短7个交易日，比特币收盘价便从17762元跌至13500元，整个加密数字资产市场，更是哀鸿遍野，腰斩、胸斩比比皆是。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	于是，具有妥协性的BIP91方案出现了，并得到矿工的支持。BIP91方案的目的是抢在8月1日前锁定隔离见证，并可兼容BIP148协议。意味着，只要BIP91在8月1日前成功激活，届时，无论是运行BIP91协议的节点（支持矿工的提案）也好，运行BIP148协议的节点（支持Core团队的提案）也罢，双方是互相兼容的，不会带来区块链的分叉。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于得到矿工们的支持，所以BIP91方案于7月21日便得以成功激活，意味着，拟于8月1日激活的BIP148方案变得无害了，区块链分叉警报得以解除。在此消息刺激下，比特币出现了快速上涨。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	未来三个月，仍有一战</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但问题还没完。BIP91之所以得到矿工的支持，因为它是一个“隔离见证+2M区块扩容”的捆绑性方案，先部署隔离见证，然后在3个月内自动升级2M区块扩容协议，照顾了矿工的利益，也顾及了Core团队部署隔离见证的需求。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	问题在于，通过BIP91方案提前锁定隔离见证，只需要算力达到80%的门槛即可，并不需要Core团队的支持。这意味着，BIP91的激活，并未从根本上消解双方的争议——区块扩容，而只是把时间延后而已。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	通过BIP91部署隔离见证并无问题，但Core团队未必同意3个月内进行2M区块扩容，所以，未来3个月内，比特币区块链依旧面临分叉风险。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	比特币的价值来自于稳固的生态圈以及由此激发的投资者信心，若仅仅因为几方的利益问题便能轻易造成分叉，投资者对比特币的信心必将受到影响。信心若被根本上动摇，怎么会有好的前景呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，这场大战仍未结束，对比特币的考验也才刚刚开始。</p>\r\n', '', 'admin', '', '1500621020', '1500621020', 'true', '', '近几日，阴霾已久的加密数字资产市场迎来久违的晴天。OKCoin币行数据显示，自7月17日起，比特币迎来6连涨，21日更是最高达到19800元人民币的高点。 在一个有效的市场中，大部分有价', '卫浴,企业,的,标准,差距,随着,每个,行业,都,', '55', '1501126866', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('34', '16', '珍爱智商，远离“区块链”', '', '/storage/images/20211201/1-1FHQP151b6.jpg', '', '<p>\r\n	中国人民一直以来都践行着多种相互冲突的价值观，而如何在恰当时机选择自己愿意相信的那一款价值观，就成为吾国人民驾驭拧巴生活的重要能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	比如，痛恨化学加工，信仰天生造物，就是国人最朴素的是非观之一。郭德纲直到现在，还在相声中借于谦老婆的口吻教育观众“西药伤身，我给你熬点中药”，台下观众听罢频频点头；而最懂吾国消费者的苏北营销大师叶茂中，亦曾针对这一点为某护肤品订做了著名广告词“我们恨化学”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而有趣的是，对化学的刻骨痛恨，却丝毫不影响国人热情拥抱物理、信息技术领域的新鲜词汇。比如从上世纪90年代的“磁疗”、“红外”、“共振”，再到后来的“纳米”、“量子”，物理界但凡有一点研究进展或学术热点，一定会被中国人民改造成养生法宝。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	同样的事情也出现在信息技术领域，任何一个火爆的互联网概念，必然给大量骗子提供了发财机遇。从“中文域名”、“微信营销”、“P2P理财”、“O2O创业”再到“MMM”、“所罗门矩阵”，伴随着国人对“神秘技术名词肯定是发财机遇”的信仰，割韭菜这行是越来越好干了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而最新的骗局，就是眼下大火的概念——“区块链”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	我有一个小老板朋友</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在众多的焦虑症候群中，“中产”和“宝妈”们起码还有社交媒体可供发泄，而那些分布在广袤国土上的中小企业老板，则无处安放他们来自业绩增长、团队建设、市场判断以及知识更新上的焦虑。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	中小企业很大程度上是依赖老板自身能力实现生存的，对此心知肚明的三四线地区做实体经济的小老板们，总感觉在互联网时代缺乏势能和希望。从北上深投射下来的信息不对等鸿沟，更加深了这种焦虑。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	恰好，这些焦虑者又拥有足够的付费能力，他们将在市场上扮演怎样的角色也就完全可以预料了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我就有这样一位小老板朋友。十年来，我眼看着他从跟着聚成导师唱国歌，到进入华商书院结识一堆“学兄”，再到每天转发苏引华（陈安之弟子）的经典语录，再到参与盛景网联的“母基金众筹”……这些开大众的小老板们上交的香火钱，供养了吾国成百上千名中学文化水平的导师们开上了宾利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	关于他被忽悠的事，我本已既麻木又懒得说了。直到上周，他扔过来一个链接，说帮我看看。看那链接中赫然写着“李笑来”、“区块链投资”之类的文字，我立时惊觉了起来——</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	时代终究是进步了，这些读过些书的人，终于也可以出来忽悠小老板们了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	（薛蛮子微博截图，薛已投资“区块链”）</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	“来搞区块链项目吧，稳稳一个月百分之30收益”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如何才能高效率地忽悠小老板？一个简单的调查途径就是百度戒赌吧，在一个标题为“做什么能挣到钱？我现在手里有13万干什么一天能挣1000？”帖子下，有位老哥这样回复到“来搞区块链项目吧，稳稳一个月百分之30收益”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	30%收益率，这才是坊间对于“区块链”的真实理解，什么贵州大数据中心、国家AI战略都太遥远了，“区块链”的原本含义更是少人知晓（比如我到现在都不明白这个词是什么意思，但毫不影响我写这篇文章，同样也不影响你阅读）。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而与之对应的是，比特币创始人中本聪和密码朋客们起初的哲学理念与政治隐喻，则完全被吾国聪明人们全盘接收了下来——</p>\r\n<p>\r\n	&nbsp;</p>\r\n<blockquote>\r\n	<p>\r\n		“国家必然会试图减缓或阻止加密技术的传播。但是，这并不能阻止加密技术的无政府主义扩散。”</p>\r\n</blockquote>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这正是“区块链”成为暴利手段的理论基础：一种可以脱离政府管控的“地下股市”。游戏是这样玩的：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	首先，找一些码农。别太贵，月薪3K即可，北大青鸟的最好。让他们去GitHub之类的地方扒些代码下来修改一下，比如像“量子链”的开发方式——</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	（15天就能改完，给码农发1.5K工资即可）</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	好了，你已经拥有一个可以运行的“区块链”项目了。这个项目的实际意义无所谓，你可以随便编一个，什么改善医疗效率加快金融变革促进科技发展。这里我们参考一下李笑来老师的PressOne项目，这个“区块链”项目号称要“颠覆掉中心化内容分发模式”——</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	（颤抖吧，所有还敢于提供免费内容的垃圾们）</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	那么接下来，你只需要再写一个看起来错字不太多的白皮书pdf文件，挂在网上，就可以敲锣打鼓宣布众筹，等着让韭菜们交钱了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有人会问了，这些项目不明显是扯淡的吗，韭菜凭什么会投资？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你听说过“打新”吗？对，就是传说中A股的那个“打新”，每个股民打到了都会欢欣雀跃的那个“打新”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于吾国证监会的IPO政策，导致新股发放受到严格控制，以至于股民可以投资的新项目极为有限，而这些有限的项目又被限制了价格（锁死市盈率），所以几乎每支新股一放出来，都是连续几个十几个涨停板。打新股买到就是赚到，不需要花脑细胞，买就对了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	于是，当我的小老板朋友被拉去参加“币神训练营”之后，同行的小老板们纷纷表示根本听不懂啥叫比特币啥叫区块链啥叫ICO，这时导师点拨了一下：“你们就当这是&lsquo;打新&rsquo;就行了。”小老板们立刻一脸恍然大悟状。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	没错，所谓“区块链”项目的真实套路就是——项目对外发行“韭菜币”，韭菜们拿比特币（或者人民币）按比率购买韭菜币。韭菜币的特点是，成本为零，总量有限，你买得越晚就越贵，而且越发越少，越来越难买到。项目方暗示：如果“打新”成功，韭菜将可以坐等韭菜币升值，一个字：稳。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你可能会猜：这么老套的把戏，一次也就能骗几十万，了不起上百万吧？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不好意思，这是李笑来老师连白皮书都懒得写的PressOne项目的募集资金目标，请过目——</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2亿美金，谢谢。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为了便于大家理解韭菜轮2亿美金的概念，列举几个数字：陌陌F轮6000万美元、锤子B轮2亿人民币、滴滴E轮1.42亿美元、摩拜D轮2亿美元。难怪在近日的培训课程上，李笑来对外称“PressOne是个打破旧世界的项目，李笑来是罕见的能做这件事的人”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对了，上边那个“量子链”项目，也是李笑来老师站台支持的，已经成功众筹近2200万人民币。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	还有比李笑来格局更大的</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而不幸的是，我这个小老板朋友由于此前受骗次数太多，对于“区块链”投资多少有点嘀咕。说时迟那时快，拉他培训的导师们又换了一个新套路，这次彻底击中了小老板心中的软肋。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	（小老板发给我的广告，某培训机构借北邮名号组织的“区块链总裁班”，学费12800元）</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	简单来说，这个套路不再是让小老板们花钱投资韭菜币了，而是做一个韭菜币交易平台，让小老板们各自去发币，公众买了这些小老板们的韭菜币后，可以在韭菜币交易平台上进行交易。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	导师们美其名曰“使用区块链记账技术，把企业打造成真正的公众公司”。这句话翻译过来，就是“你们这些小企业都缺融资渠道，A股IPO不可能，新三板上去没意思，民间集资不敢搞，银行拆借成本高，但如果向社会出售经过高科技包装的&lsquo;区块链&rsquo;韭菜币，以&lsquo;互联网投资&rsquo;的名义向公众融资，就可以减少很多阻力，还能忽悠到比你们更傻的人。”小老板们参与的动力可想而知有多强。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不难想象，这种产品的对象，范围将远超上文所述的“区块链”项目，会直接下沉到三四线地区的中老年人。他们过往就是各类民间集资和理财骗局的精准客户，现在看着亲戚朋友的公司发售“互联网数字货币”了，“区块链”这一听就是要掀起科技革命的新事物啊，能不投资一下吗？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	总结一下，市面上大多数“数字货币”、“区块链项目”、“ICO众筹”，都是打着“区块链”幌子进行的投机游戏，属于完全的地下消息市，无任何监管保证，风险极高。</p>\r\n', '', 'admin', '', '1500621677', '1500621677', 'true', '', '中国人民一直以来都践行着多种相互冲突的价值观，而如何在恰当时机选择自己愿意相信的那一款价值观，就成为吾国人民驾驭拧巴生活的重要能力。\r\n比如，痛恨化学加工，信仰天生造物，就', '地漏,堵了,怎么办,现代,城市,中,高楼,林立,', '170', '1505179437', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('35', '17', '共享，正从风口到风险', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	历史总是惊人的相似，现在越来越多的“共享”创业，与两年前的O2O乱象如出一辙。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	天下熙熙，皆为利来。由于资本和创业者对风口的疯狂追逐，导致了虚假繁荣、泡沫滋生。那些顶着所谓“共享”光环，盲目上马的创业项目也会因种种缺陷而留下后患，最终成为刹那花火。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	近日，颇受媒体和公众关注的共享睡眠项目又有了新情况，继上周被爆查封之后，21日北京市公安局治安管理部门约谈了共享睡眠企业“享睡空间”的负责人，并要求拆除已经搭建的太空舱。</p>\r\n<p>\r\n	图片来源：澎湃新闻记者 李菁</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为什么要求拆除，因为性命攸关。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些共享睡眠项目在开局就遭遇重挫，确实与此前的共享雨伞、共享篮球迥然不同。后两者更多的问题是需求，而共享睡眠则是本身就存在设计缺陷。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	暂且不讨论这些设置在办公区域附近的共享睡眠项目是否刚需，单纯观察它之前的准备工作就会发现，创业者和投资人是为了抢风口，仓促上线不具备法定手续、经营许可的项目，这势必会给别人和自己留下苦果。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如今，“享睡空间”企业所设立的16处场所被关停，正是其跳进了自己挖的坑。这里面更显示一个趋势，政府部门对于创业和创新的规范化、有序化机监管力度会更加严格，蒙眼狂奔前确实需要想想红线在哪里。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	共享新物种遭遇成长烦恼</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	7月15日，有媒体报道称，北京中关村共享床铺“享睡空间”大门紧闭，一办公人员表示，该公司的共享床铺已被警方查封，具体原因尚不得知。据了解，类似的共享睡眠太空舱，已经在北京、上海、成都等地逐渐铺开。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这件事情在近日又有了新的进展。据新华网报道，北京公安机关透露，针对近期出现的“共享睡眠舱”进行调查发现，其中存在诸多治安和消防等隐患。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据了解，北京中关村的共享睡眠太空舱属北京一科技有限公司所有，经营范围以科技开发、技术服务等为主要内容，在全市还有多处享睡空间太空舱的放置点。而在海淀区中关村大街某广场地下二层出现的太空舱，均为长约2.1米、宽约0.9米、高约0.9米的长方体空间，可容纳一人。值得强调的一点是，入住该太空舱无须登记身份信息，只需通过手机注册扫码后就可以使用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	根据消防法规定，“共享睡眠舱”属于旅馆性质，如对外开放经营，需通过相应的法律程序，譬如消防行政审批或者备案手续。此外，根据 《北京市旅馆业治安管理规定》第二条规定，以计时休息形式提供住宿休息服务的经营场所，须向属地公安机关申请办理旅馆业特种行业许可证，未经许可前均不得私自营业。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而，享睡空间在相关法律法规规定、公安机关监管、消防安全技术标准等多方面都不具备相应的经营资质。因此，北京市公安局治安管理部门约谈了“享睡空间”的相关负责人，告知其应履行相应的法定手续，如未经许可私自经营，将依法予以查处。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对此，享睡空间公司负责人表示，“非常感谢公安机关在法律法规方面的指导，公司将严格守法经营。”这家公司也确实遵守了承诺，已将在全市设立的16处太空舱经营点全部停运。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	谈的明白，关的也痛快，说明心服口服。毕竟这么多年来，一根未熄灭的烟蒂引发的惨案，足够成为血的教训。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	盲目上线并不能制造风口</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	回看2015年网约车大战、2016年共享单车火爆，都是因为巨大的市场需求和用户流量，受到了资本的追捧，并由此引发了一股共享热潮。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一时间，共享经济创业大潮中，以共享单车企业独领风骚，之后便是不断冒出来的共享雨伞、共享篮球、共享洗衣机、共享充电宝以及共享睡眠……这些共享经济项目的出现，与共享单车甚至网约车被资本市场疯狂推动存在很大关系。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这种情形让懂懂笔记回想起2014年、2015年时候的O2O大潮，因为外卖O2O和其他本地生活服务的火热，资本热钱涌入，几乎每个星期都会发生投融资事件，这就导致很多人匆忙上线各种O2O项目。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而，当时着急抢占风口、吸引资本的项目，都因为种种隐患而惨淡收场。比如不具备冷链服务能力的生鲜O2O，缺乏完善售后服务机制的洗衣O2O，没有人员安全培训的美业O2O，纷纷被资本和市场抛弃。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过，导致这些项目无法存活下去的原因，不只是各自遗留的隐患，还有市场需求这一关键因素。而眼下的共享经济，很多项目还无法验证是否真的存在市场需求。但可以肯定的是，其中一些项目与当年的O2O很像，都是为了吸引资本快速圈钱，而很多资本因为错过了共享单车风口，更是不惜代价去抢占或制造新的风口。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以共享睡眠项目为例，据享睡空间创始人代建功介绍，共享睡眠是他在今年4月萌生的想法，5月完成内测，随后上线。“在使用流程上，用户通过扫描二维码，进入享睡空间的小程序，就能打开舱门。用户点击&lsquo;解锁舱门&rsquo;后可以暂时离开也能结束入住。出于保障用户入驻卫生的考虑，我们提供的是一次性寝具，包括太空毯、一次性床单、一次性枕巾等。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	客观来讲，享睡空间这样的设计，能够给用户使用提供一些方便。而且，在北京、上海、成都等地投放的50个太空舱，也吸引了不少用户。然而，这个项目还是因为仓促上线，在前期各方面都准备不足，导致上线不到两个月就因缺乏相关经营资质被叫停。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	新东方创始人俞敏洪，曾根据自己所投资的创业公司出现的问题总结了一条经验，凡是最后出问题的公司都有一个共同点，就是号称解决痛点的同时，出现了两个毛病。“第一是找到了一个伪痛点，第二是解决了痛点之后带来了其它的痛点。比如找到漂亮的姑娘想跟她谈恋爱，解决了要谈恋爱的痛点。然后姑娘提了要求，跟我谈恋爱每天必须给我十万，马上觉得恋爱不能谈，因为带来了经济短缺的痛点。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这就说明，共享经济的项目在不考虑是否是刚需的情况下，也不应因为抢时间、抢市场而忽略早期设计，给自己留下隐患，否则将会付出更大的代价。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	天下攘攘，皆为利往。创业者和投资人要了解的是，并不是所有共享项目都能成为共享单车，盲目和虚妄堆不出一个新的风口。</p>\r\n', '', 'admin', '', '1500621424', '1500621424', 'true', '', '在装修房子的时候千万不要购买低档地漏，地漏的选择很重要，不象别的材料，如果不合适还可以拆下来换一个，因为地漏是要装在地面上固定死的，如果拆换非常麻烦。很多人家里装', '在,装修,要,注意,一些,什么,在,装修,房子,的,', '148', '1500953486', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('36', '17', '在人工智能炒热机器人时，也被人把风带进了教', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	最近市面上涌现了大量的智能音箱，随之而来的批评声也层出不穷。人们对于机器人这一词的滥用已经忍无可忍，不夸张的说，市面上有一大半自称XX机器人的产品都是跟风。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这阵风是从哪吹起来的？或许是《中国制造2025》，或许是人工智能领域的发展，也有可能是AlphaGO制造的种种大事件。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	可我们不知道的是，被这阵风吹起来的，除了各种算法公司、大数据公司、山寨机器人之外，还有一大波机器人教育机构。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这里的机器人教育机构，指的不是那些早教机器人，或是传说中的AI+教育，而是一种通过组装、搭建、运行机器人，激发学生学习兴趣、培养学生综合能力的教育方式。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最典型的就是如图所示的这种，将乐高积木通上电，让他们动起来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	虽然看上去只是玩具，但这一产业已经进入中国一线城市的各个中小学。根据中国机器人教育联盟在2016年发布的数据显示，全国已经有了约有7600家机器人教育机构，最近5年增长了近15倍。预计2016年底，全国机器人教育机构将突破1万家，市场规模约为100-200亿，未来空间可达300亿。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在今年，这个数字只会自增不减。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	随着《国家中长期教育改革和发展规划纲要（2010 - 2020年）》将创新二字作为重头戏，机器人教育开始逐渐走进中小学、少年宫。同时《中国素质体育机器人运动通用竞赛规则》正式颁布，各种关于机器人的竞赛有了法规背书，开始登堂入室。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如今这一产业甚至产生了很多分支，有美系、韩系和国产系三个分支。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其中美系的乐高机器人算是最“根正苗红”的，1986年由丹麦乐高公司和美国麻省理工学院的媒体实验室（Media Lab）进行了一项名为「可编程式积木（Programmable Brick）」的合作案。针对12岁以上对于机器人感兴趣的青少年推出了乐高机器人套件，其中包括编程主机、电动马达、传感器等等配件。乐高机器人用种种配件解决了自制机器人需要的电路、机械结构问题，还设计了一套名为RCX Code的视觉化编程工具，只要把各种代表不同程序逻辑的「积木」在屏幕上堆起来，就能完成RCX的程序撰写。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	准确的说，乐高机器人属于“教具”，进入国内后被各种关系复杂的教育机构代理，才实现了商业化。而韩系机器人，则是一开始就奔着教育市场来的。比如设计了积木机器人、单片机器人、人形机器人等等针对不同年龄段的课程，还创造了一系列教学理念。兼之其国内教育机构战略合作伙伴的身份，疯狂的铺设大量校区、举办比赛，还获得了著名基金的风投。</p>\r\n<p>\r\n	至于国产派系，大多都在分割以上两者留下的空白市场，说是鱼龙混杂也不为过。有的甚至只是购买了几套教具，就开始招揽生源。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	市场如此火热，多多少少也证实了机器人教育对青少年有一定的益处。在最近非常流行的STEAM教育中，提倡的学习尖端科技、培养创新能力、合作能力、跨多学科综合教育等等，都在机器人教育中有很好的体现。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	可除了教育本身之外，机器人教育中更多的是功利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一方面是应试教育促进市场发展。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	随着创新二字提上日程，机器人教育不仅走入了校园，也走入了中高考加分制度。尤其最近，教育部下发新规定，将自主招生的报名条件做出调整，只留下了学科特长和创新潜质两个类别，各种机器人比赛的含金量又进一步上升。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这样一来，不少家长开始奔着竞赛、特长、加分等等关键词为孩子报机器人班，最终导致家长对K12科技教育的热情大大高于高校生对科技竞赛的参与热情。机器人教育正在像曾经的奥数一样蓬勃发展。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另一方面素质教育促使校方加大投入。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	素质教育、课改是两个喊了很多年的词，这些词汇一方面关系着学生的课业负担，另一方面也关系着学校的各种荣誉。素质教育示范校、科技教育示范校等等评选促使更多学校开始和机器人教育加强了联系。据了解，截至2017年3月底，全国学校体育机器人联盟成员超过18000家，其中以学校为单位申请加入联盟（含军校）的超过8000家，以各级教育局（委）为牵头人代表所辖学校申请加入联盟的超过10000家。这其中涉及大量的器材采购、人才引进，也给这一产业又打了一剂生长素。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最后，则是混乱的加盟机制促使市场无节制的发展。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	目前很多国产机器人教育或海外机器人代理都大肆宣扬加盟机制，一边大谈工程师思维，一边大谈着人工智能的未来。有的机器人教育，甚至在加盟广告中打出了“加盟三年北上广买房”的旗号。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	实际上机器人教育不仅仅涉及加盟费用，还对场地面积有着不小的要求，行业师资流动性大、器材更新采购都有着不小的成本，一切都注定，机器人教育不是简单的靠交个加盟费用就能做好的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在西方教育理念中，理科常常与Nerd一词联系起来，在影视作品中，擅长数学、物理学科的青少年常常是一副沉闷的书呆子模样，而体育生则总是阳光帅气。机器人教育的出现，就是为了更多的将理科知识化成操作和实物，以一种更酷的形式展现出来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	可到了中国，种种利益的纠缠让机器人教育距离创新、理科、工程师词汇越来越远，最终成为了教育产业利益链上最典型的一环。当然我们承认，一定有学生在机器人教育课程中得到启发，从此在创新道路上走得更远，但我们更想看到的是，在国家政策的支持下，发展起来的是科技成果，而不是单单肥了那些投机者。</p>\r\n', '', 'admin', '', '1500621460', '1500621460', 'true', '', '一般开发商都会在交房时排水的预留孔都比较大，需要装修人员予以修整。很多消费者是在装修的时候根据装修队修整过的排水口尺寸去选购地漏，但市场上的地漏却全部是标准尺寸，', '一般,地漏,使,用的,是,那些,材料,一般,开发商,', '176', '1500953528', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('37', '17', '阿里影业为未来增持淘票票，但眼下“烧钱”依', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	或许是为了响应影院的黑暗环境，阿里影业集团总又一次选择了在晚上发布公告。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	阿里影业间接全资附属公司中联盛世与六名少数股东订立股权转让协议，阿里影业将收购这些股东所持有的淘票票股权，合计约9.12%，总价约13.33亿元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这次收购完成之后,阿里影业将持有淘票票约96.71%股权,而后者估值将为146亿元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对于增持，阿里影业董事会认为“全面增持杭州晨熹的股份，致力将淘票票打造为本集团电影产业的新基础设施的核心平台，能切合本集团中长期战略部署和业务规划的需要，有利于推进本集团业务的快速发展，为本公司股东创造更高的价值。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	换成人话版本就是：“淘票票是目前阿里影业核心，增持能在未来增大收益”，但是笔者总觉得这话还可以理解为减少未来损失、麻烦。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然虽然说的一直都是价值、利益，但就目前来说，淘票票给阿里影业带来的东西里一直没有利益。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	烧钱</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	毫无意外，这俩字依然是淘票票对于阿里的主要贡献之一。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据阿里影业今年2月的业绩公告表示，2016年度亏损介于人民币9.5亿至10亿之间，而亏损原因则是淘票票，为了“获取更多市场份额而投入的市场推广支出”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然，投入了总是有回报的， 比如拿下个市场第一。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	数据公司Quest Mobile最近一份报告显示，电影在线票务行业的App中淘票票的日活跃用户数位居第一——可惜猫眼电影还是拿下了月度活跃用户第一。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但这就是一个怪圈。用脚投票的用户很简单，谁有补贴，贴的高，就用谁，而持续的补贴则是继续亏损。对于这个情况，阿里影业当然明白，并且并不会一直烧下去，所以阿里推出了影城卡等一系列尝试。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这路子开始很好，至少对于用户很好，如果最近没变味的话。据部分用户反映，现在有些时候会遇到影城卡不如普通用户便宜，甚至特惠价格影城卡用户无法享受等问题，为此甚至有人在知乎专门开了一个问题《淘票票为什么同一个时间段有影城卡的用户比普通用户买电影票价格更贵？》</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不知道这是算法问题还是套路问题，笔者个人来说希望这是算法问题，毕竟阿里影业的志向不是这点小钱，这在增持公告上也再一次被提及了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在增持公告上阿里影业明确的写出了：“因应电影行业大势和消费者行为的快速迭代演变，本集团将持续围绕娱乐实业生态进行布局和业务升级，打造电影行业的新基础设施。淘票票作为新基础设施最重要的用户触达功能的平台，已经在电影宣传、发行和票务领域建立了坚实的业务基础，并发展成为国内领先的线上票务平台之一。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这段确实有些啰嗦，简单来说就是：我们觉得线上购票将会是未来常态，而淘票票则是阿里影业对未来的布局，目前已经在电影宣传、发行和票务领域有一定成绩。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以淘票票对于阿里影业是“核心平台”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而这或许也是个好消息，直到猫眼和淘票票合并之前，用户应该总能找到优惠。</p>\r\n', '', 'admin', '', '1500621518', '1500621518', 'true', '', '由于水封式地漏具有的种种问题，所以新式的非水封式地漏也就应运而生，以下是主要的几种： 1、偏心块式：即用一个密封垫，一边用销子固定，利用重力偏心原理来密封，弊端一是', '目前市,场上,几种,非水,封式,地漏,由于,水封,', '90', '1500953570', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('38', '17', 'AI在内容分发上的绊脚石', '', '/storage/images/20211201/1-1FHQP212512.jpg', '', '<p>\r\n	自从互联网商业化发展以来，不论是新闻客户端、视频网站或是电商平台……所有的平台，都是把自己默认为一个优秀的饲养员，它按照自己的想法，把内容（饲料）Push（喂）给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些饲养员都是受过训练的专业人士，行话叫做---由网站编辑为用户设置议程，按照大多数用户的口味挑选内容。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	后来编辑实在忙不过来，采用机器帮忙---最简单的机器方式则是“热门推荐”，比如按照点击量或其它数据来做排序。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	饲养员模式最大的问题是不知道食客胃口如何，这会导致两个显著的后果：一是食客不满意，用户个性化需求不能得到满足；二是自身资源浪费，大量长尾资源长期得不到曝光，增加沉没成本。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	有人发现了机器的好处。机器可以是根据用户特征来推荐内容。正如一个高明的厨子可以根据每一个食客的口味提供饭菜，如果机器足够聪明，在一定程度上可以解决所有用户的个性化需求。这岂不是内容产业的C2M？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	准确的说，这是内容分发的C2M，它以单个用户为对象进行沟通，跳出了大众传播/分众传播窠臼，是不是足以革了所有的搜索引擎和门户网站的命？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这种智能化的内容C2M有深刻的时代背景。今天，你已经站在时代边缘，眼睁睁的看着AI技术点燃了IOT的引线，接下来你将发现自己无可拒绝的进入下一个信息核爆的时代：信息终端爆炸、信息规模爆炸、信息平台爆炸……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在信息高速公路上，你开过的车，你走过的路，全都变了规则，你所熟悉的一切的基于饲养员模式的知识框架都面临颠覆。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在这个时代，饲养员模式已经失灵了，聪明的机器将成为最大的变量。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一个出现的场景是人类生产内容，机器分发内容。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	下一个出现的场景是机器生产内容，机器分发内容。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	内容产业面临C2M革命，行不行？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“当然不行，机器很蠢。”如果你这样想，那么很遗憾，你注定是看不到明天的太阳了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“当然行。”如果你这么想，那么祝贺你掉进坑里了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	真实的情况，你可能意想不到。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	一、内容C2M之路本质是走向个体化沟通</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	作为一个独立的研究方向，推荐系统的源头可以追溯到90年代初的协同过滤算法，中期的代表则是传统的机器学习算法，比如Netflix大赛所推动的隐语义模型，现在则是更加复杂的深度学习模型。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	近些年，深度学习突飞猛进，使得机器推荐变成了整个互联网的太阳。在新技术的推动下，个性化沟通也变得更加可行，而且越来越接近单用户沟通。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	（一）协同过滤蹒跚起步</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	按照百科词条解释，协同过滤是利用用户群体的喜好来为你推荐感兴趣的信息，这些用户要么兴趣相投、要么具有共同经验，然后网站结合你的反馈（如评分），进行过滤分析，进而帮助别人筛选信息。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然，用户喜好不一定局限于特别感兴趣的信息，特别不感兴趣信息的纪录也相当重要。协同过滤表现出了出色的效果，开始在互联网行业称王称霸。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	起先，协同过滤应用于邮件过滤。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1992年，施乐公司的科学家提出了Tapestry系统。这是最早应用协同过滤系统的设计，主要是解决Xerox公司在Palo Alto的研究中心资讯过载的问题。这个研究中心的员工每天会收到非常多的电子邮件却无从筛选分类，于是研究中心便发展这项实验性的邮件系统来帮助员工解决这项问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	接着，协同过滤思路开始应用于内容推荐。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1994年，美国Minnesota的GroupLens项目组创办了一个新闻筛选系统，这个系统可以帮助新闻的阅听者过滤其感兴趣的新闻内容，阅听者看过内容后给一个评比的分数，系统会将分数记录起来以备未来参考之用，假设前提是阅听者以前感兴趣的东西在未来也会有兴趣阅听，若阅听者不愿揭露自己的身分也可以匿名进行评分。作为最老牌的内容推荐研究团队，GroupLens于1997年创建了电影推荐系统MovieLens，还有性质相近的音乐推荐系统Ringo，以及影音推荐系统Video Recommender等等。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	后来，出现了另一个里程碑——电子商务推荐系统。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1998年，亚马逊的林登和他的同事申请的基于物品的协同过滤（item-to-item）技术专利，是亚马逊早期使用的经典算法，一度引爆流行。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	协同过滤算不算人工智能？从技术的角度来看，它也属于AI范畴。但必须指出的是协同过滤算法比较弱智，无论是基于用户的协同过滤，还是基于物品的协同过滤，推荐效果总是差强人意。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	怎样通过一个成体系的方法论来引导推荐系统的不断优化？如何才能把复杂的现实因素糅合到推荐结果中？攻城狮们一度非常非常头大，重赏之下必有勇夫，后来，终于有人发现了更加灵活的思路。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	（二）传统机器学习开始加速</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2006年，Netflix宣布举办Netflix Prize。Netflix是一家老牌的在线影片租赁网站，举办大赛的目的旨在解决电影评分预测问题的机器学习和数据挖掘问题。主办方为此下了血本，宣称对于那些能够将Netflix的推荐系统Cinematch的准确率提升10%的个人或团队，奖励100万美元！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Netflix在自家blog上披露了许多庞大的数据，举例如下：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<blockquote>\r\n	<ul>\r\n		<li>\r\n			<p>\r\n				我们有几十亿的用户评分数据，并且以每天几百万的规模在增长。</p>\r\n		</li>\r\n		<li>\r\n			<p>\r\n				我们的系统每天产生几百万的播放点击，并且包含很多特征，例如：播放时长、播放时间点和设备类型。</p>\r\n		</li>\r\n		<li>\r\n			<p>\r\n				我们的用户每天将几百万部视频添加到他们的播放列表。</p>\r\n		</li>\r\n	</ul>\r\n</blockquote>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	显然，在这些海量数据面前，我们已经不能靠由纯人工或者小型系统建立起来的分类标准对整个平台用户喜好进行标准化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	比赛开始一年后，Korbell的团队以8.43%的提升赢得了第一个阶段奖。他们付出了超过2000个小时的努力，融合了107种算法。其中两种最有效的算法：矩阵分解（通常被叫做SVD，奇异值分解）和局限型玻尔兹曼机（RBM）。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	矩阵分解作为协同过滤的补充，核心是将一个非常稀疏的用户评分矩阵R分解为两个矩阵：User特性的矩阵P和Item特性的矩阵Q，并用已知的数据构建这些向量，使用它们来预测未知的项。该算法在有效提高计算精度的同时，还能够加入各种建模元素，使更多元化的信息融合进来，更好地利用大量数据。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	然而矩阵分解也有不足。不足之处在于，矩阵分解和协同过滤算法一样，都属于监督学习范畴，粗糙且简单，适用于小型系统。摆在网络巨头们面前的问题是，如果需要建立一个大型推荐系统，协同过滤和矩阵分解则会花费较长的时间。怎么办？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	于是，一些攻城狮将眼光转移到无监督学习中。无监督学习中的聚类算法的本质是识别用户组，并对这个组内的用户推荐相同的内容。当我们拥有足够的数据，最好使用聚类作为第一步，来缩减协同过滤算法中相关邻居的选择范围。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	隐语义模型运用了聚类分析方法，其一大优势是既可以做评分预测，又可以同时对文本内容建模，使得通过内容来进行推荐的效果得到较大提升。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	传统的分析方式在对用户打标签，并根据标签映射到结果的两个步骤中准确度不高。比如用户填写的年龄不一定真实，或者并非所有青少年都喜欢漫画。而隐语义模型的核心，是超越这些表层语义标签的维度，通过机器学习技术，挖掘用户行为中更深层的潜在关联，使得推荐精度更高。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Netflix Prize百万美元武林大赛号令之下，天下英才频出。2009年达到了一个高峰，成为推荐系统领域最标致性的事件，这次比赛吸引了众多专业人士投身于推荐系统领域的研究，也让这项技术从专业圈子渗透到了商业领域，引发了热烈的讨论并逐渐勾起了主流网站的垂涎，基于内容的推荐、基于知识的推荐、混合推荐、基于信任网络的推荐等等走上了快速发展的通道。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些推荐引擎与协同过滤不同，例如基于内容的推荐是建立在项目的内容信息上作出推荐的，而不需要依据用户对项目的评价意见，更多地需要用机器学习的方法从关于内容的特征描述的事例中得到用户的兴趣资料。内容过滤主要采用自然语言处理、人工智能、概率统计和机器学习等技术进行过滤。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	百万美元花得值不值？据2016年的Netflix用户数据：注册会员6500万人，每天观看视频的总时长1亿个小时。Netflix说，每年靠这套系统能够节省10亿美元。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	（三）深度学习带来“无人驾驶”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	近些年来，用户的大痛点出现。智能手机的普及，让庞大的信息量和狭小的阅读屏幕成为一对难以化解的矛盾，用户阅读场景不再是固守于电脑屏幕，而是向移动化碎片化转变，搜索引擎失灵了，人工推荐忙不过来，机器推荐也不够用了，这种转变对大内容平台简直是生死考验。能满足需求则生，不满足则死。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	面对这一问题，YouTube和Facebook提出了新解决思路：运用深度学习，制造聪明的机器。近十年来，深度学习已经取得了巨大的飞跃，对于解决大数据量更有优势。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果说人工内容推荐如同司机开车，那么深度学习所带来的内容推荐，则如无人驾驶汽车。在这种技术是利用用户数据来“感知”用户喜好，其推荐系统基本可以分为数据层、触发层、融合过滤层和排序层，当数据层生成和存储的数据进入候选层后，也就触发了核心的推荐任务。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以YouTube为例，其最新公开的推荐系统算法由两个神经网络组成，一个用于候选生成，一个用于排序。首先，以用户的浏览历史为输入，候选生成网络可以显著减小可推荐的视频数量，从庞大的库中选出一组最相关的视频。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这样生成的候选视频与用户的相关性最高，再进一步对用户评分进行预测。这个网络的目标，只是通过协同过滤提供更广泛的个性化。排序网络的任务则是仔细分析候选内容，精选出少量最优选择。具体操作为根据视频描述数据和用户行为信息，使用设计好的目标函数为每个视频打分，将得分最高的视频呈献给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在这种模式下，机器全然接管了平台。在深度学习的持续训练下，机器越来越聪明，与人打交道的智商会逐渐提升，在某种意义上也逐渐承担起看门狗的责任。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	二、内容产业是否即将被C2M颠覆</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	世界之大无奇不有，美国得克萨斯州科珀斯—克里斯蒂市一家银行的一台自动取款机（ATM）竟然在11日吐出了字条，上面写着“救我”，这条新闻很快传遍中文网络，成为许多网站的头条。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	你需要从N个网站上看到一模一样的文章吗？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些冗余的信息消耗了你的精力和流量，就像你打开任何一个电视频道，都能看到许多方便面广告一样，让人很难从大量的信息中快速找到自己想要的内容。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如何解决用户信息冗余的尴尬？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	过去曾经有许多不成功的技术方案，个人门户昙花一现，RSS订阅不成气候，跨站跟踪上不了台面。能引领未来者，只有C2M。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	C2M模式可以像今日头条这样应用于全网，也可以像Facebook那般基于巨头的平台。其核心就在于基于用户行为习惯、特征和诉求，对海量的信息进行提取、分拣然后传递给用户，这是克服痛点的秘密。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但质疑的声音也不少。比如有观点认为，协同过滤这样的推荐容易让用户形成信息茧房、无法识别阅读场景、即时性差、耗时长等缺点，而今日头条这样的模式也常常被诟病，还要应付难以捕捉的用户兴趣、用户数据的隐私和管理等多项挑战。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	支持和质疑各执一端，孰是孰非？未来虽有两大机遇，但是目前要跨越三座大山。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	1.支持的理由如下：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①千人千面，众口可调。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化的内容推荐机制能够根据用户的喜好为其推荐信息。通过各种算法，通过分析用户的历史行为，对比相关用户和相关物品猜测用户可能喜欢的内容，列出候选集并进行验证，用户可以得到较为准确的内容，使信息分发做到千人千面，实现内容与用户的精准连接，而不是传统意义上的千人一面般的投放。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②海里捞针，提高效率</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐省去了用户在海量信息中进行提取和搜寻的环节。用户无需在海量信息中摸针，在一定程度上为用户去除了部分无用信息，缩小了用户信息搜索的范围，提高了用户的阅读效率。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	③投其所好，增强粘性</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不断为用户推荐适合他的内容能够增加用户粘性。个性化推荐技术通过算法进行用户感兴趣的内容的精准推荐，帮助用户快捷发现感兴趣的内容，当你看完一个内容后，会立马给你推荐相关的东西，可以增加用户粘性，提高用户体验。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	④挖掘长尾，打破两极</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐能够通过相关算法帮助用户挖掘长尾内容，避免两极分化的马太效应。当A用户喜欢比较冷门的长尾内容，而B用户又有跟A用户有相同或相似的兴趣和行为习惯时，系统就能够把A用户喜欢的冷门内容推荐给B用户，这样就使冷门内容得到更多的曝光，帮助用户发现更多的长尾内容，避免内容生产生态两极分化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	⑤双向交流，深度优化</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	基于用户进行个性化推荐是对用户进行深度分析和交流的结果，提升了用户的交互式体验。传统的人工推荐是遍地撒网地推荐，没有对用户进行细致地划分和筛选，机器推荐以用户特点和习惯为基础进行推荐，用户能够得到双向的交流和沟通，用户的行为也能对下一步的推荐产生影响，在一定程度上得到了反馈，提升了用户的交互式体验。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	⑥分门别类，运营细化</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐也有利于平台对内容进行分类，从而利于平台精细化管理和运营。信息时使得平台不断涌现，各种形式的内容越来越丰富，用户手机端展示的区域有限，个性化推荐能够使商家更好地针对不同客户对内容进行分类，有利于精细化运营。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	2.质疑的观点主要有：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①画地为牢，思维设限</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化新闻体验容易让思想裹足不前。个性化推荐的结果是基于用户的历史数据和历史行为，基于相似用户或者相似物品进行的推荐，在一定程度上将用户感兴趣的内容固定在一个特定的闭环里，在为用户筛选信息的同时也为用户隔断了很多信息。个性化推荐的内容采集自你的兴趣，又决定了你的兴趣。因此，无法接触“新”事物自然就不能培养新的兴趣，容易让用户越来越狭隘。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②人心变幻，机器何解</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	机器推荐无法识别阅读场景的变化而带来的需求的变化，无法感知用户为什么需要阅读，难以匹配人类情感的复杂程度。例如在某一个阶段，我们因为大家都在讨论某件事而去关注这件事，但这并不意味着我们对类似的事情都感兴趣。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	③审美下线，好坏难分</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐的难度对推荐内容的质量带来了挑战。以往评价一篇文章的好坏对编辑来说都没那么容易，如今机器推荐很容易忽略质量这一维度。机器算法不准确会使标题党内容混杂出现，机器推荐可能会把一篇没有价值的文章推荐的很高，也有可能把真正有价值的文章埋没掉，机器推荐只能从外部数据来衡量你的文章有没有价值，目前还没有办法从内容的本质上分析有没有价值。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	④耗时较长，总慢半拍</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	基于海量数据的个性化推荐行为耗时较长，即时性较差。如新闻推荐存在及时性问题，需要不断更新，通过分析用户的历史行为、对比类似用户等数据分析工作耗时较长，不易在第一时间形成推荐结果。并且协同过滤等方法还存在冷启动的问题，即在用户体验之初，并未形成成熟的历史数据时，需要经过很长的时间收集用户点击日志数据，从而产生推荐。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	⑤热点共通，个体趋同</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	并不是所有的用户都彼此相等，但协同过滤方法不考虑用户之间的个体差异。例如，我们观察到娱乐新闻不断推荐给大多数用户，即使用户不点击娱乐的故事。原因是，娱乐新闻一般都是非常流行的，因此总是从一个用户的“邻居”的娱乐故事足够的点击进行推荐。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	3.未来的机遇在哪里？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	未来的机遇在于两大推动力：业界对长尾金矿的商业动力；用户强烈的个性化需求的推动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①长尾金矿</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐能够帮助用户发现更多优质的长尾内容，提高平台商业价值。一般平台用户访问的只局限在热门的10%左右的内容，很多小众的、冷门的内容却沉在数据库中不易被发现，我们将其称之为长尾内容。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	按长尾理论，由于成本和效率的因素，当商品储存流通展示的场地和渠道足够宽广，商品生产成本急剧下降以至于个人都可以进行生产，并且商品的销售成本急剧降低时，几乎任何以前看似需求极低的产品，只要有卖，都会有人买。个性化推荐能够通过协同过滤中基于用户的推荐技术将小众喜欢的长尾内容扩散开来，充分挖掘长尾内容，产生长尾金矿。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②时代刚需</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我们所处的时代已经变化了。经过20年发展，互联网变成了移动互联网，现在即将融合AI进入IOT时代，终端和信息正在以核爆的态势发生急剧膨胀，用户在海量的数据中想要找到他们需要的信息将变得越来越难。在这种情况下，传统的搜索引擎已经力不从心。早先最具代表性的就是分类目录的雅虎和搜索引擎的谷歌，已经进入死胡同，想要通过搜索引擎去了解一个陌生领域的知识，效率极低！</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	要满足时代刚需，希望在于个性化推荐。机器需要尽可能的了解用户，并且根据用户的数据，主动推荐让用户有兴趣和需求的信息。目前这20来年，虽说取得了一点点成就，但仅仅是唐僧取经迈出了第一步，还有很长的路要走。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	4.当下需要跨越的三座大山</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个性化推荐在发展过程中面临很多诸如难以预测用户兴趣、用户相关数据涉及隐私以及数据的处理难度等问题，都给个性化推荐带来了很大的威胁和挑战。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一座山，准确。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	用户的兴趣易受多重因素影响而不断变化，这对个性化推荐来说是个不可避免的挑战。个性化推荐系统的基础部分是用户兴趣建模，用户兴趣建模的质量直接决定了个性化推荐的质量。但是用户兴趣随时都会受到社交、场景、环境等多重因素影响，用户兴趣地不断变化使得根据以往数据预测用户未来倾向的工作变得很难，也会影响推荐结果的准确性。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二座山，隐私。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对以用户数据为基础进行的个性化推荐来说，如何保护用户隐私是个不小的难题。传统的内容推荐系统对用户的页面访问记录进行数据挖掘,找出用户的访问习惯,然后在服务器端根据用户需求进行信息筛选，试图为用户提供信息推荐服务和垃圾信息过滤服务。但如何能在保护用户隐私的同时,又为用户提供更准确的内容推荐服务是一个不小的挑战。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第三座山，价值观。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	除了三座大山外，还有一个问题也值得重视。现在的机器推荐等于“没有三观”、“没有审美”，在中文圈运营，由于众所周知的原因，一定会遇到相当的挑战。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	流量造假和作弊是比较明显的例子。比如有网友告诉笔者说：网上经常看到一些视频学习人数几万、几十万，数字大的得令我们怀疑人生，结果测试了一下，页面刷新一次人数就加三而新课程加几十，瞬间明了。半夜测试某些视频直播，对着墙拍，从启动直播十分钟直播粉丝还能蹭蹭往上涨，进一个真粉丝时人数又一波涨，作弊一时爽，但心里不踏实。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	曾经有企业在智能推荐的客户端上投过一些非常垂直大号的广告，有的效果真好，有的造假太明显---在阅读量瞬间破万的时候带过来的流量，还不如自己阅读破千的号效果好。如此种种，数据是正经的，就看用它的人正经不正经了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	未来，个性化推荐如何在技术和管理上继续革新，人工智能因素的参与能否改善现存的诸多问题，为用户产生更优质的推荐结果将成为一个重要课题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	三、巨头正在开辟的技术路线</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实，无论支持还质疑有多么大，个性化推荐已经引得无数巨头竞折腰。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	目前在市场上，依然是新老技术各占一方地盘，新派深度学习技术快速崛起，咄咄逼人；老派技术也在不断优化，以防不测。新老技术之争，是当下的一个热点，也是决定未来发展的两大路线。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	（一）老派技术认为：传统推荐技术可以自我完善</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1.Google新闻的套路，不断优化</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Google新闻是一个在线信息门户站点，它聚集数千家信息源的新闻报道（在将相似新闻分组后）并以个性化的方法展现给登录用户。由于文章和用户数量巨大，以及给定的响应时间要求，纯粹的基于记忆的方法是不适用的，需要一种可扩展的算法，因此Google新闻组合使用了基于模型和基于记忆的技术。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Google新闻的套路依然是协同过滤的底子。它在个性化推荐方面采用的是基于模型和基于记忆的技术相结合的协同过滤技术。根据《推荐系统》一书的介绍，基于模型的那部分依赖两种聚类技术：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①概率潜在语义索引（PLSI）：协同过滤的“第二代”概率技术，为了识别出有相似想法的用户和相关物品的聚类，引入了隐藏变量，对应每个用户—物品对的有限状态集合,能适应用户可能同时对多个主题感兴趣的情况。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②MinHash：根据两个用户浏览过物品的交集将两者放入相同的聚类（哈希桶）。为了让这种哈希过程具有可扩展性，采用了一种特殊方法寻找近邻，并采用Google自己的MapReduce技术在几个机群之间分发计算任务。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	基于记忆的方法主要是分析“伴随浏览量”。“伴随浏览量”指的是一篇文章在预先定义的一段时间内被相同用户浏览过。预测时需要遍历活跃用户最近的历史数据和从内存里获取邻近的文章。运行时，预先设定集合里候选物品的综合推荐评分是这三种方法（MinHash、PLSI和伴随浏览）获得的分数的线性组合计算值，然后再根据计算值的高低进行推荐结果的输出。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2.Linkedin为四个场景开发的系统</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Linkedin主要是通过自主研发设计的协同过滤推荐平台Browsemap实现个性化推荐。Browsemap是Linkedin开发的一个实现了物品协同过滤推荐算法的泛化平台，该平台可支持Linkedin中所有实体的推荐，包括求职者、招聘贴、企业、社会群体（如学校等）、搜索词等，若要通过该平台实现某个新的实体协同过滤推荐，开发者要做的工作仅仅包括：相关行为日志的接入、编写Browsemap DSL配置文件和调整相关过期参数等简单工作。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	论文指出，Browsemap平台在Linkedin最常用的有四个推荐场景：给求职者推荐公司、相似公司推荐、相似简历推荐和搜索词推荐等等。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①给求职者推荐公司：通过Browsemap实现基于物品的协同过滤，计算用户和潜在意向公司的相似度值，得到相关公司特征；将相关公司特征和用户/公司内容特征（包括用户位置、工作经验；企业产品、相关描述）一起分析得到最终的偏好分值。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②相似公司推荐：与给求职者推荐公司有两点不同：一是内容特征相似度变为公司画像之间的相似度；二是基于多种用户行为构建browsemap。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	③相似简历（用户）推荐：通过公司详情页浏览行为和用户画像特征实现该部分推荐。同时将相似简历的属性用于补足简历的缺失属性，得到该用户的虚拟简历。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	④搜索词推荐提供了四种关联方式：一是协同过滤：在计算搜索词间相关性时会加入时间和空间因素；二是基于推荐搜索词搜索结果的点击率；三是基于搜索词之间的重合度；四是基于推荐搜索词的点击率。但实验结果表明协同过滤的结果最好，甚至也好于将这四种方式综合的结果。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3.今日头条的三个阶段</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	作为国内当红的个性化推荐产品，今日头条技术经历了三个阶段：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	早期阶段，以非个性化推荐为主，重点解决热文推荐和新文推荐，这个阶段对于用户和新闻的刻画粒度也比较粗，并没有大规模运用推荐算法。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	中期阶段，以个性化推荐算法为主，主要基于协同过滤和内容推荐两种方式。协同过滤技术思想和前文介绍的并无差别。基于内容推荐的方式，则是先对新闻进行刻画，然后利用用户的正反馈（如点击，阅读时长、分享、收藏、评论等）和负反馈（如不感兴趣等）建立用户和新闻标签之间的联系，从而来进行统计建模。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当前阶段，以大规模实时机器学习算法为主，用到的特征达千亿级别，能做到分钟级更新模型。架构分为两层：检索层，有多个检索分支，拉出用户感兴趣的新闻候选；打分层，基于用户特征、新闻特征、环境特征三大类特征使用实时学习进行建模打分。值得一提的是，实际排序时候并不完全按照模型打分排序，会有一些特定的业务逻辑综合在一起进行最终排序并吐给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	头条为何能取得成功？文章分析，很多人会说是头条的个性化推荐技术做得好，其实不尽然。原因在于，今日头条的个性化推荐也是经历着复杂的演变过程：从人工推荐到机器推荐再到最终不断迭代算法和技术，反复的进行验证，日益完善。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	（二）新派技术认为：深度学习才是明智选择</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	新派技术主要指采用了深度学习的个性化推荐系统。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	深度学习是机器学习中一种基于对数据进行表征学习的方法。观测值（例如一幅图像）可以使用多种方式来表示，如每个像素强度值的向量，或者更抽象地表示成一系列边、特定形状的区域等。而使用某些特定的表示方法更容易从实例中学习任务（例如，人脸识别或面部表情识别）。深度学习的好处是用非监督式或半监督式的特征学习和分层特征提取高效算法来替代手工获取特征。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当常规推荐算法已经无法及时地分析处理体量较大的数据并准确地针对独立用户做出推荐时，具备相应技术水平的公司开始利用深度学习解决海量内容分析推荐的痛点。我们以较早开始引入深度学习的YouTube、Facebook为例进行分析。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1.YouTube的神经网络</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	YouTube的推荐系统是是世界上规模最大、最复杂的推荐系统之一。YouTube的全球用户已经超过十亿，每秒上传的视频长度以小时计。视频“语料”库存日益增长，就需要一个推荐系统及时、准确地将用户感兴趣的视频不断推荐给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	相比其他商业推荐系统，Youtube推荐系统面临三个主要的挑战：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	①规模。现有绝大多数可行的推荐算法，在处理YouTube级别的海量视频就力不从心了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	②新鲜度。YouTube视频“语料”库不仅仅是储量巨大，每时每刻上传的新增视频也是源源不断。推荐系统要及时针对用户上传的内容进行分析建模，同时要兼顾已有视频和新上传视频的平衡。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	③噪声。由于用户行为的稀疏性和不可观测的影响因素，用户的历史记录本质上难以预测。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	为了解决这些问题，YouTube推荐系统将研究重点转移到深度学习，使用Google Brain开发的TensorFlow（Google研发的第二代人工智能学习系统）系统为推荐系统带来了开发测试上的灵活性。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	YouTube推荐系统主要由两个深度神经网络组成：第一个神经网络用来生成候选视频列表；第二个神经网络用来对输入视频列表打分排名，以便将排名靠前的视频推荐给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	候选视频生成是依靠协同过滤算法产生一个宽泛的针对用户的个性化推荐候选名单。排名神经网络是基于第一个候选生成网络的列表，提供更精细的区分细化，从来达到较高的推荐命中率。通过定义目标函数来提供一系列描述视频和用户的特征，排名网络则根据目标函数来给每一个视频打分。分数最高的一组视频就被推荐给用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	正是YouTube海量级别的视频才产生了深度学习的需要，有效弥补了协同过滤存在地处理数据耗时长等问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2.Facebook迈出的一大步</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Facebook近10年来一直沿用其Newsfeed功能实现个性化推荐。2006年9月份，NewsFeed（信息流）问世，同时问世的还有MiniFeed（个人动态）。NewsFeed是一个系统自动整合生成的内容信息流，它自行来决定我们读到哪些新闻、动态、事件。它所覆盖的范围，其信息推送的精准度，以及其影响力远超过我们的想象，可以说NewsFeed是Facebook在人工智能上所走的一大步。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	Facebook是如何利用深度学习来评价内容和用户的呢？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一，在检视文本方面，Facebook使用“自然语言处理”技术来扫描每个人发的“状态”和“日志”，以便“真正理解文本的语义”，不仅如此还要将它们评级。日志在扫描的过程中，系统会自动识别出“过度标题党”或者“过度商业化”的内容，而且这样的内容在NewFeed里面是越来越少见到了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二，在内容翻译上，当在处理非英语的语言时，Facebook工程师专门开发了一个深度学习平台，每一天会对100多种语言所写成的文本进行分析，翻译。比如当一个朋友以德语发表了一条动态时，NewsFeed会以英语体现出来给一个美国的朋友，营造了一个能够跨过语言障碍的，人人实现互联互通的数字虚拟环境。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第三，在识别物体方面，Facebook也在利用深度学习技术来识别照片和视频里面的物体，不仅如此，它还能进一步地去探究谁有可能对这些照片感兴趣，或者这些照片跟哪些用户相关联，从而推荐给目标用户。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	（三）深度学习之困境</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	深度学习能打遍天下无敌手吗？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	至少目前来看，深度学习只是在Speech和Image这种比较“浅层”的智能问题上效果是比较明显的，而对于语言理解和推理这些问题效果就有点失分，也许未来的深度神经网络可以更“智能”的解决这个问题，但目前还差点火候。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	深度学习在推荐系统领域的研究与应用还处于早期阶段。即使深度学习被认为能够解决协同过滤的冷启动、数据处理较慢的问题，但是风光之下，它也有自己的难言之隐。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一，成本太高。数据对深度学习的进一步发展和应用至关重要。然而过分倚重有标注的大数据也恰恰是深度学习的局限性之一。数据收集是有成本的，而且标注成本已经开始水涨船高，这就使得深度学习的成本过高。而且对于体量较小、数据较少的众多小公司来说，即使有能力用深度学习改善个性化推荐结果，也面临着没有数据支撑的尴尬境地。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二，降低成本的方案有没有？有，但是难以实现。深度学习分为有监督学习和无监督学习，大量无监督数据的获取成本却是微乎其微的。目前一般用的都是监督学习，但本质上基于监督学习的大多数推荐模型都很难彻底规避现存问题从而提高推荐质量。无监督学习由于无需对数据进行加标签等原因成本较有监督学习较低，但目前深度学习对无监督数据的学习能力严重不足，因此深度学习在推荐系统中的应用仍处于早期阶段。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	新老派两大力量相互抗争、相互促进但又相互交融。传统推荐技术在深度学习的冲击下不断完善，深度学习带着赶超传统推荐技术的强势劲头不断革新但也面临着发展窘境。但正是在多个平台的这种自我发展和革新的过程中，新老派的界限也变得越来越模糊，越来越走向融合。即使坚持完善传统推荐技术的公司也开始慢慢涉足到深度学习的领域中，深度学习发展较为成熟的新派也并没有完全摒弃老派技术，那么，未来到底何派为王？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	四．未来鹿死谁手？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	内容C2M，本质上是对人心的一种洞察和预测。技术与人心的斗法，并非一朝一夕便能奏功。人类思想的根本特征在于“意识”，即个体理解自己与他人的心理状态，包括情绪意图、期望、思考和信念等，并借此信息预测和解释他人行为的一种能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是，当前的人工智能领域中存在着一个很严重的问题：人们误解了深度学习模型的工作机理，并高估了网络模型的能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	通过深度学习，我们可以训练出一个模型，它可以根据图片内容生成文字描述。这个过程被视作机器“理解”了图片和它生成的文字。当某个图像存在轻微改变，导致模型开始产生相当荒谬的字幕时，结果就会让人非常惊讶—模型失灵了。机器能找出一只猫，但机器仍然不能识别跟猫相关的所有信息。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	回顾历史不难发现，技术一直追求的目标，与其说是让机器替代人类，而不如说是制造聪明的机器来提高效率。协同过滤技术的发展便是个明显的例子。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最近几年来，互联网巨头制造“聪明的机器”的积极性异常高涨，也是效率使然。根据微软研究院的估计，亚马逊网站上大约30%的页面浏览来自于推荐系统；Netflix首席产品官声称80%以上的电影观看来自于推荐系统，并称Netflix推荐系统的价值每年高达十亿美元；据阿里巴巴披露数字，2013年当天由推荐直接引导的成交总额为56.8亿元。今日头条则将公司核心业务架构在推荐引擎上，是当今最重视推荐技术的公司之一……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在内容C2M发展历程中，尽管深度学习存在许多不足，但深度学习主导未来是大概率事件。我们看到代表着传统推荐技术和深度学习的新老派在相互促进和相互融合，在全球流量前20的平台中，虽然有不少公司依然沿用采用协同过滤技术，比如Google新闻，LinkedIn等，但是其中一些公司也已经准备甚至已经采用深度学习等技术来改进自身不足。而YouTube、Facebook等先行者已开始享受深度学习的红利。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从饲养员模式到聪明的机器，内容产业的C2M已然成势，颠覆日，不远了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我们可以相信，虽然深度学习还存在着一些制约因素，但是，随着AI技术和产业的强劲发展，技术上的瓶颈终究会被突破。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	需要警惕的是，在C2M跨越了准确、隐私两座大山后，人类通过AI掌握了新的力量，掌握者的欲望和野心，也应该受到一定的控制，尤其是价值观问题，将显得越发重要。</p>\r\n', '', 'admin', '', '1500953681', '1500953681', 'true', '', '自从互联网商业化发展以来，不论是新闻客户端、视频网站或是电商平台所有的平台，都是把自己默认为一个优秀的饲养员，它按照自己的想法，把内容（饲料）Push（喂）给用户。 这', '在,内容,分发,上,的,绊脚石,自从,互联网,', '144', '1501236125', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('39', '18', '国产顶级“二次元”IP：三国', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	《三国演义》一直是中国人民津津乐道的名著。曹操、刘备、诸葛亮、司马懿，这些一千多年前的历史人物，至今仍是家喻户晓。这本书不仅是中国人的骄傲，也是东亚范围内最受欢迎的中国古典小说。究竟什么原理导致的《三国演义》有如此大的魅力，能够在汉字文明圈长久不衰？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	小说的三国，而非历史的三国</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我们现在熟知的三国典故，多是来自小说《三国演义》，早已脱离史实，是纯粹的小说。《三国志》中的人物形象和《三国演义》中可以说是大相径庭。中国人所喜爱的三国，并不是正史中的三国，而是经过演绎和修改的故事三国。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	宋代以前人们对权臣并没有后来那种反感，因此曹操的形象在正史《三国志》里，其实非常高大。他不但是个军事奇才还是个卓越的政治领袖，更是一个结束了北方战乱的英雄。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是到了魏晋南北朝的时候，其形象开始一路下坡逐渐变得奸诈狡猾，到了宋代尤其是南宋，已经和《三国演义》中的形象相差无几了。这个过程也正是中国集权化加强，人们的观念中对权臣的看法逐渐变化所致。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这个时候正史《三国志》中的英雄曹操自然不被大众所喜，而且在很多野史中逐渐黑化。当《三国演义》描述曹操的时候，不一定是作者个人对曹操有什么偏见，而是吸收了大量之前的野史记录所致。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	曹操是被妖魔化了，诸葛亮则被神圣化，原本在《三国志》中他是一个长于内政但是短于军事的人，但是因为“鞠躬尽瘁”被之后的儒家观念所喜，因此逐渐成为了一个神机妙算的人。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	《三国演义》的成书时间和作者众说纷纭，普遍认为是罗贯中所著，全称为《三国志通俗演义》，成书于明初或者明中叶。《三国演义》基本是迎合了明代的价值观念。明清之际恰恰是程朱理学大成之际，《三国演义》在故事中出现的一千多个人物全部是儒家心中正反派的具象化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	在日本，三国故事，座无虚席</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过《三国演义》的输出却并非一帆风顺。罗贯中的《三国志通俗演义》第一次被翻译成日语的时候叫做《通俗三国志》。译者为京都天龙寺僧人义彻、月堂兄弟，两人从1689年开始，费时三年共同译成后，署名“湖南文山”刻版刊行。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此时距离三国演义诞生已经过去了差不多三百年了。而且在译成之后很久依旧只是在僧人内部流传。这究竟是怎么回事呢？其实这与儒家思想在日本的地位有着直接的关系。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据日本第一部正史《日本书纪》记载，应神天皇15年（公元405年）百济博士王仁应邀到达日本，带去十卷《论语》和一卷《千字文》。这是中国儒学传入日本的最早记录。但一直到战国时代为止，儒家在日本并没有真正意义上的“官学”地位。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是这一切都随着一个人而改变了。公元1600年，关原之战中德川家康获胜并夺取全国霸权，随后于1603年迫使皇室封他为右大臣和征夷大将军，在江户（今天的东京）开设幕府，开始了将近三百年的德川幕府统治。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	德川家康既是一位精明的政治统帅，也是一名热衷于中国文化的大学者。他曾经邀请藤原惺窝讲授《贞观政要》和《汉书》，出版《诗经》、《易经》等中国经典，聘请林罗山为儒学顾问，学习和研究儒家政治文化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	儒家政治文化在德川幕府统治时期的得势一方面原因是统治者的实际需要。特别是在经历了一百多年的战乱之后，德川统治者急需巩固自己的政权，恢复社会政治秩序，重建道德基础，而原来曾经在这些方面发挥重要作用的佛教已经走向衰落，不堪为用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	之后《三国演义》开始了漫长的本土化过程。到了1836年，随着《绘本通俗三国志》的出版，日本迅速刮起了三国热。《通俗三国志》以罗贯中《演义》为基础，参考了陈寿的《三国志》，合并一百二十回成五十回的日语版《演义》通俗读本。还在意犹未尽处多做了补充，因而更近乎编译，而非忠实于原文的逐句翻译。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	19世纪末，在大阪庶民区仍有许多说书场常年讲说三国故事。故事太长，听者多半途而废，但只要书场门口贴出“孔明今起出场”告示，听者必又纷至，以致座无虚席，可见三国故事于当时日本之普及。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而与此相呼应的就是此时经过两百年的本土化，儒家已经在日本深深地扎下了根。以至于到明治维新前夕，哪怕是倒幕派的口号都是基于儒家思维“尊王攘夷”，可见《三国演义》在江户时代大兴并非是一个巧合。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	朝鲜越南也是三国死忠</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	和日本不同，三国进入朝鲜半岛的时间要早得多。目前已知至少在1569年6月之前，该书就已经进入朝鲜并且被士大夫阶级所熟知。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在传入之初，大部分的朝鲜士大夫其实和明中叶以前的士大夫一样是对《三国演义》持批判态度的。他们援引孔孟或程朱之著述，对《三国演义》等中国通俗小说，采取排斥的态度，批判《三国演义》的非正统性、非伦理性、非史实性和淫乱性。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过朝鲜作为最地道的儒教国家，《三国演义》对他们自然有着无与伦比的吸引力。这也让部分开明的士大夫放下了偏见。例如李朝著名文人金万重对《三国演义》等中国通俗小说所特有的、为正史所无法替代的价值，给予了充分肯定。“此其罗氏演义之权舆乎。今以陈寿史传、温公《通鉴》聚众讲说，人未必有出涕者。此通俗小说之所以作也。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	和日本一样，朝鲜完全接纳《三国演义》也花了不少时间。一个契机让朝鲜人对三国的痴迷达到了巅峰——壬辰战争。在战争中大部分的朝鲜国土被日军所占领，大量人口被掳掠。在明军帮助下复国的李氏朝鲜需要强化儒家来稳固自己的地位。在这个思潮下，三国故事在朝鲜备受欢迎，几乎人人都知道刘备、关羽、张飞。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	除了日韩之外，受到中国影响最深的就要数越南了。在历史上，越南与中国自古就关系密切。从秦汉到唐代，越南长期被中国王朝统治，越南历史学家称之为北属时期。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在后黎朝，越南的统治阶级更是独尊儒学，使儒学进入一个鼎盛时期。特别是黎圣宗，他把儒家思想渗透到社会的政治、经济、文化教育、民风民俗各个方面，使儒学成为越南封建社会后期占主导地位的统治思想。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	因此越南有了深厚的儒学基础。而且和日韩不同，越南曾经几度被中原王朝直接统治，而明朝就是其中一个。因此有着不少侨居的明朝遗民或者兵士，相比日韩而言，这个传播媒介无疑更加直接。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	目前所见越南汉文历史小说基本都采用了章回体结构形式，这种形式正是越南作家跟《三国演义》学的。在越南所有的历史小说中，《皇黎一统志》成就最高，影响最大，也被称为越南中世纪文学的杰出代表，其所受《三国演义》的影响早已为学界公认。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	受《三国演义》影响而作的《皇黎一统志》是越南著名的汉文文学作品 /&nbsp;http://goodreads.com</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	值得一提的是《三国演义》也是越南文字拉丁化后，第一部被翻译成新文字的外国小说，其影响力可见一斑。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	日本让三国走向世界</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果说中国用文字和插画组成小说让儒家世界认可三国，那么日本就是用游戏和动画让全世界知道三国。毕竟随着百余年的变迁，东亚三国的儒家传统都在减弱，尤其是朝鲜半岛，连汉字都抛弃了，一般人根本连原著小说都无法阅读。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1971年，横山光辉的漫画版《三国志》开始连载，一直到1986年，单行本共60本，发行数千万册。这部漫画后来又改编成动画，在日本国内外都颇受欢迎。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但在新时代的日本三国作品中，很难再看到小说中那种儒家思维具现化的人物。遍数二战后来自日本的三国作品，我们看到更多的是一个个符合现代人观念的英雄，不存在过去那种几乎完美的具现化的“神祇”或者“魔鬼”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以曹操为主角的漫画《苍天航路》便是其中典型，在里面没有那种绝对的善恶，有的只是为了各自的理想而行动的英雄们。在《钢铁三国志》里，诸葛亮化身反派但是最终目的是为了拯救世界。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此时的三国作品，比《三国演义》还要演义，很多只是借鉴了三国演义的人设，但是其核心完全是现代动画“拯救世界”的套路。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	游戏更是将三国文化发扬开来，让年轻人对之着迷。1985年，影响了好几代中国人的《三国志》游戏发行，截至2016年，已经发行了13代产品，堪称模拟游戏史上的佳话。此后，三国游戏一发不可收拾。这部经久不衰的游戏是无数中国年轻人的童年记忆。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而《孔明传》之类的掌机游戏更是陪伴了包括中国80、90后在内全世界很多孩子的童年。原著中的火烧新野无论多么精彩，相比起自己在手掌上手动制造“火攻”而言，记忆的深刻度都会弱很多。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而《三国无双》中武将的打斗，也将三国人物更加淋漓尽致地表现出来。而且已经去除了正邪对立和善恶分明的政治分野，完全中立化了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这和《苍天航路》一样摒弃了传统三国那种红白脸的善恶模式，几乎所有人的目标都是为了这个世界更好，这无疑比非黑即白更符合当代人的价值观。不少欧美人，在成为了“日式三国”的发烧友之后去读原著，读出了和东亚人完全不同的感受。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	日本在动画和漫画界的地位也为三国文化推波助澜。日本的漫画仅仅在2003年就在美国取得了48.4亿美元的销售额。2007年，德国售出的70%的漫画来自日本。类似《龙珠》之类的王道漫画已经成为了不少欧美人的童年回忆。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	日本通过精美的人设和现代化的解读，使三国散发出不同以往的光芒。毫不夸张地说，虽然三国文化诞生于中国，但真正将其发扬光大的，还是日本。</p>\r\n', '', 'admin', '', '1500621102', '1500621102', 'true', '', '《三国演义》一直是中国人民津津乐道的名著。曹操、刘备、诸葛亮、司马懿，这些一千多年前的历史人物，至今仍是家喻户晓。这本书不仅是中国人的骄傲，也是东亚范围内最受欢迎的中国古', '市,场上,什么,牌,的,地漏,好呀,地漏,的,材质,', '177', '1501126967', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('40', '18', '智能音箱，正走在智能手表的老路上', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	去年，我和同事在体验HTC Vive（虚拟现实）的时候，边试边骂街，心里非常激动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当时我们想给科技产品拟一个“卧槽指数”，意思是在试用哪个科技产品的时候，骂街次数最多的产品是有一定代表性的，当时HTC Vive的卧槽指数非常高，同事甚至在不少小Demo的时候都全程骂到尾——“卧槽，还有这种操作”的卧槽。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今年，我看一些媒体评测任天堂的新掌机Switch和《塞尔达传说 荒野之息》，也提出了一个新鲜的词汇，可以理解为“时间新鲜度”，意思是当你在体验一款产品，越体验越发现打开了新大陆，并且深陷其中……那么它的时间新鲜度也就越高，即你长时间使用之后越发现离不开它了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我觉得只要“卧槽指数”够高，“时间新鲜度”也够高，一个数码产品可能就成了一大半了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	说实话，今天我在写各种智能音箱技术、产品、体验的稿子的时候，其实很像是去年我写VR（虚拟现实）时的感受——“卧槽，卧槽，卧槽”、“买买买”……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	可以肯定地是，几乎所有的中国互联网巨头和人工智能公司都试图在智能音箱这个品类上一展身手，而这一“看得见”、“摸得着”、“听得到”的硬件产品，也确实远比“PPT人工智能”来的靠谱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但智能音箱，真的是人工智能技术到位了，就能火起来的产品么？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	音箱的智能和“时间新鲜度”，受制于可以绑定多少智能电器……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	巨头的闯入迅速给音箱市场升温。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<blockquote>\r\n	<p>\r\n		2017年1月：百度联合小鱼在家发布搭载了DuerOS的视频对讲机器人；</p>\r\n	<p>\r\n		2017年6月：腾讯联合数字家圆发布搭载了小微的“亲见H2”；</p>\r\n	<p>\r\n		2017年7月：阿里推出搭载了AliGenie人机交互系统的“天猫精灵X1”。</p>\r\n</blockquote>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	巨头公司和音箱制造厂商纷纷卡位音箱，更多的是体现争夺智能家居入口、以及背后大数据的决心。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但即使是在两年就开始布局的叮咚音箱、三年前就启动创业的Rokid，如今在智能音箱的C端赛道上都做得不够好，原因并不在于音箱本身。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一方面是中国消费者对于传统音箱的历史遗留问题；另一方面，中国消费者的家庭环境与智能音箱形成了强烈的反差，场景元素并不充分，自然不能形成刚需。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	与音箱的音质、识别准确度等自身素质无关，智能音箱的“时间新鲜度”取决于你家里有多少可连接的智能电器。只有当家庭中拥有足够多的智能设备，智能音箱“语音控制”的核心功能才能起到作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	买不买智能音箱这个问题，从“音箱做的好不好”变成了“消费者已有多少智能设备”，“这些智能设备能不能连接”，以及“能不能完成更好的体验”的问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这与大多数智能音箱生产厂商极力炫耀和想要展示的人工智能技术其实没有任何关系，反而是一个单纯的商业问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	大部分的普通人家里，没有这么多可扩展的边际产品。而即便是有足够多智能硬件的“极客之家”也面临一个“站队”的问题：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我买了天猫精灵，连不上京东智能的空调；我买了叮咚音箱，连不上阿里智能的加湿器；我买了亲见H2，连不上小米的电灯。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	过去3年中智能家居领域军阀混战的局面，尚且可以用“在一个手机上装一堆控制App”来解决。但厂商总不可能让用户在家里买一堆智能音箱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而反过来说，想用一个单价千元左右的智能音箱来约束用户“只能买某个平台合作的家电”，也是非常不现实的。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	因此，中国智能音箱的“技能”永远只能停留在听歌、听相声、听天气预报这种不痛不痒没有利益纠葛的领域上。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	西方的火，不一定是东方的火</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2014年11月，智能音箱的“祖师爷”亚马逊的Echo正式发布。你能看到如今这么多的智能音箱、BAT的厮杀，基本上都是源于这款产品。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2014年的Echo更多的还是专注在音箱上，让人很难发现它是一个家庭场景的入口，更别提有多少“卧槽指数”了；2017年的Echo摇身一边成为了一个语音为基础的平台，根据报道，它开放出来的技能已经超过10000种。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	或许，终究是看穿了Jeff Bezos的诡计，在Echo发布两年后，搭载Google Assistant的Google Home正式面市。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	至今不到三年时间，Echo的数量接近1000万台。根据市场咨询公司eMarketer发布的报告，美国智能音箱用户约70.6%是亚马逊用户，Google只占了23.8%。正是亚马逊上演的这场音箱的奇袭，点燃了正寻求新增长点的中国消费电子品市场。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但很大意义上，中国音箱市场的火热并不仅仅是因为Echo的出现。2017年苹果WWDC上，苹果正式推出了音箱产品HomePod，这款产品主打音质，并未过多的强调人工智能以及语音助手。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“苹果这样定义产品是非常聪明的，因为对话音箱对于普通消费者来说，根本没有任何感觉。但如果它是苹果的一个音箱产品，而且主打传统的&lsquo;音质&rsquo;概念，可能才能引起更多消费者的注意。”一位音箱产业的人士对PingWest品玩说。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其实他讲得是一个自然逻辑的问题——从本来就有“买音箱”的习惯，到“有一台音箱”，最后习惯用语音和音箱对话，这是亚马逊以及海外市场做音箱的逻辑。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但这和目前在中国市场强调人工智能的产品不同——在中国，人们很少有隔几年买一台音箱的习惯，更是很少有时间去关注智能音箱；况且人工智能是一个晦涩的技术，中文语音的技术本身还存在着一些问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	换言之，西方世界对于音箱没有“卧槽”般的惊讶，它是一个自然形成的过程——智能音箱源自于对传统音箱这一品类的自然延伸。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而中国市场，用人工智能为音箱包装一个概念，强行给不需要音箱的用户塞一个音箱，就完全不是这么一回事儿了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	海外市场研究公司Counterpoint Research就出过一份报告——今年将会有200万台智能音箱进入中国市场，但比起美国的1400万台还是较逊色。我们也用极光大数据跑了一份国内市场主流智能音箱数据报告，来体现目前智能音箱用户占有率的问题：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	主要跑的是目前已售智能音箱的app的装机量，当然，产品排名和app发布时间有很大关系</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于所有智能音箱都需要在初始化时与手机App相连，我们可以通过手机App的安装量侧面观察出智能音箱的出货水平。从上图的数据可以看出，国内智能音箱产品的排名与音箱发布的时间有直接关系，产品排名和app发布时间有很大关系，但两年前发布并持续推出新品的叮咚音箱（App名为“智能音箱”）的装机量也仅9万左右。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	尽管这一数字并不完全代表销量，但从数量级来模糊判断智能音箱在过去两年里整体的普及度甚至没有智能手表高。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	智能音箱在消费级市场，目前还没有起量。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	但，究竟要熬要多久？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“巨头闯入实际上好事，让更多的人知道还有这样的产品存在”、“目前能够实现的功能还有限，我们会继续打磨边界”、“功能会随着产品升级越来越完善”、“要有点耐心等待这个市场的爆发……”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这几乎是采访每家音箱公司在“如何看待中国音箱市场不温不火”的问题时的答复。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	音箱企业主和市场研究机构都认为，中国市场要等到智能音箱市场爆发，可能还是要到明后年再看。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	PingWest品玩也统计到，尽管BAT平台全部都在布局人工智能以及智能音箱，但目前为止，能到达消费者手中的产品在10款左右。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	要知道，消费者从来不会为技术付费。这一年，AI技术的增长无非最终是要落到消费硬件上，有更多的硬件用来获得更多的消费者，消费者为产品付费，产品公司为技术付费，最后形成一个良性的环。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在市场还没起量、消费者对于智能音箱还没有特殊概念、巨头介入市场教育消费者的前期，“熬下去”可能是每家音箱企业、制造商能给出的唯一答案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然“熬下去”无非是需要有钱撑下去——或是继续融资抬高估值，或是开源节流，用以继续打磨产品的体验，继续拓展音箱在家庭场景的应用，直到音箱市场的爆发，消费者认可。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但高估值、低销量、不能变现这些问题是否能承载不知道到何时才能火的音箱市场内大量涌入的资本、公司、产品以及创业者？不可确定的因素实在太多，熬到最后的结果不得而知。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	那些年，最后熬成泡沫的产品……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	说起“熬下去”，以及每每联系到智能家居，就让我想到那些沦为技术泡沫的产品。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	两三年前，智能硬件火了一波，但又退潮。本质上，传统硬件+WiFi被灌上了一个Smart的名字，其实到最后发现，根本上就是一个伪需求——人们不愿意用一个手机去控制智能家居，而且对于大众来说，智能硬件接受度不高，那些公司沦为一个大泡沫。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	去年，VR成为泡沫的原因，是技术存在不足，产品应用范围太窄，体验没有足够好；倒是产品价格高企，企业估值太高，进入的资本又太多，全都闯进入口，却没有出口，也形成了一个巨大的泡沫；</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今年，AI人才又有了成为泡沫的倾向——人才太贵，企业高估值，但能实现的具体需求又不成正比，不能体现平民化，还不能形成广泛的价值，C端公司可能又要形成一个泡沫；</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	我想划个重点了——那些符合泡沫的元素：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<blockquote>\r\n	<p>\r\n		短时间大量冒出来——在音箱这个问题上，因为有了BAT技术平台的开放，涌现出一批技术创业，但整体核心技术仍然受制于人；出现大量的套壳产品。BAT三家全部竞争，最后必有炮灰，倒下的就是那些套技术壳的创业者。</p>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p>\r\n		投入和产出不成正比——做一个好的产品，本质上是一个技术输出的过程；做音箱的公司，本质上还是人工智能公司。技术要落在产品上，让更多的消费者感受到价值。如果只是有高高在上的技术，最后没有带来更多的消费者，投入的技术精力就会沦为泡沫。</p>\r\n</blockquote>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	本质上来看，对话音箱其实是硬件+语音（AI技术）。从目前来看，AI对于语音交互本身的提升仍然有限，C端用户没有大量采用，目前还没有形成广泛的场景应用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从技术成熟落地到产品应用，产品如果没有被大规模消费者使用，没有持续的“时间新鲜度”，或许都要成为昙花一现的风口……</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	其实，我有一台智能音箱</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	作为这个行业的从业人士，我家真的有一台智能音箱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	几个月前，我风风火火地找到一家智能音箱公司的创始人，在上市前几天就内购了一台。关于语音技术提升效率的问题——现在我基本上养成了用这个产品听歌、播新闻的习惯，每天早上我都会说“xxx，播放新闻！”，“xxx，播放抒情的音乐”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	到目前为止，它还是我认为产品做得最好的一家公司——无论产品的外形还是整体的语音技术体验都能给出一个极高的“卧槽指数”，我确实养成了一些语音唤醒的习惯；但仅限于此，组建智能家居的部分就没那么顺畅了，它需要我更换掉所有家里的传统电器，还是要有指向性的。久而久之，它止步于此，再也没有“新鲜度”了，更像是一台“传统音箱”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这让我想到当年买回的第一块Apple Watch，我调整好所有的设置、推送，但到最后，它还是沦为了每天一充的“传统手表”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	智能音箱的下场可能就会和躺着吃灰的智能手表一样，用之无益弃之可惜。</p>\r\n', '', 'admin', '', '1500621122', '1500621122', 'true', '', '去年，我和同事在体验HTC Vive（虚拟现实）的时候，边试边骂街，心里非常激动。\r\n当时我们想给科技产品拟一个“卧槽指数”，意思是在试用哪个科技产品的时候，骂街次数最多的产品是有一', '厨房,地漏,漏水,怎么办,很多,业主,不装,地漏,', '145', '1501126982', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('41', '18', '“去乐视化”之后，新易到的机会在哪儿？', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	随着孙宏斌强势入主，贾跃亭出走美国，老乐视旗下资产正在重构，有粘性用户的易到终获韬蕴资本赎身，但重新上路的易到机会在哪里？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	至少这个解谜游戏的谜面已然亮出。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一、团队震荡的终结</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当初乐视入主易到，虽然一再宣称公司的治理结构不变，但周航被彭钢架空的传言仍然不径而走。从周航发出公开信，转投顺为资本，创始团队集体出走，再到今天乐视系4位高管联袂出局，以及彭钢6个月内可能卸任的传说。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	那个被各种外部信息困扰，公司内部更换下午茶都被认为别有深意的易到，如今的人事动荡不是刚刚开始，而是已经趋近结束了。韬蕴旗下的易到用车虽然还没有新战略发声，倒是深通“先安己心，才能安人”的道理了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	二、资金与欠款纠纷的化解</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易到之所以深陷风波源于哪两点？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	首先是乐视入主之后，周航对市场格局产生乐观估计，为快速启动市场，过于激进的开始了力度空前的充100返100的活动；</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其次是乐视自身的危机殃及池鱼，给易到运营带来兑现压力，进而导致易到没法按照预定的节奏推进战略构想。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但换个角度来看，易到也不是全无所获，它用充返建立起来的4000万用户和600万车主仍是有效壁垒，特别是6月30日在韬蕴支持下恢复司机提现，也让市场重拾信心。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	三、“去乐视化”基本完成</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当初乐视控股易到的商业逻辑很多人看不懂，但实质上无非是善用外力、以势造势的惯常手法而已。彼时的贾跃亭正痴迷于SEE计划，在美国为法拉第站台，加码易到大抵是给内容生态加码传播手段，对抗陈彤加盟后咄咄逼人的小米，此外就是为如火如荼的造车运动注入高频场景。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如今的易到“去乐视化”，与其说是与老金主乐视划清界限，倒不如说是与那种贪大求全、华而不实的运营风格的决裂。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	谜面虽已清晰，但易到能否顺利解谜，完成通关，还取决于几点：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、存量用户的再激活</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易到的充返是2015年11月展开，2016年7月达到最高潮，按当时公布的数据，有653万用户进行了充值，有效拉动了营收和用户规模的增长。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但也是从那时开始，几乎所有第三方数据都显示易到APP的用户活跃度开始下滑，这被周航描述为“钱到用户到，钱跑用户跑”，但它至少解决了一个重要问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	即原来着重用户体验、自我封闭在一个相对小众场景中的易到，却能在滴滴和Uber补贴大战的冬歇期规模化地完成基础用户的圈定，虽然代价高昂。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易到的复苏不外两条路径：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	通过补贴从友商手中剥夺用户。但今天的网约车已是政策管控下的成熟市场，草莽竞争手段难以奏效，加之用户叫不到车、司机不愿接单的情况已经持续了一段时间，对易到来说，再用补贴争夺用户时机未到，成本也太高了，而靠服务建立口碑又有时间成本。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从存量用户中寻找变现的机会。从表面上看，继续为这部分已经进入返赠消耗阶段的用户服务，似乎不太符合易到的利益，但后者带来的订单对易到在供需两端的双向企稳有润滑作用，也意味着用户活跃度下滑的趋势得到遏制，重归良性循环。至于返赠消耗影响营收的问题，更多的是考研运营团队和收益管理部门在产品设计和场景运营上的能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2、韬蕴资本会用多大力度支持易到？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	韬蕴资本投资了很多项目，但大体集中在金融、新能源汽车、消费品、大文娱等领域，说明投资方向关注的是市场广阔并有线下场景的领域。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	韬蕴资本的掌舵人温晓东受访时曾说，“操不了那么多心，先管好易到再说”，同时又表示易到需要持续投入大约二三十亿，再联想到韬蕴入主前对易到的管理层、用户和司机有过一系列的深度访谈，可看出韬蕴注重的是易到的潜力以及异业协同的能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	3、新易到的对手究竟是谁？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	周航时期的易到有三类不同性质的友商。一类是同为C2C模式的滴滴，之前也包括Uber中国；另一类则是神州专车和首汽约车的B2C模式；还有一类是背靠吉利的曹操专车，上海大众集团的大众出行等等。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	已经拿到8张网约车牌照的易到，其真正对手不会是神州专车和首汽专车，也不会是背靠大树好乘凉，只是为车企推广新能源车的那种试验品。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	真正目标还是滴滴，由于网约车严格的准入门槛，滴滴不得不接受与巡游出租车的差异化竞争。市场容量已经萎缩，正从补贴冲量转向精细化运营，表现出来就是近期有一系列动作在提高服务体验，而这并不是滴滴所熟悉的市场，反而更有经验。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易到之前诸如配置英文司机以及允许用户挑选司机的设置，已经显示出深厚的服务文化而不是GMV文化的基因。在草莽竞争时代，易到曾经因此而掉队，用周航的话说，就是“不够狠，不够坏”，但在一个规范化的市场中，这反而是核心竞争力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	4、海外化是噱头还是战略？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2014年易到就开通了北美服务，主打用中文叫车的海外华人市场，今年3月又宣布加入Splyt全球出行联盟，后者推行在全球4大洲280多个城市的一键跨平台叫车，易到也是服务提供方之一。但Splyt既不是中国人熟悉的比价平台，也不像1个APP就能共享所有单车的“小发明”。对所有参与企业来说，它就是一个打通了API接口以及帐户体系的接单平台。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易到的海外化当然不应该仅仅指望这种没有门槛的导流平台，更大可能是在韬蕴投资的特定地区深度楔入，或是寻求跨业合作的机会。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	5、衍生业务是否继续推动？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	曾经的易到有许多野心勃勃的计划，不仅做打车，做专车都在滴滴之前，还有比乐视还早的易奇互联网造车计划以及海易出行的汽车金融计划。易到的理念也从“随时随地的私人专车”改为“汽车共享生态”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	韬蕴入主之后这些已经沉寂了许久的计划或许会重新启动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	那么，易到回归之后的市场格局如何？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	滴滴合并Uber加上网约车新政出台，让市场出奇的平静，但暗流仍然不少，神州专车和首汽约车都搭建了C2C平台，挖角滴滴，而注资ofo的滴滴则致力于补全产品线。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从明争转向暗战的市场给了易到复苏的机会，但后者仍需关注两点：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	1、迅速恢复平台供需两端的活力，提升用户粘性，进入良性循环；</p>\r\n<p>\r\n	2、制定有效的产品策略，平衡存量用户集中消费返赠的压力；</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	去年底，参加完第三届世界互联网大会的程维表示，“滴滴在中国主场的比赛已结束”，他还担心滴滴“失去了竞争，失去了活力，就失去了未来”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	对于程维的乐观和自矜，在韬蕴资本支持下重新站起并再度攻城掠地的新易到，大概有不同意见了。</p>\r\n', '', 'admin', '', '1500621148', '1500621148', 'true', '', '随着孙宏斌强势入主，贾跃亭出走美国，老乐视旗下资产正在重构，有粘性用户的易到终获韬蕴资本赎身，但重新上路的易到机会在哪里？至少这个解谜游戏的谜面已然亮出。', '地漏,不,防臭,怎么办,不,防臭,要素,水封,高度,', '82', '1501126998', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('42', '18', '为什么大公司的高管们都爱练咏春？', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	几个月以前，我有幸和阿里巴巴、百度、乐视以及宅急送的前任及现任人力资源高管一起去了趟福州，向郑祖杰先生请教咏春拳的基本要领。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在学习了两天外功拳法，研习了拳法所蕴含的哲学理念后，我们发现，咏春拳的武学思想可以被纳入到我们现有的课程培训体系中。我们相信，这些思想将有力的帮助商业领袖和他的团队成员更好的驾驭个人生活，实现职业理想，提高自己在面对纷繁复杂的商业环境时做必需的适应能力。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最让我着迷的是咏春拳的核心拳理——中心线理论。对咏春拳的习练者来说，中心线，即为人体头顶百会至尾闾和地面的中垂线。咏春拳理论相信人体全身的核心能量都汇聚于此，因此这条线即是一切招式的焦点。无论进攻还是防守，习练者的每个动作都要围绕这条中线展开。技击的原则为：在守护我中心线的同时，我的拳力要集中打击对方的中心线部位。这样一来，我的每次进攻可以制造最大的攻击效果，而我的每次防守也能卸下对方猛烈的攻势。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	也许是职业使然，刚刚接触中线理论，我就发现它与商界精英所追求的领袖气质、企业文化等议题关系密切。咏春拳所着力强调的中心线概念与企业的核心理念，比如强大的价值观内驱力、浓烈的身份认同感，以及明确的企业使命感等等都有着异曲同工之妙。与咏春拳类似，在商界也流传着“核心内驱力”的传说。无论是卓越的企业家、成功的商业模式亦或是享誉全球的企业品牌，围绕“中心线”建构理想是所有伟大实践者通往伟大的不二秘方。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	中线理论与黄金同心圆法则</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	民族学学者、知名演说家西蒙·西内克（Simon Sinek）在他那篇广受欢迎的TED演讲和他的代表作《从“为什么”开始》一书中都谈到了一个简洁有力的概念——“黄金同心圆”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	西内克发现，“世界上所有伟大的、鼓舞人心的个人和组织的思考方式、行为方式以及交流方式都具有惊人的相似性。”这种相似性可以被形象化的比喻成由三个不同直径的同心圆所嵌套而成的图形，这便是“黄金同心圆”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	西内克给这三个同心圆各自赋予了象征意义。最小的，也是距离圆心最近的同心圆他称之为“为什么（why）”，即“目的”；中间一层同心圆是“怎么样（how）”，即方式；而最外层的则为“是什么（what）”，即“成果”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	黄金同心圆理论认为，“目的”、“方式”和“成果”是层级递推的关系。这其中，“目的”居于核心地位，“方式”是“目的”的外延，“目的”和“方式”共同衍生出了 “成果”。在这一理论模型下，成功的商业领袖和商业模式都是核心能量由内向外自然推展出的必然产物，这与咏春拳武术家的技击原理可谓异曲同工。和拳理相似，只有当个人和企业把“为什么”，即使命感和价值观，置于思维理念和具体行动的核心时，他们才能做出更正确的决策，建立可靠的个人与商业信誉，最终实现强大而持久的品牌效应。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	西内克以斯蒂夫·乔布斯的苹果公司为例，详细阐释了他的理论。他发现，尽管乔布斯也有不少缺点，但他具备异乎寻常的专注度和强烈的使命感，也正因为此，苹果公司才取得了今日的成就。乔布斯打破常规、独立思考，他相信科技绝不仅仅是工具，更是人类思想的延展，是具象化的创造力。从他创立苹果之日起到他因病去职，苹果公司的职员、客户、股东无不被其魅力所折服。原因很简单：他们相信乔布斯所相信的理念，他们认同乔布斯所倡导的价值。换句话说，他们之所以信赖苹果和乔布斯，是因为他们清楚的知道这家公司的“中心线”是什么。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而对个人来说，这种对价值观的恪守和对使命感的遵循就是吉米·罗霍（Jim Loehr）所讲的“精神能量”。这位作家和企业管理培训师在他的作品，《全情投入的力量》一书中指出，健康、成功的人生离不开精神能量的浇灌。然而遗憾的是，人们往往会为日常生活中不断出现的一个个“要紧事”而疲于奔命，却忽略了精神能量之于个体生命而言重要而基础性的作用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“一个简单却让人尴尬的现实是我们都在忙碌的寻找人生的意义，（却忘记了，人生的意义不在诸事而在诸己）”，罗霍如是说。这与许多咏春拳习练者的感受很像，他们常在抱怨，说自己没办法把注意力集中到中心线上，因为他们一直忙于格斗。但事实上，当你格斗时放弃了中心线，你所遭遇的只能是失败。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	惨痛商业悲剧的核心原因：“中心线”缺失</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但在我北京的工作圈和社交圈中，类似上文所述的本末倒置的情形十分常见。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很多企业家火急火燎的四处奔波，不断切换他们的商业主张，什么东西热门他们就去追什么；他们不关心如何创造真正的价值，他们只关心哪些东西能吸引到投资人。很多家长和孩子只关心如何通过考试，却不知道，唯有热情与好奇心才能真正让孩子提高技能、获得知识。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很多管理者喜欢在人前摆出一副忙碌的样子，然后就不停的邀功请赏。但其实他们本该做的是提升自我，为团队付出并且真正去关心自家企业的生产状况。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	历史上，因背离自己的“中心线”而最终酿成巨大商业悲剧的案例并不鲜见。曾经的能源巨头，美国安然公司就是其中之一。安然不关心自己作为能源企业的核心价值，他们盲目转型，向不熟悉的领域疯狂扩张；而当转型出现问题，亏损愈发严重时，安然选择的是用做假账来掩盖问题。他们使用按市场计价的做账方法，将预期利润计入公司财务报表，导致账面数字和实际现金收入之间的差距越来越大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	一方面公司股价扶摇直上，但一方面公司内部却病入膏肓；最终，当泡沫破裂，公司只能破产。2001年的这桩破产案成为了史上11大破产案之一，公司高管锒铛入狱，还连带当时五大会计事务所之一的安达信四分五裂。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	同样的，企业家自己放弃“中心线”而给企业带来麻烦的也不少，比如特拉维斯·卡拉尼克。作为Uber的创始人，卡拉尼克的傲慢无礼、狂妄自大及缺乏诚信的行为，给公司带来了一连串公关危机。更糟的是，卡拉尼克的个人行事原则还毒害了Uber自身的企业文化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	现在的Uber让自家的司机怨声载道，而Uber自己又在与同行的竞争中落于下风。难怪上个月公司会做出罢免卡拉尼克CEO职务的决定。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而在中国，我认为背离自己“中心线”的典型企业莫过于乐视了。盲目的扩张政策使得公司忘记了自己当年崛起时的第一准则：向客户输出价值（在此有必要做下说明，我是乐视的前员工）。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	&nbsp;“谦逊中心线”：通往尊严与成就的基石</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从积极的一面看，那些依靠清晰的“中心线”而取得成就的个人和企业其实也并没有那么难找。西蒙·西内克提到了苹果公司，不过我反而对苹果、谷歌等那些时刻标榜着要“改变世界”的企业兴趣不大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这倒不是因为我缺乏理想主义，仅仅是因为我比较现实。而现实就是绝大部分企业并没打算“改变世界”，他们也并没有大张旗鼓的在鼓吹某个错误的“中心线”，他们只是在做自己的事情而已。因此，对于他们而言，能起到示范作用的榜样也并不是谷歌、苹果那样的公司，而是能始终保持谦虚的态度和专注的精神的个人和企业。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在2015到2016年期间，我曾在DHL-中国外运集团开班授课。我被那里所崇尚的严谨、专注的企业气质所吸引。很快，我就发现了他们的成功秘诀：他们以“雇主之选”作为企业价值，他们秉持公平公正的态度，依靠世界级的物流供应体系为客户提供稳定而高质量的服务，使后者能放心的将他们视为“可靠之选”，也使股东们能满意的将他们视为 “投资之选”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	他们不像如今的许多科技企业那样有着炫目的身姿，他们只是近乎执拗的坚守自己的企业价值并始终如一的坚持做自己最擅长的事。而现在，依靠多年的耕耘，他们已经取得了丰硕的成果：他们是中国境内最大的国际快递公司。去年，他们刚刚庆祝了自己的30周岁生日，这对于在中国经营的中外合资企业来说绝对称得上是傲人的成就。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而从人的角度看，“谦虚而卓越”的最好代言人莫过于沃伦·巴菲特。尽管身价已超过600亿美元，但大多数时候，巴菲特并不在纽约塔，而是在奥马哈市那幢普通的办公楼中工作。他现在的居所仍然是49年前为家人购置的那个舒适而平凡的五居室住宅。这幢房子现在的估值大约是60万美元，只相当于巴菲特身价的0.001%。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	他不用投机炒作、财务花招亦或是公关手段来赚钱；他所累积的财富来自于投资企业所收获的回报。他会用严谨的计算方式去衡量哪些企业值得买入，然后再用合理的估价进行持续不断的投资。而一旦完成投资，他绝不过问公司的运营，他所做的仅仅是看着公司在正确的轨道上走得越来越好，然后自己收获公司升值所带来的附加财富。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	尽管他不像硅谷的大人物们那样，时刻把“让世界更美好”之类的话挂在嘴边，但多年来，他一直身体力行的将自己的财富投入慈善事业。尽管许多人质疑他“低调”的处事方式，但巴菲特并不以为意。他不在意外界的种种评判，因为他内心自有一杆秤、一条“中心线”，一张“内心世界的积分卡”。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	“评判一个人的所作所为是否正确其实很简单，就看他自己获得的&lsquo;分数&rsquo;是记录在&lsquo;内心世界的积分卡&rsquo;上还是&lsquo;外部世界的积分卡&rsquo;上，”这是巴菲特的名言，“如果你的内心世界因此而得到了平静和满足，那么你做的一定是正确的事。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	很多人艳羡巴菲特的财富，垂涎于苹果公司产品所推出的高规格产品，却不知道他们的成功来自于深沉的专注度和坚定的使命感。换句话说，商界精英的成就和商业模式的成功其实来自于践行者内心深处对“中心线”的坚守。</p>\r\n', '', 'admin', '', '1500621175', '1500621175', 'true', '', '几个月以前，我有幸和阿里巴巴、百度、乐视以及宅急送的前任及现任人力资源高管一起去了趟福州，向郑祖杰先生请教咏春拳的基本要领。在学习了两天外功拳法，研习了拳法所蕴含的哲学理', '怎么样,才能,选,到,好,地漏,地漏,是,我们,必,', '91', '1501127019', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('43', '18', '为什么互联网产品越来越难做了？', '', '/storage/images/20211201/1-1FH5114015352.jpg', '', '<p>\r\n	最近，Uber用户增长负责人Andrew Chen在个人博客上发表文章称，如今，移动互联网产品已经越来越难实现用户增长，原因就在于，我们当下所处的技术增长周期即将结束。那么，这对创业公司来说，又有怎样的启示？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	本文要探讨的趋势包括：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<ul>\r\n	<li>\r\n		<p>\r\n			平台固化</p>\r\n	</li>\r\n	<li>\r\n		<p>\r\n			付费获客渠道接近饱和</p>\r\n	</li>\r\n	<li>\r\n		<p>\r\n			广告遭到无视</p>\r\n	</li>\r\n	<li>\r\n		<p>\r\n			高级工具降低运营门槛</p>\r\n	</li>\r\n	<li>\r\n		<p>\r\n			竞争对手变得更加敏捷</p>\r\n	</li>\r\n	<li>\r\n		<p>\r\n			从对抗“无聊时段”到对抗谷歌/Facebook</p>\r\n	</li>\r\n</ul>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	好像是突然之间，创业者和投资者纷纷开始进军一些新的领域——基因学、垂直起降的飞行汽车、加密货币、AI、物联网等，试图寻找新的机会。要理解这种现象，认识到上文所说的趋势就很有必要。毕竟，如果你在现有的市场上无法获得增长，那么你就需要迅速进军新的市场，正如格拉德说的那样：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<blockquote>\r\n	<p>\r\n		在一个周期的尾部，技术市场往往会出现这样的特点：获得融资的初创公司的类型快速出现了多样化。例如，在90年代后期互联网主流市场（谷歌、雅虎、eBay、PayPal）大爆发之后，2000-2001年突然出现了多样化趋势，人们开始向P2P和移动设备领域投资，然后在2002年、2003年，人们开始关注清洁技术、纳米技术等等。从创业投资回报的角度来说，这些行业最终是失败了。</p>\r\n</blockquote>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	纳米技术、清洁技术属于上一个周期，现在我们要谈论下一个周期。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	一、平台固化</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	与网页相比，谷歌/苹果对应用程序的双重垄断显得更加集中、更为封闭，也更加缺少丰富性（从增长的角度来看），这意味着移动领域更加难以进入。 应用商店的功能好像是一个排行榜，提供一些必装应用，推荐一些精选应用，而这一切都在推动移动生态系统的“赢家通吃”特征。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这也难怪这些年来应用商店里的排行榜已经出现僵化， Facebook和谷歌现在已经控制了移动生态系统中Top 10中的多个席位：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果你想推出一款新应用，你该如何应对这种情况？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而伴随着增长机会的减少，付费获客的渠道也变得饱和起来。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	二、获客渠道接近饱和</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	如果你能找到具有较高投资回报率的待开发受众群体，那么付费获客仍然是一个有用的方法。但是，这种做法只有在成本不增加，同一个广告资源没有太多竞争的时候才行得通。可惜的是，现在这种好事已经不存在了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	让我们来看看Facebook过去几年中， 日活跃用户（DAU）的平均营收是怎样增加的：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当然，驱动这种增长的因素有很多，比如相关性、针对性等等，但其中一个关键原因是：在Facebook上打广告的竞争越来越激烈了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在2017年，Facebook平台上的广告主超过500万，而2016年第三季度是400万，2015年是200万。在2017年第一季度的财报电话会议中，Facebook告诉投资者，尽管与2016年相比，2017年第一季度的收入出现了大幅增长，但它预计广告收入将接近饱和点。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	目前，Facebook的用户为20亿，同比增长率为17%。它是否能提供更多广告投放机会，取决于用户群体是否能够继续增加，或用户是否能在Facebook上花费更多时间。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	三、广告遭到无视</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	互联网用户正在变得越来越聪明。如今，大多数邀请系统的价值和效果都远不如10年前（Dropbox的邀请系统刚刚出现时效果真是神奇），用户不仅会无视广告，而且对邀请机制和病毒式传播也往往熟视无睹。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在“互联网女皇”玛丽·米克尔（Mary Meeker）最新的互联网趋势报告中，她表示，一些国家有1/3的人在使用广告屏蔽功能，而且不久之后，广告就会无法触及多达6亿的月活跃用户（MAU）：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	来源：2017互联网女皇报告</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这是2017年版的“劣质点击定律”。我曾在几年前提出了“劣质点击定律”，当时，邮件营销的点击率就已经出现下降：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而传统横幅广告的点击率也越来越接近于零：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些趋势令人不安，这说明某些渠道的用户参与度越来越低，而我们还没有发现令人眼前一亮的新渠道来替代它们。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	四、高级工具降低运营门槛</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	广告越来越多的同时，Mixpanel、Leanplum、Optimizely等工具的使用也变得越来越普遍，这就缩小了各家公司在数据驱动方面的差距。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	10年前，我们对注册用户总数这个指标很看重，对MAU、DAU或其他更精细的指标尚未重视起来。 Mixpanel的其中一个关键功能是，它可以让你看到基于群组的留存率。工程师、数据科学家对它喜爱有加，它可以创建下面这样的简单图表：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在B2B领域，也有同样的现象出现。在一些工具（Mixmax、Outreach，insidesales.com等）的帮助下，过去很费劲的任务也变得容易起来。但如此一来，竞争也变得更加激烈。繁琐的任务变得自动化了、简单了，难免就会有更多人进入这个领域。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	结果，所有参与者都变得更高效了。大家都对自己产品的获客和留存率有了更深的了解。大家都学会了通过看数据来提高用户终身价值，最后也势必会在广告上投入更多的钱。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	五、对手变得更加敏捷</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	过去，创业公司可以从竞争对手的“大、笨、慢”中获益。现在不一样了，所有人都变得更聪明、更迅速，竞争对手也是如此。以前，可能你的竞争对手要等到几年后才会做出反应，而现在，Facebook、Hubspots和Salesforce随时都可以复制你的新点子。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最著名的例子就是，Facebook快速把Snapchat的功能复制到自己的Messenger、Instagram、Whatsapp和其他核心产品中：</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而且，这种情况并不仅仅发生在消费级产品中：Dropbox与Google Drive、Slack与Microsoft Teams、YesWare与Hubspot Sales……这样的例子还有很多。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	六、从对抗“无聊时段”，到对抗谷歌 / Facebook</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	应用商店刚刚推出的时候，一款应用的竞争对手其实是人们的“无聊时段”。移动应用开发人员希望你能够在无聊的时间段（排队等候，上下班）使用他们的应用。但是如今，你的应用要获得一个新的用户，就意味着让他放弃自己当前最喜欢的应用。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	随着这个周期接近结束，公司之间的竞争也越来越像是一场“零和游戏”。</p>\r\n', '', 'admin', '', '1500621287', '1500621287', 'true', '', '最近，Uber用户增长负责人Andrew Chen在个人博客上发表文章称，如今，移动互联网产品已经越来越难实现用户增长，原因就在于，我们当下所处的技术增长周期即将结束。那么，这对创业公司来说', '怎么,安装,地漏,现在,是,夏季,天气,闷热,不少,', '194', '1503977231', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('44', '46', '光伏行业解决方案', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	当转型AI成为中国互联网企业的政治正确时，人工智能、机器学习方面的人才争夺已经成了一场明面上的战争。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	数据显示，目前百度的人工智能人才储备量占员工总数的2.54%， 2015年到2017年，阿里巴巴和腾讯的人工智能人才增幅分别为325%和285%。而人工智能岗的整体薪酬，甚至达到了2万元以上。挖同行、挖高校、挖研究院都不在话下，好像不表现出人才的渴望，就没有拿出对人工智能足够的诚意。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不过除了明面上的短兵相接之外，我们更感兴趣的是企业间的人才“暗战”——通过内训、高校合作等等方式培养的嫡系军。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以企业角色培养人工智能和机器学习方面的人才究竟有多重要？能获得的老员工忠诚的高性价比，更是实现机器学习、计算机视觉等等技术率先应用的可能。除了这些，不同的企业恐怕还有不同的答案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	谷歌：用全民AI做存量</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	最近又有人提起了谷歌的“忍者计划”：一项谷歌内部的机器学习培训项目，给予各个部门有限的名额，经过层层筛选，最终选择优胜者成为“忍者”参与培训。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	谷歌表示，这样做的目的是让所有产品都提升智能化程度，扩大内部精英人才的储备，甚至让机器学习成为谷歌员工必备的技能。这一计划已经实行了几年，而谷歌内训员工机器学习的历史则更早，大概在05年左右。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"小标题\">\r\n	正在接受机器学习“忍者训练”的谷歌工程师卡森·霍尔盖特</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	全民AI，是谷歌忍者计划最大的重点。让不同产品线的员工都去掌握机器学习技能，对于谷歌最大的好处就是全线产品都可以获得AI+的光环。现在的谷歌左手牵着Waymo，右手拉着DeepMind，在无人驾驶、TPU等等人工智能的增量上都有所布局，但用AI技术改善谷歌搜索一类老业务、做人工智能的存量同样是不能缺少。而相比空降CTO、PM等等高成本的选择，培训原先产品线上的员工，用新技术激发老员工做创新无疑是更好的选择。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但谷歌的玩法不是人人都能模仿的了——谷歌总部6万名员工中有2.5万都是工程师，因为有强大的基因才让全民AI成为可能。这也在提醒着我们，人工智能不仅仅带来了无人驾驶这样的新战场，我们的对手还在不断的完善着搜索、翻译等等旧业务。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	Facebook：建立人工智能西点军校</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	相比谷歌，Facebook的内部人工智能培训课程更体系化、看起来专业度也更高。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今年三月，宣布创建 Facebook AI Academy，对公司内部员工进行免费AI技能培训。Facebook人工智能学院的课程来自于Facebook人工智能研究院（FAIR）首脑之一Larry Zitnick，课程涉及深度学习、卷积神经网络、循环神经网络、强化学习等等多种技术，课程完成后，还可以到FAIR中进行一到两年的项目实践。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	相比谷歌较为泛泛的忍者计划，Facebook可以说是为员工提供了一条完整的人工智能向内部晋升通道，从技术培训，再到项目实践，而且接触到的都是FAIR这样Facebook人工智能最核心的资源，简直是军校式的人才培养方案。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这样不遗余力的培育人才，一是在帮助FAIR的学术能力落地应用，FAIR在技术上的实力毋庸置疑，虽然时不时出个“AI发明自己语言”的炸裂性新闻，可小扎在开发者大会上提到的更多还是AR，不得不让人怀疑，FAIR的技术成果是不是只能应用于CV领域。第二也是在加速在人工智能赛程上的步伐，相比谷歌2.5万工程师的数量优势，Facebook只能从质量上进行补充。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	英伟达：一切为了卖GPU</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	前面两家企业培育人才的逻辑还很容易理解，要提到英伟达的深度学习学院（DLI），就有点让人看不懂了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	和Facebook、谷歌不一样的是，英伟达的DLI面对的不是自己的员工，而是对外开放的，而且开放性非常高。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	英伟达DLI课程分成两类，一类是和Udacity、Coursera在线编程教育合作的线上课程，另一类则是定期举办的线下培训课程，同时还有可以为产品、企业量身定制的深度学习研讨会。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	从Udacity上可以看到DLI的课程要求，可以说门槛非常低了。而学习了DLI相关课程后，还可以获得自动驾驶的纳米学位——一个优达学城与 Google、亚马逊、Facebook、AT&amp;T 等企业共同打造的学习认证项目。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在官网上也能看到，英伟达DLI时长为一天的线下深度学习培训班，限报名50人，学费为750元，课后发布统一结业证书，还经常有免费的公开课。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	坦白讲，这些线上课程和一天式的线下培训，离培养出人才还有点距离。不过这样下去的话，黄仁勋培养出10万深度学习从业者的计划可能会很快实现。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以，英伟达和FB、谷歌最大区别就是，后者盯上了科技创新的红利，而英伟达盯上了跟风期的红利。今天人工智能人才的争夺，暂时只存在于大公司间对顶尖人才的争夺。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在高校课程还没彻底普及时，英伟达DLI培育出来的有企业证明背书、有基础技能的深度学习从业者，就可以填补这些缺口，最重要的，向所有企业普及GPU。英伟达目标清晰，一切行为都以“让GPU更好卖”为最终目标。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	国内企业：人工智能大战，别输在战备阶段</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	再看国内企业，令人意外的是几乎无一有这样的企业内部培训机制，只有百度在今年和一些高校展开合作，用共建实验室、共享数据等方式推行人工智能教育的“企校联动”。而其他企业最多是开放一些平台，几乎没有公开宣传过类似忍者计划等等的内训机制。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	百度与南大签约共建大数据研究平台</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	其中的原因也不难理解，或许是现如今中国人才竞争太过激烈，公开宣传内训机制反而会引来他人挖角甚至“卧底”；又或许是我们习惯了KPI文化，不知道该怎么给企业内训这件高成本的事定转化目标，一些大企业不同事业部、部门间的竞争也注定了无法将知识共享；最糟糕的情况，可能就是我们在机器学习方面的人才太过紧缺，根本无法负担起内部培训、知识传承这种事。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	不管是哪一种情况，我们都应该反思，国际上人工智能的赛场，表面上是拼的新技术、发论文，可背后却是一场人才储备的暗战。看着硅谷一批批的华人工程师，难道吸引他们的仅仅只是海外企业的光环和高薪？国内企业极差的内部学习氛围和单一的晋升渠道，多多少少要背上一锅。人才流失还不是唯一的损失，技术只集中在一小部分人手中，更会让企业陷入被动的局面。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	只希望，下次再搜索“人工智能培训”时，霸屏的不仅仅是流水化生产的培训机构，也能看到有中国企业承担起知识传承的责任。</p>\r\n', '', 'admin', '', '1505011874', '1505011874', 'true', '', '防护箱（安全箱)采用高强度，高抗冲击，绝对密封，防潮，防尘，防水，内附方格海绵是存放贵重仪器设备的理想专业用箱，广泛用于，户外摄影，野外考餐，科学探测，等众多领域，精', '光伏,行业,解决方案,当,转型,成为,中国,', '79', '1513329731', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('45', '46', '风电行业解决方案', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	今天想通过捋顺消费演变的历史，来看看阿里巴巴、京东这样的电商，究竟是能不能瓦解所有的实体零售业态，还想看看未来零售的竞争，到底是哪方面的竞争。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	纵观历史，人类的进化和社会的进化是由哲学和科技推动的。哲学在乎制度，即组织形式，科技在乎力量，即生产力。西方哲学和工业革命的层层递进推动了制度和生产力，消费是在这两台历史推动机下的产物，而后凯恩斯主义将消费从历史的产物变成了推动历史的原因，消费社会就此掀开。这是他的伟大之处。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所以历史推动了消费，现在消费也在推动历史。研究消费的一个最基础的方式就是研究消费的历史。反观制度和科技是如何改变消费的，着力思考这些改变的方向和逻辑是什么。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	为什么会诞生百货和便利店？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	城市化先于大众消费的产生。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	以日本为例，日本在1895年打了中日甲午战争，1905年打了日俄战争。第一次世界大战的战时需求使得日本经济一片繁荣，也加速了日本城市化进程。1920年东京人口占日本总人口的6.6%，1930年占到了8.4%。1940年超过了10%。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在这城市化的20年，东京电器（东芝前身）开始批量生产灯泡。同时出现的还有1923年开始的资生堂连锁店，日本第一次开始了培训经销商的体系，1925年宝塚大剧场开业，宣告了娱乐消费的开启。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在基础设施方面，日本第一条地铁线浅草-上野线开始运营。城市基础设施开始加速和扩大城市人的活动范围。随着基础设施的建立，房地产商开始盖公寓，写字楼林立，随着写字楼诞生了一批中产阶级消费者，百货公司应运而生，百货业态开始出现，三越百货起于1929年，伊势丹起于1933年，位于浅草的松屋起于1931年。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二年，也就是1932年，日本的无线广播收听人数突破100万，媒体从纸媒向广播发展，人们的消费生活以物质消费和娱乐消费的形式展开。但是当时由于工业生产尚无法满足大众消费，多是以家庭手工业生产出来的，没有规模效益的商品单价昂贵，此时的消费多是以社会中上层的消费者为主，百货的兴起为这类消费者提供了绝佳的购物空间。但是无法规模化的商品无法使得大众进入消费社会。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是那个时代的消费发展完全不平衡。在那时，美国已经开始上映了米老鼠，因为电视机已经开始普及。T型车早在1908年就成为了大众消费品，1919年欧洲的首款量产汽车雪铁龙A型也上市。崇尚时尚的法国人也在那时用Chanel&nbsp;5号香水宣告了中高层消费的崛起。Walgreens则开创性地将药品，个户，报摊，烟草，餐馆，冷饮集合在一起，开成了连锁经营模式，极大地便利了城市人的消费，和百货公司穿插布局。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另一业态便利店也雏形初现，成立于1927年的7-11开始在达拉斯贩售鸡蛋牛奶面包和冷冻食品。当时的美国作为世界领先的消费业态，而当时的日本十分崇尚美式生活，而这些业态也都被逐渐引进日本。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	百货是怎么被便利店逼上“中高端定位”这条路的？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	19世纪30-40年代的第二次世界大战让日本的消费社会发展停滞，甚至倒退，战后的匮乏生活恐慌之后，日本开始了战后复兴，随之而来的是经济的高速增长期。日本经济最快速的增长是1955到1973年。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	随着生产效率的大幅提升，大众消费品开始崛起。第一个规模化的大众消费品类是家电。1953年，三洋开始销售洗衣机，家电三大神器：洗衣机、电冰箱和电视机，开始大规模登上历史舞台，这期间孕育了松下、三洋、东芝等至今我们依然熟悉的企业。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当时诞生于1949年的优衣库还是一家小服装店。而后的1960年代是大规模生产汽车，当时的汽车厂商大多以性价比高的型号为主打，最突出的是丰田花冠，卡罗拉，同时期的马自达，斯巴鲁也都竞相开发小型汽车。汽车的发展同时，索尼的前身东京通信工业研发了世界上最小的半导体收音机。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	基础设施方面，1951年东京的羽田国际机场竣工。日本第一个特快列车开始在东京新宿运营。交通的发展加速了地产的溢出效应，东京城市圈越来越大，就如同纽约一样。公路的便利让沃尔玛等大卖场开始大规模扩张，日本的大荣超市等业态开始扩张，日本人学习美国的速度之快令人咋舌。因为美国的超市诞生可是经历了50年的变迁。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但无论如何大量生产，大量消费使得日本民众纷纷过上了朝思暮想的美式生活，人们崇尚越大越好，东西越买越多，越卖越贵，房子一直在涨，财富效益不断涌现，而此时的日本的老年人比例占5%-6%（这个数字和后面的老龄化形成鲜明对比，2004年日本的老年人比例占到了20%，预计在2034年达到30%）。之后80年代日本又掀起了奢侈品的狂热。纷纷出国和在境内购买奢侈品，物质极大丰富之后，人们的物欲越来越膨胀。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	再看二战后的美国，拥有私家车的户数占到了60%，私家车的普及成为了基础设施，让沃尔玛可以在郊区开Big&nbsp;Box，大规模运货车和大量私家车涌向郊区的大卖场。同时最低工资法案出台，城市内早已成熟的街角杂货店业态无法承受高额的人工成本，美国的杂货店从40年代开始，逐渐将年轻的店员，变成了退休妇女，再由于70年代条形码的普及，杂货店直接取消了店员，只设置结账收银员，于是便利店的雏形开始出现。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	由于便利店的效率提升，价格降低，百货店无法和拥有咄咄逼人的价格和极度方便的便利店相抗衡，百货公司开始定位中高端消费，巨大的消费市场和财富效益，让欧洲的奢侈品LV,Prada等品牌大规模登陆美国，成立于1941年的Coach遇到了前所未有的压力，但这也为后面的轻奢策略奠定了基础。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	美国和日本在消费升级的时候发生了什么？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	消费的升级让美国的业态更加丰富，第一家购物中心也于1954年在底特律开业，容纳了1000家门店。购物中心和百货公司的普及，使得商业地产的价值凸显，下一年，麦当劳开始连锁营业。美国的大众消费开始掀起廉价文化。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	而廉价文化是建立在效率的提升，包括生产效率和营运效率。廉价文化下的业态是城市内的连锁超市，连锁便利店，连锁餐饮，和郊区的大卖场。而百货则更加定位精英阶层。这是20年代-70年代美国零售业态发生的改变，至今都在稳定发展着，唯一的变化是集中度越来越高，梅西和西尔斯市场份额越来越大，沃尔玛也效率越来越高，这其中淘汰了效率较低的伍尔沃斯（自选模式和收款机的开拓者，但是因价格相比沃尔玛无优势而逐渐衰退）。出现的挑战者都是商业模式创新的Costco等更便宜的竞争者。只是这些业态无一不受到地产和交通的制约。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	但是直到Amazon的出现，才打破了地产的界限和消费者阶层的划分。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	反观日本，类似的业态演变也在发生。到了七十年代，日本的超市代表大荣曾经在1972年销售额超过了三越百货，曾经也是非常轰动的新闻。让人们看到了杂货商品的巨大市场，大众消费和廉价文化成为兴起。百货店的业态开始并不是主流，人们开始思考如何增加超市的效率（就如同现今阿里巴巴和京东在思考如何占领日用百货和生鲜市场一样）。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	美国的沃尔玛似乎是一个好案例，但是是建立在私家车渗透率极高和公路效率极高的基础设施之上，这真的适合日本吗？直到日本第一家7-11的开业，这发生在1974年。现在连锁便利店的销售额远远超过百货，成为了日本最典型的业态。因为日本拥有着美国没有的：城市密度。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	阿里巴巴和京东为什么都要做便利店？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	自从沃尔玛一统天下，很多零售从业者都看到的是规模效益，而便利店的精髓在于密度。门店密度越大，单次配送的效率越高，便利店的周转也就越快。而便利店的周转是经营的命根，周转速度越快，产品就可以越便宜，同时库存压力越小，门店的迭代越快。比方说每件产品3%的净利润率，一年周转3次，年化的净利率就是9%，一年周转四次，就是12%。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	因此便利店是要建立在配送效率上，配送效率建立在门店网店的密度上。这是日本独一无二的优势。因此，城市的基础设施规划，决定了不同的业态的适应性。直到现在，超市在日本的发展都十分有限，而便利店的店效则高的惊人，百货业态则一直慢慢地衰老。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	因此零售的一切变革都是效率的进步。在美国，伍尔沃斯用没有售货员，只有收银员的杂货店统一了杂货市场，胜在经营效率，而沃尔玛用供应链开创了新的秩序，胜在供应链效率。在日本，效仿美国的大荣超市并没有成为主流业态，而是因日本独特的城市规划而诞生的便利店成为了主流。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	百货业态永远是中高端的定位，购物中心为人们建立了场景和空间。在中国，独特的饮食文化丰富了购物中心的业态。超市虽然也已经占领各大城市，但是伺机而起的便利店正在酝酿新的变革。目前全中国一共有600万家，那些夫妻店，估计市场规模在7万亿左右，很多目前都是在亏损边缘，受困于低效的供应链。因此，过慢的周转和库存积压，使得行业整体提升空间非常大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p label=\"大标题\">\r\n	阿里巴巴和京东的介入能带来什么？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	刚才我们回顾了美国和日本的消费历史，发现大众消费从大规模生产开始成为了主流，基础设施的建立和城镇特点决定了不同业态的竞争边界。科技发展又让不同的业态效率提升成为了可能。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	未来的中国应该是便利店和超市并起的环境。在超市的集中度经过连锁的方式提升之后，夫妻店是唯一没有被升级的业态。这不，电商企业就想来搞事情了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	只不过阿里巴巴认为自己拥有的数据可以帮助夫妻店实现“千店千面”，这应该是小看了夫妻店而高估了数据的价值。便利店因为周转速度非常快，其自我更新迭代的能力远不是百货商场和购物中心能媲美的，电商能够让百货公司过得很难受，但是很难让便利店们过得很难受。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	目前快消品的电商渗透率只有6%。生鲜只有3%，其及时性和消费的偶然性都不是电商能够达到的。作为便利店的店主，只用几天的时间就能知道在我这个位置，什么商品周转速度最快，用不着阿里京东用数据告诉我我该进什么货，我更相信每一天每时每刻交易出来的结果。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在现在的世界，数据崇拜会让人远远高估数据的价值。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	既然数据对便利店并不是很有价值，那么电商平台的介入能带来什么？除了我们众所周知的物流效率, 另一个是资金流的效率。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	所谓电商的“赋能”，不外乎三种，便宜的流量，高效的货品周转以及高效的资金周转。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	便宜的流量对于便利店来讲并不是很明显，毕竟便利店也是一桩地产的生意，并且可复制性极高。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	资金周转的效率提升靠供应链金融，而供应链金融在中国刚刚发展尚未成熟。因为供应链金融需要有足够了解商家的物流巨头用自己做背书，为难以获得贷款的小商家拿得银行贷款，加快资金流的流动，从而促进商品地流动。这要求供应链巨头作为第三方，十分熟悉小商家的经营状况和节奏，甚至是货品的折旧规律，为库存估值，从而向银行担保，帮助商家获得授信。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	资金流的效率是一个业态最后一个提升的点，这块目前有条件的只有京东和阿里巴巴，因为京东物流和菜鸟、三通一达控制着商家的物流。因此，京东的便利店和天猫小店的竞争，实质不是大数据的竞争，而依然是供应链的竞争，所谓的定制化和“千店千面”，其实让便利店这种快速迭代的业态自我演化，要比外人介入来的更好。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	因此，从历史的角度来看，建立零售的基础设施，提升物流的效率，进而让资金流高效地运转，最终实现人流，物流，资金流的高效协同流动。这才是让零售进化的正确且不可逆的道路。</p>\r\n', '', 'admin', '', '1505011928', '1505011928', 'true', '', '风电行业接线盒安装与塔筒里面作为一个接线盒使用\r\n1. 箱体连接螺栓采用注塑成型的方式，与箱体连接时具有足够的强度， 紧固后不会破裂。\r\n2. 为了饿有效地保护内部电子电', '风电', '78', '1513329745', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('46', '46', '畜牧行业解决方案', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '<p>\r\n	工信部副部长辛国斌9月9日在2017中国汽车产业发展（泰达）国际论坛上致辞时透露，中国已经开始研究制定禁售传统燃油汽车时间表。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	辛国斌表示，许多国家纷纷调整发展战略，在新能源、智能网联产业加快产业布局，抢占新一轮制高点。针对一些国家已经制订了停止生产销售传统能源汽车的时间表，目前工信部也启动了相关研究，将制订中国自己的时间表。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	辛国斌称，截至2016年底，中国汽车保有量接近两亿辆，带来严峻的资源能源和和环境压力。中国政府承诺2030年碳排放达到峰值，一次能源比重达到20%，按照目前状况达标的难度仍然很大。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	车企望风而动</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	中国政府从2009年起，开始为新能源汽车提供财政补贴。但补贴政策对市场扭曲明显，2016年国家主管部门还展开大范围“骗补”核查，行业普遍认为财政补贴政策不可持续。按照目前计划，2019年开始财政补贴将逐步退坡，2020年之后则有望全面退出。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	中国政府着手制定禁售传统燃油汽车时间表，亦显示出鼓励新能源汽车态度不变。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	财政部经济建设司副司长宋秋玲在同一场合致辞时指出，目前新能源汽车财政补贴的退坡政策已经明确，在落实好现有政策的同时，财政部将积极配合工信部等部门加快建立新能源积分交易机制。确保财政补贴政策退出之后，新能源汽车扶持力度不会断档。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	2016年9月，工信部发布《乘用车企业平均燃料消耗量与新能源汽车积分并行管理办法（征求意见稿）》（下称双积分政策），计划2018年实施，2018-2020年三个年度的新能源汽车汽车积分比例要求分别是8%、10%和12%。新能源积分不能在不同年度间结转。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	该政策对新能源汽车扶持力度明显，为达到积分要求，已有数家存在达标压力的跨国公司与中国新能源汽车领先企业达成合资计划。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	据路透报道，雷诺和日产上月底表示，正与合作伙伴中国东风汽车集团组建新的合资公司——易捷特新能源汽车有限公司（eGT），新公司将在中国设计和生产电动汽车。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	易捷特计划选址在中国中部地区的湖北省十堰市，电动汽车的生产将在十堰市东风汽车生产基地开展。预计将于2019年开始生产新款电动汽车，并形成年生产12万辆的产销规模。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	在这之前，福特汽车宣布，已与中国电动汽车制造商——众泰汽车签署了一份合作备忘录，双方拟建一家合资公司，新的合资公司将集纯电动乘用车的研发，制造，销售和服务于一体。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	今年4月，戴姆勒宣布，将与合作伙伴北汽集团在中国建立一家电池厂。这家投资规模为6.55亿欧元（约合7.4亿美元）的工厂不仅生产电动汽车电池，还将生产梅赛德斯-奔驰的电池驱动汽车。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	近期接近工信部的人士向财新记者确认，该政策计划延后一年实施，但仍需等待最终正式文件。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	申万宏源认为，尽管新能源汽车积分政策延后一年实施，但鼓励新能源汽车趋势不变。同时，因平均油耗积分按计划实施，部分车企会加大生产新能源汽车来抵消平均油耗负积分。申万宏源测算，预计中国2018年至少生产75万辆新能源乘用车才可满足需求。</p>\r\n<p>\r\n	　　</p>\r\n<p label=\"大标题\">\r\n	多国给出“消灭”燃油汽车时间表</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此前一些国家已经制订了停止生产销售传统能源汽车的时间表。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	7月底，英国政府宣布，将于2040年开始全面禁售传统柴汽油车，此项计划主要是应对英国国内的空气污染问题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	英国政府称，空气污染是公共卫生的最大威胁，禁止销售燃油车将有助于快速解决空气污染问题。英国政府还将投入30亿英镑，用于鼓励地方政府翻新改良巴士、整修道路甚至调整交通灯模式来降低排放。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	事实上，不只是英国，近几个月以来，关于“禁售燃油车”的新闻屡屡爆出，特别是欧洲部分国家相继发布停售燃油汽车时间表的报道。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	7月初，法国能源部长Nicolas Hulot宣布，法国计划在2040年前停止销售汽油和柴油车。该计划是法国一项旨在履行巴黎气候协定承诺的“五年大计”的一部分。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	去年，德国《明镜周刊》报道，德国联邦参议会通过一项决议，将于2030年起禁止所有燃油汽车上路。但这项禁令遭到德国汽车协会和全德汽车俱乐部反对，认为该目标太过激进。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	此外，荷兰和挪威曾提出，将在2025年禁售燃油车。印度也称，要在2030年全面禁售燃油车。</p>\r\n', '', 'admin', '', '1505011991', '1505011991', 'true', '', '畜牧行业室内防水控制箱采用工程塑料ABS材质箱体透明盖子组合在一起\r\n1. 在箱体的上下位置为了达到更加有效的防护效果，特别设计了防护突出层，更加有效地防止水', '畜牧,行业,解决,方案', '73', '1513329791', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('47', '46', '军工行业解决方案', '', '/storage/images/20211201/1-1G2151H4170-L.jpg', '', '<p>\r\n	<img alt=\"5.jpg\" src=\"/storage/images/20211201/1H5015A7-0.jpg\" title=\"5.jpg\" /></p>\r\n<p>\r\n	指纹防护箱特点如下;<br />\r\n	&nbsp;&nbsp;&nbsp;&nbsp; 1:采用世界最先进的活体指纹识别技术<br />\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2：硅晶片电容传感器，锂电池供电<br />\r\n	&nbsp;&nbsp;&nbsp;&nbsp; 3：款式新颖，做工精良，风格时尚，美观大方，高档典雅，坚固耐用<br />\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 设定级别管理，放置越权操作<br />\r\n	&nbsp;&nbsp;&nbsp;&nbsp; 4：安全性能高，箱体无明锁，通体防撬设计，通过指纹开启<br />\r\n	指纹参数：<br />\r\n	指纹识别时间小于1S<br />\r\n	指纹采集时间小于1S&nbsp;<br />\r\n	误识别率小于0.001%<br />\r\n	拒真率小于0.01%<br />\r\n	指纹容量8枚（2管理者/6一般用户）<br />\r\n	工作温度-20度%~60度<br />\r\n	相对湿度-40度~70度<br />\r\n	储存环境-40度~70度<br />\r\n	电源950mah,3.7v可充电锂电池<br />\r\n	指纹分辨率508DPI<br />\r\n	职位采集窗口尺寸10.64mm*14mm<br />\r\n	充电器部分：输入AC100-24V<br />\r\n	输出：DC.500ma<br />\r\n	充电时间：5-10小时</p>\r\n', '', 'admin', '', '1513329901', '1513329901', 'true', '', '防护箱（安全箱)采用高强度，高抗冲击，绝对密封，防潮，防尘，防水，内附方格海绵是存放贵重仪器设备的理想专业用箱，广泛用于，户外摄影，野外考餐，科学探测，等众多领域，', '军工,行业,解决方案,指纹,防护,箱,特点,如下,', '111', '1513329852', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('48', '21', '企业风采一', '', '/storage/images/20211201/1-1G2161H5190-L.jpg', '', '', '', 'admin', '', '1513416323', '1513416323', 'true', '', '', '企业,风采,一,企业,风采,一,', '176', '1513416305', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('49', '21', '企业风采二', '', '/storage/images/20211201/1-1G2161H5370-L.jpg', '', '', '', 'admin', '', '1513416342', '1513416342', 'true', '', '', '企业,风采,二,企业,风采,二,', '68', '1513416326', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('50', '21', '企业风采三', '', '/storage/images/20211201/1-1G2161H5570-L.jpg', '', '', '', 'admin', '', '1513416361', '1513416361', 'true', '', '', '企业,风采,三,企业,风采,三,', '108', '1513416345', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('51', '21', '企业风采四', '', '/storage/images/20211201/1-1G2161H6170-L.jpg', '', '', '', 'admin', '', '1513416381', '1513416381', 'true', '', '', '企业,风采,四,企业,风采,四,', '100', '1513416365', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('52', '21', '企业风采五', '', '/storage/images/20211201/1-1G2161H6370-L.jpg', '', '', '', 'admin', '', '1513416401', '1513416401', 'true', '', '', '企业,风采,五,企业,风采,五,', '53', '1513416384', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('53', '41', '合作伙伴一', '', '/storage/images/20211201/1-1FHG613180-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG613180-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501143210', '1501143210', 'true', '', '', '合作伙伴,一,', '55', '1501143168', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('54', '41', '合作伙伴二', '', '/storage/images/20211201/1-1FHG63T60-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG63T60-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501144736', '1501144736', 'true', '', '', '合作伙伴,二,', '127', '1501144711', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('55', '41', '合作伙伴三', '', '/storage/images/20211201/1-1FHG63Z80-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG63Z80-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501144758', '1501144758', 'true', '', '', '合作伙伴,三,', '132', '1501144740', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('56', '41', '合作伙伴四', '', '/storage/images/20211201/1-1FHG639350-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG639350-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501144785', '1501144785', 'true', '', '', '合作伙伴,四,', '155', '1501144762', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('57', '41', '合作伙伴五', '', '/storage/images/20211201/1-1FHG640000-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG640000-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501144808', '1501144808', 'true', '', '', '合作伙伴,五,', '122', '1501144788', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('58', '41', '合作伙伴六', '', '/storage/images/20211201/1-1FHG640250-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FHG640250-L.jpg\" style=\"width: 250px; height: 109px;\" /></div>\r\n', '', 'admin', '', '1501144834', '1501144834', 'true', '', '', '合作伙伴,六,', '72', '1501144811', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('59', '40', '视频展示一', '', '/storage/images/20211201/1-1FH91451420-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<iframe frameborder=\"0\" height=\"498\" src=\"http://player.youku.com/embed/XMjkyMTUwODMyMA==\" width=\"510\"></iframe></div>\r\n', '', 'admin', '', '1501311153', '1501311153', 'true', '', '', '视频,展示,一,', '125', '1501311037', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('60', '40', '视频展示二', '', '/storage/images/20211201/1-1FH91453020-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<iframe frameborder=\"0\" height=\"498\" src=\"http://player.youku.com/embed/XMjkyNDkwNDk1Mg==\" width=\"510\"></iframe></div>\r\n', '', 'admin', '', '1501311215', '1501311215', 'true', '', '', '视频,展示,二,', '145', '1501311156', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('61', '40', '视频展示三', '', '/storage/images/20211201/1-1FH91453500-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<iframe frameborder=\"0\" height=\"498\" src=\"http://player.youku.com/embed/XMjkyNzI5OTY0OA==\" width=\"510\"></iframe></div>\r\n', '', 'admin', '', '1501311244', '1501311244', 'true', '', '', '视频,展示,三,', '201', '1501311219', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('62', '44', '企业展示一', '', '/storage/images/20211201/1-1FH11455050-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11455050-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500620478', '1500620478', 'true', '', '', '企业展示,一,', '50', '1500620081', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('63', '44', '企业展示二', '', '/storage/images/20211201/1-1FH11501330-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11501330-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500620504', '1500620504', 'true', '', '', '企业展示,二,', '135', '1500620481', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('64', '44', '企业展示三', '', '/storage/images/20211201/1-1FH11502020-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11502020-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500620527', '1500620527', 'true', '', '', '企业展示,三,企业展示,三,', '126', '1500620588', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('65', '44', '企业展示四', '', '/storage/images/20211201/1-1FH11502280-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FH11502280-L.jpg\" style=\"width: 250px; height: 166px;\" /></div>\r\n', '', 'admin', '', '1500620558', '1500620558', 'true', '', '', '企业展示,四,', '79', '1500620536', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('66', '44', '基地展示一', '', '/storage/images/20211201/1-1FP31051040-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP31051040-L.jpg\" style=\"width: 650px; height: 490px;\" /></div>\r\n', '', 'admin', '', '1501728681', '1501728681', 'true', '', '', '基地,展示,一,', '130', '1501728640', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('67', '44', '基地展示二', '', '/storage/images/20211201/1-1FP31051330-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP31051330-L.jpg\" style=\"width: 650px; height: 490px;\" /></div>\r\n', '', 'admin', '', '1501728701', '1501728701', 'true', '', '', '基地,展示,二,', '56', '1501728684', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('68', '44', '基地展示三', '', '/storage/images/20211201/1-1FP31051540-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP31051540-L.jpg\" style=\"width: 650px; height: 490px;\" /></div>\r\n', '', 'admin', '', '1501728723', '1501728723', 'true', '', '', '基地,展示,三,', '132', '1501728705', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('69', '44', '基地展示四', '', '/storage/images/20211201/1-1FP31052170-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211201/1-1FP31052170-L.jpg\" style=\"width: 650px; height: 490px;\" /></div>\r\n', '', 'admin', '', '1501728748', '1501728748', 'true', '', '', '基地,展示,四,', '154', '1501728726', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('70', '25', '手机幻灯一', '', '/storage/images/20211201/1-1FH9161041508.jpg', '', '', '', 'admin', '', '1500688893', '1500688893', 'true', '', '', '手机,幻灯,一,手机,幻灯,一,', '133', '1501315832', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('71', '25', '手机幻灯二', '', '/storage/images/20211201/1-1FH9161101464.jpg', '', '', '', 'admin', '', '1500688915', '1500688915', 'true', '', '', '手机,幻灯,二,手机,幻灯,二,', '57', '1501315855', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('72', '47', '列表幻灯一', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '', '', 'admin', '', '1505115510', '1505115510', 'true', '', '', '列表,幻灯,一,列表,幻灯,一,', '91', '1505179312', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('73', '47', '列表幻灯二', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '', '', 'admin', '', '1505115529', '1505115529', 'true', '', '', '列表,幻灯,二,列表,幻灯,二,', '50', '1505179347', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('74', '47', '列表幻灯三', '', '/storage/images/20211201/1-1FH915155T28.jpg', '', '', '', 'admin', '', '1505115546', '1505115546', 'true', '', '', '列表,幻灯,三,列表,幻灯,三,', '102', '1505179360', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';

-- -----------------------------
-- Records of `rrz_channelfield`
-- -----------------------------
INSERT INTO `rrz_channelfield` VALUES ('5', 'tb2_chicun', '2', 'goods', '产品尺寸', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '100', '1638321009', '1638321009');
INSERT INTO `rrz_channelfield` VALUES ('6', 'tb2_xiaolv', '2', 'goods', '工作效率', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '100', '1638321009', '1638321009');
INSERT INTO `rrz_channelfield` VALUES ('7', 'tb2_jianjie', '2', 'goods', '产品简介', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '100', '1638321009', '1638321009');

-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';

-- -----------------------------
-- Records of `rrz_channeltype`
-- -----------------------------
INSERT INTO `rrz_channeltype` VALUES ('2', '图片集', 'goods', '1638321009', '0');

-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211201/header1.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211201/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某网站 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', 'ICP备*******号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '小吃餐饮管理公司类网站人人站模板(带手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'email@rrzcms.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某区某某地', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '39.903970449129694,116.39786991534426', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '2', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '3', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '1300000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_suffix', 'html', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('53', 'app_debug', '2', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线留言', 'a:3:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";i:1;}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"联系电话\";s:8:\"required\";i:1;}i:2;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:6:\"备注\";s:8:\"required\";i:0;}}', '1638321015', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `tb2_chicun` varchar(255) NOT NULL DEFAULT '' COMMENT '产品尺寸',
  `tb2_xiaolv` varchar(255) NOT NULL DEFAULT '' COMMENT '工作效率',
  `tb2_jianjie` varchar(255) NOT NULL DEFAULT '' COMMENT '产品简介',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';

-- -----------------------------
-- Records of `rrz_goods`
-- -----------------------------
INSERT INTO `rrz_goods` VALUES ('1', '产品名称一', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '1', '0', '/storage/images/20211201/1-1FH915155T28.jpg', '/storage/images/20211201/1-1FH915155T28.jpg,/storage/images/20211201/1-1FH1133T9.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH9151912609.jpg\" style=\"border: 0px; margin-left: 0px; margin-right: 0px; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505118875', '0', '0', '1', '0', '54', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('2', '产品名称二', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '1', '0', '/storage/images/20211201/1-1FH9152020J2.jpg', '/storage/images/20211201/1-1FH9152020J2.jpg,/storage/images/20211201/1-1FH1152S5.jpg,/storage/images/20211201/1-1FH1152S6.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	<img alt=\"白色封箱透明胶带48mm\" src=\"/storage/images/20211201/1-1FH9151950K3.jpg\" style=\"border: 0px; margin-left: 0px; margin-right: 0px; width: 600px; height: 450px;\" title=\"白色封箱透明胶带48mm\" /></p>\r\n<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1513561512', '0', '0', '1', '0', '175', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('3', '产品名称三', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '1', '0', '/storage/images/20211201/1-1FH91521123P.jpg', '/storage/images/20211201/1-1FH91521123P.jpg,/storage/images/20211201/1-1FH1153004.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH915204c62.jpg\" style=\"border: 0px; margin-left: 0px; margin-right: 0px; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p style=\"margin: 0px; padding: 0px; word-spacing: -1.5px; color: rgb(65, 65, 65); font-family: \'microsoft yahei\'; font-size: 14px; line-height: 25px; text-align: center;\">\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505118805', '0', '0', '1', '0', '91', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('4', '产品名称四', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '1', '0', '/storage/images/20211201/1-1FH915221BA.jpg', '/storage/images/20211201/1-1FH915221BA.jpg,/storage/images/20211201/1-1FH1153052.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH9152152Q2.jpg\" style=\"border-width: 0px; border-style: solid; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505118756', '0', '0', '1', '0', '51', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('5', '产品名称五', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '2', '0', '/storage/images/20211201/1-1FH9152240455.jpg', '/storage/images/20211201/1-1FH9152240455.jpg,/storage/images/20211201/1-1FH1153135.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH915225GA.jpg\" style=\"border-width: 0px; border-style: solid; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505119009', '0', '0', '1', '0', '157', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('6', '产品名称六', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '2', '0', '/storage/images/20211201/1-1FH9152325C3.jpg', '/storage/images/20211201/1-1FH9152325C3.jpg,/storage/images/20211201/1-1FH1153217.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH915233L49.jpg\" style=\"border-width: 0px; border-style: solid; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505118997', '0', '0', '1', '0', '109', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');
INSERT INTO `rrz_goods` VALUES ('7', '产品名称七', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '2', '0', '/storage/images/20211201/1-1FH9152415647.jpg', '/storage/images/20211201/1-1FH9152415647.jpg,/storage/images/20211201/1-1FH5162S2.jpg,/storage/images/20211201/1-1FH5162S3.jpg', '0.00', '0.00', '0', 'false', '0.00', '', '', '<p>\r\n	<img alt=\"热熔胶带\" src=\"/storage/images/20211201/1-1FH915242L17.jpg\" style=\"border-width: 0px; border-style: solid; width: 600px; height: 450px;\" title=\"热熔胶带\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性、高强度抗压性、防腐蚀、耐用性、轻质、高硬度、产品再用性、环境保护等优异性能的环保型保温材料。</p>\r\n', '', '0', '1505118982', '0', '0', '0', '0', '148', '100', '', 'true', '', '挤塑聚苯乙烯保温板（XPS）是以聚苯乙烯树脂为原料，经由特殊工艺连续挤出发泡成型的硬质板材，其内部为独特的密闭式气泡结构，是一种具有优异、持久的绝热保温性、优越的抗水、防潮性', '', '2000mmx1900mmx1950mm', '11400㎡/h', '电动扫地车针对大坡度，高减速带，垃圾相对较多的环境。广泛适用于物业，市政道路，大型工厂，开阔的户外地面等环境作业。');

-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';

-- -----------------------------
-- Records of `rrz_goods_cat`
-- -----------------------------
INSERT INTO `rrz_goods_cat` VALUES ('1', '2', '产品分类一', '', 'chanpinzhongxin/js', '0', '', '1', '1', '1', '1001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_goods_cat` VALUES ('2', '2', '产品分类二', '', 'chanpinzhongxin/jb', '0', '', '2', '1', '2', '1002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_goods_cat` VALUES ('3', '0', '产品分类三', '', 'chanpinzhongxin/ym', '0', '', '3', '1', '3', '1003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_goods_cat` VALUES ('4', '0', '产品分类四', '', 'chanpinzhongxin/fq', '0', '', '4', '1', '4', '1004', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_goods_cat` VALUES ('5', '0', '产品分类五', '', 'chanpinzhongxin/bw', '0', '', '5', '1', '5', '1005', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');
INSERT INTO `rrz_goods_cat` VALUES ('6', '0', '产品分类六', '', 'chanpinzhongxin/sj', '0', '', '6', '1', '6', '1006', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', 'true', '1638321009');

-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '网站首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '产品中心', 'PRODUCT', 'chanpinzhongxin', '0', '2', '1', '/cats.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '成功案例', 'case', 'chenggonganli', '0', '3', '1', '/node/33.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '名师团队', 'PINJIA', 'kehupingjia', '0', '4', '1', '/node/39.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '荣誉资质', 'Honor', 'rongyuzizhi/rongyuzizhi', '0', '5', '1', '/node/11.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '新闻动态', 'NEWS', 'xinwendongtai', '0', '6', '1', '/node/15.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '解决方案', '', 'jiejuefangan', '0', '7', '1', '/node/46.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '关于我们', 'ABOUT US', 'guanyuwomen', '0', '8', '1', '/node/19.html', '8', '1008', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('9', '联系我们', ' 联系我们 Contact', 'lianxiwomen', '0', '9', '1', '/node/22.html', '9', '1009', 'false', '');
