<?php

namespace Rougin\Slytherin\Integration;

use Rougin\Slytherin\Container\ContainerInterface;
use Rougin\Slytherin\System;

/**
 * Configuration Integration
 *
 * Integrates Configuration inside the specified container.
 *
 * @package Slytherin
 *
 * @author Rougin Gutib <rougingutib@gmail.com>
 */
class ConfigurationIntegration implements IntegrationInterface
{
    /**
     * Defines the specified integration.
     *
     * @param \Rougin\Slytherin\Container\ContainerInterface $container
     * @param \Rougin\Slytherin\Integration\Configuration    $config
     *
     * @return \Rougin\Slytherin\Container\ContainerInterface
     */
    public function define(ContainerInterface $container, Configuration $config)
    {
        $alias = 'Rougin\Slytherin\Configuration';

        return $container->set($alias, $config)->set(System::CONFIG, $config);
    }
}
