from typing import Any

from ..sql.annotation import SupportsCloneAnnotations
from ..sql.base import Executable
from ..sql.selectable import GroupedElement, HasHints, HasPrefixes, HasSuffixes, SelectBase, _SelectFromElements
from . import interfaces
from .context import QueryContext as QueryContext
from .util import aliased as aliased

__all__ = ["Query", "QueryContext", "aliased"]

class Query(_SelectFromElements, SupportsCloneAnnotations, HasPrefixes, HasSuffixes, HasHints, Executable):
    logger: Any
    load_options: Any
    session: Any
    def __init__(self, entities, session: Any | None = ...) -> None: ...
    @property
    def statement(self): ...
    def subquery(self, name: Any | None = ..., with_labels: bool = ..., reduce_columns: bool = ...): ...
    def cte(self, name: Any | None = ..., recursive: bool = ..., nesting: bool = ...): ...
    def label(self, name): ...
    def as_scalar(self): ...
    def scalar_subquery(self): ...
    @property
    def selectable(self): ...
    def __clause_element__(self): ...
    def only_return_tuples(self, value) -> None: ...
    @property
    def is_single_entity(self): ...
    def enable_eagerloads(self, value) -> None: ...
    def with_labels(self): ...
    apply_labels: Any
    @property
    def get_label_style(self): ...
    def set_label_style(self, style): ...
    def enable_assertions(self, value) -> None: ...
    @property
    def whereclause(self): ...
    def with_polymorphic(self, cls_or_mappers, selectable: Any | None = ..., polymorphic_on: Any | None = ...) -> None: ...
    def yield_per(self, count) -> None: ...
    def get(self, ident): ...
    @property
    def lazy_loaded_from(self): ...
    def correlate(self, *fromclauses) -> None: ...
    def autoflush(self, setting) -> None: ...
    def populate_existing(self) -> None: ...
    def with_parent(self, instance, property: Any | None = ..., from_entity: Any | None = ...): ...
    def add_entity(self, entity, alias: Any | None = ...) -> None: ...
    def with_session(self, session) -> None: ...
    def from_self(self, *entities): ...
    def values(self, *columns): ...
    def value(self, column): ...
    def with_entities(self, *entities) -> None: ...
    def add_columns(self, *column) -> None: ...
    def add_column(self, column): ...
    def options(self, *args) -> None: ...
    def with_transformation(self, fn): ...
    def get_execution_options(self): ...
    def execution_options(self, **kwargs) -> None: ...
    def with_for_update(
        self, read: bool = ..., nowait: bool = ..., of: Any | None = ..., skip_locked: bool = ..., key_share: bool = ...
    ) -> None: ...
    def params(self, *args, **kwargs) -> None: ...
    def where(self, *criterion): ...
    def filter(self, *criterion) -> None: ...
    def filter_by(self, **kwargs): ...
    def order_by(self, *clauses) -> None: ...
    def group_by(self, *clauses) -> None: ...
    def having(self, criterion) -> None: ...
    def union(self, *q): ...
    def union_all(self, *q): ...
    def intersect(self, *q): ...
    def intersect_all(self, *q): ...
    def except_(self, *q): ...
    def except_all(self, *q): ...
    def join(self, target, *props, **kwargs) -> None: ...
    def outerjoin(self, target, *props, **kwargs): ...
    def reset_joinpoint(self) -> None: ...
    def select_from(self, *from_obj) -> None: ...
    def select_entity_from(self, from_obj) -> None: ...
    def __getitem__(self, item): ...
    def slice(self, start, stop) -> None: ...
    def limit(self, limit) -> None: ...
    def offset(self, offset) -> None: ...
    def distinct(self, *expr) -> None: ...
    def all(self): ...
    def from_statement(self, statement) -> None: ...
    def first(self): ...
    def one_or_none(self): ...
    def one(self): ...
    def scalar(self): ...
    def __iter__(self): ...
    @property
    def column_descriptions(self): ...
    def instances(self, result_proxy, context: Any | None = ...): ...
    def merge_result(self, iterator, load: bool = ...): ...
    def exists(self): ...
    def count(self): ...
    def delete(self, synchronize_session: str = ...): ...
    def update(self, values, synchronize_session: str = ..., update_args: Any | None = ...): ...

class FromStatement(GroupedElement, SelectBase, Executable):
    __visit_name__: str
    element: Any
    def __init__(self, entities, element) -> None: ...
    def get_label_style(self): ...
    def set_label_style(self, label_style): ...
    def get_children(self, **kw) -> None: ...  # type: ignore[override]

class AliasOption(interfaces.LoaderOption):
    def __init__(self, alias) -> None: ...
    inherit_cache: bool
    def process_compile_state(self, compile_state) -> None: ...

class BulkUD:
    query: Any
    mapper: Any
    def __init__(self, query) -> None: ...
    @property
    def session(self): ...

class BulkUpdate(BulkUD):
    values: Any
    update_kwargs: Any
    def __init__(self, query, values, update_kwargs) -> None: ...

class BulkDelete(BulkUD): ...
