# This sample tests the name binder's handling of
# try/except/raise statements


def func1():

    try:
        pass
    except:
        raise

    raise


def func2(x, y) -> bool:
    try:
        z = x / y
    except (RuntimeError, NameError) as e:
        reveal_type(e, expected_text="RuntimeError | NameError")
        return False
    except Exception as e:
        reveal_type(e, expected_text="Exception")
        return False
    except:
        raise Exception()
    else:
        return True

    # This should not generate an error
    # because this code is unreachable.
    return "hello"


def func3():
    # This should generate an error because there is no
    # except or finally clause.
    try:
        pass
    