/*
 * unicode.ts
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT license.
 * Author: Eric Traut
 *
 * Tables that encode Unicode character codes for various Unicode-
 * defined categories used in the Python spec. These tables were built
 * from the npm package unicode, which contains the same information
 * in a much more verbose form.
 */

export type UnicodeRange = [number, number] | number;
export type UnicodeRangeTable = UnicodeRange[];
export type UnicodeSurrogateRangeTable = { [surrogate: number]: UnicodeRange[] };

export const unicodeLu: UnicodeRangeTable = [
    [65, 90],
    [192, 214],
    [216, 222],
    256,
    258,
    260,
    262,
    264,
    266,
    268,
    270,
    272,
    274,
    276,
    278,
    280,
    282,
    284,
    286,
    288,
    290,
    292,
    294,
    296,
    298,
    300,
    302,
    304,
    306,
    308,
    310,
    313,
    315,
    317,
    319,
    321,
    323,
    325,
    327,
    330,
    332,
    334,
    336,
    338,
    340,
    342,
    344,
    346,
    348,
    350,
    352,
    354,
    356,
    358,
    360,
    362,
    364,
    366,
    368,
    370,
    372,
    374,
    [376, 377],
    379,
    381,
    [385, 386],
    388,
    [390, 391],
    [393, 395],
    [398, 401],
    [403, 404],
    [406, 408],
    [412, 413],
    [415, 416],
    418,
    420,
    [422, 423],
    425,
    428,
    [430, 431],
    [433, 435],
    437,
    [439, 440],
    444,
    452,
    455,
    458,
    461,
    463,
    465,
    467,
    469,
    471,
    473,
    475,
    478,
    480,
    482,
    484,
    486,
    488,
    490,
    492,
    494,
    497,
    500,
    [502, 504],
    506,
    508,
    510,
    512,
    514,
    516,
    518,
    520,
    522,
    524,
    526,
    528,
    530,
    532,
    534,
    536,
    538,
    540,
    542,
    544,
    546,
    548,
    550,
    552,
    554,
    556,
    558,
    560,
    562,
    [570, 571],
    [573, 574],
    577,
    [579, 582],
    584,
    586,
    588,
    590,
    880,
    882,
    886,
    895,
    902,
    [904, 906],
    908,
    [910, 911],
    [913, 929],
    [931, 939],
    975,
    [978, 980],
    984,
    986,
    988,
    990,
    992,
    994,
    996,
    998,
    1000,
    1002,
    1004,
    1006,
    1012,
    1015,
    [1017, 1018],
    [1021, 1071],
    1120,
    1122,
    1124,
    1126,
    1128,
    1130,
    1132,
    1134,
    1136,
    1138,
    1140,
    1142,
    1144,
    1146,
    1148,
    1150,
    1152,
    1162,
    1164,
    1166,
    1168,
    1170,
    1172,
    1174,
    1176,
    1178,
    1180,
    1182,
    1184,
    1186,
    1188,
    1190,
    1192,
    1194,
    1196,
    1198,
    1200,
    1202,
    1204,
    1206,
    1208,
    1210,
    1212,
    1214,
    [1216, 1217],
    1219,
    1221,
    1223,
    1225,
    1227,
    1229,
    1232,
    1234,
    1236,
    1238,
    1240,
    1242,
    1244,
    1246,
    1248,
    1250,
    1252,
    1254,
    1256,
    1258,
    1260,
    1262,
    1264,
    1266,
    1268,
    1270,
    1272,
    1274,
    1276,
    1278,
    1280,
    1282,
    1284,
    1286,
    1288,
    1290,
    1292,
    1294,
    1296,
    1298,
    1300,
    1302,
    1304,
    1306,
    1308,
    1310,
    1312,
    1314,
    1316,
    1318,
    1320,
    1322,
    1324,
    1326,
    [1329, 1366],
    [4256, 4293],
    4295,
    4301,
    [5024, 5109],
    7680,
    7682,
    7684,
    7686,
    7688,
    7690,
    7692,
    7694,
    7696,
    7698,
    7700,
    7702,
    7704,
    7706,
    7708,
    7710,
    7712,
    7714,
    7716,
    7718,
    7720,
    7722,
    7724,
    7726,
    7728,
    7730,
    7732,
    7734,
    7736,
    7738,
    7740,
    7742,
    7744,
    7746,
    7748,
    7750,
    7752,
    7754,
    7756,
    7758,
    7760,
    7762,
    7764,
    7766,
    7768,
    7770,
    7772,
    7774,
    7776,
    7778,
    7780,
    7782,
    7784,
    7786,
    7788,
    7790,
    7792,
    7794,
    7796,
    7798,
    7800,
    7802,
    7804,
    7806,
    7808,
    7810,
    7812,
    7814,
    7816,
    7818,
    7820,
    7822,
    7824,
    7826,
    7828,
    7838,
    7840,
    7842,
    7844,
    7846,
    7848,
    7850,
    7852,
    7854,
    7856,
    7858,
    7860,
    7862,
    7864,
    7866,
    7868,
    7870,
    7872,
    7874,
    7876,
    7878,
    7880,
    7882,
    7884,
    7886,
    7888,
    7890,
    7892,
    7894,
    7896,
    7898,
    7900,
    7902,
    7904,
    7906,
    7908,
    7910,
    7912,
    7914,
    7916,
    7918,
    7920,
    7922,
    7924,
    7926,
    7928,
    7930,
    7932,
    7934,
    [7944, 7951],
    [7960, 7965],
    [7976, 7983],
    [7992, 7999],
    [8008, 8013],
    8025,
    8027,
    8029,
    8031,
    [8040, 8047],
    [8120, 8123],
    [8136, 8139],
    [8152, 8155],
    [8168, 8172],
    [8184, 8187],
    8450,
    8455,
    [8459, 8461],
    [8464, 8466],
    8469,
    [8473, 8477],
    8484,
    8486,
    8488,
    [8490, 8493],
    [8496, 8499],
    [8510, 8511],
    8517,
    8579,
    [11264, 11310],
    11360,
    [11362, 11364],
    11367,
    11369,
    11371,
    [11373, 11376],
    11378,
    11381,
    [11390, 11392],
    11394,
    11396,
    11398,
    11400,
    11402,
    11404,
    11406,
    11408,
    11410,
    11412,
    11414,
    11416,
    11418,
    11420,
    11422,
    11424,
    11426,
    11428,
    11430,
    11432,
    11434,
    11436,
    11438,
    11440,
    11442,
    11444,
    11446,
    11448,
    11450,
    11452,
    11454,
    11456,
    11458,
    11460,
    11462,
    11464,
    11466,
    11468,
    11470,
    11472,
    11474,
    11476,
    11478,
    11480,
    11482,
    11484,
    11486,
    11488,
    11490,
    11499,
    11501,
    11506,
    42560,
    42562,
    42564,
    42566,
    42568,
    42570,
    42572,
    42574,
    42576,
    42578,
    42580,
    42582,
    42584,
    42586,
    42588,
    42590,
    42592,
    42594,
    42596,
    42598,
    42600,
    42602,
    42604,
    42624,
    42626,
    42628,
    42630,
    42632,
    42634,
    42636,
    42638,
    42640,
    42642,
    42644,
    42646,
    42648,
    42650,
    42786,
    42788,
    42790,
    42792,
    42794,
    42796,
    42798,
    42802,
    42804,
    42806,
    42808,
    42810,
    42812,
    42814,
    42816,
    42818,
    42820,
    42822,
    42824,
    42826,
    42828,
    42830,
    42832,
    42834,
    42836,
    42838,
    42840,
    42842,
    42844,
    42846,
    42848,
    42850,
    42852,
    42854,
    42856,
    42858,
    42860,
    42862,
    42873,
    42875,
    [42877, 42878],
    42880,
    42882,
    42884,
    42886,
    42891,
    42893,
    42896,
    42898,
    42902,
    42904,
    42906,
    42908,
    42910,
    42912,
    42914,
    42916,
    42918,
    42920,
    [42922, 42926],
    [42928, 42932],
    42934,
    [65313, 65338],
    [66560, 66599],
    [66736, 66771],
    [68736, 68786],
    [71840, 71871],
    [119808, 119833],
    [119860, 119885],
    [119912, 119937],
    119964,
    [119966, 119967],
    119970,
    [119973, 119974],
    [119977, 119980],
    [119982, 119989],
    [120016, 120041],
    [120068, 120069],
    [120071, 120074],
    [120077, 120084],
    [120086, 120092],
    [120120, 120121],
    [120123, 120126],
    [120128, 120132],
    120134,
    [120138, 120144],
    [120172, 120197],
    [120224, 120249],
    [120276, 120301],
    [120328, 120353],
    [120380, 120405],
    [120432, 120457],
    [120488, 120512],
    [120546, 120570],
    [120604, 120628],
    [120662, 120686],
    [120720, 120744],
    120778,
    [125184, 125217],
];

export const unicodeLuSurrogate: UnicodeSurrogateRangeTable = {
    55297: [
        [56320, 56359],
        [56496, 56531],
    ],
    55299: [[56448, 56498]],
    55302: [[56480, 56511]],
    55323: [[56896, 56927]],
    55349: [
        [56320, 56345],
        [56372, 56397],
        [56424, 56449],
        56476,
        [56478, 56479],
        56482,
        [56485, 56486],
        [56489, 56492],
        [56494, 56501],
        [56528, 56553],
        [56580, 56581],
        [56583, 56586],
        [56589, 56596],
        [56598, 56604],
        [56632, 56633],
        [56635, 56638],
        [56640, 56644],
        56646,
        [56650, 56656],
        [56684, 56709],
        [56736, 56761],
        [56788, 56813],
        [56840, 56865],
        [56892, 56917],
        [56944, 56969],
        [57000, 57024],
        [57058, 57082],
        [57116, 57140],
        [57174, 57198],
        [57232, 57256],
        [57290, 57290],
    ],
    55354: [[56576, 56609]],
};

export const unicodeLl: UnicodeRangeTable = [
    [97, 122],
    181,
    [223, 246],
    [248, 255],
    257,
    259,
    261,
    263,
    265,
    267,
    269,
    271,
    273,
    275,
    277,
    279,
    281,
    283,
    285,
    287,
    289,
    291,
    293,
    295,
    297,
    299,
    301,
    303,
    305,
    307,
    309,
    [311, 312],
    314,
    316,
    318,
    320,
    322,
    324,
    326,
    [328, 329],
    331,
    333,
    335,
    337,
    339,
    341,
    343,
    345,
    347,
    349,
    351,
    353,
    355,
    357,
    359,
    361,
    363,
    365,
    367,
    369,
    371,
    373,
    375,
    378,
    380,
    [382, 384],
    387,
    389,
    392,
    [396, 397],
    402,
    405,
    [409, 411],
    414,
    417,
    419,
    421,
    424,
    [426, 427],
    429,
    432,
    436,
    438,
    [441, 442],
    [445, 447],
    454,
    457,
    460,
    462,
    464,
    466,
    468,
    470,
    472,
    474,
    [476, 477],
    479,
    481,
    483,
    485,
    487,
    489,
    491,
    493,
    [495, 496],
    499,
    501,
    505,
    507,
    509,
    511,
    513,
    515,
    517,
    519,
    521,
    523,
    525,
    527,
    529,
    531,
    533,
    535,
    537,
    539,
    541,
    543,
    545,
    547,
    549,
    551,
    553,
    555,
    557,
    559,
    561,
    [563, 569],
    572,
    [575, 576],
    578,
    583,
    585,
    587,
    589,
    [591, 659],
    [661, 687],
    881,
    883,
    887,
    [891, 893],
    912,
    [940, 974],
    [976, 977],
    [981, 983],
    985,
    987,
    989,
    991,
    993,
    995,
    997,
    999,
    1001,
    1003,
    1005,
    [1007, 1011],
    1013,
    1016,
    [1019, 1020],
    [1072, 1119],
    1121,
    1123,
    1125,
    1127,
    1129,
    1131,
    1133,
    1135,
    1137,
    1139,
    1141,
    1143,
    1145,
    1147,
    1149,
    1151,
    1153,
    1163,
    1165,
    1167,
    1169,
    1171,
    1173,
    1175,
    1177,
    1179,
    1181,
    1183,
    1185,
    1187,
    1189,
    1191,
    1193,
    1195,
    1197,
    1199,
    1201,
    1203,
    1205,
    1207,
    1209,
    1211,
    1213,
    1215,
    1218,
    1220,
    1222,
    1224,
    1226,
    1228,
    [1230, 1231],
    1233,
    1235,
    1237,
    1239,
    1241,
    1243,
    1245,
    1247,
    1249,
    1251,
    1253,
    1255,
    1257,
    1259,
    1261,
    1263,
    1265,
    1267,
    1269,
    1271,
    1273,
    1275,
    1277,
    1279,
    1281,
    1283,
    1285,
    1287,
    1289,
    1291,
    1293,
    1295,
    1297,
    1299,
    1301,
    1303,
    1305,
    1307,
    1309,
    1311,
    1313,
    1315,
    1317,
    1319,
    1321,
    1323,
    1325,
    1327,
    [1377, 1415],
    [5112, 5117],
    [7296, 7304],
    [7424, 7467],
    [7531, 7543],
    [7545, 7578],
    7681,
    7683,
    7685,
    7687,
    7689,
    7691,
    7693,
    7695,
    7697,
    7699,
    7701,
    7703,
    7705,
    7707,
    7709,
    7711,
    7713,
    7715,
    7717,
    7719,
    7721,
    7723,
    7725,
    7727,
    7729,
    7731,
    7733,
    7735,
    7737,
    7739,
    7741,
    7743,
    7745,
    7747,
    7749,
    7751,
    7753,
    7755,
    7757,
    7759,
    7761,
    7763,
    7765,
    7767,
    7769,
    7771,
    7773,
    7775,
    7777,
    7779,
    7781,
    7783,
    7785,
    7787,
    7789,
    7791,
    7793,
    7795,
    7797,
    7799,
    7801,
    7803,
    7805,
    7807,
    7809,
    7811,
    7813,
    7815,
    7817,
    7819,
    7821,
    7823,
    7825,
    7827,
    [7829, 7837],
    7839,
    7841,
    7843,
    7845,
    7847,
    7849,
    7851,
    7853,
    7855,
    7857,
    7859,
    7861,
    7863,
    7865,
    7867,
    7869,
    7871,
    7873,
    7875,
    7877,
    7879,
    7881,
    7883,
    7885,
    7887,
    7889,
    7891,
    7893,
    7895,
    7897,
    7899,
    7901,
    7903,
    7905,
    7907,
    7909,
    7911,
    7913,
    7915,
    7917,
    7919,
    7921,
    7923,
    7925,
    7927,
    7929,
    7931,
    7933,
    [7935, 7943],
    [7952, 7957],
    [7968, 7975],
    [7984, 7991],
    [8000, 8005],
    [8016, 8023],
    [8032, 8039],
    [8048, 8061],
    [8064, 8071],
    [8080, 8087],
    [8096, 8103],
    [8112, 8116],
    [8118, 8119],
    8126,
    [8130, 8132],
    [8134, 8135],
    [8144, 8147],
    [8150, 8151],
    [8160, 8167],
    [8178, 8180],
    [8182, 8183],
    8458,
    [8462, 8463],
    8467,
    8495,
    8500,
    8505,
    [8508, 8509],
    [8518, 8521],
    8526,
    8580,
    [11312, 11358],
    11361,
    [11365, 11366],
    11368,
    11370,
    11372,
    11377,
    [11379, 11380],
    [11382, 11387],
    11393,
    11395,
    11397,
    11399,
    11401,
    11403,
    11405,
    11407,
    11409,
    11411,
    11413,
    11415,
    11417,
    11419,
    11421,
    11423,
    11425,
    11427,
    11429,
    11431,
    11433,
    11435,
    11437,
    11439,
    11441,
    11443,
    11445,
    11447,
    11449,
    11451,
    11453,
    11455,
    11457,
    11459,
    11461,
    11463,
    11465,
    11467,
    11469,
    11471,
    11473,
    11475,
    11477,
    11479,
    11481,
    11483,
    11485,
    11487,
    11489,
    [11491, 11492],
    11500,
    11502,
    11507,
    [11520, 11557],
    11559,
    11565,
    42561,
    42563,
    42565,
    42567,
    42569,
    42571,
    42573,
    42575,
    42577,
    42579,
    2581,
    42583,
    42585,
    42587,
    42589,
    42591,
    42593,
    42595,
    42597,
    42599,
    42601,
    42603,
    42605,
    42625,
    42627,
    42629,
    42631,
    42633,
    42635,
    42637,
    42639,
    42641,
    42643,
    42645,
    42647,
    42649,
    42651,
    42787,
    42789,
    42791,
    42793,
    42795,
    42797,
    [42799, 42801],
    42803,
    42805,
    42807,
    42809,
    42811,
    42813,
    42815,
    42817,
    42819,
    42821,
    42823,
    42825,
    42827,
    42829,
    42831,
    42833,
    42835,
    42837,
    42839,
    42841,
    42843,
    42845,
    42847,
    42849,
    42851,
    42853,
    42855,
    42857,
    42859,
    42861,
    42863,
    [42865, 42872],
    42874,
    42876,
    42879,
    42881,
    42883,
    42885,
    42887,
    42892,
    42894,
    42897,
    [42899, 42901],
    42903,
    42905,
    42907,
    42909,
    42911,
    42913,
    42915,
    42917,
    42919,
    42921,
    42933,
    42935,
    43002,
    [43824, 43866],
    [43872, 43877],
    [43888, 43967],
    [64256, 64262],
    [64275, 64279],
    [65345, 65370],
    [66600, 66639],
    [66776, 66811],
    [68800, 68850],
    [71872, 71903],
    [119834, 119859],
    [119886, 119892],
    [119894, 119911],
    [119938, 119963],
    [119990, 119993],
    119995,
    [119997, 120003],
    [120005, 120015],
    [120042, 120067],
    [120094, 120119],
    [120146, 120171],
    [120198, 120223],
    [120250, 120275],
    [120302, 120327],
    [120354, 120379],
    [120406, 120431],
    [120458, 120485],
    [120514, 120538],
    [120540, 120545],
    [120572, 120596],
    [120598, 120603],
    [120630, 120654],
    [120656, 120661],
    [120688, 120712],
    [120714, 120719],
    [120746, 120770],
    [120772, 120777],
    120779,
    [125218, 125251],
];

export const unicodeLlSurrogate: UnicodeSurrogateRangeTable = {
    55297: [
        [56360, 56399],
        [56536, 56571],
    ],
    55299: [[56512, 56562]],
    55302: [[56512, 56543]],
    55323: [[56928, 56959]],
    55349: [
        [56346, 56371],
        [56398, 56404],
        [56406, 56423],
        [56450, 56475],
        [56502, 56505],
        56507,
        [56509, 56515],
        [56517, 56527],
        [56554, 56579],
        [56606, 56631],
        [56658, 56683],
        [56710, 56735],
        [56762, 56787],
        [56814, 56839],
        [56866, 56891],
        [56918, 56943],
        [56970, 56997],
        [57026, 57050],
        [57052, 57057],
        [57084, 57108],
        [57110, 57115],
        [57142, 57166],
        [57168, 57173],
        [57200, 57224],
        [57226, 57231],
        [57258, 57282],
        [57284, 57289],
        [57291, 57291],
    ],
    55354: [[56610, 56643]],
};

export const unicodeLt: UnicodeRangeTable = [
    453,
    456,
    459,
    498,
    [8072, 8079],
    [8088, 8095],
    [8104, 8111],
    8124,
    8140,
    8188,
];

export const unicodeLo: UnicodeRangeTable = [
    170,
    186,
    443,
    [448, 451],
    660,
    [1488, 1514],
    [1520, 1522],
    [1568, 1599],
    [1601, 1610],
    [1646, 1647],
    [1649, 1747],
    1749,
    [1774, 1775],
    [1786, 1788],
    1791,
    1808,
    [1810, 1839],
    [1869, 1957],
    1969,
    [1994, 2026],
    [2048, 2069],
    [2112, 2136],
    [2144, 2154],
    [2208, 2228],
    [2230, 2237],
    [2308, 2361],
    2365,
    2384,
    [2392, 2401],
    [2418, 2432],
    [2437, 2444],
    [2447, 2448],
    [2451, 2472],
    [2474, 2480],
    2482,
    [2486, 2489],
    2493,
    2510,
    [2524, 2525],
    [2527, 2529],
    [2544, 2545],
    2556,
    [2565, 2570],
    [2575, 2576],
    [2579, 2600],
    [2602, 2608],
    [2610, 2611],
    [2613, 2614],
    [2616, 2617],
    [2649, 2652],
    2654,
    [2674, 2676],
    [2693, 2701],
    [2703, 2705],
    [2707, 2728],
    [2730, 2736],
    [2738, 2739],
    [2741, 2745],
    2749,
    2768,
    [2784, 2785],
    2809,
    [2821, 2828],
    [2831, 2832],
    [2835, 2856],
    [2858, 2864],
    [2866, 2867],
    [2869, 2873],
    2877,
    [2908, 2909],
    [2911, 2913],
    2929,
    2947,
    [2949, 2954],
    [2958, 2960],
    [2962, 2965],
    [2969, 2970],
    2972,
    [2974, 2975],
    [2979, 2980],
    [2984, 2986],
    [2990, 3001],
    3024,
    [3077, 3084],
    [3086, 3088],
    [3090, 3112],
    [3114, 3129],
    3133,
    [3160, 3162],
    [3168, 3169],
    3200,
    [3205, 3212],
    [3214, 3216],
    [3218, 3240],
    [3242, 3251],
    [3253, 3257],
    3261,
    3294,
    [3296, 3297],
    [3313, 3314],
    [3333, 3340],
    [3342, 3344],
    [3346, 3386],
    3389,
    3406,
    [3412, 3414],
    [3423, 3425],
    [3450, 3455],
    [3461, 3478],
    [3482, 3505],
    [3507, 3515],
    3517,
    [3520, 3526],
    [3585, 3632],
    [3634, 3635],
    [3648, 3653],
    [3713, 3714],
    3716,
    [3719, 3720],
    3722,
    3725,
    [3732, 3735],
    [3737, 3743],
    [3745, 3747],
    3749,
    3751,
    [3754, 3755],
    [3757, 3760],
    [3762, 3763],
    3773,
    [3776, 3780],
    [3804, 3807],
    3840,
    [3904, 3911],
    [3913, 3948],
    [3976, 3980],
    [4096, 4138],
    4159,
    [4176, 4181],
    [4186, 4189],
    4193,
    [4197, 4198],
    [4206, 4208],
    [4213, 4225],
    4238,
    [4304, 4346],
    [4349, 4680],
    [4682, 4685],
    [4688, 4694],
    4696,
    [4698, 4701],
    [4704, 4744],
    [4746, 4749],
    [4752, 4784],
    [4786, 4789],
    [4792, 4798],
    4800,
    [4802, 4805],
    [4808, 4822],
    [4824, 4880],
    [4882, 4885],
    [4888, 4954],
    [4992, 5007],
    [5121, 5740],
    [5743, 5759],
    [5761, 5786],
    [5792, 5866],
    [5873, 5880],
    [5888, 5900],
    [5902, 5905],
    [5920, 5937],
    [5952, 5969],
    [5984, 5996],
    [5998, 6000],
    [6016, 6067],
    6108,
    [6176, 6210],
    [6212, 6263],
    [6272, 6276],
    [6279, 6312],
    6314,
    [6320, 6389],
    [6400, 6430],
    [6480, 6509],
    [6512, 6516],
    [6528, 6571],
    [6576, 6601],
    [6656, 6678],
    [6688, 6740],
    [6917, 6963],
    [6981, 6987],
    [7043, 7072],
    [7086, 7087],
    [7098, 7141],
    [7168, 7203],
    [7245, 7247],
    [7258, 7287],
    [7401, 7404],
    [7406, 7409],
    [7413, 7414],
    [8501, 8504],
    [11568, 11623],
    [11648, 11670],
    [11680, 11686],
    [11688, 11694],
    [11696, 11702],
    [11704, 11710],
    [11712, 11718],
    [11720, 11726],
    [11728, 11734],
    [11736, 11742],
    12294,
    12348,
    [12353, 12438],
    12447,
    [12449, 12538],
    12543,
    [12549, 12590],
    [12593, 12686],
    [12704, 12730],
    [12784, 12799],
    [13312, 19893],
    [19968, 40938],
    [40960, 40980],
    [40982, 42124],
    [42192, 42231],
    [42240, 42507],
    [42512, 42527],
    [42538, 42539],
    42606,
    [42656, 42725],
    42895,
    42999,
    [43003, 43009],
    [43011, 43013],
    [43015, 43018],
    [43020, 43042],
    [43072, 43123],
    [43138, 43187],
    [43250, 43255],
    43259,
    43261,
    [43274, 43301],
    [43312, 43334],
    [43360, 43388],
    [43396, 43442],
    [43488, 43492],
    [43495, 43503],
    [43514, 43518],
    [43520, 43560],
    [43584, 43586],
    [43588, 43595],
    [43616, 43631],
    [43633, 43638],
    43642,
    [43646, 43695],
    43697,
    [43701, 43702],
    [43705, 43709],
    43712,
    43714,
    [43739, 43740],
    [43744, 43754],
    43762,
    [43777, 43782],
    [43785, 43790],
    [43793, 43798],
    [43808, 43814],
    [43816, 43822],
    [43968, 44002],
    [44032, 55203],
    [55216, 55238],
    [55243, 55291],
    [63744, 64109],
    [64112, 64217],
    64285,
    [64287, 64296],
    [64298, 64310],
    [64312, 64316],
    64318,
    [64320, 64321],
    [64323, 64324],
    [64326, 64433],
    [64467, 64829],
    [64848, 64911],
    [64914, 64967],
    [65008, 65019],
    [65136, 65140],
    [65142, 65276],
    [65382, 65391],
    [65393, 65437],
    [65440, 65470],
    [65474, 65479],
    [65482, 65487],
    [65490, 65495],
    [65498, 65500],
    [65536, 65547],
    [65549, 65574],
    [65576, 65594],
    [65596, 65597],
    [65599, 65613],
    [65616, 65629],
    [65664, 65786],
    [66176, 66204],
    [66208, 66256],
    [66304, 66335],
    [66349, 66368],
    [66370, 66377],
    [66384, 66421],
    [66432, 66461],
    [66464, 66499],
    [66504, 66511],
    [66640, 66717],
    [66816, 66855],
    [66864, 66915],
    [67072, 67382],
    [67392, 67413],
    [67424, 67431],
    [67584, 67589],
    67592,
    [67594, 67637],
    [67639, 67640],
    67644,
    [67647, 67669],
    [67680, 67702],
    [67712, 67742],
    [67808, 67826],
    [67828, 67829],
    [67840, 67861],
    [67872, 67897],
    [67968, 68023],
    [68030, 68031],
    68096,
    [68112, 68115],
    [68117, 68119],
    [68121, 68147],
    [68192, 68220],
    [68224, 68252],
    [68288, 68295],
    [68297, 68324],
    [68352, 68405],
    [68416, 68437],
    [68448, 68466],
    [68480, 68497],
    [68608, 68680],
    [69635, 69687],
    [69763, 69807],
    [69840, 69864],
    [69891, 69926],
    [69968, 70002],
    70006,
    [70019, 70066],
    [70081, 70084],
    70106,
    70108,
    [70144, 70161],
    [70163, 70187],
    [70272, 70278],
    70280,
    [70282, 70285],
    [70287, 70301],
    [70303, 70312],
    [70320, 70366],
    [70405, 70412],
    [70415, 70416],
    [70419, 70440],
    [70442, 70448],
    [70450, 70451],
    [70453, 70457],
    70461,
    70480,
    [70493, 70497],
    [70656, 70708],
    [70727, 70730],
    [70784, 70831],
    [70852, 70853],
    70855,
    [71040, 71086],
    [71128, 71131],
    [71168, 71215],
    71236,
    [71296, 71338],
    [71424, 71449],
    71935,
    72192,
    [72203, 72242],
    72250,
    72272,
    [72284, 72323],
    [72326, 72329],
    [72384, 72440],
    [72704, 72712],
    [72714, 72750],
    72768,
    [72818, 72847],
    [72960, 72966],
    [72968, 72969],
    [72971, 73008],
    73030,
    [73728, 74649],
    [74880, 75075],
    [77824, 78894],
    [82944, 83526],
    [92160, 92728],
    [92736, 92766],
    [92880, 92909],
    [92928, 92975],
    [93027, 93047],
    [93053, 93071],
    [93952, 94020],
    94032,
    [94208, 100332],
    [100352, 101106],
    [110592, 110878],
    [110960, 111355],
    [113664, 113770],
    [113776, 113788],
    [113792, 113800],
    [113808, 113817],
    [124928, 125124],
    [126464, 126467],
    [126469, 126495],
    [126497, 126498],
    126500,
    126503,
    [126505, 126514],
    [126516, 126519],
    126521,
    126523,
    126530,
    126535,
    126537,
    126539,
    [126541, 126543],
    [126545, 126546],
    126548,
    126551,
    126553,
    126555,
    126557,
    126559,
    [126561, 126562],
    126564,
    [126567, 126570],
    [126572, 126578],
    [126580, 126583],
    [126585, 126588],
    126590,
    [126592, 126601],
    [126603, 126619],
    [126625, 126627],
    [126629, 126633],
    [126635, 126651],
    [131072, 173782],
    [173824, 177972],
    [177984, 178205],
    [178208, 183969],
    [183984, 191456],
    [194560, 195101],
];

export const unicodeLoSurrogate: UnicodeSurrogateRangeTable = {
    55296: [
        [56320, 56331],
        [56333, 56358],
        [56360, 56378],
        [56380, 56381],
        [56383, 56397],
        [56400, 56413],
        [56448, 56570],
        [56960, 56988],
        [56992, 57040],
        [57088, 57119],
        [57133, 57152],
        [57154, 57161],
        [57168, 57205],
        [57216, 57245],
        [57248, 57283],
        [57288, 57295],
    ],
    55297: [
        [56400, 56477],
        [56576, 56615],
        [56624, 56675],
        [56832, 57142],
        [57152, 57173],
        [57184, 57191],
    ],
    55298: [
        [56320, 56325],
        [56328, 56328],
        [56330, 56373],
        [56375, 56376],
        [56380, 56380],
        [56383, 56405],
        [56416, 56438],
        [56448, 56478],
        [56544, 56562],
        [56564, 56565],
        [56576, 56597],
        [56608, 56633],
        [56704, 56759],
        [56766, 56767],
        [56832, 56832],
        [56848, 56851],
        [56853, 56855],
        [56857, 56885],
        [56928, 56956],
        [56960, 56988],
        [57024, 57031],
        [57033, 57060],
        [57088, 57141],
        [57152, 57173],
        [57184, 57202],
        [57216, 57233],
    ],
    55299: [
        [56320, 56392],
        [56576, 56611],
        [56960, 57001],
        [57008, 57009],
        [57088, 57116],
        57127,
        [57136, 57157],
        [57264, 57284],
        [57312, 57334],
    ],
    55300: [
        [56323, 56375],
        [56451, 56495],
        [56528, 56552],
        [56579, 56614],
        56644,
        56647,
        [56656, 56690],
        56694,
        [56707, 56754],
        [56769, 56772],
        56794,
        56796,
        [56832, 56849],
        [56851, 56875],
        [56960, 56966],
        56968,
        [56970, 56973],
        [56975, 56989],
        [56991, 57000],
        [57008, 57054],
        [57093, 57100],
        [57103, 57104],
        [57107, 57128],
        [57130, 57136],
        [57138, 57139],
        [57141, 57145],
        57149,
        57168,
        [57181, 57185],
    ],
    55301: [
        [56320, 56372],
        [56391, 56394],
        [56415, 56417],
        [56448, 56495],
        [56516, 56517],
        56519,
        [56704, 56750],
        [56792, 56795],
        [56832, 56879],
        56900,
        [56960, 57002],
        57016,
        [57088, 57114],
    ],
    55302: [
        [56320, 56363],
        [56575, 56582],
        56585,
        [56588, 56595],
        [56597, 56598],
        [56600, 56623],
        56639,
        56641,
        [56736, 56743],
        [56746, 56784],
        56801,
        56803,
        56832,
        [56843, 56882],
        56890,
        56912,
        [56924, 56969],
        56989,
        [57024, 57080],
    ],
    55303: [
        [56320, 56328],
        [56330, 56366],
        56384,
        56434,
        [56576, 56582],
        [56584, 56585],
        [56587, 56624],
        56646,
        [56672, 56677],
        [56679, 56680],
        [56682, 56713],
        56728,
        [57056, 57074],
        57264,
    ],
    55304: [[56320, 57241]],
    55305: [[56448, 56643]],
    55308: [[56320, 57343]],
    55309: [[56320, 56366]],
    55313: [[56320, 56902]],
    55322: [
        [56320, 56888],
        [56896, 56926],
        [57040, 57069],
        [57088, 57135],
        [57187, 57207],
        [57213, 57231],
    ],
    55323: [[57088, 57162], 57168],
    55324: [56320],
    55329: [57335],
    55330: [[56320, 57343]],
    55331: [
        [56320, 56533],
        [56576, 56576],
        [56584, 56584],
    ],
    55340: [
        [56320, 56606],
        [56656, 56658],
        [56676, 56679],
        [56688, 57083],
    ],
    55343: [
        [56320, 56426],
        [56432, 56444],
        [56448, 56456],
        [56464, 56473],
    ],
    55352: [[56576, 56620], 56654, [57024, 57067]],
    55354: [[56320, 56516]],
    55355: [
        [56832, 56835],
        [56837, 56863],
        [56865, 56866],
        56868,
        56871,
        [56873, 56882],
        [56884, 56887],
        56889,
        56891,
        56898,
        56903,
        56905,
        56907,
        [56909, 56911],
        [56913, 56914],
        56916,
        56919,
        56921,
        56923,
        56925,
        56927,
        [56929, 56930],
        56932,
        [56935, 56938],
        [56940, 56946],
        [56948, 56951],
        [56953, 56956],
        56958,
        [56960, 56969],
        [56971, 56987],
        [56993, 56995],
        [56997, 57001],
        [57003, 57019],
    ],
    55360: [56320],
    55401: [57053, 57088],
    55405: [57140, 57152],
    55406: [56349, 56352],
    55411: [56993, 57008],
    55418: [57312],
    55422: [[56320, 56861]],
    55424: [56320],
    55428: [57162],
};

export const unicodeLm: UnicodeRangeTable = [
    [688, 705],
    [710, 721],
    [736, 740],
    748,
    750,
    884,
    890,
    1369,
    1600,
    [1765, 1766],
    [2036, 2037],
    2042,
    2074,
    2084,
    2088,
    2417,
    3654,
    3782,
    4348,
    6103,
    6211,
    6823,
    [7288, 7293],
    [7468, 7530],
    7544,
    [7579, 7615],
    8305,
    8319,
    [8336, 8348],
    [11388, 11389],
    11631,
    11823,
    12293,
    [12337, 12341],
    12347,
    [12445, 12446],
    [12540, 12542],
    40981,
    [42232, 42237],
    42508,
    42623,
    [42652, 42653],
    [42775, 42783],
    42864,
    42888,
    [43000, 43001],
    43471,
    43494,
    43632,
    43741,
    [43763, 43764],
    [43868, 43871],
    65392,
    [65438, 65439],
    [92992, 92995],
    [94099, 94111],
    [94176, 94177],
];

export const unicodeLmSurrogate: UnicodeSurrogateRangeTable = {
    55322: [[57152, 57155]],
    55323: [[57235, 57247], [57312, 57313], 57315],
    55352: [[56631, 56637]],
    55354: [56651],
};

export const unicodeNl: UnicodeRangeTable = [
    [5870, 5872],
    [8544, 8578],
    [8581, 8584],
    12295,
    [12321, 12329],
    [12344, 12346],
    [42726, 42735],
    [65856, 65908],
    66369,
    66378,
    [66513, 66517],
    [74752, 74862],
];

export const unicodeNlSurrogate: UnicodeSurrogateRangeTable = {
    55296: [[56640, 56692], 57153, 57162, [57297, 57301]],
    55305: [[56320, 56430]],
};

export const unicodeMn: UnicodeRangeTable = [
    [768, 879],
    [1155, 1159],
    [1425, 1469],
    1471,
    [1473, 1474],
    [1476, 1477],
    1479,
    [1552, 1562],
    [1611, 1631],
    1648,
    [1750, 1756],
    [1759, 1764],
    [1767, 1768],
    [1770, 1773],
    1809,
    [1840, 1866],
    [1958, 1968],
    [2027, 2035],
    [2070, 2073],
    [2075, 2083],
    [2085, 2087],
    [2089, 2093],
    [2137, 2139],
    [2260, 2273],
    [2275, 2306],
    2362,
    2364,
    [2369, 2376],
    2381,
    [2385, 2391],
    [2402, 2403],
    2433,
    2492,
    [2497, 2500],
    2509,
    [2530, 2531],
    [2561, 2562],
    2620,
    [2625, 2626],
    [2631, 2632],
    [2635, 2637],
    2641,
    [2672, 2673],
    2677,
    [2689, 2690],
    2748,
    [2753, 2757],
    [2759, 2760],
    2765,
    [2786, 2787],
    [2810, 2815],
    2817,
    2876,
    2879,
    [2881, 2884],
    2893,
    2902,
    [2914, 2915],
    2946,
    3008,
    3021,
    3072,
    [3134, 3136],
    [3142, 3144],
    [3146, 3149],
    [3157, 3158],
    [3170, 3171],
    3201,
    3260,
    3263,
    3270,
    [3276, 3277],
    [3298, 3299],
    [3328, 3329],
    [3387, 3388],
    [3393, 3396],
    3405,
    [3426, 3427],
    3530,
    [3538, 3540],
    3542,
    3633,
    [3636, 3642],
    [3655, 3662],
    3761,
    [3764, 3769],
    [3771, 3772],
    [3784, 3789],
    [3864, 3865],
    3893,
    3895,
    3897,
    [3953, 3966],
    [3968, 3972],
    [3974, 3975],
    [3981, 3991],
    [3993, 4028],
    4038,
    [4141, 4144],
    [4146, 4151],
    [4153, 4154],
    [4157, 4158],
    [4184, 4185],
    [4190, 4192],
    [4209, 4212],
    4226,
    [4229, 4230],
    4237,
    4253,
    [4957, 4959],
    [5906, 5908],
    [5938, 5940],
    [5970, 5971],
    [6002, 6003],
    [6068, 6069],
    [6071, 6077],
    6086,
    [6089, 6099],
    6109,
    [6155, 6157],
    [6277, 6278],
    6313,
    [6432, 6434],
    [6439, 6440],
    6450,
    [6457, 6459],
    [6679, 6680],
    6683,
    6742,
    [6744, 6750],
    6752,
    6754,
    [6757, 6764],
    [6771, 6780],
    6783,
    [6832, 6845],
    [6912, 6915],
    6964,
    [6966, 6970],
    6972,
    6978,
    [7019, 7027],
    [7040, 7041],
    [7074, 7077],
    [7080, 7081],
    [7083, 7085],
    7142,
    [7144, 7145],
    7149,
    [7151, 7153],
    [7212, 7219],
    [7222, 7223],
    [7376, 7378],
    [7380, 7392],
    [7394, 7400],
    7405,
    7412,
    [7416, 7417],
    [7616, 7673],
    [7675, 7679],
    [8400, 8412],
    8417,
    [8421, 8432],
    [11503, 11505],
    11647,
    [11744, 11775],
    [12330, 12333],
    [12441, 12442],
    42607,
    [42612, 42621],
    [42654, 42655],
    [42736, 42737],
    43010,
    43014,
    43019,
    [43045, 43046],
    [43204, 43205],
    [43232, 43249],
    [43302, 43309],
    [43335, 43345],
    [43392, 43394],
    43443,
    [43446, 43449],
    43452,
    43493,
    [43561, 43566],
    [43569, 43570],
    [43573, 43574],
    43587,
    43596,
    43644,
    43696,
    [43698, 43700],
    [43703, 43704],
    [43710, 43711],
    43713,
    [43756, 43757],
    43766,
    44005,
    44008,
    44013,
    64286,
    [65024, 65039],
    [65056, 65071],
    66045,
    66272,
    [66422, 66426],
    [68097, 68099],
    [68101, 68102],
    [68108, 68111],
    [68152, 68154],
    68159,
    [68325, 68326],
    69633,
    [69688, 69702],
    [69759, 69761],
    [69811, 69814],
    [69817, 69818],
    [69888, 69890],
    [69927, 69931],
    [69933, 69940],
    70003,
    [70016, 70017],
    [70070, 70078],
    [70090, 70092],
    [70191, 70193],
    70196,
    [70198, 70199],
    70206,
    70367,
    [70371, 70378],
    [70400, 70401],
    70460,
    70464,
    [70502, 70508],
    [70512, 70516],
    [70712, 70719],
    [70722, 70724],
    70726,
    [70835, 70840],
    70842,
    [70847, 70848],
    [70850, 70851],
    [71090, 71093],
    [71100, 71101],
    [71103, 71104],
    [71132, 71133],
    [71219, 71226],
    71229,
    [71231, 71232],
    71339,
    71341,
    [71344, 71349],
    71351,
    [71453, 71455],
    [71458, 71461],
    [71463, 71467],
    [72193, 72198],
    [72201, 72202],
    [72243, 72248],
    [72251, 72254],
    72263,
    [72273, 72278],
    [72281, 72283],
    [72330, 72342],
    [72344, 72345],
    [72752, 72758],
    [72760, 72765],
    72767,
    [72850, 72871],
    [72874, 72880],
    [72882, 72883],
    [72885, 72886],
    [73009, 73014],
    73018,
    [73020, 73021],
    [73023, 73029],
    73031,
    [92912, 92916],
    [92976, 92982],
    [94095, 94098],
    [113821, 113822],
    [119143, 119145],
    [119163, 119170],
    [119173, 119179],
    [119210, 119213],
    [119362, 119364],
    [121344, 121398],
    [121403, 121452],
    121461,
    121476,
    [121499, 121503],
    [121505, 121519],
    [122880, 122886],
    [122888, 122904],
    [122907, 122913],
    [122915, 122916],
    [122918, 122922],
    [125136, 125142],
    [125252, 125258],
    [917760, 917999],
];

export const unicodeMnSurrogate: UnicodeSurrogateRangeTable = {
    55296: [56829, 57056, [57206, 57210]],
    55298: [[56833, 56835], [56837, 56838], [56844, 56847], [56888, 56890], 56895, [57061, 57062]],
    55299: [
        [56612, 56615],
        [57003, 57004],
        [57158, 57168],
    ],
    55300: [
        56321,
        [56376, 56390],
        [56447, 56449],
        [56499, 56502],
        [56505, 56506],
        [56576, 56578],
        [56615, 56619],
        [56621, 56628],
        56691,
        [56704, 56705],
        [56758, 56766],
        [56777, 56780],
        56783,
        [56879, 56881],
        56884,
        [56886, 56887],
        56894,
        57055,
        [57059, 57066],
        [57088, 57089],
        [57147, 57148],
        57152,
        [57190, 57196],
        [57200, 57204],
    ],
    55301: [
        [56376, 56383],
        [56386, 56388],
        56390,
        56414,
        [56499, 56504],
        56506,
        [56511, 56512],
        [56514, 56515],
        [56754, 56757],
        [56764, 56765],
        [56767, 56768],
        [56796, 56797],
        [56883, 56890],
        56893,
        [56895, 56896],
        57003,
        57005,
        [57008, 57013],
        57015,
        [57117, 57119],
        [57122, 57125],
        [57127, 57131],
    ],
    55302: [
        [56367, 56375],
        [56377, 56378],
        [56635, 56636],
        56638,
        56643,
        [56788, 56791],
        [56794, 56795],
        56800,
        [56833, 56842],
        [56883, 56888],
        [56891, 56894],
        56903,
        [56913, 56918],
        [56921, 56923],
        [56970, 56982],
        [56984, 56985],
    ],
    55303: [
        [56368, 56374],
        [56376, 56381],
        56383,
        [56466, 56487],
        [56490, 56496],
        [56498, 56499],
        [56501, 56502],
        [56625, 56630],
        56634,
        [56636, 56637],
        [56639, 56645],
        56647,
        [56720, 56721],
        56725,
        56727,
        [57075, 57076],
    ],
    55322: [
        [57072, 57076],
        [57136, 57142],
    ],
    55323: [57167, [57231, 57234], 57316],
    55343: [[56477, 56478]],
    55348: [
        [56679, 56681],
        [56699, 56706],
        [56709, 56715],
        [56746, 56749],
        [56898, 56900],
    ],
    55350: [[56832, 56886], [56891, 56940], 56949, 56964, [56987, 56991], [56993, 57007]],
    55352: [
        [56320, 56326],
        [56328, 56344],
        [56347, 56353],
        [56355, 56356],
        [56358, 56362],
        [56624, 56630],
        [57068, 57071],
    ],
    55354: [
        [56528, 56534],
        [56644, 56650],
    ],
    56128: [[56576, 56815]],
};

export const unicodeMc: UnicodeRangeTable = [
    2307,
    2363,
    [2366, 2368],
    [2377, 2380],
    [2382, 2383],
    [2434, 2435],
    [2494, 2496],
    [2503, 2504],
    [2507, 2508],
    2519,
    2563,
    [2622, 2624],
    2691,
    [2750, 2752],
    2761,
    [2763, 2764],
    [2818, 2819],
    2878,
    2880,
    [2887, 2888],
    [2891, 2892],
    2903,
    [3006, 3007],
    [3009, 3010],
    [3014, 3016],
    [3018, 3020],
    3031,
    [3073, 3075],
    [3137, 3140],
    [3202, 3203],
    3262,
    [3264, 3268],
    [3271, 3272],
    [3274, 3275],
    [3285, 3286],
    [3330, 3331],
    [3390, 3392],
    [3398, 3400],
    [3402, 3404],
    3415,
    [3458, 3459],
    [3535, 3537],
    [3544, 3551],
    [3570, 3571],
    [3902, 3903],
    3967,
    [4139, 4140],
    4145,
    4152,
    [4155, 4156],
    [4182, 4183],
    [4194, 4196],
    [4199, 4205],
    [4227, 4228],
    [4231, 4236],
    4239,
    [4250, 4252],
    6070,
    [6078, 6085],
    [6087, 6088],
    [6435, 6438],
    [6441, 6443],
    [6448, 6449],
    [6451, 6456],
    [6681, 6682],
    6741,
    6743,
    6753,
    [6755, 6756],
    [6765, 6770],
    6916,
    6965,
    6971,
    [6973, 6977],
    [6979, 6980],
    7042,
    7073,
    [7078, 7079],
    7082,
    7143,
    [7146, 7148],
    7150,
    [7154, 7155],
    [7204, 7211],
    [7220, 7221],
    7393,
    [7410, 7411],
    7415,
    [12334, 12335],
    [43043, 43044],
    43047,
    [43136, 43137],
    [43188, 43203],
    [43346, 43347],
    43395,
    [43444, 43445],
    [43450, 43451],
    [43453, 43456],
    [43567, 43568],
    [43571, 43572],
    43597,
    43643,
    43645,
    43755,
    [43758, 43759],
    43765,
    [44003, 44004],
    [44006, 44007],
    [44009, 44010],
    44012,
    69632,
    69634,
    69762,
    [69808, 69810],
    [69815, 69816],
    69932,
    70018,
    [70067, 70069],
    [70079, 70080],
    [70188, 70190],
    [70194, 70195],
    70197,
    [70368, 70370],
    [70402, 70403],
    [70462, 70463],
    [70465, 70468],
    [70471, 70472],
    [70475, 70477],
    70487,
    [70498, 70499],
    [70709, 70711],
    [70720, 70721],
    70725,
    [70832, 70834],
    70841,
    [70843, 70846],
    70849,
    [71087, 71089],
    [71096, 71099],
    71102,
    [71216, 71218],
    [71227, 71228],
    71230,
    71340,
    [71342, 71343],
    71350,
    [71456, 71457],
    71462,
    [72199, 72200],
    72249,
    [72279, 72280],
    72343,
    72751,
    72766,
    72873,
    72881,
    72884,
    [94033, 94078],
    [119141, 119142],
    [119149, 119154],
];

export const unicodeMcSurrogate: UnicodeSurrogateRangeTable = {
    55300: [
        56320,
        56322,
        56450,
        [56496, 56498],
        [56503, 56504],
        56620,
        [56645, 56646],
        56706,
        [56755, 56757],
        [56767, 56768],
        56782,
        [56876, 56878],
        [56882, 56883],
        56885,
        [57056, 57058],
        [57090, 57091],
        [57150, 57151],
        [57153, 57156],
        [57159, 57160],
        [57163, 57165],
        57175,
        [57186, 57187],
    ],
    55301: [
        [56373, 56375],
        [56384, 56385],
        56389,
        [56496, 56498],
        56505,
        [56507, 56510],
        56513,
        [56751, 56753],
        [56760, 56763],
        56766,
        [56880, 56882],
        [56891, 56892],
        56894,
        57004,
        [57006, 57007],
        57014,
        [57120, 57121],
        57126,
    ],
    55302: [
        [56364, 56366],
        56376,
        [56624, 56629],
        [56631, 56632],
        56637,
        56640,
        56642,
        [56785, 56787],
        [56796, 56799],
        56804,
        56889,
        [56919, 56920],
        56983,
    ],
    55303: [56367, 56382, 56489, 56497, 56500, [56714, 56718], [56723, 56724], 56726, [57077, 57078]],
    55323: [
        [57169, 57223],
        [57328, 57329],
    ],
    55348: [
        [56677, 56678],
        [56685, 56690],
    ],
};

export const unicodeNd: UnicodeRangeTable = [
    [48, 57],
    [1632, 1641],
    [1776, 1785],
    [1984, 1993],
    [2406, 2415],
    [2534, 2543],
    [2662, 2671],
    [2790, 2799],
    [2918, 2927],
    [3046, 3055],
    [3174, 3183],
    [3302, 3311],
    [3430, 3439],
    [3558, 3567],
    [3664, 3673],
    [3792, 3801],
    [3872, 3881],
    [4160, 4169],
    [4240, 4249],
    [6112, 6121],
    [6160, 6169],
    [6470, 6479],
    [6608, 6617],
    [6784, 6793],
    [6800, 6809],
    [6992, 7001],
    [7088, 7097],
    [7232, 7241],
    [7248, 7257],
    [42528, 42537],
    [43216, 43225],
    [43264, 43273],
    [43472, 43481],
    [43504, 43513],
    [43600, 43609],
    [44016, 44025],
    [65296, 65305],
    [66720, 66729],
    [69734, 69743],
    [69872, 69881],
    [69942, 69951],
    [70096, 70105],
    [70384, 70393],
    [70736, 70745],
    [70864, 70873],
    [71248, 71257],
    [71360, 71369],
    [71472, 71481],
    [71904, 71913],
    [72784, 72793],
    [73040, 73049],
    [92768, 92777],
    [93008, 93017],
    [120782, 120831],
    [125264, 125273],
];

export const unicodeNdSurrogate: UnicodeSurrogateRangeTable = {
    55297: [[56480, 56489]],
    55299: [[56624, 56633]],
    55300: [
        [56422, 56431],
        [56560, 56569],
        [56630, 56639],
        [56784, 56793],
        [57072, 57081],
    ],
    55301: [
        [56400, 56409],
        [56528, 56537],
        [56912, 56921],
        [57024, 57033],
        [57136, 57145],
    ],
    55302: [[56544, 56553], 56656],
    55303: [
        [56400, 56409],
        [56656, 56665],
        [56736, 56745],
    ],
    55322: [
        [56928, 56937],
        [57168, 57177],
    ],
    55349: [[57294, 57343]],
    55352: [
        [56640, 56649],
        [57072, 57081],
    ],
    55354: [[56656, 56665]],
    55358: [[57328, 57337]],
};

export const unicodePc: UnicodeRangeTable = [95, [8255, 8256], 8276, [65075, 65076], [65101, 65103], 65343];
