# 程序员女子图鉴

《技术女子图鉴：迅雷链总工程师的日常》
分享嘉宾：迅雷链总工程师

## 比起百度腾讯，迅雷更适合我

我在学校里的时候经常有机会参与一些项目。毕业前去了百度，做分布式计算 MapReduce 系统，团队导师给了我很多的帮助，包括技术和习惯方面的。但是毕业之后我并没有留在百度，因为已经能比较清晰地看到多年后自己的状态。所以，世界那么大，我想出去看看。
我现在的 boss 迅雷集团 CEO 陈磊，也是我在腾讯公司的老板。他找到我的时候说腾讯在做云计算的事情，我非常看好云计算的分布式技术，就加入了腾讯。从分布式消息队列，到去中心化的负载均衡的系统，再到信鸽的消息推送，最后主要做产品和整体的解决方案。在腾讯四年半的时间，对我有一个全方面的提升，主要是以业务为导向的思维模式和理念上的提升。
后来，我带着这样的思维模式和理念来到迅雷。因为当时的我有一颗创业的心，想做成一件事。陈总给了我很多机会去成长，也很看重对我的培养，我也希望能跟他一起干成一翻事业。可以说后期我的管理经验，很大一部分是受老板管理艺术的熏陶。

做到技术上让人信服
在程序员这个职业中，女性相当少见，所以也非常占优势，大家都会很绅士的照顾你。但作为一名女总工，免不了经常受到外界质疑。其实，能否当 leader 的决定性因素并非性别，或是要从女神变成女汉子，而是在技术上能够让人信服。
比如我的区块链的项目，我会带着大家从 0 到 1，从提出技术方案到整体逻辑的讨论，再到异常情况的判断和思考，接着整体的监控运维体系如何去建立，大家在过程中能看到我的经验。开发人员遇到问题，我都会帮忙给些解决方案，当给的方案靠谱、逻辑正确，大家就会慢慢知道你很靠谱。
技术经历 = 分布式 + 区块链

我个人非常喜欢分布式技术，也看好它的应用前景。而区块链是一个更彻底的分布式，只是其中多了共识算法和一些密码学的知识。
比如做 DAPP，也是需要做域名解析到一个 IP 上去的。不同的是它不像我们以前做业务逻辑需要找一个中心化的存储，它本身可以依赖一个全量节点去获取数据，并且实时同步数据，各个节点是独立验证数据的。
再回头说迅雷的技术，大家都知道我们以前是做下载业务的，为什么会选择区块链呢？ 核心原因是我们原本做的就是一个大型分布式技术：我们的 P2P 网络技术具备了去中心化的能力，同时我们的共享计算产品，可供企业使用的节点数目前已达到 150 多万个，接下来就只需要解决信任和激励的问题了。区块链就是很好的解决方案。
我的初链，链如人生
迅雷链的开发过程就像自己的成长经历一样，每一个阶段都在被身边的人见证。之前的区块链造富神话，引起了一阵浮躁的气氛，疯狂之后大家都越来越清楚，区块链并不能在短时间内像传说中的那样改变世界。这是一场不断跌倒再爬起的持久战。
做任何一个产品，都要知道自己的起点在哪，终点在哪。P2P 网络和共享计算节点是我们的起点，提高用户的安全和体验度、提升企业的资源利用效率并降低成本是我们的终点。所以，迅雷链的设计，一方面要提高性能，提升用户体验，另一方面要让更多应用落到我们的智能合约上来。
首先，在提高性能方面，我们的目标是百万 TPS，如何达到呢？我们创造了一种叫做同构多链框架，顾名思义就是很多链并行，且每个链上都是相同的程序，不同的用户的请求会被分配到不同的链上。比如说转账交易中，将“A 转给 B”的这个请求放到一号链，“B 转给 C”放到二号链，“C 转到 D”放到三号链，这样“A 转给 B”，“B 转给 C”，“C 转给 D”的请求同时落到不同的链上，并发进行处理，整体的性能就能保证。而且，这个模式可以不断平行扩展。
其次，在用户体验方面，如何让用户获得秒级响应？这就要说到共识算法 PBFT 了，它的本身的性能很好还能容错，同时它的出块速度非常快，能够快速出块就能做到对用户的请求秒级确认了。而且它是这个强一致的算法，能够保证结果数据的不变性。
最后，在智能合约方面，如何让更多的应用落到迅雷链上？具备了百万并发的性能及秒级确认的体验，区块链应用具备了可大规模使用的可行性，剩下就是编写业务逻辑，迅雷链兼容 EVM，我们的开放平台官网上提供了 0 基础开发智能合约的指南。我们会给不同的开发者不同的合约链，甚至一个开发者如果请求量大可以用多条链，一方面让不同的开发者不互相影响，另一方面保证性能可以横向扩展。团队培养要有顺序，有方法
我带的团队包括区块链相关的底层团队、服务层团队、应用层团队、存储团队，玩客云相关的，包括玩客云服务器后台开发、固件业务开发、固件开发、前端、APP 等。另外还有玩客云的售卖研发团队也在我这里。

对于团队伙伴的成长，我着重从四个方面来培养：
一是编码质量。这个质量包括编码的习惯、单元测试、异常情况处理等，还需要考虑扩展性、设计模式。
二是整体的架构能力。包括考虑高并发、安全、容灾、扩展性等。
三是全局观。要能够从全局角度去看整个技术研发的事情，包括考虑整体的运维、监控、告警体系，从产品的角度考虑需求和价值。
四是规划能力，也是思考能力。要能看到前言的动态，看到整个行业的发展，包括自己负责的项目怎样优化和规划未来发展。
这些能力需要伙伴们勤奋努力，尤其是在迅雷网心这样一家带着浓厚创业氛围的公司里，团队的绝大部分人都是踏实做事、有冲劲、一根筋的去学习的那一类人。有很多工程师小伙伴想转型区块链，也来找我聊天，转型区块链有两种：
一个是去做应用开发，这个难度不大。因为智能合约和传统互联网技术的业务逻辑都差不多，只是语言不同，只需要多考虑升级和安全性的问题，对异常情况慎重处理即可。
另一个是，区块链技术也分基础层，服务层和应用层。基础层和服务层的开发者，需要对整个网络编程、操作系统、数据结构和算法、分布式等有所了解，最好再多了解些共识算法和密码学知识，这些也是我们招聘时区块链开发时最看重的一些点。
怎么解决程序员宝宝都比较内敛的问题
程序员宝宝都是比较内敛的，大部分比较内向。我们刚开始做区块链项目时，因为业内也没有很多区块链技术人才，我们就从其他团队调了一些精英过来，一开始大家都不熟，自己做自己的事情，感觉气氛怪怪的。
后来我在想，如何让大家拧成一股绳去做事情。用了个牵线的方法，比如 A 同学遇到问题，我让 B 去帮忙解决，A 同学看到了团队里还有更牛的人，B 同学帮助别人获得成就感，次数多了大家就彼此越来越信任了。至于是如何提升团队的凝聚力的？其实就是让大家有共同的目标，甚至共患难，共同挑战一个有难度的问题。
比如新产品上线，一般都是在半夜，上线过程中，难免会出现一些问题，如果某个同学负责的事情出了问题，我会让一群同学一起来帮忙。一来减轻了他的个人压力，更感激帮助他的这些同事。二来大家在帮忙的过程中也有了更多的交流。上线结束后，基本上就放开了。现在我不用担心他们的之间的凝聚力，只需要关心事情的结果。
最后，总结下我的日常
我的日常就是业务、沟通、维护技术氛围和学习。
业务方面要去为整个团队的后续发展不断规划和调整，为各个团队定每周和每月的目标，并且对结果进行验收。沟通方面需要不断找骨干聊天，了解大家工作上或个人方面遇到的一些问题和需要的帮助。还需要经常组织一些分享，请团队里各领域的人来分享经验共同成长。
再有就是不断学习了，要去了解业内动态，包括区块链业务如何落地，与合作伙伴聊产品需求。最后就是充当用户和合作伙伴的角色，看看我们自己的产品体验如何，文档写的是否逻辑清晰，平台上的接口有没有问题等。