# 程序员40岁后该如何发展

 

《 程序员的群体性焦虑高压下，如何实现个体的线性增长？》
 分享嘉宾： 刘超 （ 网易研究员云计算技术部首席架构师 ）


## 我的个人体验和探索

我大学是在上海交通大学里面唯一一个叫交通的专业，学习航运、集装箱和容器。因为感兴趣和为了好找工作，又学习了第二专业，计算机专业。没有学桌面软件制作、网站制作，而是主要学习操作系统、计算机网络、编译原理、算法与数据结构、数据库、计算机组成与系统结构，最后考研也是考的这个方向。毕业之后，首先面对的第一道关卡就是面试。我在这给大家总结了关于面试的几个套路。
第一类：薪资比较低的企业，面试的时候注重会不会做个网站，甚至上手做个东西出来。其实这类企业是在找代码熟练工。
第二类：越是薪资高的企业，越重视基础知识的考察。基础好，可塑性强，培养起来成长快。
第三类：最牛的公司一般面试考的是算法和思路。
说在话外：别怪 HR 太狠心，面试题目太奇葩。《经济学的思维方式》一书中写到，所有的稀缺品都需要以某种方式分配，必须建立某种规则和制度，对那些要求得到稀缺品的人加以甄别，决定谁该得到多少。价格只是最常用的一种方式。所以，面试前做好充足的准备很重要。
面试中，简历应该是什么样？
简单： 最长不要超过两页。
量化： 多写能够数字化、能量化的东西，少写一些模糊的东西。比如写到项目的时候，多说一些项目多大规模，处理多大的数据量，管理多少台机器，处理速度如何，实时性如何，使用什么技术等等，少说一些诸如“和团队精诚合作，能吃苦耐劳，善于沟通，什么北方人的豁达，什么南方人的细致”等，这些东西在简历中不能提供任何有价值的信息。
清晰： 整个简历尽量使用表格、列表形式，而非大段大段的描述性语言，多用专业词汇。
提取亮点： 首先你需要列出你做过的所有的项目，对于每一个项目，你可能做了很多细碎的工作，你需要做的是，从中发掘出你觉得有技术含量，能让看简历的人眼睛一亮的地方。
由点到面： 上面的亮点直接写上去，面试官一般会问这样的问题：你知道实现这个都有哪些方式？为什么选择用这个方式？各有什么优劣势？你需要将你的知识面扩展开来。比如负载均衡，LACP 可以做，等价路由可以做，F5 可以做，LVS 可以做，haproxy 可以做，nginx 可以做，OVS 可以做，iptables 可以做吗？
从面到体： 面试官还可能问，你用了这么久多线程，它们背后的原理是什么？所以你还应该了解背后的原理，如果你用的是 Java 多线程，各种线程同步机制的原理总应该清楚。例如 ip addr 命令，里面的很多细节其实往往都不注意。
理论升华： 上面说的都是招式，接下来应该练一练内功了。可以看一些经典书籍，这样除了会用，还能说的头头是道。比如《深入理解 Linux 网络技术内幕》《Concurrent Programming in Java》等等。

## 开源软件上手套路

在这个过程中，我为什么会不断地追求核心代码，分析代码，其实我就是追求最熟悉，求最核心、最本质，哪怕最困难，路最远。当你发现某一个技术在未来会成为一个很好的方向，你一定要攻克它，且一定要看经典，读源文档，在这里给大家分享一个开源软件上手套路：
手动安装起来，一定要手动；
使用一下，推荐 XXX in Action 系列；
读所有的官方文档，记不住，看不懂也要读下来；
了解核心的原理和算法，推荐 XXX the definitive guide 系列；
看一本源码分析的书，会让你的源码阅读之旅事半功倍；
开始阅读核心逻辑源代码；
编译并 Debug 源代码；
开发一个插件，或者对组件做少量的修改；
大量的运维实践经验和面向真实场景的定制开发。

## 程序员有哪些发展维度？

###  技术深度

有的人会选择更细的技术分支进行更深入的研究，继续扩大自己在技术深度这一维度的优势。此类人职业规划简单直接，就是成为某项技术的大牛，不希望找过多的需求结合点，就像郭靖一样，就是降龙十八掌一掌一掌练下去，就靠一技之长行走江湖。

###  架构广度

有的人希望对整个系统，从前端到后端，从底层到上层，都能够有一定程度的了解，也即开始扩展架构广度这一维度。此类人对每一项技术都会了解到一定的深度，能够搭建起整个系统，他们的职业规划就是成为架构师。 业务知识

有的人做软件是面向某个行业的，比如金融、证券、财务、航运、电力等。他们除了技术深度形成一定的优势外，也开始慢慢了解这些行业，于是扩展了另外一维——业务知识。他们能够迅速理解这些行业的业务需求，并转换成为软件需求。他们的职业规划就是需求分析师，他们需要更系统的学习业务方面的专业知识，以期能准确把握需求。

###  管理水平

有的人在成为技术主力后，由于有一定的沟通和组织能力，开始带新人，领导一些人完成任务，于是扩展了另外一维——管理水平。他们需要学习项目管理、组织行为学、绩效管理等方面的知识，职业规划是成为技术经理。
所有顺畅的表达，都是体系化的思考。

对于架构师来讲，表达能力也很重要，不但要自己会，也要给客户、产品经理、开发说明白。所以需要使用通俗易懂的方式表达深奥的知识。

没有什么天然会表达，口若悬河，只要涉及严肃的内容。如果没有体系化的思考和总结，现场肯定发挥不出来。从逐字稿开始准备，看起来随意的现场表达，都是熟练背诵后的轻松表现。
我在极客时间开设的专栏，是自己录的音频，觉得新闻联播主播很不容易，但有了一个全新的尝试。所以，技术人员不要鄙视不做技术的人，要讲给他们听，写给他们看，技术要为客户服务。
附：我在直播中推荐的基础必备书单

C：《The C Programming Langage》
C++：《Thinking in C++》《The C++ Programming Language》《Effective C++》《More Effective C++》《Exceptional C++》《More Exceptional C++》《Inside the C++ Object Model》
Java：《Thinking in Java》《Core Java》《Effective Java》《Java Puzzlers》《Java Network Programming》《Java Concurrency in Practice》《深入 Java 虚拟机》
Windows：《Windows 核心编程》《Windows Internals》
Linux：《Advanced Programming in the UNIX.Environment》《Understanding Linux Network Internals》《UNIX Network Programming》
Network：《TCP/IP Illustrated Volume I》《The Linux Networking Architecture》