// Copyright 2021. rongweihe All rights reserved.
// https://github.com/rongweihe/CPPNotes/tree/master/NetPrograming
//
// Use of this source code is governed by a BSD-style license
// that can be found in the License file.
//
// This is a public header file, it must only include public header files.

#ifndef MUDUO_NET_EVENTLOOPTHREAD_H
#define MUDUO_NET_EVENTLOOPTHREAD_H

#include "muduo/base/Condition.h"
#include "muduo/base/Mutex.h"
#include "muduo/base/Thread.h"

namespace muduo
{
namespace net
{

class EventLoop;
class EventLoopThread : noncopyable
{
public:
	typedef std::function<void(EventLoop*)> ThreadInitCallback;
	EventLoopThread(const ThreadInitCallback& cb = ThreadInitCallback(),
                	const string& name = string());
	~EventLoopThread();
	EventLoop* startLoop();
private:
	void threadFunc();
	EventLoop* loop_ GUARDED_BY(mutex_);
	bool exiting_;
	Thread thread_;
	MutexLock mutex_;
	Condition cond_ GUARDED_BY(mutex_);
	ThreadInitCallback callback_;
};
    
}	//namespace net
}	//namespace muduo
