# 条款 22 ：将成员变量声明为private

将成员变量声明为私有，然后定义操作变量的函数接口，这些接口可以对成员变量的处理有更精确的控制，它们可以实现“不准访问”、“只读访问”，“读写访问”。并且通过函数访问成员变量，日后可以改为某个计算替换成这个成员变量，实现封装的特性。

如此细微地划分控制颇有必要，因为许多成员变量应该被隐藏起来。每个成员变量都需要一个 `get`  函数和 `set`  函数毕竟罕见。所谓封装的特性就是如果你通过函数访问成员变量日后可以改变某个计算来替换这个成员变量，而 `class` 客户一点也不会知道 `classd` 的内部实现都已经起了变化。

如果我们将成员变量定义为 `public` 或者 `protected` ，一旦成员变量发生改变，都会有不可预知的大量代码将会受到破坏。

因此，从封装的角度来看，成员变量的访问权限只有两种：`private` 提供封装和其它权限提供非封装。

最后来个总结：

- 将成员变量声明为 private，这可以保证客户端访问数据的一致性，细微地划分访问控制，允诺约束条件获得保证，并提供 class 作者充分的实现弹性。
- `protected` 并不比 `public` 更具有封装性。