# 条款 19：设计 class 需要考虑的十个问题

在 `C++` 语言中，当你定义了一个 `class` 的时候，也就定义了一个 `types`，这意味着你不仅仅是 `class` 的设计者，还是 `types` 的设计者：重载函数和操作符、控制内存的分配和回收、定义对象的初始化和终结。

设计优秀的 `class` 是一项艰巨的工作。那么如何设计高效的 `class` 呢？先考虑下面几个问题。 

- **新 `type` 的对象应该如何被创建和销毁？**

  这涉及到构造函数和析构函数，以及内存分配函数和释放函数（`operator new，operator new[]，operator delete，operator delete[]`）；

- **对象的初始化和对象的赋值应该有什么样的差异？**

  这涉及到你的构造函数和赋值操作符的行为，以及其中的差异。需要注意的是别混淆了”初始化“和”赋值“，因为这对应着不同的函数调用。

- **新 type 的对象如果被 passed by value（值传递）意味着什么？**

- **什么是新 type 的合法值？**

  这决定了类需要维护的约束条件，也决定了你的成员函数（特别是构造函数，赋值操作符）必须进行的错误检查工作。它也影响函数抛出的异常。

- **新 type 需要配合某个继承体系么？**

  如果新 type 继承自某些已有的类，它就受到那些类的设计的束缚。特别是受到虚函数或非虚函数的影响。

- **新 type 需要什么样的转换？**

  如果允许类型 T1 被隐式转化为类型 T2，就必须在 class T1 内写一个类型转换函数（operator T2）或在 class T2 内写一个可被单一实参调用 （non-explicit-one-argument）的构造函数；

  如果只允许 explicit 构造函数存在，就得写出专门负责的函数。

- **什么样的操作符和函数对此新 type 而言是合理的？**这将决定新 type 声明哪些函数。

- **什么样的标准函数应该驳回？**这将决定哪些函数应该被声明为 private。

- **谁该取用新的 type 的成员？**这将决定成员变量是 public/protected/private，也会决定哪些 class/function 应该是 friends；

- **什么是新 type 的未声明接口？**这涉及到新 type 对效率、异常安全性以及资源运用所提供的保证；

- **新 type 有多么一般化？**这决定你是否该考虑定义一个 class template

- **真的需要一个新 type 么？**如果只是定义新的 derived class  以便为既有的 class 添加技能，那么可能可以单纯定义一或多个 non-member 函数或 templates。

