# 条款 14：在资源管理类中小心 copying 行为

上一章条款 13 导入 `RAII` 的观念：资源获取时机便是初始化时机，资源会在不需要的时刻被销毁。典型代表就是`shared_ptr`  和 `weak_ptr` ，但是需要注意的是并非所有资源都是堆内存，例如外存和堆栈。

那么在这种情况下，`auto_ptr`，`shared_ptr`，`weak_ptr` 等显然不适合作为资源管理类，这就需要建立自己的资源管理类。

同样，自建的资源管理类同样需要考虑 `RAII` 对象被复制的问题，一般有以下两种选择：

- 禁止复制：将 `copying` 声明为 `private` 且不提供定义，或者继承自一个将 `copying`  函数声明为 `private`  的基类。

- 对底层资源祭出"引用计数法"：使用 `shared_ptr`  是个不错的选择，但它的缺省行为是"当引用词数为 0 时删除其所指物"，幸运的是它允许指定所谓的删除器——一个接受一个 T* 类型参数函数或函数对象，当引用次数为 0 时便被调用 。

最后做一个总结：

- **复制 `RAII` 对象必须一并复制它所管理的资源，所以复制的  `copying`  行为决定了 `RAII`  对象的   `copying` 行为。**
- **普遍而常见的  `RAII class copying` 行为是：抑制 `copying ` ，采用引用计数法。**

