# 条款 13：以对象管理资源

> 这一篇开始进入资源管理篇。

导读：

所谓资源就是，一旦用了它，将来必须还给系统。如果不这样，糟糕的事情就会发生。

`C++`  程序中最常使用的资源就是动态分配内存，但内存只是你必须管理的众多资源之一。

其它常见的资源包括文件描述器，互斥锁，数据库连接，以及网络 `sockets`。不论哪一种资源，重要的是，当你不再使用它时，必须将它归还给系统。

现在假设用一个类来模拟投资行为，各式各样的投资类都继承自一个基类 `Investment`。

用工厂函数来创建特定的 `Investment`  对象：

举一个例子：

```c++
class Investment {
	//基类
}
Investment* createInvestment();//返回一个指针，指向 Investment 继承体系内的动态分配对象。

void f() {
  Investment* pInv = createInvestment();
  //...
  delete pInv;
}
```

上面这段代码看起来没什么问题，但在特殊情况下，f 函数可能无法删除 `new`  出来的对象——或许中间因为某个操作提前 `return`  或者发生其它异常。这种情况 f 函数内的控制流就不会执行到最后 `delete`  语句，那么内存泄漏就会发生，不仅仅是 `Investment` 对象本身所属内存，也包括 Investment 对象所保存的任何资源都会内存泄漏。

书中指出：为确保返回的资源总是被释放，我们需要将资源放进对象内，也就是在控制流离开函数 `f` 之后该对象的析构函数会自动释放那些资源。实际上这是本条款的重点：将资源放进对象内，触发析构函数调用确保资源被释放。

以对象管理资源的两个关键想法：

- 获得资源后立刻放进管理对象。以对象管理资源的做法在 C++ 里就是所谓的 RAII 机制（资源取得时机便是初始化时机）。
- 管理对象运用析构函数确保资源被释放。

采用智能指针可以很方便地解决这个问题，比如 TR1 的 std::tr1::shared_ptr 就是一个【引用计数器智慧指针 RCSP】 持续追踪共有多少个对象指向某笔资源，在无人指向的时候自动删除资源。

但是值得注意的是像 `auto_ptr` 和 `shared_ptr`  两者都是在其析构函数内执行 `delete` 而不是 `delete[]` ，所以不能用于动态分配的数组。

最后还要说明一点：`createInvestment`  返回的是未加工指针（`raw pointer` ），调用者极易忘记释放，即便是使用智能指针，也要首先把 `createInvestment`   返回的指针存储于智能指针对象内。条款18将对其进行讨论。

最后总结一下：

- **为防止资源泄漏，请使用 `RAII `对象，它们在构造函数中获得资源并在析构函数中释放资源。**

- **两个常被使用的 `RAII classes`  分别是 `tr1::shared_ptr ` 和 `auto_ptr` 。前者通常是较佳选择，因为其 `copy`  行为比较直观。若选择 `auto_ptr`  复制动作会使它指向 `null` 。**

