# 条款 08：别让异常逃离析构函数

C++ 并不禁止析构函数吐出异常，但它并不鼓励这样做。这是有理由的。考虑以下代码：

```c++
class Widget {
	public:
		...
		~Widget(){...}//假设这个析构函数抛出一个异常
};
void doSomething() {
  std::vector<Widget> v;
  ...
}//v在这里被自动销毁
```

当 vector v 被销毁，它有责任销毁其内含的所有 Widgets。假设 v 内含十个 Widget，而在析构一个元素期间，有个异常被抛出。

其它 九个 Widget 还是应该被销毁（否则他们所保存的任何资源都会发生泄漏），因此 v 应该调用它们各个析构函数，但假设在哪些调用期间，第二个 Widget 析构函数又抛出异常，现在有两个同时作用的异常，这对 C++来说就有点扛不住了，在两个异常同时存在的情况下，程序有可能直接结束执行或者导致不明确行为。

即使没有使用容器，也会导致这样的结果。

### 请记住

- **C++ 不喜欢析构函数吐出异常。**

- **析构函数绝对不要吐出异常。如果一个被析构函数调用的函数可能抛出异常，析构函数应该捕捉任何异常，然后吞下他们或结束程序。**

- **如果客户端需要对某个操作函数运行期间抛出的异常做反应，那么 class 应该提高一个普通函数而非析构函数去执行这些操作。**

