# 条款 02：尽量以 const，enum，inline替换 #define

这个条款的前提是如果你有定义了一个

```c++
#define ASP_RADIO 1.63
```

记号 `ASP_RADIO` 也许从未被编译器识别到；也许在编译器开始处理源码之前就被移走了。（为什么会出现这种情况？）

我们假设编译器没有处理这个定义常量。于是这个记号有可能没有进入记号表（symbool table）内。于是当你处理此常量的时候但获得了一个编译错误，可能会带来困惑。

解决的方法是以一个常量来替换上面的宏 。

```c++
const double AspRadio = 1.63
```

作为一个语言常量，`AspRadio` 肯定能被编译器看到，当然就会进入记号表。

此外，对于浮点常量而言，使用常量可能比使用 #define 导致较小量的码（编译阶段的目标码 object code）。

改为常量就不会出现这种情况。

当我们以常量替换 `#define`  的时候，有两种特殊情况需要值得说说：

1、当定义常量指针的时候，由于常量定义式通常被放在头文件内，因此有必要将指针（而不是指针所指之物）声明为 `const` 。

2、第二个值得注意的是：class 专属常量，为了将常量的作用域限制于 class 内，你必须让它成为一个成员；而确保此常量至多只有一份实体，所以必须让它成为一个 static 成员。

3、我们无法利用 #define 创建一个 class 专属常量，因为 #defines 并不重视作用域。一旦宏被定义，它就在其后的编译过程中有效。这意味着 #define 不仅不能够用来定义 class 专属常量。也不能提供任何封装性。

4、无论何时写出这种宏，你必须记住为宏中的所有实参加上小括号，否则在有些人在表达式中调用这个宏的时候 有可能遭到麻烦

```c++
#define CALC_MAX(a,b) f((a) > (b) ? (a) : (b));
```

解决上面的办法是用 `template inline 函数替换` 。

有了 `const`，`enums`，`inlines`，我们对预处理（特别是 `#define` ）的需求降低了，但并非完全消除。 

`#include` 仍然是必需品，而 `#ifdef/#ifndef` 也继续扮演着控制编译的角色。目前还不到预处理器完全不起作用的时候。

**请记住：**

> 对于单纯变量，最好以 const 或者 enums 来替代 #define。
>
> 对于形式函数的宏，最好改用 inline 函数替代 #define。