## 15.1 OOP 概述

面向对象程序设计包含三个部分：数据抽象、继承、动态绑定。

**通过数据抽象**：我们可以将类的接口定义和实现分离开来。

**通过继承**：我们可以使用相似的类并用其相似的类关系进行建模。

通过动态绑定：我们可以在一定程度上忽略相似类之间的差别，而以统一的方式来使用他们的对象。



## 15.5 访问控制与继承

每个类分别控制自己的成员初始化过程。

与之类似，每个类还分别控制着其成员对于派生类来说是否可访问（accessible）。

有如下的规定：**派生类的成员函数和友元只能访问派生类对象中的基类部分的受保护成员：对于普通的基类对象中的成员不具有特殊的访问权限。**

### 默认的继承保护级别

默认情况下，使用 `class` 关键字定义的派生类是私有继承的；而使用 `struct` 关键字定义的派生类是公有继承的。除此之外，再无其他不同之处。

> 提示：一个私有派生的类最好显式地将 private 声明，是式地 private 声明出来，而不要仅仅依赖于默认。显式声明的好处是可以使私有维承关系清晰明了，不至于产生误会。

## 15.6 继承中的类作用域

每个类定义自己的作用域，在这个作用域内我们定义类的成员。当存在继承关系时，派生类的作用域嵌套在基类的作用域之内。如果一个名字在派生类的作用域内无法完成正确解析，则编译器将继续在外层的基类作用域中寻找该名字的定义。

例如，当我们编写下面的代码时：

```c++
buik_quote bulk;
std::cout<<bulk.isbn();
```

名字 isbn 的解析将按照下述过程所示：

1、因为我们是通过Bulk_quote的对象调用isbn的，所以首先在Bulk_quote中查找，这一步没有找到名字 isbn。

2、因为Bulk_quote是 Disc_quote的派生类，所以接下来在Disc_quote中查找，仍然找不到。

3、因为 Disc_quote 是 Quote的派生类，所以接着查找 Quote;此时找到了名字 isbn，所以我们使用的 isbn 最终被解析为 Quote 中的 isbn。

### 在编译时进行名字的查找

一个对象、引用或指针的静态类型决定了该对象的哪些成员函数是可见的。即使静态类型与动态类型可能不一致。但是我们能使用哪些成员仍然是由静态类型决定的。

例如下面的例子：

```c++
class B : public A{
public:
    void funcb();
};
B b;
B * bp = &b;            //静态类型与动态类型一致
A * ap = &b;            //静态类型与动态类型不一致, B类型的对象隐式转换成A类型的对象, 派生类对象隐式转换成基类对象.
bp->funcb();            //正确, bp的类型是B*
ap->funcb();            //错误, ap的类型是A*
```

尽管b中确实存在funcb的成员, 但是该成员对于ap来说却是不可见的, ap的类型是A的指针, 意味着对funcb的搜索将从A开始, 显然A不包含funcb成员, 而且A是基类, B是派生类, A的作用域范围在B之外, 不会去搜索B内的作用域。

### 名字冲突与继承

和其它作用域一样，派生类也能重用定义在其直接基类或间接基类中的名字，此时定义在内层作用域（即派生类）的名字将隐藏在外层作用域（即基类）的名字。

```c++
struct Base{
	Base():mem(0){}
protected:
  int mem;
};

struct Derived : Base{
	Derived(int i):mem(i){}
	int get_mem() {return mem;}
protected:
  int mem;		//隐藏基类中的mem
};
//get_mem 中 mem 引用的解析结果是定义在 Derived 中的名字
Derived d(666);
std::cout << d.get_mem(); //输出 666
```

> 提示：派生类的成员函数将隐藏同名的基类成员。

### 通过作用域符来使用隐藏的成员

可以通过作用域符来访问被隐藏的基类成员：

```c++
struct Derived ： Base{
	int get_base_mem(){return Base::mem;}
	//...
};
```

作用运算符将覆盖掉原有的查找规则，并指示编译器从 `Base` 类的作用域开始查找 `mem`。

> 提示：除了覆盖继承而来的虚函数之外，派生类最好不要重用其他定义在基类中的名字。

**关键概念：名字查找和继承**

> 理解函数调用的解析过程对于理解C++的继承关系至关重要，假定我们调用p->fun() 或者调用obj.fun()，则其背后依次执行下面4个步骤：
>
> - 首先确定p或者obj的静态类型。因为我们调用的是一个成员，所以该类型必然是类类型。
> - 在p或者obj的静态类型对应的类中查找fun。如果找不到，则依次在直接基类中不断查找直至达到继承链的最顶端。如果找遍了该类及其基类仍然找不到，则编译器将报错。
> - 一旦找到了fun，就进行常规的类型检查已确认对于当前找到的fun本次调用是否合法。
> - 假设调用合法，则编译器将根据调用的是否是虚函数而产生不同的代码：
> - - 如果fun是虚函数且我们是通过引用或者指针进行的调用，则编译器产生的代码将在运行时确定到底运行哪个虚函数的哪个版本？依据是对象动态类型。
>   - 反之，如果fun不是虚函数或者我们是通过对象(而非引用或指针)进行的调用，则编译器将产生一个常规函数调用。

### 一如往常，名字查找先于类型检查

如果派生类的成员与基类的某个成员同名，则派生类将在其作用域内隐藏该基类成员，即使派生类成员与基类成员的形参列表不一致，基类成员也会被隐藏。

例如下面的例子：

```c++
struct Base {
    void memfun() {
        std::cout<<"Base"<<endl;
    }
};

struct Derived : Base {
    void memfun(int a) {
        std::cout<<"Derived" << a <<endl;
    }
};
int main()
{
    Base B;
    Derived D;
    B.memfun();
    D.memfun(5);
  	D.memfun();//错误：参数列表为空的memfun被隐藏了
    D.Base::memfun();
}
```

### 虚函数与作用域

基类和派生类的虚函数接受的实参必须相同，否则就无法通过基类的引用或者指针调用派生类的虚函数。

```c++
class Base{
public:
	virtual int fun();
};

class D1 : public Base{
public:
	int fun(int);		//@ 隐藏了Base中的fun函数
	virtual void f2();
};

class D2 : public D1{
public:
	int fun(int);		//@ 隐藏了D1 中的 fun 函数
	int fun();			//@ 覆盖了Base 中的 fun 函数
	void f2();			//@ 覆盖了 D1 中的 f2 函数
};
```

