<div align=center>
    <img src="images/logo.jpg" alt="领课教育系统-开源版"/>
    <div align=center>    
        <a href="http://spring.io/projects/spring-boot">
            <img src="https://img.shields.io/badge/spring--boot-2.6.3-blue.svg" alt="spring-boot">
        </a>
        <a href="https://spring.io/projects/spring-cloud-alibaba">
            <img src="https://img.shields.io/badge/spring--cloud--alibaba-2021.0.1.0-blue.svg" alt="mybatis-plus">
        </a> 
    </div>
</div>

### 项目介绍

领课教育系统（roncoo-education）是基于领课网络多年的在线教育平台开发和运营经验打造出来的产品，致力于打造一个各行业都适用的分布式在线教育系统。系统采用前后端分离模式，前台采用vue.js为核心框架，后台采用Spring Cloud为核心框架。系统目前主要功能有课程点播功能，支持多家视频云的接入，课程附件管理功能，支持多家存储云的接入，可以帮助个人或者企业快速搭建一个轻量级的在线教育平台。

* 所有使用到的框架或者组件都是基于开源项目，代码保证100%开源。
* 系统功能通用，无论是个人还是企业都可以利用该系统快速搭建一个属于自己的在线教育平台。
* 如需商业技术服务支持，可使用 [领课教育系统商业版](https://www.roncoo.net/)，功能更丰富，架构更健壮，VIP服务，上线快速。
* 友情链接：领课教育系统的视频云服务基于 [保利威视频云](https://my.polyv.net/v3/register/?f=qd=lingke) 实现，通过链接注册即可免费试用。

### 前台主要功能介绍

* 首页功能：导航模块，轮播模块，专区模块，友情链接，底部信息
* 课程中心：搜索功能，分类导航（自定义分类设置），课程列出
* 课程详情：课程信息，课程目录，讲师信息、购买、播放等功能
* 个人中心：我的课程，我的订单，个人信息

  <img src="images/index.jpg" alt="领课教育系统-首页"/>
  <img src="images/course.jpg" alt="领课教育系统-课程"/>

### 后台主要功能介绍

* 权限管理功能：菜单多角色多用户自定义管理
* 系统配置功能：自定义进行站点配置及第三方参数配置
* 讲师管理功能：讲师列出、添加、修改、删除等功能
* 课程分类管理：分类列出、添加、修改、删除等功能
* 课程管理功能：课程列出、添加、修改、删除等功能
* 订单管理功能：订单的列出，对订单进行分析统计功能
* 用户管理功能：同一时间只允许同一个账号在同一个浏览器登录，防止账号共享
* 轮播管理功能：后台自定义轮播设置，增加营销效果
* 支付功能模块：对接官方支付宝、官方微信
* 其他功能模块：菜单导航功能、友情链接功能等

  <img src="images/admin1.jpg" alt="领课教育系统-首页"/>
  <img src="images/admin2.jpg" alt="领课教育系统-课程"/>

### 演示地址

* [前端门户演示地址：https://eduos.roncoo.net/](https://eduos.roncoo.net/)
* [后台管理演示地址：https://eduos.roncoo.net/admin](https://eduos.roncoo.net/admin/)
* [项目帮助文档地址：https://eduos.roncoo.net/doc](https://eduos.roncoo.net/doc/)

---

##### 领课教育系统(roncoo-education)：[码云地址](https://gitee.com/roncoocom/roncoo-education) | [Github地址](https://github.com/roncoo/roncoo-education)

> roncoo-education是后台工程，核心框架：Spring Cloud Alibaba

##### 前端门户工程(roncoo-education-web)： [码云地址](https://gitee.com/roncoocom/roncoo-education-web) | [Github地址](https://github.com/roncoo/roncoo-education-web)

> roncoo-education-web是前端门户工程，核心框架：Vuejs + Nuxt.js

##### 后台管理工程(roncoo-education-admin)：[码云地址](https://gitee.com/roncoocom/roncoo-education-admin) | [Github地址](https://github.com/roncoo/roncoo-education-admin)

> roncoo-education-admin是后台管理工程，核心框架：vue-element-admin

### 官方交流群（加群即可获取sql脚本）

<img src="images/qun.jpg" alt="领课教育系统-官方开源群" width="200"/>
