'use strict';

const nodeExternals = require('webpack-node-externals');
const path = require('path');
const webpack = require('webpack');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = [
  {
    name: 'frontend',
    devtool: 'eval-source-map',
    entry: path.join(__dirname, 'app/main.js'),
    output: {
      path: path.join(__dirname, '/dist/'),
      filename: '[name].js',
      publicPath: '/',
    },
    plugins: [
      new HtmlWebpackPlugin({
        template: 'app/index.tpl.html',
        inject: 'body',
        filename: 'index.html',
      }),
      new webpack.optimize.OccurrenceOrderPlugin(),
      new webpack.NoErrorsPlugin(),
      new webpack.DefinePlugin({
        'process.env.NODE_ENV': JSON.stringify('development'),
      }),
    ],
    module: {
      loaders: [
        {
          test: /\.jsx?$/,
          exclude: /node_modules/,
          loader: 'babel',
          query: {
            presets: ['react', 'es2015', 'stage-0'],
          },
        },
      ],
    },
  },
  {
    name: 'server',
    target: 'node',
    node: {
      __filename: false,
      __dirname: false,
    },
    externals: [nodeExternals()],
    entry: path.join(__dirname, 'server.js'),
    output: {
      path: path.join(__dirname, '/dist/'),
      filename: 'server.js',
    },
    plugins: [],
    module: {
      loaders: [
        {
          test: /\.jsx?$/,
          exclude: /node_modules/,
          loader: 'babel',
          query: {
            presets: ['react', 'es2015', 'stage-0'],
          },
        },
      ],
    },
  },
];
