---
title: Document Center
---

# Spell Point Calculator
[Launch Spell Point Calculator](https://rockhazard.github.io/spell-point-calculator/)

## Description
A JavaScript utility designed to assist players in managing spell points for the variant player rules in the 5th Edition D&D _Dungeon Master's Guide_ on page 288.

Traditionally, a caster must use spell slots to keep track of spells.  For instance, a level 4 wizard will normally have 4 level 1 spells, and 2 level 2 spells.  This is easy to keep track of, but limiting, since you can't sacrifice your level 1 spells to increase the number of level 2 spells available.  Spell points solve this problem at the cost of complexity, giving the player a pool of points to use as he or she sees fit on any available spell levels.  For instance, a caster may choose to spend all their magic on level 2 spells, exhausting the ability to cast any level 1 spells, but gaining more castings of the more powerful spells in the bargain.  This utility aims to remove the complexity of keeping track of these spell points for all types of casters.

## Features
- #### Caster Type Selection:
It allows the selection of full, half, and third caster spell points and class progressions. This means it automatically calculates spell point progression for Wizards, Sorcerers, Rangers, Paladins, and Clerics, among other classes and subclasses, with ease. 
- #### Level Selection:
Automatically calculates maximum spell points according to caster level after a long rest.
- #### Spell Casting:
Manage your mystic resources at a glance by automatically recalculating remaining spell points after every casting. The calculator displays the number of castings remaining at each level, showing the user how many castings he or she would have if they were to exhaust all their points on one spell level.
- #### Arcane Recovery:
Warns when spell points reach 50% of maximum, then allows the player to add their class level in spell points, simulating a short rest with arcane recovery. The calculator allows you to do this multiple times; this is not a bug but rather a quick way to use the adjust points feature in arcane recovery increments.
- #### Manually Adjust Spell Points:
Allows player to manually add or remove spell points in case of mistakes or house rules.
- #### Long Rest:
Recover all your spell points or calculate a change like Caster Type at the press of a button.
- #### School Selection with Level Titles:
Pick your caster's school of magic and display an associated mystic symbol along with level titles that reflect the special features of your arcane tradition.  You get a new title at each level where your tradition bestows new powers. These titles are not official, just some game flavor.
- ### Tables:
Includes handy tables for spell point and caster type progressions, so you don't have to search the manuals, saving time.

## Requirements
Any modern browser.

## Contributors
rockhazardz@gmail.com