import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "网络安全专家",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Chinese. My first request is [项目要求]",
    "description": "我希望你能作为一名网络安全专家。我将提供一些关于数据如何存储和共享的具体信息，而你的工作将是提出保护这些数据免遭恶意行为的策略。这可能包括建议加密方法、创建防火墙或实施将某些活动标记为可疑的政策。",
    "remark": "根据网络环境，提供网络安全建议。"
  },
  "en": {
    "title": "cyber security specialist",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. My first request is ",
    "remark": "Provide network security recommendations based on the network environment."
  },
  "ja": {
    "title": "サイバーセキュリティスペシャリスト",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたには、サイバーセキュリティのスペシャリストとして働いてほしい。私は、データがどのように保存され、共有されているかという具体的な情報を提供し、あなたの仕事は、悪意のある行動からデータを保護するための戦略を提案することです。暗号化の方法、ファイアウォールの構築、特定の活動を疑わしいと判断するポリシーの導入など、さまざまな方法を提案することができます。",
    "remark": "ネットワーク環境に応じたサイバーセキュリティアドバイスを提供する。"
  },
  "ko": {
    "title": "사이버 보안 전문가",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "사이버 보안 전문가로 일해 주셨으면 합니다. 데이터가 저장되고 공유되는 방식에 대한 구체적인 정보를 제공하고, 이 데이터를 악의적인 행위로부터 보호하기 위한 전략을 제안하는 것이 여러분의 임무입니다. 여기에는 암호화 방법 제안, 방화벽 구축 또는 특정 활동을 의심스러운 것으로 표시하는 정책 구현 등이 포함될 수 있습니다.",
    "remark": "네트워크 환경에 기반한 사이버 보안 조언을 제공합니다."
  },
  "es": {
    "title": "Especialista en seguridad de redes",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que trabajaras como experto en ciberseguridad. Te proporcionaré información específica sobre cómo se almacenan y comparten los datos, y tu trabajo consistirá en idear estrategias para proteger esos datos de comportamientos maliciosos. Esto puede incluir sugerir métodos de cifrado, crear cortafuegos o aplicar políticas que señalen ciertas actividades como sospechosas.",
    "remark": "Proporcionar recomendaciones de seguridad de red basadas en el entorno de red."
  },
  "fr": {
    "title": "Spécialiste de la sécurité des réseaux",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous travailliez en tant qu'expert en cybersécurité. Je vous fournirai des informations spécifiques sur la manière dont les données sont stockées et partagées, et votre tâche consistera à élaborer des stratégies pour protéger ces données contre les comportements malveillants. Il peut s'agir de suggérer des méthodes de cryptage, de créer des pare-feu ou de mettre en œuvre des politiques qui signalent certaines activités comme suspectes.",
    "remark": "Fournir des recommandations en matière de sécurité du réseau en fonction de l'environnement du réseau."
  },
  "de": {
    "title": "Spezialist für Netzwerksicherheit",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als Experte für Cybersicherheit arbeiten. Ich werde Ihnen einige spezifische Informationen darüber geben, wie Daten gespeichert und weitergegeben werden, und Ihre Aufgabe wird es sein, Strategien zu entwickeln, um diese Daten vor bösartigem Verhalten zu schützen. Dazu können Vorschläge für Verschlüsselungsmethoden, die Einrichtung von Firewalls oder die Umsetzung von Richtlinien gehören, die bestimmte Aktivitäten als verdächtig kennzeichnen.",
    "remark": "Abgabe von Empfehlungen zur Netzwerksicherheit auf der Grundlage der Netzwerkumgebung."
  },
  "it": {
    "title": "Specialista della sicurezza di rete",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che lavoraste come esperti di sicurezza informatica. Le fornirò alcune informazioni specifiche su come vengono archiviati e condivisi i dati e il suo compito sarà quello di elaborare strategie per proteggere tali dati da comportamenti dannosi. Potresti suggerire metodi di crittografia, creare firewall o implementare politiche che segnalino determinate attività come sospette.",
    "remark": "Fornire raccomandazioni sulla sicurezza della rete in base all'ambiente di rete."
  },
  "ru": {
    "title": "Специалист по сетевой безопасности",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы поработали в качестве эксперта по кибербезопасности. Я предоставлю конкретную информацию о том, как хранятся и передаются данные, а ваша задача будет заключаться в разработке стратегий защиты этих данных от вредоносного поведения. Это может включать в себя предложение методов шифрования, создание межсетевых экранов или внедрение политик, позволяющих отмечать определенные действия как подозрительные.",
    "remark": "Предоставление рекомендаций по обеспечению сетевой безопасности с учетом особенностей сетевой среды."
  },
  "pt": {
    "title": "Especialista em segurança de redes",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que trabalhasse como especialista em cibersegurança. Fornecerei algumas informações específicas sobre a forma como os dados são armazenados e partilhados, e a tua tarefa será apresentar estratégias para proteger esses dados de comportamentos maliciosos. Isto pode incluir a sugestão de métodos de encriptação, a criação de firewalls ou a implementação de políticas que assinalem determinadas actividades como suspeitas.",
    "remark": "Fornecer recomendações de segurança de rede com base no ambiente de rede."
  },
  "hi": {
    "title": "साइबर सुरक्षा विशेषज्ञ",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक साइबर सुरक्षा पेशेवर बनें। मैं डेटा कैसे संग्रहीत और साझा किया जाता है, इसके बारे में कुछ विवरण प्रदान करूंगा और आपका काम उस डेटा को दुर्भावनापूर्ण व्यवहार से बचाने के लिए रणनीतियों के साथ आना होगा। इसमें एन्क्रिप्शन विधियों का सुझाव देना, फ़ायरवॉल बनाना या ऐसी नीतियां लागू करना शामिल हो सकता है जो कुछ गतिविधियों को संदिग्ध के रूप में चिह्नित करती हैं।",
    "remark": "नेटवर्क वातावरण के अनुसार नेटवर्क सुरक्षा सलाह प्रदान करें।"
  },
  "ar": {
    "title": "خبير الأمن السيبراني",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تكون محترفًا في الأمن السيبراني. سأقدم بعض التفاصيل حول كيفية تخزين البيانات ومشاركتها ، وستكون مهمتك هي التوصل إلى استراتيجيات لحماية تلك البيانات من السلوك الضار. قد يشمل ذلك اقتراح طرق تشفير أو إنشاء جدران حماية أو تنفيذ سياسات تضع علامة على أنشطة معينة على أنها مشبوهة.",
    "remark": "وفقًا لبيئة الشبكة ، قدم نصائح حول أمان الشبكة."
  },
  "bn": {
    "title": "সাইবার সিকিউরিটি এক্সপার্ট",
    "prompt": "I want you to act as a cyber security specialist. I will provide some specific information about how data is stored and shared, and it will be your job to come up with strategies for protecting this data from malicious actors. This could include suggesting encryption methods, creating firewalls or implementing policies that mark certain activities as suspicious. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি আপনাকে একজন সাইবার নিরাপত্তা পেশাদার হতে চাই। আমি কীভাবে ডেটা সংরক্ষণ এবং ভাগ করা হয় সে সম্পর্কে কিছু সুনির্দিষ্ট তথ্য প্রদান করব এবং আপনার কাজ হবে সেই ডেটাকে দূষিত আচরণ থেকে রক্ষা করার কৌশলগুলি নিয়ে আসা। এর মধ্যে এনক্রিপশন পদ্ধতির পরামর্শ দেওয়া, ফায়ারওয়াল তৈরি করা, বা কিছু ক্রিয়াকলাপকে সন্দেহজনক হিসাবে চিহ্নিত করে এমন নীতি প্রয়োগ করা অন্তর্ভুক্ত থাকতে পারে।",
    "remark": "নেটওয়ার্ক পরিবেশ অনুযায়ী, নেটওয়ার্ক নিরাপত্তা পরামর্শ প্রদান."
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-cyber-security-specialist",
  "tags": [
    "code"
  ],
  "id": 96,
  "weight": 688
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
