import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "架构师 IT",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Chinese. My first request is [项目要求]",
    "description": "我希望你能扮演一个 IT 架构师的角色。我将提供一些关于应用程序或其他数字产品功能的细节，而你的工作是想出将其整合到 IT 环境中的方法。这可能涉及到分析业务需求，进行差距分析，并将新系统的功能映射到现有的 IT 环境中。接下来的步骤是创建一个解决方案设计，一个物理网络蓝图，定义系统集成的接口和部署环境的蓝图。",
    "remark": "从 IT 架构师的角度，设计系统方案。"
  },
  "en": {
    "title": "IT Architect",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. My first request is ",
    "remark": "Design system solutions from the perspective of an IT architect."
  },
  "ja": {
    "title": "アーキテクト IT",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたには、IT アーキテクトの役割を担ってほしい。私がアプリケーションやその他のデジタル製品の機能についての詳細を提供しますので、それをどのように IT 環境に統合するかを考えるのがあなたの仕事です。そのためには、ビジネス要件を分析し、ギャップ分析を行い、新しいシステムの機能を既存の IT 環境にマッピングする必要があるかもしれません。次のステップは、ソリューションデザイン、物理的なネットワークの設計図、システム統合のためのインターフェイスを定義する設計図、展開環境の設計図を作成することです。",
    "remark": "IT アーキテクトの視点からシステムソリューションを設計する。"
  },
  "ko": {
    "title": "IT 설계자",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "IT 아키텍트의 역할을 맡았으면 합니다. 애플리케이션이나 기타 디지털 제품의 기능에 대한 세부 정보를 제공하고, 이를 IT 환경에 통합하는 방법을 알아내는 것이 여러분의 임무입니다. 여기에는 비즈니스 요구 사항을 분석하고, 격차 분석을 수행하며, 새 시스템의 기능을 기존 IT 환경에 매핑하는 작업이 포함될 수 있습니다. 다음 단계는 솔루션 설계, 물리적 네트워크 청사진, 시스템 통합을 위한 인터페이스를 정의하는 청사진, 배포 환경에 대한 청사진을 만드는 것입니다.",
    "remark": "IT 아키텍트의 관점에서 시스템 솔루션을 설계합니다."
  },
  "es": {
    "title": "Arquitecto informático",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que asumieras el papel de un arquitecto informático. Te daré algunos detalles sobre la funcionalidad de una aplicación u otro producto digital, y tu trabajo consistirá en averiguar cómo integrarlo en el entorno informático. Esto puede implicar el análisis de los requisitos empresariales, la realización de un análisis de carencias y la asignación de la funcionalidad del nuevo sistema al entorno informático existente. Los siguientes pasos son crear un diseño de la solución, un plano de la red física que defina las interfaces para la integración del sistema y un plano del entorno de implantación.",
    "remark": "Diseñar soluciones de sistemas desde la perspectiva de un arquitecto informático."
  },
  "fr": {
    "title": "Architecte IT",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous jouiez le rôle d'un architecte informatique. Je vous donnerai quelques détails sur les fonctionnalités d'une application ou d'un autre produit numérique, et il vous appartiendra de déterminer comment l'intégrer dans l'environnement informatique. Cela peut impliquer d'analyser les besoins de l'entreprise, d'effectuer une analyse des lacunes et de cartographier la fonctionnalité du nouveau système dans l'environnement informatique existant. Les étapes suivantes consistent à créer une conception de la solution, un plan du réseau physique qui définit les interfaces pour l'intégration du système et un plan de l'environnement de déploiement.",
    "remark": "Concevoir des solutions systèmes du point de vue d'un architecte informatique."
  },
  "de": {
    "title": "Architekt IT",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie in die Rolle eines IT-Architekten schlüpfen. Ich gebe Ihnen einige Details über die Funktionalität einer Anwendung oder eines anderen digitalen Produkts, und es ist Ihre Aufgabe, herauszufinden, wie es in die IT-Umgebung integriert werden kann. Dies kann die Analyse der Geschäftsanforderungen, die Durchführung einer Lückenanalyse und die Abbildung der Funktionalität des neuen Systems in der bestehenden IT-Umgebung beinhalten. Die nächsten Schritte sind die Erstellung eines Lösungskonzepts, eines physischen Netzwerkentwurfs, der die Schnittstellen für die Systemintegration definiert, und eines Entwurfs für die Bereitstellungsumgebung.",
    "remark": "Entwurf von Systemlösungen aus der Sicht eines IT-Architekten."
  },
  "it": {
    "title": "Architetto IT",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che assumeste il ruolo di un architetto IT. Vi fornirò alcuni dettagli sulle funzionalità di un'applicazione o di un altro prodotto digitale e il vostro compito sarà quello di capire come integrarlo nell'ambiente IT. Ciò può comportare l'analisi dei requisiti aziendali, l'esecuzione di una gap analysis e la mappatura delle funzionalità del nuovo sistema nell'ambiente IT esistente. I passi successivi consistono nel creare un progetto di soluzione, un blueprint della rete fisica che definisca le interfacce per l'integrazione del sistema e un blueprint dell'ambiente di distribuzione.",
    "remark": "Progettare soluzioni di sistema dal punto di vista di un architetto IT."
  },
  "ru": {
    "title": "Архитектор ИТ",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы взяли на себя роль ИТ-архитектора. Я предоставлю некоторые сведения о функциональности приложения или другого цифрового продукта, а ваша задача - понять, как интегрировать его в ИТ-среду. Это может включать в себя анализ бизнес-требований, анализ недостатков и сопоставление функциональности новой системы с существующей ИТ-средой. Следующие шаги - создание проекта решения, чертежа физической сети, определяющего интерфейсы для интеграции систем, и чертежа среды развертывания.",
    "remark": "Проектирование системных решений с точки зрения ИТ-архитектора."
  },
  "pt": {
    "title": "Arquiteto TI",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que assumisse o papel de um arquiteto de TI. Fornecerei alguns pormenores sobre a funcionalidade de uma aplicação ou de outro produto digital e cabe-lhe a si descobrir como integrá-lo no ambiente informático. Isto pode envolver a análise dos requisitos comerciais, a realização de uma análise de lacunas e o mapeamento da funcionalidade do novo sistema no ambiente de TI existente. Os passos seguintes consistem em criar uma conceção da solução, um projeto de rede física que defina as interfaces para a integração do sistema e um projeto para o ambiente de implementação.",
    "remark": "Conceber soluções de sistemas na perspetiva de um arquiteto de TI."
  },
  "hi": {
    "title": "वास्तुकार आई.टी",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक आईटी आर्किटेक्ट की भूमिका निभाएं। मैं एप्लिकेशन या अन्य डिजिटल उत्पाद की कार्यक्षमता के बारे में कुछ विवरण प्रदान करूंगा, और आपका काम यह पता लगाना है कि इसे आईटी वातावरण में कैसे एकीकृत किया जाए। इसमें व्यावसायिक आवश्यकताओं का विश्लेषण करना, अंतराल विश्लेषण करना और मौजूदा आईटी वातावरण में नई प्रणाली की क्षमताओं का मानचित्रण करना शामिल हो सकता है। अगले चरण एक समाधान डिज़ाइन, एक भौतिक नेटवर्क ब्लूप्रिंट बनाना है जो सिस्टम एकीकरण के लिए इंटरफेस और तैनाती वातावरण के लिए एक ब्लूप्रिंट को परिभाषित करता है।",
    "remark": "आईटी आर्किटेक्ट्स के दृष्टिकोण से, डिज़ाइन सिस्टम समाधान।"
  },
  "ar": {
    "title": "مهندس تكنولوجيا المعلومات",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تلعب دور مهندس تكنولوجيا المعلومات. سأقدم بعض التفاصيل حول وظائف التطبيق أو أي منتج رقمي آخر ، وتتمثل مهمتك في معرفة كيفية دمجها في بيئة تكنولوجيا المعلومات. قد يشمل ذلك تحليل احتياجات العمل ، وإجراء تحليل للفجوات ، وتخطيط إمكانيات النظام الجديد لبيئة تكنولوجيا المعلومات الحالية. تتمثل الخطوات التالية في إنشاء تصميم حل ، ومخطط شبكة فعلي يحدد واجهات تكامل النظام ومخطط لبيئة النشر.",
    "remark": "من منظور مهندسي تكنولوجيا المعلومات ، حلول أنظمة التصميم."
  },
  "bn": {
    "title": "স্থপতি আইটি",
    "prompt": "I want you to act as an IT Architect. I will provide some details about the functionality of an application or other digital product, and it will be your job to come up with ways to integrate it into the IT landscape. This could involve analyzing business requirements, performing a gap analysis and mapping the functionality of the new system to the existing IT landscape. Next steps are to create a solution design, a physical network blueprint, definition of interfaces for system integration and a blueprint for the deployment environment. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই আপনি একজন আইটি আর্কিটেক্টের ভূমিকায় অভিনয় করুন। আমি অ্যাপ্লিকেশন বা অন্যান্য ডিজিটাল পণ্যের কার্যকারিতা সম্পর্কে কিছু বিশদ প্রদান করব, এবং আপনার কাজ হল আইটি পরিবেশে এটিকে কীভাবে একীভূত করা যায় তা নির্ধারণ করা। এর মধ্যে ব্যবসার চাহিদা বিশ্লেষণ করা, একটি ফাঁক বিশ্লেষণ করা এবং বিদ্যমান আইটি পরিবেশে নতুন সিস্টেমের ক্ষমতা ম্যাপ করা জড়িত থাকতে পারে। পরবর্তী পদক্ষেপগুলি হল একটি সমাধান ডিজাইন তৈরি করা, একটি ফিজিক্যাল নেটওয়ার্ক ব্লুপ্রিন্ট যা সিস্টেম ইন্টিগ্রেশনের জন্য ইন্টারফেসগুলিকে সংজ্ঞায়িত করে এবং স্থাপনার পরিবেশের জন্য একটি ব্লুপ্রিন্ট।",
    "remark": "আইটি স্থপতিদের দৃষ্টিকোণ থেকে, ডিজাইন সিস্টেম সমাধান।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-an-it-architect",
  "tags": [
    "code"
  ],
  "id": 95,
  "weight": 2222
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
