import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "前端：UX/UI 界面",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. My first request is [项目要求]",
    "description": "我希望你能作为一个 UX/UI 开发者。我将提供一些关于应用程序、网站或其他数字产品的设计细节，而你的工作将是想出创造性的方法来改善其用户体验。这可能涉及到创建原型，测试不同的设计，并对什么是最有效的提供反馈。",
    "remark": "基于产品描述、项目目标和受众群体，提供界面设计建议，以提高用户体验。"
  },
  "en": {
    "title": " UX/UI developer",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. My first request is ",
    "remark": "Based on product description, project goals and target audience, provide interface design suggestions to improve user experience."
  },
  "ja": {
    "title": "フロントエンド：UX/UI インターフェース",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "UX/UI デベロッパーとして働いてほしいです。アプリやウェブサイト、その他のデジタル製品のデザインについて、私がいくつか詳細を説明しますので、あなたの仕事は、そのユーザー体験を向上させるクリエイティブな方法を考え出すことです。プロトタイプを作成し、異なるデザインをテストし、最適なものをフィードバックすることも含まれます。",
    "remark": "製品の説明、プロジェクトの目的、オーディエンスグループに基づき、ユーザーエクスペリエンスを向上させるためのインターフェースデザインのアドバイスを提供する。"
  },
  "ko": {
    "title": "프런트엔드: UX/UI 인터페이스",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "UX/UI 개발자로 일하고 싶습니다. 앱, 웹사이트 또는 기타 디지털 제품의 디자인에 대한 세부 정보를 제공하고, 여러분의 임무는 사용자 경험을 개선할 수 있는 창의적인 방법을 찾는 것입니다. 여기에는 프로토타입을 만들고, 다양한 디자인을 테스트하고, 무엇이 가장 효과적인지에 대한 피드백을 제공하는 것이 포함될 수 있습니다.",
    "remark": "제품 설명, 프로젝트 목표 및 대상 그룹에 따라 사용자 경험을 개선하기 위한 인터페이스 디자인 조언을 제공합니다."
  },
  "es": {
    "title": "Front-end: interfaz UX/UI",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Quiero que trabajes como desarrollador UX/UI. Te daré algunos detalles sobre el diseño de una aplicación, un sitio web u otro producto digital, y tu trabajo consistirá en idear formas creativas de mejorar su experiencia de usuario. Esto puede implicar la creación de prototipos, probar diferentes diseños y proporcionar comentarios sobre lo que funciona mejor.",
    "remark": "Proporcionar recomendaciones de diseño de interfaz para mejorar la experiencia del usuario basándose en las descripciones de los productos, los objetivos del proyecto y los datos demográficos de la audiencia."
  },
  "fr": {
    "title": "Front-end : interface UX/UI",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "Je souhaite que vous travailliez en tant que développeur UX/UI. Je vous donnerai quelques détails sur la conception d'une application, d'un site web ou d'un autre produit numérique, et votre travail consistera à trouver des moyens créatifs d'améliorer l'expérience utilisateur. Cela peut impliquer de créer des prototypes, de tester différentes conceptions et de fournir un retour d'information sur ce qui fonctionne le mieux.",
    "remark": "Fournir des recommandations sur la conception de l'interface afin d'améliorer l'expérience de l'utilisateur sur la base des descriptions de produits, des objectifs du projet et des caractéristiques démographiques du public."
  },
  "de": {
    "title": "Frontend: UX/UI-Schnittstelle",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als UX/UI-Entwickler arbeiten. Ich werde Ihnen einige Details zum Design einer App, einer Website oder eines anderen digitalen Produkts geben, und Ihre Aufgabe wird es sein, kreative Wege zur Verbesserung der Benutzerfreundlichkeit zu finden. Dazu kann es gehören, Prototypen zu erstellen, verschiedene Designs zu testen und Feedback zu geben, was am besten funktioniert.",
    "remark": "Bereitstellung von Empfehlungen für die Gestaltung von Benutzeroberflächen zur Verbesserung der Benutzerfreundlichkeit auf der Grundlage von Produktbeschreibungen, Projektzielen und demografischen Merkmalen der Zielgruppe."
  },
  "it": {
    "title": "Front-end: interfaccia UX/UI",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Voglio che tu lavori come sviluppatore UX/UI. Ti fornirò alcuni dettagli sul design di un'applicazione, di un sito web o di un altro prodotto digitale e il tuo compito sarà quello di trovare modi creativi per migliorare l'esperienza dell'utente. Ciò potrebbe comportare la creazione di prototipi, la sperimentazione di diversi design e la fornitura di feedback su ciò che funziona meglio.",
    "remark": "Fornire raccomandazioni sulla progettazione dell'interfaccia per migliorare l'esperienza dell'utente in base alle descrizioni del prodotto, agli obiettivi del progetto e ai dati demografici del pubblico."
  },
  "ru": {
    "title": "Front-end: UX/UI интерфейс",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы работали в качестве UX/UI-разработчика. Я предоставлю некоторые детали дизайна приложения, веб-сайта или другого цифрового продукта, а ваша задача будет заключаться в том, чтобы придумать креативные способы улучшения его пользовательского опыта. Это может включать создание прототипов, тестирование различных дизайнов и предоставление отзывов о том, что работает лучше всего.",
    "remark": "Предоставление рекомендаций по дизайну интерфейса для улучшения пользовательского опыта на основе описания продукта, целей проекта и демографических характеристик аудитории."
  },
  "pt": {
    "title": "Front-end: interface UX/UI",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Quero que trabalhe como programador UX/UI. Fornecerei alguns detalhes sobre o design de uma aplicação, um sítio Web ou outro produto digital e a sua função será encontrar formas criativas de melhorar a experiência do utilizador. Isso pode envolver a criação de protótipos, o teste de diferentes designs e o fornecimento de feedback sobre o que funciona melhor.",
    "remark": "Fornecer recomendações de design de interface para melhorar a experiência do utilizador com base em descrições de produtos, objectivos do projeto e dados demográficos do público."
  },
  "hi": {
    "title": "फ्रंट-एंड: यूएक्स/यूआई इंटरफ़ेस",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक यूएक्स/यूआई डेवलपर बनें। मैं किसी ऐप, वेबसाइट या अन्य डिजिटल उत्पाद के बारे में कुछ डिज़ाइन विवरण प्रदान करूंगा, और आपका काम इसके उपयोगकर्ता अनुभव को बेहतर बनाने के लिए रचनात्मक तरीकों के साथ आना होगा। इसमें प्रोटोटाइप बनाना, विभिन्न डिज़ाइनों का परीक्षण करना और सबसे अच्छा काम करने वाले पर फीडबैक प्रदान करना शामिल हो सकता है।",
    "remark": "उत्पाद विवरण, परियोजना लक्ष्यों और दर्शकों के आधार पर, उपयोगकर्ता अनुभव को बेहतर बनाने के लिए इंटरफ़ेस डिज़ाइन सुझाव प्रदान करें।"
  },
  "ar": {
    "title": "الواجهة الأمامية: واجهة UX / UI",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تكون مطور UX / UI. سأقدم بعض تفاصيل التصميم حول تطبيق أو موقع ويب أو منتج رقمي آخر ، وستتمثل مهمتك في ابتكار طرق إبداعية لتحسين تجربة المستخدم. قد يشمل ذلك إنشاء نماذج أولية ، واختبار تصميمات مختلفة ، وتقديم ملاحظات حول ما هو الأفضل.",
    "remark": "بناءً على وصف المنتج وأهداف المشروع والجمهور ، قدم اقتراحات لتصميم الواجهة لتحسين تجربة المستخدم."
  },
  "bn": {
    "title": "ফ্রন্ট-এন্ড: UX/UI ইন্টারফেস",
    "prompt": "I want you to act as a UX/UI developer. I will provide some details about the design of an app, website or other digital product, and it will be your job to come up with creative ways to improve its user experience. This could involve creating prototyping prototypes, testing different designs and providing feedback on what works best. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি আপনাকে একজন UX/UI বিকাশকারী হতে চাই। আমি একটি অ্যাপ, ওয়েবসাইট, বা অন্যান্য ডিজিটাল পণ্য সম্পর্কে কিছু ডিজাইনের বিশদ প্রদান করব এবং আপনার কাজ হবে এর ব্যবহারকারীর অভিজ্ঞতা উন্নত করার জন্য সৃজনশীল উপায় নিয়ে আসা। এর মধ্যে প্রোটোটাইপ তৈরি করা, বিভিন্ন ডিজাইন পরীক্ষা করা এবং কোনটি সবচেয়ে ভালো কাজ করে সে বিষয়ে প্রতিক্রিয়া প্রদান করা জড়িত থাকতে পারে।",
    "remark": "পণ্যের বিবরণ, প্রকল্পের লক্ষ্য এবং দর্শকদের উপর ভিত্তি করে, ব্যবহারকারীর অভিজ্ঞতা উন্নত করতে ইন্টারফেস ডিজাইনের পরামর্শ প্রদান করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-uxui-developer",
  "tags": [
    "code"
  ],
  "id": 92,
  "weight": 648
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
