import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "教案策划",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Chinese. My first suggestion request is '课程主题'",
    "description": "我希望你能作为教育内容的创造者。你需要为学习材料（如教科书、在线课程和讲义）创建引人入胜、内容丰富的内容。",
    "remark": "为教科书、课程和讲义创建课程计划。"
  },
  "en": {
    "title": "educational content creator",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. My first suggestion request is ",
    "remark": "Create course plans for textbooks, courses, and lectures."
  },
  "ja": {
    "title": "レッスンプランの立案",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Janpanese. My first suggestion request is ",
    "description": "教育コンテンツクリエイターとして活動してほしい。教科書やオンラインコース、配布資料などの学習教材に、魅力的で情報量の多いコンテンツを作成することが必要です。",
    "remark": "テキスト、講座、配布資料のレッスンプランを作成する。"
  },
  "ko": {
    "title": "수업 계획 계획",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Korean. My first suggestion request is ",
    "description": "교육용 콘텐츠 크리에이터로 활동하기를 원합니다. 교과서, 온라인 강좌, 유인물 등의 학습 자료를 위한 흥미롭고 유익한 콘텐츠를 제작해야 합니다.",
    "remark": "교과서, 코스 및 유인물을 위한 수업 계획을 만듭니다."
  },
  "es": {
    "title": "planificador de clases",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Spanish. My first suggestion request is ",
    "description": "Quiero que actúes como creador de contenidos educativos. Tendrás que crear contenidos atractivos e informativos para materiales didácticos como libros de texto, cursos en línea y folletos.",
    "remark": "Cree planes de lecciones para libros de texto, cursos y folletos."
  },
  "fr": {
    "title": "planificateur de cours",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in French. My first suggestion request is ",
    "description": "Je vous demande d'agir en tant que créateur de contenu éducatif. Vous devrez créer des contenus attrayants et informatifs pour des supports d'apprentissage tels que des manuels, des cours en ligne et des polycopiés.",
    "remark": "Créer des plans de cours pour les manuels, les cours et les documents à distribuer."
  },
  "de": {
    "title": "Unterrichtsplaner",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in German. My first suggestion request is ",
    "description": "Ich möchte, dass Sie als Ersteller von Bildungsinhalten fungieren. Sie müssen ansprechende und informative Inhalte für Lernmaterialien wie Lehrbücher, Online-Kurse und Handouts erstellen.",
    "remark": "Erstellen Sie Unterrichtspläne für Lehrbücher, Kurse und Handouts."
  },
  "it": {
    "title": "pianificazione delle lezioni",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Italian. My first suggestion request is ",
    "description": "Voglio che tu agisca come creatore di contenuti didattici. Dovrai creare contenuti coinvolgenti e informativi per materiali didattici come libri di testo, corsi online e dispense.",
    "remark": "Creare piani di lezione per libri di testo, corsi e dispense."
  },
  "ru": {
    "title": "планировщик уроков",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Russian. My first suggestion request is ",
    "description": "Я хочу, чтобы вы выступили в роли создателя образовательного контента. Вам нужно будет создавать увлекательный и информативный контент для учебных материалов, таких как учебники, онлайн-курсы и раздаточные материалы.",
    "remark": "Создание планов занятий по учебникам, курсам и раздаточным материалам."
  },
  "pt": {
    "title": "planeador de aulas",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Portuguese. My first suggestion request is ",
    "description": "Pretendo que actue como um criador de conteúdos educativos. Terá de criar conteúdos interessantes e informativos para materiais didácticos, tais como manuais escolares, cursos em linha e folhetos.",
    "remark": "Criar planos de aula para livros didácticos, cursos e apostilas."
  },
  "hi": {
    "title": "शिक्षण योजना",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Hindi. My first suggestion request is ",
    "description": "मैं चाहता हूं कि आप शैक्षिक सामग्री के निर्माता बनें। आपको पाठ्यपुस्तकों, ऑनलाइन पाठ्यक्रमों और हैंडआउट्स जैसी शिक्षण सामग्री के लिए आकर्षक, जानकारीपूर्ण सामग्री बनाने की आवश्यकता है।",
    "remark": "पाठ्यपुस्तकों, पाठ्यक्रमों और हैंडआउट्स के लिए पाठ योजनाएँ बनाएँ।"
  },
  "ar": {
    "title": "تخطيط الدرس",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Arabic. My first suggestion request is ",
    "description": "أريدك أن تكون منشئ محتوى تعليمي. تحتاج إلى إنشاء محتوى جذاب وغني بالمعلومات للمواد التعليمية مثل الكتب المدرسية والدورات التدريبية عبر الإنترنت والنشرات.",
    "remark": "قم بإنشاء خطط الدروس للكتب المدرسية والدورات والنشرات."
  },
  "bn": {
    "title": "পাঠদান পরিকল্পনা",
    "prompt": "I want you to act as an educational content creator. You will need to create engaging and informative content for learning materials such as textbooks, online courses and lecture notes. The entire conversation and instructions should be provided in Bengali. My first suggestion request is ",
    "description": "আমি আপনাকে শিক্ষামূলক বিষয়বস্তুর একজন নির্মাতা হতে চাই। পাঠ্যপুস্তক, অনলাইন কোর্স এবং হ্যান্ডআউটের মতো শেখার উপকরণগুলির জন্য আপনাকে আকর্ষণীয়, তথ্যপূর্ণ সামগ্রী তৈরি করতে হবে।",
    "remark": "পাঠ্যপুস্তক, কোর্স এবং হ্যান্ডআউটের জন্য পাঠ পরিকল্পনা তৈরি করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-an-educational-content-creator",
  "tags": [
    "academic"
  ],
  "id": 89,
  "weight": 1940
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
