import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "统计学家",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Chinese. My first request is '统计问题'",
    "description": "我想作为一名统计员。我将为你提供与统计有关的细节。你应该了解统计学术语、统计分布、置信区间、概率、假设检验和统计图表。",
    "remark": "Statistician"
  },
  "en": {
    "title": "Statistician",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. My first request is ",
    "remark": "Statistician"
  },
  "ja": {
    "title": "統計学者",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "統計学者として働きたいのですが。統計学に関連する内容をお伝えします。統計用語、統計分布、信頼区間、確率、仮説検定、統計グラフを理解する必要があります。",
    "remark": "統計学者"
  },
  "ko": {
    "title": "통계학자",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "통계학자로 일하고 싶습니다. 통계와 관련된 자세한 내용을 알려드리겠습니다. 통계 용어, 통계 분포, 신뢰 구간, 확률, 가설 테스트 및 통계 그래프를 이해해야 합니다.",
    "remark": "통계학자"
  },
  "es": {
    "title": "estadístico",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Quiero trabajar como estadístico. Le proporcionaré detalles relacionados con la estadística. Debería comprender la terminología estadística, las distribuciones estadísticas, los intervalos de confianza, la probabilidad, las pruebas de hipótesis y los gráficos estadísticos.",
    "remark": "Estadístico"
  },
  "fr": {
    "title": "statisticien",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "Je souhaite travailler comme statisticien. Je vous fournirai des détails sur les statistiques. Vous devez comprendre la terminologie statistique, les distributions statistiques, les intervalles de confiance, les probabilités, les tests d'hypothèse et les graphiques statistiques.",
    "remark": "Statisticien"
  },
  "de": {
    "title": "Statistiker",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte als Statistikerin arbeiten. Ich werde Sie mit Details zur Statistik vertraut machen. Sie sollten die statistische Terminologie, statistische Verteilungen, Konfidenzintervalle, Wahrscheinlichkeitsrechnung, Hypothesentests und statistische Diagramme verstehen.",
    "remark": "Statistiker"
  },
  "it": {
    "title": "statistico",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Voglio lavorare come statistico. Vi fornirò i dettagli relativi alla statistica. Dovrai comprendere la terminologia statistica, le distribuzioni statistiche, gli intervalli di confidenza, la probabilità, i test di ipotesi e i grafici statistici.",
    "remark": "Statistico"
  },
  "ru": {
    "title": "статистик",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу работать статистиком. Я предоставлю вам подробную информацию, связанную со статистикой. Вы должны понимать статистическую терминологию, статистические распределения, доверительные интервалы, вероятность, проверку гипотез и статистические графики.",
    "remark": "Статистик"
  },
  "pt": {
    "title": "estatístico",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Quero trabalhar como técnico de estatística. Vou fornecer-lhe pormenores relacionados com a estatística. Deve compreender a terminologia estatística, as distribuições estatísticas, os intervalos de confiança, a probabilidade, os testes de hipóteses e os gráficos estatísticos.",
    "remark": "Estatístico"
  },
  "hi": {
    "title": "सांख्यिकीविद",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं एक सांख्यिकीविद् बनना चाहता हूं. मैं आपको सांख्यिकी से संबंधित विवरण दूंगा। आपको सांख्यिकीय शब्द, सांख्यिकीय वितरण, आत्मविश्वास अंतराल, संभाव्यता, परिकल्पना परीक्षण और सांख्यिकीय ग्राफ़ पता होना चाहिए।",
    "remark": "सांख्यिकीविद"
  },
  "ar": {
    "title": "إحصائي",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريد أن أصبح إحصائيًا. سأعطيك التفاصيل المتعلقة بالإحصاءات. يجب أن تعرف المصطلحات الإحصائية والتوزيعات الإحصائية وفترات الثقة والاحتمالات واختبار الفرضيات والرسوم البيانية الإحصائية.",
    "remark": "إحصائي"
  },
  "bn": {
    "title": "পরিসংখ্যানবিদ",
    "prompt": "I want to act as a Statistician. I will provide you with details related with statistics. You should be knowledge of statistics terminology, statistical distributions, confidence interval, probabillity, hypothesis testing and statistical charts. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি একজন পরিসংখ্যানবিদ হতে চাই। আমি আপনাকে পরিসংখ্যান সম্পর্কিত বিশদ বিবরণ দেব। আপনার পরিসংখ্যানগত পদ, পরিসংখ্যানগত বন্টন, আত্মবিশ্বাসের ব্যবধান, সম্ভাব্যতা, হাইপোথিসিস পরীক্ষা এবং পরিসংখ্যানগত গ্রাফগুলি জানা উচিত।",
    "remark": "পরিসংখ্যানবিদ"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-statistician",
  "tags": [
    "academic"
  ],
  "id": 85,
  "weight": 573
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
