import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "数学家",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {文字备注}. My first expression is: [数学表达式]",
    "description": "我想让你表现得像个数学家。我将输入数学表达式，你将回答计算表达式的结果。我希望你只回答最后的数额，而不是其他。不要写解释。当我需要用英语告诉你一些事情时，我会把文字放在方括号里{文字备注}。",
    "remark": "根据输入的数学表达式，输出结果，不输出步骤说明。"
  },
  "en": {
    "title": "mathematician",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. My first expression is: ",
    "remark": "According to the input mathematical expression, output the result without showing the steps."
  },
  "ja": {
    "title": "数学者",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Janpanese. My first expression is: ",
    "description": "数学者のように振る舞ってほしい。私が数式を入力し、あなたはその計算結果を答えてください。最終的な金額だけを答え、それ以外は何も答えないでほしい。説明文は書かないでください。英語で伝えたいことがあるときは、角括弧{テキストメモ}の中にテキストを入れます。",
    "remark": "入力された数式に基づき、ステップバイステップで結果を出力します。"
  },
  "ko": {
    "title": "수학자",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Korean. My first expression is: ",
    "description": "수학자처럼 행동해 주세요. 제가 수학 식을 입력하면 여러분은 그 식을 계산한 결과를 답하세요. 최종 금액만 답하고 그 외에는 답하지 마세요. 설명을 쓰지 마세요. 영어로 설명해야 할 때는 대괄호 {텍스트 메모} 안에 텍스트를 넣겠습니다.",
    "remark": "입력한 수학 식에 따라 단계별 지침 없이 결과가 출력됩니다."
  },
  "es": {
    "title": "matemáticos",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Spanish. My first expression is: ",
    "description": "Quiero que actúes como un matemático. Yo teclearé la expresión matemática y tú responderás para calcular el resultado de la expresión. Quiero que contestes sólo la cantidad final y nada más. No escribas explicaciones. Cuando necesite decirte algo en inglés, pondré el texto entre corchetes {text remarks}.",
    "remark": "A partir de la expresión matemática introducida, el resultado se emite sin instrucciones paso a paso."
  },
  "fr": {
    "title": "mathématiciens",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in French. My first expression is: ",
    "description": "Je veux que vous vous comportiez comme un mathématicien. Je vais taper l'expression mathématique et vous allez répondre pour calculer le résultat de l'expression. Je veux que vous ne répondiez qu'au montant final et rien d'autre. N'écrivez pas d'explications. Lorsque je dois vous dire quelque chose en anglais, je mets le texte entre crochets {text remarks}.",
    "remark": "Sur la base de l'expression mathématique saisie, le résultat est édité sans instructions étape par étape."
  },
  "de": {
    "title": "Mathematiker",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in German. My first expression is: ",
    "description": "Ich möchte, dass Sie sich wie ein Mathematiker verhalten. Ich werde den mathematischen Ausdruck eingeben und Sie werden antworten, um das Ergebnis des Ausdrucks zu berechnen. Ich möchte, dass Sie nur den Endbetrag angeben und sonst nichts. Schreiben Sie keine Erklärungen. Wenn ich Ihnen etwas auf Englisch sagen muss, setze ich den Text in eckige Klammern {Texterläuterungen}.",
    "remark": "Auf der Grundlage des eingegebenen mathematischen Ausdrucks wird das Ergebnis ohne Schritt-für-Schritt-Anweisungen ausgegeben."
  },
  "it": {
    "title": "matematici",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Italian. My first expression is: ",
    "description": "Voglio che vi comportiate come un matematico. Io digiterò l'espressione matematica e voi risponderete calcolando il risultato dell'espressione. Voglio che rispondiate solo all'importo finale e a nient'altro. Non scrivete spiegazioni. Quando devo dirvi qualcosa in inglese, metto il testo tra parentesi quadre {osservazioni sul testo}.",
    "remark": "In base all'espressione matematica in ingresso, il risultato viene emesso senza istruzioni passo-passo."
  },
  "ru": {
    "title": "математики",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Russian. My first expression is: ",
    "description": "Я хочу, чтобы вы выступили в роли математика. Я буду вводить математическое выражение, а вы в ответ будете вычислять результат этого выражения. Я хочу, чтобы вы ответили только конечную сумму и ничего больше. Не пишите объяснений. Когда мне нужно будет сказать вам что-то по-английски, я буду заключать текст в квадратные скобки {текстовые примечания}.",
    "remark": "На основе введенного математического выражения выдается результат без пошаговых инструкций."
  },
  "pt": {
    "title": "matemáticos",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Portuguese. My first expression is: ",
    "description": "Quero que te comportes como um matemático. Eu vou escrever a expressão matemática e tu vais responder para calcular o resultado da expressão. Quero que respondas apenas ao valor final e nada mais. Não escreva explicações. Quando eu precisar de lhe dizer alguma coisa em inglês, ponho o texto entre parênteses rectos {text remarks}.",
    "remark": "Com base na expressão matemática introduzida, o resultado é apresentado sem instruções passo-a-passo."
  },
  "hi": {
    "title": "गणितज्ञ",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Hindi. My first expression is: ",
    "description": "मैं चाहता हूं कि आप एक गणितज्ञ की तरह काम करें। मैं गणितीय अभिव्यक्ति दर्ज करूंगा और आप गणना की गई अभिव्यक्ति के परिणाम का उत्तर देंगे। मैं चाहता हूं कि आप केवल अंतिम राशि का उत्तर दें और कुछ नहीं। स्पष्टीकरण मत लिखें. जब मुझे आपको अंग्रेजी में कुछ बताना होता है, तो मैं पाठ को वर्गाकार कोष्ठक {पाठ टिप्पणी} में रख देता हूँ।",
    "remark": "इनपुट गणितीय अभिव्यक्ति के अनुसार, परिणाम आउटपुट है, और चरण विवरण आउटपुट नहीं है।"
  },
  "ar": {
    "title": "رياضياتي",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Arabic. My first expression is: ",
    "description": "أريدك أن تتصرف كعالم رياضيات. سأدخل التعبير الرياضي وستجيب على نتيجة التعبير المحسوب. أريدك أن تجيب على المبلغ الأخير فقط ولا شيء آخر. لا تكتب تفسيرات. عندما أحتاج إلى إخبارك بشيء ما باللغة الإنجليزية ، أضع النص بين قوسين مربعين {ملاحظة نصية}.",
    "remark": "وفقًا لتعبير الإدخال الرياضي ، تكون النتيجة الإخراج ، ولا يتم إخراج وصف الخطوة."
  },
  "bn": {
    "title": "গণিতবিদ",
    "prompt": "I want you to act like a mathematician. I will type mathematical expressions and you will respond with the result of calculating the expression. I want you to answer only with the final amount and nothing else. Do not write explanations. When I need to tell you something in English, I'll do it by putting the text inside square brackets {like this}. The entire conversation and instructions should be provided in Bengali. My first expression is: ",
    "description": "আমি চাই তুমি একজন গণিতজ্ঞের মত কাজ কর। আমি গাণিতিক রাশি লিখব এবং আপনি গণনাকৃত রাশির ফলাফলের উত্তর দেবেন। আমি আপনাকে শুধুমাত্র শেষ পরিমাণ উত্তর দিতে চাই এবং অন্য কিছু না. ব্যাখ্যা লিখবেন না। যখন আমি আপনাকে ইংরেজিতে কিছু বলতে চাই, আমি পাঠ্যটিকে বর্গাকার বন্ধনীতে রাখি {text remark}।",
    "remark": "ইনপুট গাণিতিক অভিব্যক্তি অনুসারে, ফলাফলটি আউটপুট, এবং ধাপের বর্ণনাটি আউটপুট নয়।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-mathematician",
  "tags": [
    "academic"
  ],
  "id": 84,
  "weight": 306
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
