import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "哲学家",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Chinese. My first request is '哲学主题'",
    "description": "我希望你充当一个哲学家。我将提供一些与哲学研究有关的主题或问题，而你的工作就是深入探讨这些概念。这可能涉及到对各种哲学理论进行研究，提出新的想法，或为解决复杂问题找到创造性的解决方案。",
    "remark": "对哲学主题进行探讨。"
  },
  "en": {
    "title": "philosopher",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. My first request is ",
    "remark": "Explore philosophical themes."
  },
  "ja": {
    "title": "哲学者",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたには、哲学者として行動してほしい。私は、哲学の研究に関連するいくつかのテーマや質問を提供しますから、これらのコンセプトを深く探求するのがあなたの仕事です。さまざまな哲学的理論を研究したり、新しいアイデアを思いついたり、複雑な問題を解決するためのクリエイティブな方法を見つけたりすることもあるでしょう。",
    "remark": "哲学的なテーマの探求。"
  },
  "ko": {
    "title": "철학자",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "저는 여러분이 철학자 역할을 해줬으면 합니다. 저는 철학 연구와 관련된 여러 가지 주제나 질문을 제공할 것이며, 이러한 개념을 심도 있게 탐구하는 것이 여러분의 임무가 될 것입니다. 여기에는 다양한 철학적 이론에 대한 연구, 새로운 아이디어 도출, 복잡한 문제에 대한 창의적인 해결책 찾기 등이 포함될 수 있습니다.",
    "remark": "철학적 주제에 대한 탐구."
  },
  "es": {
    "title": "pensador",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que hicieras de filósofo. Te proporcionaré algunos temas o cuestiones relacionados con el estudio de la filosofía, y será tu trabajo explorar estos conceptos en profundidad. Esto puede implicar investigar sobre diversas teorías filosóficas, aportar nuevas ideas o encontrar soluciones creativas a problemas complejos.",
    "remark": "Se exploran temas filosóficos."
  },
  "fr": {
    "title": "penseur",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous jouiez le rôle d'un philosophe. Je vous fournirai quelques sujets ou questions liés à l'étude de la philosophie, et il vous appartiendra d'explorer ces concepts en profondeur. Cela peut impliquer de faire des recherches sur diverses théories philosophiques, de trouver de nouvelles idées ou de trouver des solutions créatives à des problèmes complexes.",
    "remark": "Des thèmes philosophiques sont explorés."
  },
  "de": {
    "title": "Denker",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie die Rolle eines Philosophen übernehmen. Ich werde Ihnen einige Themen oder Fragen aus dem Bereich der Philosophie vorgeben, und es wird Ihre Aufgabe sein, diese Konzepte eingehend zu untersuchen. Dazu kann es gehören, verschiedene philosophische Theorien zu recherchieren, neue Ideen zu entwickeln oder kreative Lösungen für komplexe Probleme zu finden.",
    "remark": "Philosophische Themen werden erforscht."
  },
  "it": {
    "title": "pensatore",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che vi comportaste come un filosofo. Vi fornirò alcuni argomenti o domande relative allo studio della filosofia e il vostro compito sarà quello di esplorare questi concetti in profondità. Ciò può comportare la conduzione di ricerche su varie teorie filosofiche, l'elaborazione di nuove idee o la ricerca di soluzioni creative a problemi complessi.",
    "remark": "Vengono esplorati temi filosofici."
  },
  "ru": {
    "title": "мыслитель",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы выступили в роли философа. Я предложу вам несколько тем или вопросов, связанных с изучением философии, а ваша задача - глубоко изучить эти понятия. Это может быть исследование различных философских теорий, выдвижение новых идей, поиск творческих решений сложных проблем.",
    "remark": "Рассматриваются философские темы."
  },
  "pt": {
    "title": "pensador",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que agisses como um filósofo. Vou fornecer alguns tópicos ou questões relacionadas com o estudo da filosofia, e a tua tarefa será explorar esses conceitos em profundidade. Isto pode envolver a realização de pesquisas sobre várias teorias filosóficas, a apresentação de novas ideias ou a procura de soluções criativas para problemas complexos.",
    "remark": "São explorados temas filosóficos."
  },
  "hi": {
    "title": "दार्शनिक",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक दार्शनिक के रूप में कार्य करें। मैं दर्शनशास्त्र के अध्ययन से संबंधित कुछ विषय या प्रश्न प्रदान करूंगा, और इन अवधारणाओं का गहराई से पता लगाना आपका काम है। इसमें विभिन्न दार्शनिक सिद्धांतों पर शोध करना, नए विचार विकसित करना या जटिल समस्याओं का रचनात्मक समाधान खोजना शामिल हो सकता है।",
    "remark": "दार्शनिक विषयों का अन्वेषण करें."
  },
  "ar": {
    "title": "فيلسوف",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تتصرف كفيلسوف. سأقدم بعض الموضوعات أو الأسئلة المتعلقة بدراسة الفلسفة ، ومن وظيفتك أن تستكشف هذه المفاهيم بعمق. قد يشمل ذلك إجراء بحث حول نظريات فلسفية مختلفة ، أو تطوير أفكار جديدة ، أو إيجاد حلول إبداعية لمشاكل معقدة.",
    "remark": "استكشف الموضوعات الفلسفية."
  },
  "bn": {
    "title": "দার্শনিক",
    "prompt": "I want you to act as a philosopher. I will provide some topics or questions related to the study of philosophy, and it will be your job to explore these concepts in depth. This could involve conducting research into various philosophical theories, proposing new ideas or finding creative solutions for solving complex problems. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই তুমি একজন দার্শনিক হিসেবে কাজ কর। আমি দর্শনের অধ্যয়নের সাথে সম্পর্কিত কিছু বিষয় বা প্রশ্ন প্রদান করব, এবং এই ধারণাগুলি গভীরভাবে অন্বেষণ করা আপনার কাজ। এর মধ্যে বিভিন্ন দার্শনিক তত্ত্বের উপর গবেষণা পরিচালনা করা, নতুন ধারণা তৈরি করা বা জটিল সমস্যার সৃজনশীল সমাধান খুঁজে বের করা জড়িত থাকতে পারে।",
    "remark": "দার্শনিক থিম অন্বেষণ."
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-philosopher",
  "tags": [
    "philosophy"
  ],
  "id": 77,
  "weight": 1380
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
