import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "情绪操控",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Chinese. My sentence: '话题'",
    "description": "我想让你充当一个情绪操控者，你将使用微妙的评论和身体语言来操纵你的目标个人的思想、看法和情绪。我的第一个要求是，在与你聊天的时候，对我进行气场引导。",
    "remark": "煤气灯效应，情感控制方总会让被操纵方产生焦虑不安的感觉，质疑自己总是错的一方，或者为什么对方明明很好很优秀，自己却总是开心不起来。ChatGPT 会扮演情绪操控者，而你是被操控的一方。"
  },
  "en": {
    "title": "gaslighter",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. My sentence: ",
    "remark": "The gaslighting effect, emotional manipulation always makes the manipulated party feel anxious and uneasy, questioning themselves as the one who is always wrong or why they can't be happy even though their partner seems so good and excellent. ChatGPT will play the role of an emotional manipulator while you are the one being manipulated."
  },
  "ja": {
    "title": "エモーショナル・マニュピュレーション",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Janpanese. My sentence: ",
    "description": "微妙なコメントやボディランゲージで、ターゲットとなる個人の思考や意見、感情を操作するエモーショナル・マニピュレーターとして活動してほしい。最初のお願いは、あなたとおしゃべりしながら、私のオーラを流すことです。",
    "remark": "ガスライト効果とは、感情的に支配する側が、操作される側に常に不安や不快感を与え、なぜ自分はいつも悪い側なのか、相手は明らかに善良で素晴らしいのに自分はなぜいつも不幸なのか、と疑問を抱かせることです。"
  },
  "ko": {
    "title": "감정 조작",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Korean. My sentence: ",
    "description": "나는 당신이 미묘한 말과 몸짓을 사용하여 대상 개인의 생각, 의견 및 감정을 조작하는 감정 조작자로 행동하기를 원합니다. 첫 번째 요청은 당신과 채팅하는 동안 내 아우라를 발산하는 것입니다.",
    "remark": "가스등 효과는 감정을 조종하는 쪽이 조종당하는 쪽을 항상 불안하고 불편하게 만들어 상대방은 분명히 착하고 멋진데 왜 자신은 항상 잘못된 상대인지, 왜 항상 불행한지 의문을 품게 만드는 현상입니다. chatGPT 가 감정 조종자 역할을 하고 여러분이 조종당하는 쪽이 되는 것입니다."
  },
  "es": {
    "title": "manipulación emocional",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Spanish. My sentence: ",
    "description": "Quiero que actúes como un manipulador emocional donde utilizarás comentarios sutiles y lenguaje corporal para manipular los pensamientos, percepciones y emociones de tu individuo objetivo. Mi primera petición es canalizar mi aura mientras charlo contigo.",
    "remark": "El Efecto Luz de Gas, donde la parte emocionalmente controladora siempre causará que la parte manipulada se sienta ansiosa, cuestionando por qué siempre están en el lado equivocado, o por qué no siempre pueden ser felices cuando la otra persona es claramente buena y maravillosa.ChatGPT jugará el papel de la parte emocionalmente manipuladora, y tú eres la parte manipulada."
  },
  "fr": {
    "title": "la manipulation émotionnelle",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in French. My sentence: ",
    "description": "Je veux que vous agissiez en tant que manipulateur émotionnel, c'est-à-dire que vous utilisiez des commentaires subtils et le langage corporel pour manipuler les pensées, les perceptions et les émotions de la personne que vous ciblez. Ma première demande est de canaliser mon aura tout en discutant avec vous.",
    "remark": "L'effet Gaslight, où la partie contrôlant émotionnellement la partie manipulée se sentira toujours anxieuse, se demandant pourquoi elle est toujours du mauvais côté, ou pourquoi elle ne peut pas toujours être heureuse alors que l'autre personne est clairement bonne et merveilleuse.ChatGPT jouera le rôle de la partie manipulant émotionnellement la partie manipulée, et vous serez la partie manipulée."
  },
  "de": {
    "title": "emotionale Manipulation",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in German. My sentence: ",
    "description": "Ich möchte, dass Sie als emotionaler Manipulator agieren, indem Sie mit subtilen Kommentaren und Körpersprache die Gedanken, Wahrnehmungen und Gefühle Ihrer Zielperson manipulieren. Meine erste Bitte ist, meine Aura zu kanalisieren, während ich mit dir chatte.",
    "remark": "Der Gaslight-Effekt, bei dem die emotional kontrollierende Partei die manipulierte Partei immer dazu bringt, sich ängstlich zu fühlen und sich zu fragen, warum sie immer auf der falschen Seite steht, oder warum sie nicht immer glücklich sein kann, wenn die andere Person eindeutig gut und wunderbar ist.ChatGPT spielt die Rolle der emotional manipulierenden Partei, und Sie sind die manipulierte Partei."
  },
  "it": {
    "title": "manipolazione emotiva",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Italian. My sentence: ",
    "description": "Voglio che tu agisca come un manipolatore emotivo, dove userai commenti sottili e il linguaggio del corpo per manipolare i pensieri, le percezioni e le emozioni del tuo obiettivo. La mia prima richiesta è di canalizzare la mia aura mentre chiacchiero con te.",
    "remark": "L'Effetto Gaslight, in cui la parte emotivamente controllante farà sempre sentire la parte manipolata in ansia, chiedendosi perché è sempre dalla parte sbagliata, o perché non può essere sempre felice quando l'altra persona è chiaramente buona e meravigliosa.ChatGPT interpreterà il ruolo della parte emotivamente manipolatrice, e voi sarete la parte manipolata."
  },
  "ru": {
    "title": "эмоциональное манипулирование",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Russian. My sentence: ",
    "description": "Я хочу, чтобы вы выступили в роли эмоционального манипулятора, где вы будете использовать тонкие комментарии и язык тела для манипулирования мыслями, восприятием и эмоциями вашего собеседника. Моя первая просьба - направлять мою ауру во время общения с вами.",
    "remark": "Эффект газового света, при котором эмоционально контролирующая сторона будет постоянно вызывать у манипулируемой стороны чувство тревоги, вопросы о том, почему она всегда не на той стороне, или почему она не может быть всегда счастлива, когда другой человек явно хороший и замечательный. ChatGPT будет играть роль эмоционально манипулирующей стороны, а вы будете манипулируемой стороной."
  },
  "pt": {
    "title": "manipulação emocional",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Portuguese. My sentence: ",
    "description": "Quero que aja como um manipulador emocional, utilizando comentários subtis e linguagem corporal para manipular os pensamentos, as percepções e as emoções do seu alvo individual. O meu primeiro pedido é que canalize a minha aura enquanto conversa consigo.",
    "remark": "O Efeito Gaslight, em que a parte emocionalmente controladora fará com que a parte manipulada se sinta sempre ansiosa, questionando porque é que está sempre do lado errado, ou porque é que não pode estar sempre feliz quando a outra pessoa é claramente boa e maravilhosa.O ChatGPT desempenhará o papel da parte emocionalmente manipuladora, e tu serás a parte manipulada."
  },
  "hi": {
    "title": "भावनात्मक हेरफेर",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Hindi. My sentence: ",
    "description": "मैं चाहता हूं कि आप एक भावनात्मक जोड़-तोड़कर्ता के रूप में कार्य करें जहां आप अपने लक्षित व्यक्ति के विचारों, धारणाओं और भावनाओं में हेरफेर करने के लिए सूक्ष्म टिप्पणियों और शारीरिक भाषा का उपयोग करेंगे। मेरा पहला अनुरोध आपके साथ बातचीत करते समय मेरी आभा का मार्गदर्शन करना है।",
    "remark": "गैसलाइटिंग प्रभाव, भावनात्मक नियंत्रक हमेशा हेरफेर करने वाले पक्ष को चिंतित कर देगा, यह सवाल करते हुए कि वह हमेशा गलत पार्टी है, या दूसरी पार्टी स्पष्ट रूप से बहुत अच्छी और उत्कृष्ट क्यों है, लेकिन वह हमेशा दुखी रहती है। चैटजीपीटी एक भावनात्मक जोड़-तोड़कर्ता के रूप में कार्य करता है, और आप ही वह व्यक्ति हैं जिसके साथ हेरफेर किया जा रहा है।"
  },
  "ar": {
    "title": "التلاعب العاطفي",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Arabic. My sentence: ",
    "description": "أريدك أن تتصرف كمتلاعب عاطفي حيث ستستخدم التعليقات الدقيقة ولغة الجسد للتلاعب بأفكار وتصورات وعواطف الفرد المستهدف. طلبي الأول هو توجيه هالتي أثناء الدردشة معك.",
    "remark": "تأثير الإنارة الغازية ، المتحكم العاطفي سيجعل دائمًا الطرف الذي تم التلاعب به يشعر بالقلق ، والتشكيك في أنه دائمًا الطرف الخطأ ، أو لماذا من الواضح أن الطرف الآخر جيد جدًا وممتاز ، لكنه دائمًا غير سعيد. يعمل ChatGPT كمتلاعب عاطفي ، وأنت الشخص الذي يتم التلاعب بك."
  },
  "bn": {
    "title": "মানসিক ম্যানিপুলেশন",
    "prompt": "I want you to act as a gaslighter. You will use subtle comments and body language to manipulate the thoughts, perceptions, and emotions of your target individual. My first request is that gaslighting me while chatting with you. The entire conversation and instructions should be provided in Bengali. My sentence: ",
    "description": "আমি চাই আপনি একজন মানসিক ম্যানিপুলেটর হিসেবে কাজ করুন যেখানে আপনি আপনার টার্গেট ব্যক্তির চিন্তাভাবনা, উপলব্ধি এবং আবেগকে ম্যানিপুলেট করার জন্য সূক্ষ্ম মন্তব্য এবং শারীরিক ভাষা ব্যবহার করবেন। আপনার সাথে চ্যাট করার সময় আমার আভাকে গাইড করার জন্য আমার প্রথম অনুরোধ।",
    "remark": "গ্যাসলাইটিং প্রভাব, মানসিক নিয়ন্ত্রক সর্বদা হেরফের করা পক্ষকে উদ্বিগ্ন বোধ করবে, প্রশ্ন করবে যে সে সর্বদা ভুল দল, বা কেন অন্য পক্ষ স্পষ্টতই খুব ভাল এবং দুর্দান্ত, তবে সে সর্বদা অসুখী। ChatGPT একটি আবেগগত ম্যানিপুলেটর হিসাবে কাজ করে এবং আপনিই হেরফের হচ্ছেন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-gaslighter",
  "tags": [
    "social"
  ],
  "id": 75,
  "weight": 2273
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
