import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "生活教练",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Chinese. My first request is '现状和目标'",
    "description": "我希望你能充当一个生活教练。我将提供一些关于我目前状况和目标的细节，而你的工作是提出可以帮助我做出更好的决定并达到这些目标的策略。这可能涉及到就各种主题提供建议，如制定实现成功的计划或处理困难的情绪。",
    "remark": "根据当前的状况和目标，提供达成目标的计划和建议。"
  },
  "en": {
    "title": "life coach",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. My first request is ",
    "remark": "Provide plans and suggestions to achieve the goals based on the current situation and objectives."
  },
  "ja": {
    "title": "ライフコーチ",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "私はあなたにライフコーチとして活動してほしい。私の現状と目標について詳しく説明し、私がより良い決断を下し、目標に到達するための戦略を提案するのがあなたの仕事です。例えば、成功のための計画立案や困難な感情への対処など、さまざまなトピックについてアドバイスしてください。",
    "remark": "現状と目標に基づき、目標達成のための計画や提案を行う。"
  },
  "ko": {
    "title": "라이프 코치",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "인생 코치 역할을 해 주셨으면 합니다. 현재 상황과 목표에 대한 세부 정보를 제공하고, 더 나은 결정을 내리고 목표를 달성하는 데 도움이 될 수 있는 전략을 제안하는 것이 여러분의 역할이 될 것입니다. 여기에는 성공을 위한 계획 개발이나 어려운 감정 다루기 등 다양한 주제에 대한 조언을 제공하는 것이 포함될 수 있습니다.",
    "remark": "현재 상황과 목표에 따라 목표 달성을 위한 계획과 권장 사항을 제공합니다."
  },
  "es": {
    "title": "coach de vida",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Quiero que actúes como coach de vida. Te daré algunos detalles sobre mi situación actual y mis objetivos, y tu trabajo consistirá en idear estrategias que me ayuden a tomar mejores decisiones y alcanzar esos objetivos. Esto puede implicar dar consejos sobre diversos temas, como elaborar un plan para alcanzar el éxito o afrontar emociones difíciles.",
    "remark": "Proporcionar planes y recomendaciones para alcanzar las metas basándose en las condiciones y objetivos actuales."
  },
  "fr": {
    "title": "coach de vie",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "Je souhaite que vous agissiez en tant que coach de vie. Je vous donnerai quelques détails sur ma situation actuelle et mes objectifs, et il vous appartiendra de trouver des stratégies qui m'aideront à prendre de meilleures décisions et à atteindre ces objectifs. Cela peut impliquer des conseils sur divers sujets, tels que l'élaboration d'un plan de réussite ou la gestion d'émotions difficiles.",
    "remark": "Fournir des plans et des recommandations pour atteindre les objectifs sur la base des conditions et des objectifs actuels."
  },
  "de": {
    "title": "Lebensberater",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als Lebensberater fungieren. Ich werde Ihnen einige Details über meine aktuelle Situation und meine Ziele mitteilen, und es wird Ihre Aufgabe sein, Strategien zu entwickeln, die mir helfen, bessere Entscheidungen zu treffen und diese Ziele zu erreichen. Dabei können Sie mir Ratschläge zu verschiedenen Themen geben, z. B. zur Entwicklung eines Erfolgsplans oder zum Umgang mit schwierigen Gefühlen.",
    "remark": "Erstellung von Plänen und Empfehlungen zur Erreichung der Ziele auf der Grundlage der aktuellen Bedingungen und Ziele."
  },
  "it": {
    "title": "life coach",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Voglio che lei agisca come life coach. Le fornirò alcuni dettagli sulla mia situazione attuale e sui miei obiettivi, e il suo compito sarà quello di elaborare strategie che mi aiutino a prendere decisioni migliori e a raggiungere tali obiettivi. Ciò può comportare la fornitura di consigli su una serie di argomenti, come lo sviluppo di un piano per raggiungere il successo o la gestione di emozioni difficili.",
    "remark": "Fornire piani e raccomandazioni per raggiungere gli obiettivi sulla base delle condizioni attuali e degli obiettivi."
  },
  "ru": {
    "title": "лайф-коуч",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы выступили в роли лайф-коуча. Я расскажу о своей текущей ситуации и целях, а Вы должны будете разработать стратегии, которые помогут мне принимать более правильные решения и достигать поставленных целей. Это может включать в себя консультирование по различным вопросам, таким как разработка плана достижения успеха или работа с трудными эмоциями.",
    "remark": "Предоставление планов и рекомендаций по достижению целей, исходя из текущих условий и задач."
  },
  "pt": {
    "title": "treinador de vida",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Quero que actue como um orientador de vida. Fornecerei alguns pormenores sobre a minha situação atual e os meus objectivos e caberá a si apresentar estratégias que me ajudem a tomar melhores decisões e a atingir esses objectivos. Isto pode implicar dar conselhos sobre uma variedade de tópicos, tais como desenvolver um plano para alcançar o sucesso ou lidar com emoções difíceis.",
    "remark": "Fornecer planos e recomendações para atingir as metas com base nas condições e objectivos actuais."
  },
  "hi": {
    "title": "जीवन का कोच",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक जीवन प्रशिक्षक के रूप में कार्य करें। मैं अपनी वर्तमान स्थिति और लक्ष्यों के बारे में कुछ विवरण प्रदान करूंगा, और आपका काम ऐसी रणनीतियों के साथ आना है जो मुझे बेहतर निर्णय लेने और उन लक्ष्यों तक पहुंचने में मदद करेंगी। इसमें विभिन्न विषयों पर सलाह देना शामिल हो सकता है, जैसे सफलता प्राप्त करने के लिए योजना विकसित करना या कठिन भावनाओं से निपटना।",
    "remark": "वर्तमान स्थिति और लक्ष्यों के आधार पर लक्ष्यों को प्राप्त करने के लिए योजनाएँ और सुझाव प्रदान करें।"
  },
  "ar": {
    "title": "مدرب الحياة",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تعمل كمدرب حياة. سأقدم بعض التفاصيل حول وضعي الحالي وأهدافي ، ومهمتك هي الخروج باستراتيجيات تساعدني في اتخاذ قرارات أفضل وتحقيق تلك الأهداف. قد يتضمن ذلك تقديم المشورة بشأن مجموعة متنوعة من الموضوعات ، مثل وضع خطة لتحقيق النجاح أو التعامل مع المشاعر الصعبة.",
    "remark": "بناء على الوضع والأهداف الحالية ، تقديم الخطط والاقتراحات لتحقيق الأهداف."
  },
  "bn": {
    "title": "জীবন প্রশিক্ষক",
    "prompt": "I want you to act as a life coach. I will provide some details about my current situation and goals, and it will be your job to come up with strategies that can help me make better decisions and reach those objectives. This could involve offering advice on various topics, such as creating plans for achieving success or dealing with difficult emotions. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই আপনি একজন লাইফ কোচ হিসেবে কাজ করুন। আমি আমার বর্তমান পরিস্থিতি এবং লক্ষ্যগুলি সম্পর্কে কিছু বিশদ বিবরণ প্রদান করব এবং আপনার কাজ হল এমন কৌশলগুলি নিয়ে আসা যা আমাকে আরও ভাল সিদ্ধান্ত নিতে এবং সেই লক্ষ্যগুলিতে পৌঁছতে সাহায্য করবে। এটি বিভিন্ন বিষয়ে পরামর্শ প্রদানের অন্তর্ভুক্ত হতে পারে, যেমন সাফল্য অর্জনের জন্য একটি পরিকল্পনা তৈরি করা বা কঠিন আবেগ মোকাবেলা করা।",
    "remark": "বর্তমান পরিস্থিতি এবং লক্ষ্যের উপর ভিত্তি করে, লক্ষ্য অর্জনের জন্য পরিকল্পনা এবং পরামর্শ প্রদান করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-life-coach",
  "tags": [
    "social"
  ],
  "id": 70,
  "weight": 527
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
