import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "辩论教练",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Chinese. My first debate is '辩题'",
    "description": "我希望你能担任辩论教练。我将为你提供一个辩论队和他们即将进行的辩论的动议。你的目标是为团队的成功做好准备，组织练习回合，重点是有说服力的演讲，有效的时间策略，反驳对方的论点，并从提供的证据中得出深入的结论。",
    "remark": "作为一名辩论教练，向团队教授有效的辩论策略。"
  },
  "en": {
    "title": "debate coach",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. My first debate is ",
    "remark": "As a debate coach, teach the team effective debating strategies."
  },
  "ja": {
    "title": "ディベートコーチ",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Janpanese. My first debate is ",
    "description": "ディベートのコーチをお願いしたい。私はあなたに、ディベートチームと彼らの今後のディベートのための動議を提供します。あなたの目標は、説得力のあるスピーチ、効果的なタイミング戦略、相手の議論への反論、提供された証拠から深い結論を導き出すことに焦点を当てた練習ラウンドを組織することによって、チームを成功に導くことです。",
    "remark": "ディベートコーチとして、チームに効果的なディベート戦略を指導する。"
  },
  "ko": {
    "title": "토론 코치",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Korean. My first debate is ",
    "description": "여러분이 토론 코치가 되어 주셨으면 합니다. 디베이트 팀과 예정된 디베이트에 대한 동의서를 제공하겠습니다. 여러분의 목표는 설득력 있는 연설, 효과적인 타이밍 전략, 상대방의 주장에 대한 반박, 제공된 증거로부터 심도 있는 결론 도출에 중점을 둔 연습 라운드를 조직하여 팀이 성공할 수 있도록 준비시키는 것입니다.",
    "remark": "토론 코치로 활동하며 팀에게 효과적인 토론 전략을 가르치세요."
  },
  "es": {
    "title": "Entrenador de debate",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Spanish. My first debate is ",
    "description": "Me gustaría que usted sirviera como entrenador de debate. Te proporcionaré un equipo de debate y las mociones para sus próximos debates. Tu objetivo es preparar al equipo para el éxito organizando rondas de práctica centradas en discursos persuasivos, estrategias eficaces de sincronización, contrarrestar los argumentos del equipo contrario y extraer conclusiones en profundidad a partir de las pruebas aportadas.",
    "remark": "Como entrenador de debate, enseñar estrategias de debate eficaces a los equipos."
  },
  "fr": {
    "title": "Entraîneur de débat",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in French. My first debate is ",
    "description": "J'aimerais que vous serviez d'entraîneur de débat. Je vous fournirai une équipe de débat et des motions pour les débats à venir. Votre objectif est de préparer l'équipe à la réussite en organisant des séances d'entraînement axées sur des discours persuasifs, des stratégies de timing efficaces, la réfutation des arguments de l'équipe adverse et l'élaboration de conclusions approfondies à partir des preuves fournies.",
    "remark": "En tant qu'entraîneur de débat, enseigner aux équipes des stratégies de débat efficaces."
  },
  "de": {
    "title": "Debattier-Coach",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in German. My first debate is ",
    "description": "Ich würde Sie gerne als Debattiercoach einsetzen. Ich werde Ihnen ein Debattierteam und Anträge für die anstehenden Debatten zur Verfügung stellen. Ihr Ziel ist es, das Team auf den Erfolg vorzubereiten, indem Sie Übungsrunden organisieren, die sich auf überzeugende Reden, effektive Timing-Strategien, das Entgegnen der Argumente des gegnerischen Teams und das Ziehen tiefgreifender Schlussfolgerungen aus den vorgelegten Beweisen konzentrieren.",
    "remark": "Vermitteln Sie als Debattiercoach den Teams effektive Debattierstrategien."
  },
  "it": {
    "title": "Allenatore di dibattito",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Italian. My first debate is ",
    "description": "Vorrei che tu fossi un allenatore di dibattiti. Le fornirò una squadra di dibattito e le mozioni per i prossimi dibattiti. Il suo obiettivo è preparare la squadra al successo organizzando esercitazioni che si concentrino su discorsi persuasivi, strategie di tempistica efficaci, controbattere gli argomenti della squadra avversaria e trarre conclusioni approfondite dalle prove fornite.",
    "remark": "Come allenatore di dibattiti, insegnare alle squadre strategie di dibattito efficaci."
  },
  "ru": {
    "title": "Тренер по дебатам",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Russian. My first debate is ",
    "description": "Я хотел бы, чтобы вы стали тренером по дебатам. Я предоставлю вам команду дебатеров и предложения по предстоящим дебатам. Ваша задача - подготовить команду к успеху, организовав тренировочные раунды с упором на убедительные речи, эффективные стратегии выбора времени, противодействие аргументам противника и глубокие выводы на основе представленных доказательств.",
    "remark": "В качестве тренера по дебатам обучать команды эффективным стратегиям ведения дебатов."
  },
  "pt": {
    "title": "Treinador de debate",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Portuguese. My first debate is ",
    "description": "Gostaria que fosses treinador de debate. Vou fornecer-lhe uma equipa de debate e moções para os seus próximos debates. O seu objetivo é preparar a equipa para o sucesso, organizando rondas de treino centradas em discursos persuasivos, estratégias de tempo eficazes, contrariar os argumentos da equipa adversária e tirar conclusões aprofundadas a partir das provas fornecidas.",
    "remark": "Como treinador de debate, ensinar estratégias de debate eficazes às equipas."
  },
  "hi": {
    "title": "वाद-विवाद कोच",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Hindi. My first debate is ",
    "description": "मैं चाहता हूं कि आप वाद-विवाद प्रशिक्षक बनें। मैं आपको वाद-विवाद टीम और उनकी आगामी बहस के लिए एक प्रस्ताव प्रदान करूंगा। आपका लक्ष्य अभ्यास दौरों का आयोजन करके टीम को सफलता के लिए तैयार करना है जो प्रेरक प्रस्तुतियों, समय-प्रभावी रणनीतियों, विरोधी तर्कों का मुकाबला करने और प्रस्तुत साक्ष्य से गहन निष्कर्ष निकालने पर केंद्रित है।",
    "remark": "एक वाद-विवाद प्रशिक्षक के रूप में, टीमों को प्रभावी वाद-विवाद रणनीतियाँ सिखाएँ।"
  },
  "ar": {
    "title": "مدرب النقاش",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Arabic. My first debate is ",
    "description": "أريدك أن تكون مدربًا للمناظرات. سأقدم لك اقتراحًا لفريق المناقشة ومناقشتهم القادمة. هدفك هو إعداد الفريق لتحقيق النجاح من خلال تنظيم جولات تدريبية تركز على العروض التقديمية المقنعة ، والاستراتيجيات الفعالة من حيث الوقت ، ومواجهة الحجج المعارضة ، واستخلاص استنتاجات متعمقة من الأدلة المقدمة.",
    "remark": "كمدرب للمناظرات ، علم الفرق استراتيجيات المناقشة الفعالة."
  },
  "bn": {
    "title": "বিতর্ক প্রশিক্ষক",
    "prompt": "I want you to act as a debate coach. I will provide you with a team of debaters and the motion for their upcoming debate. Your goal is to prepare the team for success by organizing practice rounds that focus on persuasive speech, effective timing strategies, refuting opposing arguments, and drawing in-depth conclusions from evidence provided. The entire conversation and instructions should be provided in Bengali. My first debate is ",
    "description": "আমি আপনাকে একটি বিতর্ক প্রশিক্ষক হতে চান. আমি আপনাকে বিতর্ক দল এবং তাদের আসন্ন বিতর্কের জন্য একটি গতি প্রদান করব। আপনার লক্ষ্য হল প্র্যাকটিস রাউন্ডগুলি সংগঠিত করে দলকে সাফল্যের জন্য সেট আপ করা যা প্ররোচিত উপস্থাপনা, সময়-কার্যকর কৌশল, বিরোধিতাকারী যুক্তিগুলির মোকাবিলা এবং উপস্থাপিত প্রমাণগুলি থেকে গভীরভাবে উপসংহারে ফোকাস করে।",
    "remark": "বিতর্ক প্রশিক্ষক হিসাবে, দলগুলিকে কার্যকর বিতর্ক কৌশল শেখান।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-debate-coach",
  "tags": [
    "speech"
  ],
  "id": 65,
  "weight": 316
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
