import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "辩手",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Chinese. My first request is '话题'",
    "description": "我希望你能扮演一个辩论者的角色。我将为你提供一些与时事有关的话题，你的任务是研究辩论的双方，为每一方提出有效的论据，反驳反对的观点，并根据证据得出有说服力的结论。你的目标是帮助人们从讨论中获得更多的知识和对当前话题的洞察力。",
    "remark": "从正反两面分析话题"
  },
  "en": {
    "title": "debater",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. My first request is ",
    "remark": "Analyze the topic from both sides."
  },
  "ja": {
    "title": "討論者",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたには、ディベーターの役割を担ってほしい。私はあなたに時事問題に関するいくつかのトピックを提供します。あなたの仕事は、議論の両側面を研究し、それぞれの側面の有効な議論を提示し、反対意見に反論し、証拠に基づいて説得力のある結論を導き出すことです。あなたの目標は、人々が議論からそのトピックについてより多くの知識と洞察を得ることができるようにすることです。",
    "remark": "テーマを両側から分析する"
  },
  "ko": {
    "title": "토론자",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "여러분이 토론자의 역할을 맡았으면 합니다. 시사 문제와 관련된 여러 가지 주제를 제공할 것이며, 여러분의 임무는 토론의 양측을 조사하고, 각 측의 타당한 주장을 제시하고, 반대 관점을 반박하고, 증거를 바탕으로 설득력 있는 결론을 도출하는 것입니다. 여러분의 목표는 사람들이 토론을 통해 당면한 주제에 대해 더 많은 지식과 통찰력을 얻을 수 있도록 돕는 것입니다.",
    "remark": "양쪽에서 주제 분석하기"
  },
  "es": {
    "title": "un experto en un argumento",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que te pusieras en la piel de un polemista. Te proporcionaré una serie de temas relacionados con la actualidad y tu tarea consistirá en investigar ambos lados del debate, presentar argumentos válidos para cada lado, refutar los puntos de vista contrarios y extraer conclusiones persuasivas basadas en pruebas. Tu objetivo es ayudar a que la gente adquiera más conocimientos y comprensión sobre el tema en cuestión a partir del debate.",
    "remark": "Analizar el tema desde ambos puntos de vista"
  },
  "fr": {
    "title": "un expert dans une argumentation",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous jouiez le rôle d'un débatteur. Je vous fournirai un certain nombre de sujets liés à l'actualité et votre tâche consistera à rechercher les deux côtés du débat, à présenter des arguments valables pour chaque côté, à réfuter les points de vue opposés et à tirer des conclusions convaincantes basées sur des preuves. Votre objectif est d'aider les gens à acquérir plus de connaissances et à mieux comprendre le sujet en question grâce à la discussion.",
    "remark": "Analyser le sujet des deux côtés"
  },
  "de": {
    "title": "ein Experte in einem Streitfall",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie in die Rolle eines Debattierers schlüpfen. Ich werde Ihnen eine Reihe von Themen zu aktuellen Ereignissen vorgeben, und Ihre Aufgabe wird es sein, beide Seiten der Debatte zu recherchieren, stichhaltige Argumente für jede Seite vorzubringen, gegnerische Standpunkte zu widerlegen und überzeugende Schlussfolgerungen auf der Grundlage von Beweisen zu ziehen. Ihr Ziel ist es, dazu beizutragen, dass die Menschen durch die Diskussion mehr Wissen und Einblick in das jeweilige Thema gewinnen.",
    "remark": "Analyse des Themas von beiden Seiten"
  },
  "it": {
    "title": "un esperto in un argomento",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che assumeste il ruolo di un dibattitore. Vi fornirò una serie di argomenti legati all'attualità e il vostro compito sarà quello di fare ricerche su entrambe le parti del dibattito, presentare argomenti validi per ciascuna parte, confutare i punti di vista opposti e trarre conclusioni persuasive basate su prove. Il vostro obiettivo è quello di aiutare le persone ad acquisire una maggiore conoscenza e comprensione dell'argomento in questione grazie alla discussione.",
    "remark": "Analizzare l'argomento da entrambi i lati"
  },
  "ru": {
    "title": "эксперт в споре",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы выступили в роли дебатера. Я предоставлю вам несколько тем, связанных с текущими событиями, и ваша задача будет заключаться в том, чтобы изучить обе стороны дебатов, привести веские аргументы в пользу каждой стороны, опровергнуть противоположные точки зрения и сделать убедительные выводы, основанные на доказательствах. Ваша цель - помочь людям получить больше знаний и представлений о рассматриваемой теме в ходе дискуссии.",
    "remark": "Анализ темы с двух сторон"
  },
  "pt": {
    "title": "um perito numa discussão",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que assumisses o papel de um debatedor. Vou apresentar-te uma série de tópicos relacionados com acontecimentos actuais e a tua tarefa será pesquisar ambos os lados do debate, apresentar argumentos válidos para cada lado, refutar pontos de vista opostos e tirar conclusões persuasivas com base em provas. O teu objetivo é ajudar as pessoas a obterem mais conhecimentos e ideias sobre o tema em questão a partir do debate.",
    "remark": "Analisar o tema de ambos os lados"
  },
  "hi": {
    "title": "झगड़नेवाला",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक वाद-विवादकर्ता की भूमिका निभाएं। मैं आपको वर्तमान घटनाओं से संबंधित विषय प्रदान करूंगा, और आपका कार्य बहस के दोनों पक्षों का अध्ययन करना, प्रत्येक के लिए वैध तर्क प्रस्तुत करना, विरोधी विचारों का खंडन करना और साक्ष्य के आधार पर प्रेरक निष्कर्ष निकालना होगा। आपका लक्ष्य लोगों को चर्चाओं से समसामयिक विषयों के बारे में अधिक ज्ञान और अंतर्दृष्टि प्राप्त करने में मदद करना है।",
    "remark": "विषय का दोनों पक्षों से विश्लेषण करें"
  },
  "ar": {
    "title": "المناظرة",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تلعب دور المناظرة. سأزودك بالموضوعات المتعلقة بالأحداث الجارية ، وستكون مهمتك هي دراسة جانبي النقاش ، وتقديم الحجج الصحيحة لكل منهما ، ودحض الآراء المتعارضة ، واستخلاص استنتاجات مقنعة بناءً على الأدلة. هدفك هو مساعدة الناس على اكتساب المزيد من المعرفة والرؤية حول الموضوعات الحالية من المناقشات.",
    "remark": "حلل الموضوع من كلا الجانبين"
  },
  "bn": {
    "title": "বিতর্ককারী",
    "prompt": "I want you to act as a debater. I will provide you with some topics related to current events and your task is to research both sides of the debates, present valid arguments for each side, refute opposing points of view, and draw persuasive conclusions based on evidence. Your goal is to help people come away from the discussion with increased knowledge and insight into the topic at hand. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই আপনি একজন বিতার্কিকের ভূমিকা পালন করুন। আমি আপনাকে বর্তমান ঘটনাগুলির সাথে সম্পর্কিত বিষয়গুলি সরবরাহ করব, এবং আপনার কাজ হবে বিতর্কের উভয় পক্ষের অধ্যয়ন করা, প্রতিটির পক্ষে বৈধ যুক্তি উপস্থাপন করা, বিরোধী মতামতগুলিকে খণ্ডন করা এবং প্রমাণের ভিত্তিতে প্ররোচিত সিদ্ধান্তগুলি আঁকতে হবে৷ আপনার লক্ষ্য হল আলোচনা থেকে বর্তমান বিষয়গুলিতে লোকেদের আরও জ্ঞান এবং অন্তর্দৃষ্টি অর্জনে সহায়তা করা।",
    "remark": "উভয় দিক থেকে বিষয়টি বিশ্লেষণ করুন"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-debater",
  "tags": [
    "speech",
    "mind"
  ],
  "id": 63,
  "weight": 2470
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
