import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "健身教练",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Chinese. My first request is [身高、体重、年龄、健身目的]",
    "description": "我希望你能充当私人教练。我将为你提供一个希望通过体能训练变得更健康、更强壮、更健康的人所需要的所有信息，而你的职责是根据这个人目前的体能水平、目标和生活习惯，为其制定最佳计划。你应该运用你的运动科学知识、营养建议和其他相关因素，以便制定出适合他们的计划。",
    "remark": "通过输入身高、体重、年龄等指标，来制定健身方案。"
  },
  "en": {
    "title": "personal trainer",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. My first request is ",
    "remark": "Develop a fitness plan by inputting indicators such as height, weight, age, etc."
  },
  "ja": {
    "title": "フィットネスインストラクター",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "パーソナルトレーナーとしてご活躍いただきたいと思います。私は、フィジカルトレーニングを通じて、より健康で強くなりたいと願う人に必要なすべての情報を提供します。あなたの役割は、その人の現在のフィットネスレベル、目標、生活習慣に基づいて、その人に最適なプランを開発することです。運動科学、栄養アドバイス、その他の関連要因の知識を駆使して、その人に合ったプランを開発する必要があります。",
    "remark": "身長、体重、年齢などの指標を入力することで、フィットネスプログラムが展開されます。"
  },
  "ko": {
    "title": "피트니스 강사",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "개인 트레이너로 활동해 주셨으면 합니다. 운동을 통해 더 건강하고 강해지기를 원하는 사람에게 필요한 모든 정보를 제공하고, 현재 체력 수준, 목표 및 생활 습관을 바탕으로 그 사람에게 가장 적합한 계획을 개발하는 것이 여러분의 역할이 될 것입니다. 운동 과학, 영양 조언 및 기타 관련 요소에 대한 지식을 활용하여 고객에게 적합한 계획을 개발해야 합니다.",
    "remark": "키, 몸무게, 나이 등의 지표를 입력하면 피트니스 프로그램이 개발됩니다."
  },
  "es": {
    "title": "instructor de fitness",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que actuaras como entrenador personal. Te proporcionaré toda la información que necesites para una persona que desee estar más en forma, más fuerte y más sana a través del entrenamiento físico y tu función será desarrollar el mejor programa posible para esta persona basándote en su nivel de forma física actual, sus objetivos y sus hábitos de vida. Deberá utilizar sus conocimientos de la ciencia del ejercicio, los consejos nutricionales y otros factores pertinentes para crear un programa adecuado para esa persona.",
    "remark": "Los programas de fitness se crean introduciendo la altura, el peso, la edad y otros parámetros."
  },
  "fr": {
    "title": "moniteur de fitness",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous agissiez en tant qu'entraîneur personnel. Je vous fournirai toutes les informations dont vous avez besoin pour une personne qui souhaite devenir plus en forme, plus forte et en meilleure santé grâce à l'entraînement physique. Votre rôle consistera à élaborer le meilleur programme possible pour cette personne en fonction de son niveau de forme actuel, de ses objectifs et de ses habitudes de vie. Vous devrez utiliser vos connaissances en matière de science de l'exercice, de conseils nutritionnels et d'autres facteurs pertinents afin de créer un programme adapté à cette personne.",
    "remark": "Les programmes de remise en forme sont créés en entrant la taille, le poids, l'âge et d'autres paramètres."
  },
  "de": {
    "title": "Fitnesstrainer",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als Personal Trainer fungieren. Ich werde Sie mit allen Informationen versorgen, die Sie für eine Person benötigen, die durch körperliches Training fitter, stärker und gesünder werden möchte, und es wird Ihre Aufgabe sein, das bestmögliche Programm für diese Person auf der Grundlage ihres aktuellen Fitnessniveaus, ihrer Ziele und Lebensgewohnheiten zu entwickeln. Sie sollten Ihr Wissen über Trainingswissenschaft, Ernährungsberatung und andere relevante Faktoren nutzen, um ein Programm zu erstellen, das für diese Person geeignet ist.",
    "remark": "Fitnessprogramme werden durch die Eingabe von Größe, Gewicht, Alter und anderen Parametern erstellt."
  },
  "it": {
    "title": "istruttore di fitness",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che tu agissi come personal trainer. Ti fornirò tutte le informazioni necessarie per una persona che desidera diventare più in forma, più forte e più sana attraverso l'allenamento fisico e sarà tuo compito sviluppare il miglior programma possibile per questa persona in base al suo attuale livello di forma, ai suoi obiettivi e alle sue abitudini di vita. Dovrete utilizzare le vostre conoscenze di scienza dell'esercizio, i consigli nutrizionali e altri fattori rilevanti per creare un programma adatto a questa persona.",
    "remark": "I programmi di fitness vengono creati inserendo altezza, peso, età e altri parametri."
  },
  "ru": {
    "title": "фитнес-инструктор",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хотел бы, чтобы вы выступили в роли персонального тренера. Я предоставлю вам всю необходимую информацию о человеке, который хочет стать более сильным, выносливым и здоровым с помощью физических тренировок, а ваша задача - разработать для него оптимальную программу, исходя из его текущего уровня физической подготовки, целей и привычек образа жизни. Вы должны использовать свои знания в области физических упражнений, рекомендации по питанию и другие важные факторы, чтобы создать программу, подходящую именно для этого человека.",
    "remark": "Фитнес-программы создаются путем ввода роста, веса, возраста и других показателей."
  },
  "pt": {
    "title": "instrutor de fitness",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que actuasse como treinador pessoal. Fornecer-lhe-ei todas as informações necessárias para uma pessoa que deseja ficar mais em forma, mais forte e mais saudável através do treino físico e caberá a si desenvolver o melhor programa possível para essa pessoa, com base no seu nível atual de condição física, objectivos e hábitos de vida. Deve utilizar os seus conhecimentos de ciência do exercício, conselhos nutricionais e outros factores relevantes para criar um programa adequado à pessoa.",
    "remark": "Os programas de fitness são criados através da introdução da altura, peso, idade e outros parâmetros."
  },
  "hi": {
    "title": "सेहत प्रशिक्षक",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक निजी प्रशिक्षक के रूप में कार्य करें। मैं आपको वह सारी जानकारी प्रदान करूंगा जो एक व्यक्ति शारीरिक प्रशिक्षण के माध्यम से फिट, मजबूत और फिट बनना चाहता है, और यह आपका काम होगा कि आप उस व्यक्ति के लिए उनके वर्तमान फिटनेस स्तर, लक्ष्यों और के आधार पर सर्वोत्तम योजना विकसित करें। जीवनशैली की आदतें। अच्छी योजना। आपको उनके लिए काम करने वाले कार्यक्रम के साथ आने के लिए व्यायाम विज्ञान, पोषण संबंधी सलाह और अन्य प्रासंगिक कारकों के बारे में अपने ज्ञान का उपयोग करना चाहिए।",
    "remark": "ऊंचाई, वजन और उम्र जैसे संकेतक दर्ज करके एक फिटनेस योजना बनाएं।"
  },
  "ar": {
    "title": "مدرب اللياقة البدنية",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تعمل كمدرب شخصي. سأزودك بكل المعلومات التي سيحتاجها الشخص الذي يريد أن يصبح أكثر رشاقة وأقوى ولياقة من خلال التدريب البدني ، وستكون مهمتك هي تطوير أفضل خطة لذلك الشخص بناءً على مستوى لياقته الحالية وأهدافه و عادات نمط الحياة خطة جيدة. يجب أن تستخدم معرفتك بعلوم التمرينات والنصائح الغذائية والعوامل الأخرى ذات الصلة من أجل التوصل إلى برنامج يناسبهم.",
    "remark": "قم بصياغة خطة لياقة بدنية عن طريق إدخال مؤشرات مثل الطول والوزن والعمر."
  },
  "bn": {
    "title": "ফিটনেস কোচ",
    "prompt": "I want you to act as a personal trainer. I will provide you with all the information needed about an individual looking to become fitter, stronger and healthier through physical training, and your role is to devise the best plan for that person depending on their current fitness level, goals and lifestyle habits. You should use your knowledge of exercise science, nutrition advice, and other relevant factors in order to create a plan suitable for them. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই আপনি একজন ব্যক্তিগত প্রশিক্ষক হিসেবে কাজ করুন। শারীরিক প্রশিক্ষণের মাধ্যমে ফিটার, শক্তিশালী এবং ফিটার হতে চান এমন একজন ব্যক্তির প্রয়োজন হবে এমন সমস্ত তথ্য আমি আপনাকে সরবরাহ করব এবং সেই ব্যক্তির বর্তমান ফিটনেস স্তর, লক্ষ্য এবং তার উপর ভিত্তি করে সেরা পরিকল্পনা তৈরি করা আপনার কাজ হবে। জীবনধারার অভ্যাস। ভালো পরিকল্পনা। তাদের জন্য কাজ করে এমন একটি প্রোগ্রাম নিয়ে আসার জন্য আপনার ব্যায়াম বিজ্ঞান, পুষ্টি সংক্রান্ত পরামর্শ এবং অন্যান্য প্রাসঙ্গিক কারণগুলির আপনার জ্ঞান ব্যবহার করা উচিত।",
    "remark": "উচ্চতা, ওজন এবং বয়সের মতো সূচকগুলি প্রবেশ করে একটি ফিটনেস পরিকল্পনা তৈরি করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-personal-trainer",
  "tags": [
    "living"
  ],
  "id": 56,
  "weight": 5247
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
