import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "提示词生成器",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). My first title is '提示词功能' (Give me prompt only)",
    "description": "我想让你充当一个提示生成器。首先，我将给你一个这样的标题。'充当英语发音的帮手'。然后你给我一个这样的提示。'我希望你充当讲土耳其语的人的英语发音助手。我给你写句子，你只回答他们的发音，其他什么都不说。答复不能是我的句子的翻译，而只能是发音。发音应该使用土耳其的拉丁字母来发音。不要在回答中写解释。我的第一句话是 '伊斯坦布尔的天气如何？'。'（你应该根据我给出的标题来调整提示样本。提示词应该是不言自明的，并且与题目相适应，不要参照我给你的例子）。我的第一个题目是 '提示词功能'(只给我提示)",
    "remark": "根据指定要求，让 ChatGPT 生成提示词。"
  },
  "en": {
    "title": "Prompt generator",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). My first title is 'Give me prompt only'",
    "remark": "ChatGPT generate prompt words according to the specified requirements"
  },
  "ja": {
    "title": "プロンプトジェネレーター",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Janpanese. My first title is 'Give me prompt only'.",
    "description": "プロンプトジェネレーターとして活躍してほしい。まず、こんなタイトルをつけます』。英語の発音のヘルパーとして活動してください』。そして、こんな感じのプロンプトを出すんだ』。トルコ語話者のための英語発音ヘルパーとして活動してほしい。私が文章を書くので、発音だけを答え、それ以外は何もしないでください。回答は私の文章の翻訳ではなく、発音だけでなければならない。発音はトルコ語のラテンアルファベットで発音してください。答えの中に説明を書いてはいけません。私の最初の文章は『イスタンブールの天気はどうですか？.'(プロンプトのサンプルは、私がつけたタイトルに合わせるべきです。プロンプトは自明で、タイトルにふさわしいものであるべきです。私があげた例を参照しないでください）。私の最初のタイトルは「プロンプトの単語機能」です（プロンプトを与えるだけです）。",
    "remark": "ChatGPT に指定された条件に従ってプロンプトワードを生成させる。"
  },
  "ko": {
    "title": "프롬프트 생성기",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Korean. My first title is 'Give me prompt only'.",
    "description": "여러분이 프롬프트 생성기 역할을 해주셨으면 합니다. 먼저, 이렇게 제목을 붙이겠습니다. 영어 발음 도우미 역할을 해줘'. 그런 다음 다음과 같은 프롬프트를 제공합니다. 나는 당신이 터키어 사용자를위한 영어 발음 도우미 역할을하기를 원합니다. 제가 문장을 작성해 드리고, 여러분은 발음으로만 답하시면 됩니다. 답변은 제가 쓴 문장을 번역해서는 안 되고 발음으로만 답해야 합니다. 발음은 터키어 라틴 알파벳을 사용하여 발음해야 합니다. 답변에 설명을 쓰지 마세요. 제 첫 문장은 '이스탄불의 날씨는 어때요? .' (샘플 프롬프트를 제가 제시한 제목에 맞게 수정해야 합니다. 프롬프트는 제목에 맞게 자명하고 적절해야 하며, 제가 제공한 예시를 참조하지 마세요.) 첫 번째 제목은 '프롬프트 단어 기능'입니다 (프롬프트만 제공).",
    "remark": "ChatGPT 가 지정된 요구 사항에 따라 프롬프트 단어를 생성하도록 합니다."
  },
  "es": {
    "title": "Generador de tacos",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Spanish. My first title is 'Give me prompt only'.",
    "description": "Quiero que actúes como generador de avisos. En primer lugar, te daré un título como este:' Acting as an English Pronunciation Helper'. A continuación, me darás un texto como este: \"Quiero que ayudes a pronunciar en inglés a los turcos\". Quiero que ayudes a los hablantes de turco a pronunciar en inglés. Te escribiré frases y tú responderás sólo a su pronunciación y nada más. Las respuestas no deben ser traducciones de mis frases, sino sólo pronunciaciones. Las pronunciaciones deben hacerse utilizando el alfabeto latino turco. No escribas explicaciones en tu respuesta. Mi primera frase era \"¿Qué tiempo hace en Estambul? .' (Debes adaptar el ejemplo al título que te he dado. (Las palabras clave deben ser autoexplicativas y adecuadas al título, no te refieras a los ejemplos que te he dado). Mi primer título es 'Prompt word function' (sólo dame prompts)",
    "remark": "Haga que ChatGPT genere palabras de aviso en función de los requisitos especificados."
  },
  "fr": {
    "title": "Générateur de repères",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in French. My first title is 'Give me prompt only'.",
    "description": "Je veux que vous fassiez office de générateur de messages. Tout d'abord, je vous donnerai un titre comme celui-ci : \"Agir en tant qu'aide à la prononciation de l'anglais\". Agir en tant qu'aide à la prononciation de l'anglais\". Ensuite, vous me donnerez un message comme celui-ci : \"Je veux que vous fassiez office d'aide à la prononciation de l'anglais pour les enfants\". Je veux que vous agissiez en tant qu'aide à la prononciation de l'anglais pour les locuteurs turcs. Je vous écrirai des phrases et vous ne répondrez qu'à leur prononciation et rien d'autre. Les réponses ne doivent pas être des traductions de mes phrases, mais uniquement des prononciations. Les prononciations doivent être prononcées en utilisant l'alphabet latin turc. N'écrivez pas d'explications dans votre réponse. Ma première phrase était \"Quel temps fait-il à Istanbul ? .' (Vous devez adapter l'exemple de question au titre que j'ai donné. (Les mots de l'exercice doivent être explicites et appropriés au titre, ne vous référez pas aux exemples que je vous ai donnés). Mon premier titre est \"Fonction mot-guide\" (ne me donnez que des mots-guides).",
    "remark": "Demandez à ChatGPT de générer des mots-guides en fonction des exigences spécifiées."
  },
  "de": {
    "title": "Cue-Generator",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in German. My first title is 'Give me prompt only'.",
    "description": "Ich möchte, dass Sie als Prompt-Generator fungieren. Zunächst werde ich Ihnen einen Titel wie diesen geben.' Als englischer Aussprachehelfer'. Dann geben Sie mir eine Aufforderung wie diese.' Ich möchte, dass Sie als englische Aussprachehilfe für Türkischsprachige fungieren. Ich werde Ihnen Sätze schreiben und Sie werden nur deren Aussprache beantworten und sonst nichts. Die Antworten dürfen keine Übersetzungen meiner Sätze sein, sondern nur Aussprachen. Die Aussprache sollte nach dem türkischen lateinischen Alphabet erfolgen. Schreiben Sie keine Erklärungen in Ihrer Antwort. Mein erster Satz war 'Wie ist das Wetter in Istanbul? .' (Sie sollten das Beispiel der Aufforderung an den von mir gegebenen Titel anpassen. (Die Aufforderungswörter sollten selbsterklärend sein und zum Titel passen, beziehen Sie sich nicht auf die Beispiele, die ich Ihnen gegeben habe). Mein erster Titel ist 'Prompt word function' (geben Sie mir nur Prompts)",
    "remark": "Lassen Sie ChatGPT Prompt-Wörter auf der Grundlage der angegebenen Anforderungen generieren."
  },
  "it": {
    "title": "Generatore di spunti",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Italian. My first title is 'Give me prompt only'.",
    "description": "Voglio che tu agisca come generatore di prompt. Per prima cosa, vi darò un titolo come questo. Aiutante di pronuncia inglese\". Poi mi darete un suggerimento come questo\". Voglio che tu agisca come aiutante della pronuncia inglese per i parlanti turchi. Io scriverò delle frasi per voi e voi dovrete rispondere solo alla loro pronuncia e nient'altro. Le risposte non devono essere traduzioni delle mie frasi, ma solo pronunce. Le pronunce devono essere pronunciate utilizzando l'alfabeto latino turco. Non scrivete spiegazioni nelle vostre risposte. La mia prima frase era \"Com'è il tempo a Istanbul?\". .' (Dovete adattare l'esempio di prompt al titolo che ho dato. (Le parole del prompt devono essere autoesplicative e appropriate al titolo, non fate riferimento agli esempi che vi ho dato). Il mio primo titolo è \"Funzione delle parole di stimolo\" (date solo stimoli).",
    "remark": "Chiedete a ChatGPT di generare parole richieste in base ai requisiti specificati."
  },
  "ru": {
    "title": "Генератор реплик",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Russian. My first title is 'Give me prompt only'.",
    "description": "Я хочу, чтобы вы выступили в роли генератора подсказок. Для начала я дам вам такое название: Acting as an English Pronunciation Helper\". Затем вы дадите мне подсказку следующего содержания. Я хочу, чтобы вы выступили в роли помощника по английскому произношению для носителей турецкого языка. Я напишу для вас предложения, а вы ответите только на вопрос о произношении и ничего больше. Ответы не должны быть переводами моих предложений, а только произношением. Произношение должно быть с использованием турецкого латинского алфавита. Не пишите в ответах пояснений. Мое первое предложение было \"Как погода в Стамбуле? .' (Вы должны адаптировать образец подсказки к названию, которое я дал. (Слова подсказки должны быть самоочевидными и соответствовать названию, не ссылайтесь на приведенные мной примеры). Мой первый заголовок - \"Функция подсказывающего слова\" (дайте только подсказки)",
    "remark": "Попросите ChatGPT генерировать слова подсказки в соответствии с заданными требованиями."
  },
  "pt": {
    "title": "Gerador de pistas",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Portuguese. My first title is 'Give me prompt only'.",
    "description": "Quero que actues como um gerador de sugestões. Em primeiro lugar, vou dar-te um título como este. Atuar como ajudante da pronúncia inglesa\". Depois, dás-me uma mensagem como esta. Quero que actues como um ajudante de pronúncia em inglês para falantes de turco. Eu escrevo-te frases e tu respondes apenas à pronúncia e nada mais. As respostas não devem ser traduções das minhas frases, mas apenas pronúncias. As pronúncias devem ser pronunciadas utilizando o alfabeto latino turco. Não escreva explicações na sua resposta. A minha primeira frase foi \"Como está o tempo em Istambul? .' (Deve adaptar o exemplo do prompt ao título que dei. (As palavras do prompt devem ser auto-explicativas e adequadas ao título, não se refira aos exemplos que lhe dei). O meu primeiro título é \"Prompt word function\" (só me dá prompts)",
    "remark": "Fazer com que o ChatGPT gere palavras de alerta com base nos requisitos especificados."
  },
  "hi": {
    "title": "शीघ्र शब्द जनरेटर",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Hindi. My first title is 'Give me prompt only'.",
    "description": "मैं चाहता हूं कि आप संकेत जनरेटर के रूप में कार्य करें। सबसे पहले, मैं आपको इस तरह एक शीर्षक देने जा रहा हूँ। &#39;अंग्रेजी उच्चारण में सहायता के रूप में कार्य करें&#39;। तो फिर आप मुझे ऐसा संकेत दीजिये. &#39;मैं चाहता हूं कि आप तुर्की बोलने वालों के लिए अंग्रेजी उच्चारण सहायक के रूप में कार्य करें। मैं आपके लिए वाक्य लिखता हूं, और आप केवल उनके उच्चारण का उत्तर देते हैं, और कुछ नहीं। उत्तर मेरे वाक्य का अनुवाद नहीं हो सकता, बल्कि केवल उच्चारण हो सकता है। उच्चारण तुर्की लैटिन वर्णमाला का उपयोग करके किया जाना चाहिए। उत्तरों में स्पष्टीकरण न लिखें. मेरे पहले शब्द थे &#39;इस्तांबुल में मौसम कैसा है? &#39;. &#39; (आपको शीघ्र नमूने को मेरे द्वारा दिए गए शीर्षक के अनुरूप ढालना चाहिए। शीघ्र शब्द स्व-व्याख्यात्मक होना चाहिए और शीर्षक के लिए उपयुक्त होना चाहिए, न कि वह उदाहरण जो मैंने आपको दिया था)। मेरा पहला शीर्षक &#39;प्रॉम्प्ट वर्ड फ़ंक्शन&#39; है (बस मुझे संकेत दें)",
    "remark": "ChatGPT को निर्दिष्ट आवश्यकताओं के अनुसार त्वरित शब्द उत्पन्न करने दें।"
  },
  "ar": {
    "title": "مولد كلمة سريع",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Arabic. My first title is 'Give me prompt only'.",
    "description": "أريدك أن تعمل كمولد تلميح. أولاً ، سأعطيك عنوانًا كهذا. &quot;العمل كمساعد في نطق اللغة الإنجليزية&quot;. ثم تعطيني تلميحًا مثل هذا. أريدك أن تعمل كمساعد نطق اللغة الإنجليزية لمتحدثي اللغة التركية. أنا أكتب لك جملاً ، وأنت تجيب فقط على نطقها ، ولا شيء غير ذلك. لا يمكن أن يكون الرد ترجمة لجملتي ، ولكن فقط النطق. يجب نطق النطق باستخدام الأبجدية اللاتينية التركية. لا تكتب التفسيرات في الإجابات. كانت كلماتي الأولى: كيف هو الطقس في اسطنبول؟ &quot;. (يجب عليك تكييف العينة السريعة مع العنوان الذي أعطيته لك. يجب أن تكون الكلمة الموجزة تشرح نفسها بنفسها ومناسبة للعنوان ، وليس المثال الذي قدمته لك). عنواني الأول هو &quot;وظيفة الكلمات الفورية&quot; (فقط أعطني تلميحات)",
    "remark": "اسمح لـ ChatGPT بإنشاء كلمات سريعة وفقًا للمتطلبات المحددة."
  },
  "bn": {
    "title": "প্রম্পট শব্দ জেনারেটর",
    "prompt": "I want you to act as a prompt generator. Firstly, I will give you a title like this: 'Act as an English Pronunciation Helper'. Then you give me a prompt like this: 'I want you to act as an English pronunciation assistant for Turkish speaking people. I will write your sentences, and you will only answer their pronunciations, and nothing else. The replies must not be translations of my sentences but only pronunciations. Pronunciations should use Turkish Latin letters for phonetics. Do not write explanations on replies. My first sentence is 'how the weather is in Istanbul?'.' (You should adapt the sample prompt according to the title I gave. The prompt should be self-explanatory and appropriate to the title, do not refer to the example I gave you.). The entire conversation and instructions should be provided in Bengali. My first title is 'Give me prompt only'.",
    "description": "আমি আপনাকে একটি ইঙ্গিত জেনারেটর হিসাবে কাজ করতে চান. প্রথমত, আমি আপনাকে এই মত একটি শিরোনাম দিতে যাচ্ছি. &#39;ইংরেজি উচ্চারণে সহায়ক হিসেবে কাজ করুন&#39;। তারপর আপনি আমাকে এই মত একটি ইঙ্গিত দিন. &#39;আমি চাই তুমি তুর্কি ভাষাভাষীদের জন্য ইংরেজি উচ্চারণ সহকারী হিসেবে কাজ কর। আমি আপনার জন্য বাক্য লিখি, এবং আপনি শুধুমাত্র তাদের উচ্চারণ উত্তর, এবং অন্য কিছু না. উত্তরটি আমার বাক্যের অনুবাদ হতে পারে না, তবে শুধুমাত্র উচ্চারণ। উচ্চারণটি তুর্কি ল্যাটিন বর্ণমালা ব্যবহার করে উচ্চারণ করা উচিত। উত্তরে ব্যাখ্যা লিখবেন না। আমার প্রথম কথা ছিল &#39;ইস্তাম্বুলের আবহাওয়া কেমন? &#39; &#39; (আমি আপনাকে যে শিরোনামটি দিয়েছি তার সাথে আপনার প্রম্পট নমুনাটি মানিয়ে নেওয়া উচিত। প্রম্পট শব্দটি স্ব-ব্যাখ্যামূলক এবং শিরোনামের জন্য উপযুক্ত হওয়া উচিত, আমি যে উদাহরণটি দিয়েছি তা নয়)। আমার প্রথম শিরোনাম হল &#39;প্রম্পট ওয়ার্ড ফাংশন&#39; (শুধু আমাকে ইঙ্গিত দিন)",
    "remark": "ChatGPT-কে নির্দিষ্ট প্রয়োজনীয়তা অনুযায়ী প্রম্পট শব্দ তৈরি করতে দিন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-prompt-generator",
  "tags": [
    "ai"
  ],
  "id": 5,
  "weight": 4140
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
