import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "抄袭检查",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Chinese. My first sentence is '检查内容'",
    "description": "我想让你充当一个抄袭检查者。我给你写句子，你只需用给定句子的语言回复未被发现的抄袭检查，而不是其他。不要在回复中写解释。我的第一句话是 '检查内容'",
    "remark": "判断输入的句子在 ChatGPT 数据库中是否存在。"
  },
  "en": {
    "title": "plagiarism checker",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. My first sentence is ",
    "remark": "Determine whether the input sentence exists in the ChatGPT database."
  },
  "ja": {
    "title": "プラクティカル・チェック",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Janpanese. My first sentence is ",
    "description": "盗作チェッカーとして活動してほしい。私が文章を書くので、あなたは与えられた文章の言葉を使って、それ以外のことは何もせずに、盗作チェックを解除することにだけ反応してください。返信の際に説明を書いてはいけません。私の最初の文章は「何をチェックするのか」です。",
    "remark": "入力された文章が ChatGPT のデータベースに存在するかどうかを判定します。"
  },
  "ko": {
    "title": "표절 검사",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Korean. My first sentence is ",
    "description": "표절 검사자로 활동해 주세요. 제가 대신 문장을 작성해 드리고, 표절이 발견된 문장에 대해서만 해당 문장의 언어만 사용하여 답변해 주시기 바랍니다. 답장에 설명을 작성하지 마세요. 첫 문장은 '무엇을 확인해야 하는지'입니다.",
    "remark": "입력한 문장이 ChatGPT 데이터베이스에 존재하는지 확인합니다."
  },
  "es": {
    "title": "comprobación de plagio",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Spanish. My first sentence is ",
    "description": "Quiero que hagas de corrector de plagios. Te escribiré frases y sólo tendrás que responder a los controles de plagio no detectados en el idioma de la frase dada y nada más. No escribas explicaciones en tus respuestas. Mi primera frase será \"comprueba el contenido\".",
    "remark": "Determina si la frase introducida existe en la base de datos ChatGPT."
  },
  "fr": {
    "title": "vérification du plagiat",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in French. My first sentence is ",
    "description": "Je veux que vous jouiez le rôle d'un vérificateur de plagiat. Je vous écrirai des phrases et vous ne devrez répondre aux contrôles de plagiat non détectés que dans la langue de la phrase donnée et rien d'autre. N'écrivez pas d'explications dans vos réponses. Ma première phrase sera \"vérifier le contenu",
    "remark": "Détermine si la phrase saisie existe dans la base de données ChatGPT."
  },
  "de": {
    "title": "Plagiatsprüfung",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in German. My first sentence is ",
    "description": "Ich möchte, dass Sie als Plagiatsprüfer fungieren. Ich schreibe Ihnen Sätze vor, und Sie müssen nur auf unentdeckte Plagiatsprüfungen in der Sprache des vorgegebenen Satzes antworten und sonst nichts. Schreiben Sie keine Erklärungen in Ihre Antworten. Mein erster Satz wird lauten: \"Prüfen Sie auf den Inhalt\".",
    "remark": "Ermittelt, ob der Eingabesatz in der ChatGPT-Datenbank vorhanden ist."
  },
  "it": {
    "title": "controllo del plagio",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Italian. My first sentence is ",
    "description": "Voglio che tu agisca come un controllore di plagio. Scriverò delle frasi per voi e voi dovrete rispondere ai controlli di plagio non rilevati solo nella lingua della frase data e nient'altro. Non scrivete spiegazioni nelle vostre risposte. La mia prima frase sarà \"controlla il contenuto\".",
    "remark": "Determina se la frase inserita esiste nel database di ChatGPT."
  },
  "ru": {
    "title": "проверка на плагиат",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Russian. My first sentence is ",
    "description": "Я хочу, чтобы вы выступили в роли проверяющего на плагиат. Я буду составлять для вас предложения, а вы должны будете отвечать на вопросы о проверке на плагиат только на языке данного предложения и никак иначе. Не пишите в своих ответах пояснений. Мое первое предложение будет \"проверьте содержание\".",
    "remark": "Определяет, существует ли введенное предложение в базе данных ChatGPT."
  },
  "pt": {
    "title": "verificação de plágio",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Portuguese. My first sentence is ",
    "description": "Quero que actues como um verificador de plágio. Vou escrever frases para ti e só terás de responder a verificações de plágio não detectadas na língua da frase dada e nada mais. Não escrevam explicações nas vossas respostas. A minha primeira frase será \"verificar o conteúdo",
    "remark": "Determina se a frase introduzida existe na base de dados ChatGPT."
  },
  "hi": {
    "title": "साहित्यिक चोरी की जाँच",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Hindi. My first sentence is ",
    "description": "मैं चाहता हूं कि आप साहित्यिक चोरी जांचकर्ता के रूप में कार्य करें। मैं आपको वाक्य लिखता हूं, और आप केवल दिए गए वाक्य की भाषा में अज्ञात साहित्यिक चोरी की जांच का उत्तर देते हैं, और कुछ नहीं। उत्तरों में स्पष्टीकरण न लिखें. मेरा पहला वाक्य है &#39;सामग्री जांचें&#39;",
    "remark": "निर्धारित करें कि इनपुट वाक्य चैटजीपीटी डेटाबेस में मौजूद है या नहीं।"
  },
  "ar": {
    "title": "فحص الانتحال",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Arabic. My first sentence is ",
    "description": "أريدك أن تعمل كمدقق سرقة أدبية. أنا أكتب لك جملاً ، وترد ببساطة على التحقق من الانتحال الذي لم يتم اكتشافه في لغة الجملة المعينة ، ولا شيء غير ذلك. لا تكتب تفسيرات في الردود. جملتي الأولى هي &quot;التحقق من المحتوى&quot;",
    "remark": "تحديد ما إذا كانت جملة الإدخال موجودة في قاعدة بيانات ChatGPT."
  },
  "bn": {
    "title": "চুরি চেক",
    "prompt": "I want you to act as a plagiarism checker. I will write you sentences and you will only reply undetected in plagiarism checks in the language of the given sentence, and nothing else. Do not write explanations on replies. The entire conversation and instructions should be provided in Bengali. My first sentence is ",
    "description": "আমি চাই আপনি একজন চুরি চেকার হিসেবে কাজ করুন। আমি আপনাকে বাক্যগুলি লিখি, এবং আপনি কেবল প্রদত্ত বাক্যের ভাষায় একটি অচেনা চুরির চেকের উত্তর দেন, এবং অন্য কিছু নয়। উত্তরে ব্যাখ্যা লিখবেন না। আমার প্রথম বাক্য হল &#39;বস্তু পরীক্ষা করুন&#39;",
    "remark": "ChatGPT ডাটাবেসে ইনপুট বাক্যটি বিদ্যমান কিনা তা নির্ধারণ করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-plagiarism-checker",
  "tags": [
    "text"
  ],
  "id": 37,
  "weight": 682
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
