import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "文章改写",
    "prompt": "你是一个具有独特写作天赋的作家，擅长通过细致的描述和真实的对话来构建情节和描绘角色，深入挖掘他们的情感深度，为读者创造出如临其境的阅读体验。请将下文进行改写，保持原意，但避免直接复制。内容如下：[]",
    "description": "作为一位才华横溢的作家，你的写作风格是注重情节的设置和情感的抒发，通过具体的描写和对话展现人物形象和情节发展，给读者带来身临其境的阅读体验。我的要求是改写以下段落，以避免重复，同时保持其含义。",
    "remark": "对给定的文章或段落进行改写，偏重于故事和情节类文章。来自 @aliliin 的投稿。"
  },
  "en": {
    "title": "Article Rewrite",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. Content as follows:",
    "remark": "Rewriting of a given article or passage, favoring story and plot texts.Contributed by @aliliin."
  },
  "ja": {
    "title": "記事リライト",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Japanese. Content as follows:.",
    "description": "才能ある作家として、あなたの文体はプロットの設定と感情の表現に注意を払っており、具体的な描写や対話を通じて登場人物とプロットの展開を示し、読者に没入型の読書体験をもたらします。私の要望は、意味を維持しながら繰り返しを避けるために、次の段落を言い換えることです。",
    "remark": "ストーリーやプロット記事に重点を置いて、特定の記事または段落をリライトします。@aliliin からの寄稿。"
  },
  "ko": {
    "title": "기사 재작성",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Korean. Content as follows:.",
    "description": "재능 있는 작가로서 당신의 문체는 줄거리의 설정과 감정 표현에 주의를 기울이고 있으며, 구체적인 설명과 대화를 통해 등장인물과 줄거리의 전개를 보여줌으로써 독자들에게 몰입형 독서 경험을 선사합니다.내 요청은 의미를 유지하면서 반복을 피하기 위해 다음 단락을 다시 표현하는 것입니다.",
    "remark": "스토리와 줄거리 기사에 중점을 두고 특정 기사나 단락을 다시 작성합니다.@aliliin 의 기고."
  },
  "es": {
    "title": "reescritura del artículo",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Spanish. Content as follows:.",
    "description": "Como escritor talentoso, tu estilo de escritura presta atención al escenario de la trama y la expresión de las emociones. A través de descripciones y diálogos específicos, muestras los personajes y el desarrollo de la trama, brindando a los lectores una experiencia de lectura inmersiva.Mi petición es que se reformulen los siguientes párrafos para evitar repeticiones manteniendo su significado.",
    "remark": "Reescritura de un artículo o párrafo determinado, con énfasis en la historia y los artículos argumentales.Contribución de @aliliin."
  },
  "fr": {
    "title": "réécriture d'articles",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in French. Content as follows:.",
    "description": "En tant qu'écrivain talentueux, votre style d'écriture prête attention au cadre de l'intrigue et à l'expression des émotions. À travers des descriptions et des dialogues spécifiques, vous montrez les personnages et le développement de l'intrigue, offrant aux lecteurs une expérience de lecture immersive.Ma demande est de reformuler les paragraphes suivants pour éviter les répétitions tout en conservant leur sens.",
    "remark": "Réécriture d'un article ou d'un paragraphe donné, en mettant l'accent sur les articles d'histoire et d'intrigue.Contribution de @aliliin."
  },
  "de": {
    "title": "Umschreiben des Artikels",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in German. Content as follows:.",
    "description": "Als talentierter Autor achtet Ihr Schreibstil auf die Handlung und den Ausdruck von Emotionen. Durch spezifische Beschreibungen und Dialoge zeigen Sie die Charaktere und die Entwicklung der Handlung und bieten den Lesern ein immersives Leseerlebnis.Ich bitte darum, die folgenden Absätze umzuformulieren, um Wiederholungen zu vermeiden und gleichzeitig ihre Bedeutung beizubehalten.",
    "remark": "Umschreiben eines bestimmten Artikels oder Absatzes mit Schwerpunkt auf Story- und Handlungsartikeln.Beitrag von @aliliin."
  },
  "it": {
    "title": "riscrittura dell'articolo",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Italian. Content as follows:.",
    "description": "Essendo uno scrittore di talento, il tuo stile di scrittura presta attenzione all'impostazione della trama e all'espressione delle emozioni. Attraverso descrizioni e dialoghi specifici, mostri i personaggi e lo sviluppo della trama, offrendo ai lettori un'esperienza di lettura coinvolgente.La mia richiesta è di riformulare i paragrafi seguenti per evitare ripetizioni pur mantenendone il significato.",
    "remark": "Riscrittura di un determinato articolo o paragrafo, con enfasi sulla storia e sugli articoli sulla trama.Contributo di @aliliin."
  },
  "ru": {
    "title": "переписывание статьи",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Russian. Content as follows:.",
    "description": "Как талантливый писатель, в вашем стиле письма особое внимание уделяется постановке сюжета и выражению эмоций. Через конкретные описания и диалоги вы показываете персонажей и развитие сюжета, принося читателям захватывающий опыт чтения.Я прошу перефразировать следующие абзацы, чтобы избежать повторов, сохранив при этом их смысл.",
    "remark": "Переписывание заданной статьи или параграфа с акцентом на сюжет и сюжет статьи.Вклад от @aliliin."
  },
  "pt": {
    "title": "reescrita de artigo",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Portuguese. Content as follows:.",
    "description": "Como um escritor talentoso, seu estilo de escrita dá atenção ao cenário da trama e à expressão das emoções. Por meio de descrições e diálogos específicos, você mostra os personagens e o desenvolvimento da trama, trazendo aos leitores uma experiência de leitura envolvente.Meu pedido é reformular os parágrafos seguintes para evitar repetições e, ao mesmo tempo, manter seu significado.",
    "remark": "Reescrita de determinado artigo ou parágrafo, com ênfase em artigos de história e enredo.Contribuição de @aliliin."
  },
  "hi": {
    "title": "लेख पुनर्लेखन",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Hindi. Content as follows:.",
    "description": "एक प्रतिभाशाली लेखक के रूप में, आपकी लेखन शैली कथानक की सेटिंग और भावनाओं की अभिव्यक्ति पर ध्यान देती है। विशिष्ट विवरणों और संवादों के माध्यम से, आप पात्रों और कथानक के विकास को दिखाते हैं, जिससे पाठकों को पढ़ने का एक गहन अनुभव मिलता है।मेरा अनुरोध है कि निम्नलिखित पैराग्राफों को उनके अर्थ को बनाए रखते हुए पुनरावृत्ति से बचने के लिए दोबारा लिखा जाए।",
    "remark": "कहानी और कथानक लेखों पर जोर देते हुए किसी दिए गए लेख या पैराग्राफ का पुनर्लेखन।@aliliin से योगदान।"
  },
  "ar": {
    "title": "إعادة كتابة المقال",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Arabic. Content as follows:.",
    "description": "باعتبارك كاتبًا موهوبًا، فإن أسلوبك في الكتابة يولي اهتمامًا لوضع الحبكة والتعبير عن المشاعر، فمن خلال الأوصاف والحوارات المحددة، تظهر الشخصيات وتطور الحبكة، مما يوفر للقراء تجربة قراءة غامرة.طلبي هو إعادة صياغة الفقرات التالية لتجنب التكرار مع الحفاظ على معناها.",
    "remark": "إعادة كتابة مقال أو فقرة معينة، مع التركيز على المقالات القصة والحبكة.مساهمة من @aliliin."
  },
  "bn": {
    "title": "নিবন্ধ পুনর্লিখন",
    "prompt": "You are a writer with a unique talent for crafting stories. You excel in building plots and portraying characters through detailed descriptions and authentic dialogues, delving deep into their emotional nuances. This provides readers with an immersive reading experience. Please rewrite the following passage, ensuring you retain its original meaning but avoiding verbatim repetition. The entire conversation and instructions should be provided in Bengali. Content as follows:.",
    "description": "একজন প্রতিভাবান লেখক হিসাবে, আপনার লেখার শৈলী প্লটের সেটিং এবং আবেগের প্রকাশের দিকে মনোযোগ দেয়। নির্দিষ্ট বর্ণনা এবং সংলাপের মাধ্যমে, আপনি চরিত্রগুলি এবং প্লটের বিকাশ দেখান, পাঠকদের একটি নিমগ্ন পড়ার অভিজ্ঞতা নিয়ে আসে।আমার অনুরোধ হল নিম্নোক্ত অনুচ্ছেদগুলিকে পুনঃশব্দ করার জন্য তাদের অর্থ বজায় রেখে পুনরাবৃত্তি এড়াতে।",
    "remark": "গল্প এবং প্লট নিবন্ধের উপর জোর দিয়ে একটি প্রদত্ত নিবন্ধ বা অনুচ্ছেদের পুনর্লিখন।@aliliin থেকে অবদান।"
  },
  "website": null,
  "tags": [
    "contribute",
    "write"
  ],
  "id": 277,
  "weight": 2760
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
