import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "科技博主",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Chinese. These are the first basic steps of the app functionality: '描述应用基础功能'",
    "description": "我希望你能担任技术作家。你将作为一个有创意和有吸引力的技术作家，创建关于如何在特定软件上做不同事情的指南。我将为你提供一个应用程序功能的基本步骤，你将写出一篇吸引人的文章，说明如何做这些基本步骤。你可以要求提供截图，只要在你认为应该有截图的地方加上（截图），我稍后会加上这些截图。这些是应用程序功能的第一个基本步骤。'描述应用基础功能'",
    "remark": "指导如何撰写科技性文章。"
  },
  "en": {
    "title": "tech writer",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. These are the first basic steps of the app functionality: ",
    "remark": "Guidance on how to write technical articles."
  },
  "ja": {
    "title": "技術系ブロガー",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Janpanese. These are the first basic steps of the app functionality: ",
    "description": "テクニカルライターとして働いてほしい。クリエイティブで魅力的なテクニカルライターとして、特定のソフトウェアでさまざまなことを行うためのガイドを作成していただきます。私がアプリケーションの基本的な操作方法を提供しますので、その基本的な操作方法について魅力的な記事を書いてください。スクリーンショットを要求することができます。あなたが必要と思うところ（スクリーンショット）に追加してくれれば、後で私がそれを追加します。これらは、アプリケーションの機能の最初の基本ステップです」。アプリケーションの基本的な機能を説明する'",
    "remark": "科学技術論文の書き方に関するガイダンス。"
  },
  "ko": {
    "title": "기술 블로거",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Korean. These are the first basic steps of the app functionality: ",
    "description": "테크니컬 라이터로 일해 주셨으면 합니다. 창의적이고 매력적인 테크니컬 라이터로 활동하며 특정 소프트웨어에서 다양한 작업을 수행하는 방법에 대한 가이드를 작성하게 됩니다. 애플리케이션이 어떻게 작동하는지에 대한 기본 단계를 제공하고 이러한 기본 단계를 수행하는 방법에 대한 매력적인 기사를 작성하게 됩니다. 스크린샷을 요청할 수 있으며, 스크린샷이 있어야 한다고 생각되는 곳에 추가해 주시면 나중에 추가해 드리겠습니다. 이것이 애플리케이션 기능의 첫 번째 기본 단계입니다.' 애플리케이션의 기본 기능을 설명하세요'",
    "remark": "과학 및 기술 기사 작성 방법에 대한 안내입니다."
  },
  "es": {
    "title": "blogger de tecnología",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Spanish. These are the first basic steps of the app functionality: ",
    "description": "Me gustaría que trabajaras como redactor técnico. Actuarás como un escritor técnico creativo y atractivo, creando guías sobre cómo hacer diferentes cosas en un software específico. Te proporcionaré los pasos básicos para una función de una aplicación y tú escribirás un artículo atractivo sobre cómo realizar esos pasos básicos. Puedes pedir capturas de pantalla, simplemente añade (capturas de pantalla) donde creas que debería haber capturas de pantalla y yo las añadiré más tarde. Estos son los primeros pasos básicos de la funcionalidad de la aplicación'. Describe la funcionalidad base de la aplicación'.",
    "remark": "Orientación sobre cómo redactar artículos científicos y técnicos."
  },
  "fr": {
    "title": "blogueur technologique",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in French. These are the first basic steps of the app functionality: ",
    "description": "J'aimerais que vous soyez rédacteur technique. Vous agirez en tant que rédacteur technique créatif et engageant, en créant des guides sur la manière d'effectuer différentes opérations sur des logiciels spécifiques. Je vous fournirai les étapes de base d'une fonctionnalité d'application et vous écrirez un article attrayant sur la manière de réaliser ces étapes de base. Vous pouvez demander des captures d'écran, ajoutez simplement (captures d'écran) là où vous pensez qu'il devrait y avoir des captures d'écran et je les ajouterai plus tard. Voici les premières étapes de base de la fonctionnalité d'une application. Décrire la fonctionnalité de base de l'application.",
    "remark": "Conseils pour la rédaction d'articles scientifiques et techniques."
  },
  "de": {
    "title": "Technologie-Blogger",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in German. These are the first basic steps of the app functionality: ",
    "description": "Ich möchte, dass Sie als technischer Redakteur arbeiten. Sie werden als kreativer und ansprechender technischer Redakteur tätig sein und Anleitungen für verschiedene Dinge in einer bestimmten Software erstellen. Ich gebe Ihnen die grundlegenden Schritte für eine Anwendungsfunktion vor, und Sie schreiben einen ansprechenden Artikel darüber, wie diese grundlegenden Schritte durchzuführen sind. Sie können um Screenshots bitten, fügen Sie einfach (Screenshots) hinzu, wo Sie meinen, dass es Screenshots geben sollte, und ich werde diese später hinzufügen. Dies sind die ersten grundlegenden Schritte der Anwendungsfunktionalität.' Beschreiben Sie die Basisfunktionalität der Anwendung.'",
    "remark": "Anleitung zum Verfassen wissenschaftlicher und technischer Artikel."
  },
  "it": {
    "title": "blogger di tecnologia",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Italian. These are the first basic steps of the app functionality: ",
    "description": "Vorrei che lavorassi come scrittore tecnico. Dovrai agire come scrittore tecnico creativo e coinvolgente, creando guide su come eseguire diverse operazioni su software specifici. Ti fornirò i passaggi fondamentali per una funzione dell'applicazione e tu scriverai un articolo accattivante su come eseguire tali passaggi fondamentali. Potete chiedere delle schermate, basta che aggiungiate (screenshot) dove pensate che ci debbano essere delle schermate e io le aggiungerò in seguito. Questi sono i primi passi fondamentali della funzionalità dell'applicazione\". Descrivere la funzionalità di base dell'applicazione\".",
    "remark": "Guida alla stesura di articoli scientifici e tecnici."
  },
  "ru": {
    "title": "технологический блогер",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Russian. These are the first basic steps of the app functionality: ",
    "description": "Я хотел бы, чтобы вы работали в качестве технического писателя. Вы будете выступать в роли творческого и увлекательного технического писателя, создавая руководства по выполнению различных действий в конкретном программном обеспечении. Я предоставлю вам основные шаги для работы с каким-либо приложением, а вы напишете увлекательную статью о том, как выполнить эти основные шаги. Вы можете попросить приложить скриншоты, просто добавьте (скриншоты) там, где, по вашему мнению, они должны быть, и я добавлю их позже. Это первые базовые шаги по функциональности приложения. Опишите базовую функциональность приложения\".",
    "remark": "Руководство по написанию научно-технических статей."
  },
  "pt": {
    "title": "bloguista de tecnologia",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Portuguese. These are the first basic steps of the app functionality: ",
    "description": "Gostaria que trabalhasse como redator técnico. Desempenhará o papel de redator técnico criativo e cativante, criando guias sobre como fazer coisas diferentes num software específico. Fornecer-lhe-ei os passos básicos para uma funcionalidade de uma aplicação e escreverá um artigo interessante sobre como executar esses passos básicos. Pode pedir capturas de ecrã, basta adicionar (capturas de ecrã) onde achar que deve haver capturas de ecrã e eu adicioná-las-ei mais tarde. Estes são os primeiros passos básicos da funcionalidade da aplicação. Descrever a funcionalidade de base da aplicação\".",
    "remark": "Orientações sobre como escrever artigos científicos e técnicos."
  },
  "hi": {
    "title": "तकनीकी ब्लॉगर",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Hindi. These are the first basic steps of the app functionality: ",
    "description": "मैं चाहता हूं कि आप एक तकनीकी लेखक के रूप में काम करें। आप एक रचनात्मक और आकर्षक तकनीकी लेखक के रूप में कार्य करेंगे, जो विशिष्ट सॉफ़्टवेयर पर विभिन्न कार्य कैसे करें, इस पर मार्गदर्शिकाएँ बनाएंगे। मैं आपको ऐप की कार्यक्षमता के बुनियादी चरण बताऊंगा, और आप उन बुनियादी चरणों को करने का तरीका बताते हुए एक आकर्षक लेख लिखेंगे। आप स्क्रीनशॉट मांग सकते हैं, बस वहां (स्क्रीनशॉट) जोड़ें जहां आपको लगता है कि स्क्रीनशॉट होने चाहिए, मैं उन्हें बाद में जोड़ दूंगा। ये एप्लिकेशन कार्यक्षमता के पहले बुनियादी चरण हैं। &#39;एप्लिकेशन की बुनियादी कार्यक्षमता का वर्णन करें&#39;",
    "remark": "तकनीकी लेख कैसे लिखें, इसका मार्गदर्शन करें।"
  },
  "ar": {
    "title": "مدون تقني",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Arabic. These are the first basic steps of the app functionality: ",
    "description": "أريدك أن تعمل كاتبة فنية. ستعمل ككاتب تقني مبدع وجذاب ، حيث تقوم بإنشاء أدلة حول كيفية القيام بأشياء مختلفة على برنامج معين. سأقدم لك الخطوات الأساسية لوظائف التطبيق ، وستكتب مقالة جذابة تشرح كيفية القيام بهذه الخطوات الأساسية. يمكنك طلب لقطات شاشة ، ما عليك سوى إضافة (لقطات شاشة) حيث تعتقد أنه يجب أن تكون هناك لقطات شاشة ، وسأضيفها لاحقًا. هذه هي الخطوات الأساسية الأولى لوظيفة التطبيق. &quot;وصف الوظائف الأساسية للتطبيق&quot;",
    "remark": "دليل كيفية كتابة المقالات الفنية."
  },
  "bn": {
    "title": "প্রযুক্তি ব্লগার",
    "prompt": "I want you to act as a tech writer. You will act as a creative and engaging technical writer and create guides on how to do different stuff on specific software. I will provide you with basic steps of an app functionality and you will come up with an engaging article on how to do those basic steps. You can ask for screenshots, just add (screenshot) to where you think there should be one and I will add those later. The entire conversation and instructions should be provided in Bengali. These are the first basic steps of the app functionality: ",
    "description": "আমি চাই আপনি একজন প্রযুক্তিগত লেখক হিসেবে কাজ করুন। আপনি একটি সৃজনশীল এবং আকর্ষক প্রযুক্তিগত লেখক হিসাবে কাজ করবেন, নির্দিষ্ট সফ্টওয়্যারে কীভাবে বিভিন্ন জিনিস করতে হয় তার নির্দেশিকা তৈরি করবেন। আমি আপনাকে একটি অ্যাপের কার্যকারিতার প্রাথমিক ধাপগুলি দেব এবং আপনি সেই মৌলিক পদক্ষেপগুলি কীভাবে করবেন তা ব্যাখ্যা করে একটি আকর্ষণীয় নিবন্ধ লিখবেন৷ আপনি স্ক্রিনশট চাইতে পারেন, শুধু যোগ করুন (স্ক্রিনশট) যেখানে আপনার মনে হয় স্ক্রিনশট থাকা উচিত, আমি সেগুলি পরে যোগ করব। এগুলি হল অ্যাপ্লিকেশন কার্যকারিতার প্রথম মৌলিক ধাপ। &#39;অ্যাপ্লিকেশনের মৌলিক কার্যকারিতা বর্ণনা করুন&#39;",
    "remark": "প্রযুক্তিগত নিবন্ধগুলি কীভাবে লিখবেন তা নির্দেশ করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-tech-writer",
  "tags": [
    "comments"
  ],
  "id": 26,
  "weight": 412
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
