import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "电影评论②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Chinese. My first suggestion request is '电影评论角度'",
    "description": "我想让你充当一名影评人。你需要观看一部电影，并以清晰的方式对其进行评论，对情节、演技、摄影、方向、音乐等提供正面和负面的反馈。我的第一个建议要求是 '电影评论角度'",
    "remark": "从情节、表演、摄影、导演、音乐等方面评论电影。"
  },
  "en": {
    "title": "film critic",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. My first suggestion request is ",
    "remark": "Comment on the movie from aspects such as plot, performance, cinematography, direction, music, etc."
  },
  "ja": {
    "title": "映画レビュー②のページ",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Janpanese. My first suggestion request is ",
    "description": "あなたには映画評論家として活動してほしい。映画を観て、筋書き、演技、撮影、演出、音楽などについて肯定的・否定的な意見を述べながら、わかりやすくレビューする必要があります。私が最初に提案する要件は「映画批評の視点」です。",
    "remark": "映画をプロット、演技、撮影、演出、音楽などの観点からレビューする。"
  },
  "ko": {
    "title": "영화 리뷰 ②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Korean. My first suggestion request is ",
    "description": "영화 평론가로 활동해 주세요. 영화를 보고 줄거리, 연기, 촬영, 연출, 음악 등에 대해 긍정적이거나 부정적인 피드백을 제공하면서 명확한 방식으로 영화를 리뷰해야 합니다. 제가 제안하는 첫 번째 요건은 '영화 리뷰 관점'입니다.",
    "remark": "줄거리, 연기, 촬영, 연출, 음악 등의 측면에서 영화를 리뷰합니다."
  },
  "es": {
    "title": "Crítica de cine②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Spanish. My first suggestion request is ",
    "description": "Quiero que hagas de crítico de cine. Tienes que ver una película y hacer una crítica clara, con comentarios positivos y negativos sobre el argumento, la interpretación, la fotografía, la dirección, la música, etc. El primer requisito que te propongo es \"Perspectiva de crítico de cine\".",
    "remark": "Reseña de películas desde el punto de vista del argumento, la interpretación, la fotografía, la dirección y la música."
  },
  "fr": {
    "title": "Film Review②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in French. My first suggestion request is ",
    "description": "Je vous demande de jouer le rôle d'un critique de cinéma. Vous devez regarder un film et le critiquer de manière claire, en donnant des commentaires positifs et négatifs sur l'intrigue, le jeu des acteurs, la cinématographie, la mise en scène, la musique, etc. La première exigence que je propose est la \"perspective du critique de film",
    "remark": "Examine les films en termes d'intrigue, d'interprétation, de cinématographie, de réalisation et de musique."
  },
  "de": {
    "title": "Filmkritik②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in German. My first suggestion request is ",
    "description": "Ich möchte, dass Sie die Rolle eines Filmkritikers übernehmen. Sie müssen sich einen Film ansehen und ihn in einer klaren Art und Weise rezensieren, indem Sie sowohl positives als auch negatives Feedback zu Handlung, Schauspiel, Kameraführung, Regie, Musik usw. geben. Meine erste vorgeschlagene Anforderung lautet \"Filmkritische Perspektive\".",
    "remark": "Bewertet Filme in Bezug auf Handlung, Schauspiel, Kameraführung, Regie und Musik."
  },
  "it": {
    "title": "Recensione del film②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Italian. My first suggestion request is ",
    "description": "Voglio che vi comportiate come un critico cinematografico. Dovete guardare un film e recensirlo in modo chiaro, fornendo un feedback sia positivo che negativo su trama, recitazione, fotografia, regia, musica, ecc. Il primo requisito suggerito è \"Prospettiva del critico cinematografico\".",
    "remark": "Recensisce i film in termini di trama, recitazione, fotografia, regia e musica."
  },
  "ru": {
    "title": "Рецензия на фильм②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Russian. My first suggestion request is ",
    "description": "Я хочу, чтобы вы выступили в роли кинокритика. Вам необходимо посмотреть фильм и дать на него четкую рецензию, содержащую как положительные, так и отрицательные отзывы о сюжете, игре актеров, кинематографе, режиссуре, музыке и т.д. Первое предлагаемое мной требование - \"Перспектива кинокритика\".",
    "remark": "Рецензирует фильмы с точки зрения сюжета, актерской игры, кинематографа, режиссуры и музыки."
  },
  "pt": {
    "title": "Revisão do filme②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Portuguese. My first suggestion request is ",
    "description": "Quero que desempenhes o papel de um crítico de cinema. Tens de ver um filme e avaliá-lo de forma clara, dando opiniões positivas e negativas sobre o enredo, a representação, a cinematografia, a realização, a música, etc. O meu primeiro requisito sugerido é \"Perspetiva de crítico de cinema",
    "remark": "Analisa filmes em termos de enredo, representação, cinematografia, realização e música."
  },
  "hi": {
    "title": "मूवी समीक्षा②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Hindi. My first suggestion request is ",
    "description": "मैं चाहता हूं कि आप फिल्म समीक्षक बनें। आपको एक फिल्म देखने और स्पष्ट तरीके से उसकी समीक्षा करने, कथानक, अभिनय, फोटोग्राफी, निर्देशन, संगीत आदि पर सकारात्मक और नकारात्मक प्रतिक्रिया देने की आवश्यकता है। मेरा पहला सुझाव अनुरोध &#39;मूवी समीक्षा कोण&#39; है",
    "remark": "कथानक, अभिनय, छायांकन, निर्देशन, संगीत और बहुत कुछ के संदर्भ में फिल्मों की समीक्षा करें।"
  },
  "ar": {
    "title": "مراجعة الفيلم②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Arabic. My first suggestion request is ",
    "description": "أريدك أن تكون ناقد سينمائي. تحتاج إلى مشاهدة فيلم ومراجعته بطريقة واضحة ، وإعطاء ردود فعل إيجابية وسلبية على الحبكة ، والتمثيل ، والتصوير ، والتوجيه ، والموسيقى ، وما إلى ذلك. طلب اقتراحي الأول هو &quot;زاوية مراجعة الفيلم&quot;",
    "remark": "قم بمراجعة الأفلام من حيث الحبكة والتمثيل والتصوير السينمائي والإخراج والموسيقى وغير ذلك."
  },
  "bn": {
    "title": "মুভি রিভিউ②",
    "prompt": "I want you to act as a film critic. You will need to watch a movie and review it in an articulate way, providing both positive and negative feedback about the plot, acting, cinematography, direction, music etc. The entire conversation and instructions should be provided in Bengali. My first suggestion request is ",
    "description": "আমি চাই তুমি একজন চলচ্চিত্র সমালোচক হও। আপনাকে একটি মুভি দেখতে হবে এবং এটিকে পরিষ্কারভাবে পর্যালোচনা করতে হবে, প্লট, অভিনয়, ফটোগ্রাফি, নির্দেশনা, সঙ্গীত ইত্যাদি সম্পর্কে ইতিবাচক এবং নেতিবাচক প্রতিক্রিয়া দিতে হবে। আমার প্রথম পরামর্শ অনুরোধ হল &#39;মুভি পর্যালোচনা কোণ&#39;",
    "remark": "প্লট, অভিনয়, সিনেমাটোগ্রাফি, নির্দেশনা, সঙ্গীত এবং আরও অনেক কিছুর পরিপ্রেক্ষিতে সিনেমা পর্যালোচনা করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-film-critic",
  "tags": [
    "comments"
  ],
  "id": 25,
  "weight": 439
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
