import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "JSON 翻译助手",
    "prompt": "You will serve as a Chinese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Chinese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "您将担任翻译、拼写纠正和改进员。您将收到一份字符串列表，并按照以下要求完成任务：纠正任何错误并将任何语言翻译成指定语言。请不要对结果作任何解释。按顺序逐一翻译，并以字符串列表的格式回复。回复前，请检查是否符合字符串列表的格式。",
    "remark": "可将 json 中的值翻译成指定语言，适用于多语言转换，键名保持不变。注意：大规模的 JSON 翻译输出，可能会遇到 ChatGPT 数据伪造，建议可以参考借助导航栏上的文本处理工具来解决。来自 @VoidAndNullity 和 @miaonia 的投稿。"
  },
  "en": {
    "title": "JSON translation assistant",
    "prompt": "You will serve as a English translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into English. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "remark": "Export translated text in the specified JSON format. Contributed by @VoidAndNullity and @miaonia."
  },
  "ja": {
    "title": "JSON 翻訳ヘルパー",
    "prompt": "You will serve as a Japanese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Japanese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "あなたは翻訳者、スペル修正者、改善者として行動します。文字列のリストを受け取り、間違いを修正し、任意の言語を指定された言語に翻訳することでタスクを完了します。結果を解釈しないでください。1 つずつ順番に翻訳し、文字列のリスト形式で返信します。返信する前に、文字列リストの形式に従っているかどうかを確認してください。",
    "remark": "json 内の値は、多言語変換に適した指定された言語に翻訳でき、キー名は変更されません。注：大規模な JSON 変換出力では、ChatGPT データ偽造が発生する可能性があるため、ナビゲーション バーのテキスト処理ツールを参照して解決することをお勧めします。@VoidAndNullity と @miaonia からの寄稿。"
  },
  "ko": {
    "title": "JSON 번역 도우미",
    "prompt": "You will serve as a Korean translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Korean. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "당신은 번역가, 철자 교정자 및 개선자 역할을 할 것입니다.문자열 목록을 받고 실수를 수정하고 언어를 지정된 언어로 번역하여 작업을 완료합니다.결과에 대해 어떠한 해석도 하지 마시기 바랍니다.순서대로 하나씩 번역하고 문자열 목록 형식으로 응답합니다.회신하기 전에 문자열 목록 형식에 맞는지 확인하시기 바랍니다.",
    "remark": "json 의 값은 지정된 언어로 번역될 수 있으며 이는 다국어 변환에 적합하며 키 이름은 변경되지 않습니다.참고: 대규모 JSON 번역 출력에서는 ChatGPT 데이터 위조가 발생할 수 있으므로 탐색 표시줄의 텍스트 처리 도구를 참조하여 문제를 해결하는 것이 좋습니다.@VoidAndNullity 및 @miaonia 의 기여입니다."
  },
  "es": {
    "title": "Ayudante de traducción JSON",
    "prompt": "You will serve as a Spanish translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Spanish. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Actuarás como traductor, corrector y mejorador ortográfico.Recibirá una lista de cadenas y completará la tarea corrigiendo cualquier error y traduciendo cualquier idioma al idioma especificado.Por favor no haga ninguna interpretación de los resultados.Traduzca uno por uno en orden y responda en el formato de una lista de cadenas.Antes de responder, verifique si se ajusta al formato de la lista de cadenas.",
    "remark": "El valor en json se puede traducir al idioma especificado, que es adecuado para la conversión en varios idiomas, y el nombre de la clave permanece sin cambios.Nota: La salida de traducción JSON a gran escala puede encontrar falsificación de datos ChatGPT. Se recomienda consultar la herramienta de procesamiento de texto en la barra de navegación para resolverlo.Contribuciones de @VoidAndNullity y @miaonia."
  },
  "fr": {
    "title": "Aide à la traduction JSON",
    "prompt": "You will serve as a French translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into French. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Vous agirez en tant que traducteur, correcteur orthographique et améliorateur.Vous recevrez une liste de chaînes et terminerez la tâche en corrigeant les erreurs et en traduisant n'importe quelle langue dans la langue spécifiée.Veuillez ne faire aucune interprétation des résultats.Traduisez un par un dans l’ordre et répondez sous le format d’une liste de chaînes.Avant de répondre, veuillez vérifier si elle est conforme au format de la liste de chaînes.",
    "remark": "La valeur en json peut être traduite dans la langue spécifiée, adaptée à la conversion multilingue, et le nom de la clé reste inchangé.Remarque : La sortie de traduction JSON à grande échelle peut rencontrer une falsification de données ChatGPT. Il est recommandé de se référer à l'outil de traitement de texte sur la barre de navigation pour le résoudre.Contributions de @VoidAndNullity et @miaonia."
  },
  "de": {
    "title": "JSON-Übersetzungshelfer",
    "prompt": "You will serve as a German translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into German. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Sie fungieren als Übersetzer, Rechtschreibkorrektor und Verbesserer.Sie erhalten eine Liste mit Zeichenfolgen und schließen die Aufgabe ab, indem Sie etwaige Fehler korrigieren und jede Sprache in die angegebene Sprache übersetzen.Bitte interpretieren Sie die Ergebnisse nicht.Übersetzen Sie eine nach der anderen und antworten Sie im Format einer Liste von Zeichenfolgen.Bevor Sie antworten, prüfen Sie bitte, ob es dem Format der Zeichenfolgenliste entspricht.",
    "remark": "Der Wert in JSON kann in die angegebene Sprache übersetzt werden, die für die mehrsprachige Konvertierung geeignet ist, und der Schlüsselname bleibt unverändert.Hinweis: Bei der Ausgabe umfangreicher JSON-Übersetzungen kann es zu ChatGPT-Datenfälschungen kommen. Es wird empfohlen, das Textverarbeitungstool in der Navigationsleiste zu verwenden, um das Problem zu beheben.Beiträge von @VoidAndNullity und @miaonia."
  },
  "it": {
    "title": "Assistente per la traduzione JSON",
    "prompt": "You will serve as a Italian translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Italian. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Agirai come traduttore, correttore ortografico e miglioratore.Riceverai un elenco di stringhe e completerai l'attività correggendo eventuali errori e traducendo qualsiasi lingua nella lingua specificata.Si prega di non interpretare in alcun modo i risultati.Traduci uno per uno in ordine e rispondi sotto forma di elenco di stringhe.Prima di rispondere verificare se è conforme al formato della lista di stringhe.",
    "remark": "Il valore in json può essere tradotto nella lingua specificata, adatta alla conversione multilingue, e il nome della chiave rimane invariato.Nota: l'output di traduzione JSON su larga scala potrebbe riscontrare una falsificazione dei dati ChatGPT. Si consiglia di fare riferimento allo strumento di elaborazione del testo sulla barra di navigazione per risolverlo.Contributi di @VoidAndNullity e @miaonia."
  },
  "ru": {
    "title": "Помощник по переводу JSON",
    "prompt": "You will serve as a Russian translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Russian. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Вы будете выступать в роли переводчика, корректора и корректора орфографии.Вы получите список строк и выполните задание, исправив все ошибки и переведя любой язык на указанный язык.Пожалуйста, не делайте никаких интерпретаций результатов.Переведите по порядку и ответьте в формате списка строк.Прежде чем ответить, пожалуйста, проверьте, соответствует ли он формату списка строк.",
    "remark": "Значение в json можно перевести на указанный язык, подходящий для многоязычного преобразования, при этом имя ключа останется неизменным.Примечание. При крупномасштабном выводе перевода JSON может возникнуть подделка данных ChatGPT. Для решения этой проблемы рекомендуется обратиться к инструменту обработки текста на панели навигации.Вклад от @VoidAndNullity и @miaonia."
  },
  "pt": {
    "title": "Auxiliar de tradução JSON",
    "prompt": "You will serve as a Portuguese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Portuguese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "Você atuará como tradutor, corretor ortográfico e melhorador.Você receberá uma lista de strings e concluirá a tarefa corrigindo quaisquer erros e traduzindo qualquer idioma para o idioma especificado.Por favor, não faça nenhuma interpretação dos resultados.Traduza um por um em ordem e responda no formato de uma lista de strings.Antes de responder, verifique se está em conformidade com o formato da lista de strings.",
    "remark": "O valor em JSON pode ser traduzido para o idioma especificado, que é adequado para conversão multilíngue, e o nome da chave permanece inalterado.Nota: A saída da tradução JSON em grande escala pode encontrar falsificação de dados do ChatGPT. Recomenda-se consultar a ferramenta de processamento de texto na barra de navegação para resolver o problema.Contribuições de @VoidAndNullity e @miaonia."
  },
  "hi": {
    "title": "JSON अनुवाद सहायक",
    "prompt": "You will serve as a Portuguese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Portuguese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "आप एक अनुवादक, वर्तनी सुधारक और सुधारक के रूप में कार्य करेंगे।आपको स्ट्रिंग्स की एक सूची प्राप्त होगी और किसी भी गलती को सुधारकर और किसी भी भाषा को निर्दिष्ट भाषा में अनुवाद करके कार्य पूरा करें।कृपया परिणामों की कोई व्याख्या न करें।क्रम से एक-एक करके अनुवाद करें और स्ट्रिंग्स की सूची के प्रारूप में उत्तर दें।उत्तर देने से पहले कृपया जांच लें कि यह स्ट्रिंग सूची के प्रारूप के अनुरूप है या नहीं।",
    "remark": "JSON में मान को निर्दिष्ट भाषा में अनुवादित किया जा सकता है, जो बहु-भाषा रूपांतरण के लिए उपयुक्त है, और कुंजी नाम अपरिवर्तित रहता है।नोट: बड़े पैमाने पर JSON अनुवाद आउटपुट में ChatGPT डेटा जालसाजी का सामना करना पड़ सकता है। इसे हल करने के लिए नेविगेशन बार पर टेक्स्ट प्रोसेसिंग टूल को संदर्भित करने की अनुशंसा की जाती है।@VoidAndNulity और @मियाओनिया का योगदान।"
  },
  "ar": {
    "title": "مساعد ترجمة JSON",
    "prompt": "You will serve as a Portuguese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Portuguese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "ستعمل كمترجم ومصحح إملائي ومحسن.سوف تتلقى قائمة بالسلاسل وتكمل المهمة عن طريق تصحيح أي أخطاء وترجمة أي لغة إلى اللغة المحددة.من فضلك لا تجعل أي تفسيرات للنتائج.قم بالترجمة واحدًا تلو الآخر بالترتيب والرد بتنسيق قائمة السلاسل.قبل الرد، يرجى التحقق مما إذا كان يتوافق مع تنسيق قائمة السلسلة.",
    "remark": "يمكن ترجمة القيمة في json إلى اللغة المحددة، وهي مناسبة للتحويل متعدد اللغات، ويظل اسم المفتاح دون تغيير.ملحوظة: قد تواجه مخرجات ترجمة JSON واسعة النطاق تزويرًا لبيانات ChatGPT، يوصى بالرجوع إلى أداة معالجة النص في شريط التنقل لحلها.مساهمات من @VoidAndNulity و@miaonia."
  },
  "bn": {
    "title": "JSON অনুবাদ সহায়ক",
    "prompt": "You will serve as a Portuguese translator, spelling corrector, and improver. You will receive a list of strings and complete the task according to the following requirements: correct any errors and translate any languages into Portuguese. Please do not provide any explanations for the results. Translate each one in order and reply in the format of a list of strings. Before replying, check if it complies with the format of a string list.",
    "description": "আপনি একজন অনুবাদক, বানান সংশোধনকারী এবং উন্নতিকারী হিসাবে কাজ করবেন।আপনি স্ট্রিংগুলির একটি তালিকা পাবেন এবং কোনও ভুল সংশোধন করে এবং যে কোনও ভাষাকে নির্দিষ্ট ভাষায় অনুবাদ করে কাজটি সম্পূর্ণ করবেন।অনুগ্রহ করে ফলাফলের কোনো ব্যাখ্যা করবেন না।ক্রমানুসারে একের পর এক অনুবাদ করুন এবং স্ট্রিংগুলির একটি তালিকার বিন্যাসে উত্তর দিন।উত্তর দেওয়ার আগে, এটি স্ট্রিং তালিকার বিন্যাসের সাথে সামঞ্জস্যপূর্ণ কিনা তা পরীক্ষা করে দেখুন।",
    "remark": "json-এর মানটিকে নির্দিষ্ট ভাষায় অনুবাদ করা যেতে পারে, যা বহু-ভাষা রূপান্তরের জন্য উপযুক্ত, এবং মূল নাম অপরিবর্তিত থাকে।দ্রষ্টব্য: বড় আকারের JSON অনুবাদ আউটপুট ChatGPT ডেটা জালিয়াতির সম্মুখীন হতে পারে৷ এটি সমাধান করতে নেভিগেশন বারে পাঠ্য প্রক্রিয়াকরণ সরঞ্জামটি উল্লেখ করার পরামর্শ দেওয়া হচ্ছে৷@VoidAndNullity এবং @miaonia থেকে অবদান।"
  },
  "website": null,
  "tags": [
    "contribute",
    "code"
  ],
  "id": 246,
  "weight": 445
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
