import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "小说式文字游戏",
    "prompt": "I want you to write a [Wuxia] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in Chinese and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [背景：a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [主角设定：16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and complet",
    "description": "我想让你写一部 [武侠] 风格的小说，主人公是我，情节由你的描述和我的选择来推动。我输入我的行动行为，你回复人物所见和其他信息的描述。请用中文回复，不要担心其他的事情，不要写解释。不要输入命令，除非我指示你这样做。当我需要补充设置时，我会把文字放在括号里（像这样）。当你遇到可以决定情节走向的关键事件时，你可以随机确定事件的走向。例如，你预先假设 3 个可能的情节方向，然后随机选择一个。背景：一个不同的世界大陆，这里有不同的国家、地区和种族，包括魔法师、剑士、牧师和其他战斗职业。这个世界有三个人类国家，一个兽人国家，还有精灵和龙等生物。还有恶魔。]，请想象完整的地形、部队和关键人物。以下信息需要包括性别、年龄或首次或适当时的大致年龄。我是 [主角设定：16 岁，可爱，受女孩欢迎]。告诉我其他人物的性别和年龄。请对每个国家的政治、经济、军事、文化等进行合理设置，以及地形和传说。请添加情节中出现的人物和事件，请添加我的人际关系，完整的背景和身份，给我一个系统的介绍。请在情节发展中加入一些意外，多一些人物互动，增加人物的参与度，而不是我一个人决定整个情节的走向。请注意作品的合理性、逻辑性和完整性。",
    "remark": "主角、背景自由设定的文字游戏，可在对话中修改、增加设定，建议多对 AI 进行引导，注意对话次数多了或者出场人物、设定过多 AI 可能会前后矛盾。来自 @karenkujiu 的投稿。"
  },
  "en": {
    "title": "Novel-style text-based game",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and complet",
    "remark": "A text-based game with freely customizable main characters and backgrounds, where settings can be modified and added during the conversation. It is recommended to guide the AI through multiple conversations and to be aware that excessive dialogue or too many characters and settings may result in inconsistencies. Contributed by @karenkujiu."
  },
  "ja": {
    "title": "フィクションの言葉遊び",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Janpanese. Please pay attention to the rationality, logic, and complet.",
    "description": "主人公が私で、あなたの描写と私の選択によって筋が進む【武道】風の小説を書いて欲しいのです。私が行動アクションを入力し、あなたは登場人物が見るものなどの描写を返信します。中国語で返信してください、余計なことは気にしないでください、説明文は書かないでください。私が指示しない限り、コマンドを入力しないでください。設定を追加する必要があるときは、（このように）カッコの中にテキストを入れます。プロットの方向性を決めるような重要な出来事に遭遇したとき、その出来事の方向をランダムにすることができます。例えば、プロットの方向性を 3 つ想定し、その中からランダムに 1 つ選びます。舞台：異なる国、地域、種族を持つ異世界の大陸で、魔法使い、剣士、神官などの戦闘職がいる。この世界には、人間の国が 3 つ、オークの国が 1 つあり、エルフやドラゴンなどの生物もいる。魔物もいます]。地形、兵力、主要キャラクターは完全に想像してください。以下の情報には、性別、年齢、または最初の年齢や適切な場所でのおおよその年齢を含める必要があります。私は【主人公設定：16 歳、かわいくて女の子にモテる】です。他の登場人物の性別と年齢を教えてください。各国の政治・経済・軍事・文化、地形や伝承など、妥当な設定をお願いします。プロットに登場するキャラクターや出来事を追加してください。私の人間関係や詳しい背景、アイデンティティを追加し、体系的な紹介をお願いします。私一人がプロットの行方を決めるのではなく、プロット展開に驚きを与えたり、キャラクター同士の交流を増やしたり、キャラクターを巻き込んだりすることも含めてください。作品のもっともらしさ、論理性、完成度にも配慮してください。",
    "remark": "テキストゲームで主人公と背景を自由に設定できる、台詞で設定を修正・追加できる、AI を多めに誘導するのがおすすめ、台詞を増やしたり、キャラクターや設定の AI が多すぎると整合性が取れなくなることがあるので注意する。寄稿：@karenkujiu さん。"
  },
  "ko": {
    "title": "가상의 말장난",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Korean. Please pay attention to the rationality, logic, and complet.",
    "description": "주인공은 나이고 줄거리는 당신의 설명과 나의 선택에 따라 움직이는 [무협] 스타일의 소설을 써주세요. 제가 액션 동작을 입력하면 캐릭터가 보는 것에 대한 설명과 기타 정보로 답장을 보내주세요. 다른 것에 신경 쓰지 말고 중국어로 답장하고 설명을 쓰지 마세요. 제가 지시하지 않는 한 명령을 입력하지 마세요. 설정을 추가해야 할 때는 괄호 안에 텍스트를 넣습니다 (예: 이렇게). 플롯의 방향을 결정할 수 있는 주요 이벤트를 발견하면 이벤트의 방향을 무작위로 지정할 수 있습니다. 예를 들어, 3 가지 가능한 플롯 방향을 전제하고 그 중 하나를 무작위로 선택하는 것입니다. 배경: 마법사, 검사, 사제 및 기타 전투 직업을 포함한 다양한 국가, 지역 및 종족이 있는 다른 세계 대륙입니다. 이 세계에는 세 개의 인간 국가, 오크 국가, 엘프와 용과 같은 생물이 있습니다. 악마도 있습니다.] 전체 지형, 병력 및 주요 캐릭터를 상상해 주세요. 다음 정보에는 성별, 나이 또는 대략적인 나이가 먼저 또는 적절한 경우 포함되어야 합니다. 저는 [주인공 설정: 16 세, 귀엽고 여자아이들에게 인기 있음] 입니다. 다른 캐릭터의 성별과 나이를 알려주세요. 각 국가의 정치, 경제, 군사, 문화, 지형과 전설에 대한 합리적인 설정을 제공해 주세요. 줄거리에 등장하는 캐릭터와 사건을 추가해 주세요. 배경과 정체성을 포함한 제 관계를 추가하고 체계적으로 소개해 주세요. 저 혼자서 전체 줄거리의 방향을 결정하기보다는 줄거리의 전개에 약간의 놀라움, 더 많은 캐릭터의 상호 작용 및 더 많은 캐릭터의 참여를 포함 해주세요. 작품의 개연성, 논리성, 완성도에 신경 써주세요.",
    "remark": "주인공과 배경은 텍스트 게임에서 자유롭게 설정할 수 있으며 대화에서 설정을 수정하고 추가 할 수 있으며 더 많은 대화 또는 너무 많은 캐릭터와 설정 AI 가 일관성이 없을 수 있으므로 AI 를 더 자주 안내하는 것이 좋습니다. karenkujiu 가 제공했습니다."
  },
  "es": {
    "title": "Juegos de palabras de ficción",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Spanish. Please pay attention to the rationality, logic, and complet.",
    "description": "Quiero que escribas una novela al estilo [artes marciales] en la que el protagonista sea yo y la trama esté dirigida por tus descripciones y mis elecciones. Yo introduciré el comportamiento de mis acciones y tú responderás con una descripción de lo que ve el personaje y otra información. Por favor, responde en chino, no te preocupes por nada más y no escribas explicaciones. No introduzcas comandos a menos que yo te lo indique. Cuando tenga que añadir algo a la ambientación, pondré el texto entre paréntesis (así). Cuando te encuentres con acontecimientos clave que puedan determinar el curso de la trama, puedes aleatorizar el curso de los acontecimientos. Por ejemplo, presupones 3 posibles direcciones de la trama y eliges una al azar. Ambientación: un mundo continente diferente donde hay diferentes países, regiones y razas, incluyendo magos, espadachines, sacerdotes y otras profesiones de combate. El mundo tiene tres naciones humanas, una de orcos y criaturas como elfos y dragones. También hay demonios]. Por favor, imagina el terreno completo, las tropas y los personajes clave. La siguiente información debe incluir género, edad o edad aproximada cuando sea la primera o apropiada. Soy [Entorno del protagonista: 16 años, guapo, popular entre las chicas]. Dime el sexo y la edad de los demás personajes. Proporciona una ambientación razonable de la política, la economía, el ejército y la cultura de cada país, así como del terreno y el saber popular. Por favor, añade personajes y acontecimientos que aparezcan en la trama, y por favor, añade mis relaciones, antecedentes completos e identidad para darme una introducción sistemática. Por favor, añada algunas sorpresas en el desarrollo de la trama, más interacciones entre los personajes, y aumente la participación de los personajes, en lugar de que yo solo decida toda la trama. Por favor, preste atención a la razonabilidad, lógica e integridad de su trabajo.",
    "remark": "El personaje principal, el fondo de la libre configuración del juego de texto, se puede modificar en el diálogo, añadir ajustes, se recomienda que más orientación a la IA, prestar atención al número de diálogos o aparecen en demasiados caracteres, ajustes, la IA puede ser inconsistente. Contribuido por @karenkujiu."
  },
  "fr": {
    "title": "Jeux de mots fictifs",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in French. Please pay attention to the rationality, logic, and complet.",
    "description": "Je veux que vous écriviez un roman de style [arts martiaux] dont le personnage principal est moi et dont l'intrigue est guidée par vos descriptions et mes choix. J'indiquerai le comportement de mes actions et vous répondrez en décrivant ce que le personnage voit et en donnant d'autres informations. Répondez en chinois, ne vous préoccupez pas du reste et n'écrivez pas d'explications. N'entrez pas d'ordres à moins que je ne vous le demande. Lorsque j'ai besoin de compléter le cadre, je mets le texte entre parenthèses (comme ceci). Lorsque vous rencontrez des événements clés qui peuvent déterminer le cours de l'intrigue, vous pouvez rendre aléatoire le déroulement des événements. Par exemple, vous présupposez 3 directions possibles pour l'intrigue et vous en choisissez une au hasard. Cadre : un continent différent où il y a différents pays, régions et races, y compris des sorciers, des épéistes, des prêtres et d'autres professions de combat. Le monde compte trois nations humaines, une nation orque et des créatures telles que les elfes et les dragons. Il y a aussi des démons]. Pour chaque personnage, imaginez le terrain complet, les troupes et les personnages clés. Les informations suivantes doivent inclure le sexe, l'âge ou l'âge approximatif lorsque c'est le cas. Je suis [Protagoniste : 16 ans, mignon, populaire auprès des filles]. Indiquez-moi le sexe et l'âge des autres personnages. Veuillez fournir un cadre raisonnable pour la politique, l'économie, l'armée et la culture de chaque pays, ainsi que pour le terrain et l'histoire. Ajoutez les personnages et les événements qui apparaissent dans l'intrigue, ainsi que mes relations, mon passé complet et mon identité pour me donner une introduction systématique. Veuillez ajouter quelques surprises dans le développement de l'intrigue, plus d'interactions entre les personnages, et augmenter l'implication des personnages, au lieu que je sois le seul à décider de l'ensemble de l'intrigue. Veillez à ce que votre travail soit raisonnable, logique et complet.",
    "remark": "Le personnage principal, l'arrière-plan de la configuration libre du jeu de texte, peut être modifié dans le dialogue, ajouter des paramètres, il est recommandé que plus d'orientation à l'IA, faire attention au nombre de dialogues ou apparaître dans trop de personnages, paramètres, l'IA peut être incohérente. Contribution de @karenkujiu."
  },
  "de": {
    "title": "Fiktive Wortspiele",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in German. Please pay attention to the rationality, logic, and complet.",
    "description": "Ich möchte, dass du einen Roman im Stil von [Kampfsport] schreibst, in dem ich die Hauptfigur bin und die Handlung von deinen Beschreibungen und meinen Entscheidungen bestimmt wird. Ich gebe das Verhalten meiner Handlungen ein, und du antwortest mit einer Beschreibung dessen, was die Figur sieht, und anderen Informationen. Bitte antworten Sie auf Chinesisch, kümmern Sie sich nicht um andere Dinge und schreiben Sie keine Erklärungen. Geben Sie keine Befehle ein, es sei denn, ich weise Sie an, dies zu tun. Wenn ich etwas zur Einstellung hinzufügen muss, setze ich den Text in Klammern (wie hier). Wenn Sie auf Schlüsselereignisse stoßen, die den Verlauf der Handlung bestimmen können, können Sie den Verlauf der Ereignisse zufällig bestimmen. Sie können zum Beispiel 3 mögliche Richtungen der Handlung vorgeben und dann eine davon zufällig auswählen. Schauplatz: ein anderer Weltkontinent, auf dem es verschiedene Länder, Regionen und Völker gibt, darunter Zauberer, Schwertkämpfer, Priester und andere Kampfberufe. In der Welt gibt es drei menschliche Völker, ein Orkvolk und Kreaturen wie Elfen und Drachen. Es gibt auch Dämonen]. Bitte stellen Sie sich das komplette Terrain, die Truppen und die wichtigsten Charaktere vor. Die folgenden Informationen müssen das Geschlecht, das Alter oder das ungefähre Alter enthalten, wenn sie zuerst genannt werden oder angemessen sind. Ich bin [Protagonist Setting: 16 Jahre alt, süß, beliebt bei Mädchen]. Nennen Sie mir das Geschlecht und Alter der anderen Charaktere. Bitte geben Sie einen angemessenen Rahmen für die Politik, die Wirtschaft, das Militär und die Kultur eines jeden Landes an, ebenso wie für das Terrain und die Überlieferungen. Fügen Sie bitte Charaktere und Ereignisse hinzu, die in der Handlung vorkommen, und fügen Sie bitte meine Beziehungen, meinen vollständigen Hintergrund und meine Identität hinzu, um mir eine systematische Einführung zu geben. Bitte fügen Sie einige Überraschungen in der Entwicklung der Handlung hinzu, mehr Interaktionen zwischen den Charakteren, und erhöhen Sie die Beteiligung der Charaktere, anstatt dass ich allein über die gesamte Handlung entscheide. Achten Sie bitte auf die Angemessenheit, Logik und Vollständigkeit Ihrer Arbeit.",
    "remark": "Die Hauptfigur, der Hintergrund der freien Einstellung des Textes Spiel, kann im Dialog geändert werden, fügen Sie Einstellungen, wird empfohlen, dass mehr Leitlinien für die AI, achten Sie auf die Anzahl der Dialoge oder in zu vielen Zeichen, Einstellungen, die AI kann inkonsistent sein. Beigetragen von @karenkujiu."
  },
  "it": {
    "title": "Giochi di parole di fantasia",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Italian. Please pay attention to the rationality, logic, and complet.",
    "description": "Voglio che tu scriva un romanzo in stile [arti marziali] in cui il protagonista sia io e la trama sia guidata dalle tue descrizioni e dalle mie scelte. Io inserirò il comportamento delle mie azioni e tu risponderai con una descrizione di ciò che il personaggio vede e altre informazioni. Rispondete in cinese, non preoccupatevi di altro e non scrivete spiegazioni. Non inserite comandi a meno che non vi dia istruzioni in tal senso. Quando devo aggiungere qualcosa all'ambientazione, metto il testo tra parentesi (come in questo caso). Quando si verificano eventi chiave che possono determinare il corso della trama, si può randomizzare il corso degli eventi. Ad esempio, si ipotizzano 3 possibili direzioni della trama e poi se ne sceglie una a caso. Ambientazione: un continente di un altro mondo in cui ci sono diversi paesi, regioni e razze, tra cui maghi, spadaccini, sacerdoti e altre professioni di combattimento. Il mondo ha tre nazioni umane, una nazione di orchi e creature come elfi e draghi. Ci sono anche i demoni]. , si prega di immaginare il terreno completo, le truppe e i personaggi chiave. Le seguenti informazioni devono includere il sesso, l'età o l'età approssimativa, quando è il primo o il più appropriato. Io sono [Protagonista Impostazione: 16 anni, carino, popolare con le ragazze]. Ditemi il sesso e l'età degli altri personaggi. Fornite un'ambientazione ragionevole per la politica, l'economia, l'esercito e la cultura di ogni paese, così come per il terreno e la storia. Aggiungete i personaggi e gli eventi che compaiono nella trama, e aggiungete le mie relazioni, il mio background completo e la mia identità per darmi un'introduzione sistematica. Aggiungete alcune sorprese nello sviluppo della trama, più interazioni tra i personaggi e aumentate il coinvolgimento dei personaggi, invece di essere io a decidere l'intera trama. Prestate attenzione alla ragionevolezza, alla logica e alla completezza del vostro lavoro.",
    "remark": "Il personaggio principale, lo sfondo dell'impostazione libera del gioco di testo, può essere modificato nel dialogo, aggiungere impostazioni, si raccomanda che più guida per l'IA, prestare attenzione al numero di dialoghi o appaiono in troppi personaggi, le impostazioni, l'IA può essere incoerente. Contribuito da @karenkujiu."
  },
  "ru": {
    "title": "Игры с вымышленными словами",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Russian. Please pay attention to the rationality, logic, and complet.",
    "description": "Я хочу, чтобы вы написали роман в стиле [боевых искусств], где главный герой - я, а сюжет развивается благодаря вашим описаниям и моему выбору. Я буду вводить поведение своих действий, а вы в ответ - описание того, что видит персонаж, и другую информацию. Пожалуйста, отвечайте на китайском языке, не беспокойтесь ни о чем другом и не пишите объяснений. Не вводите команды, если я вас не проинструктирую. Когда мне нужно будет дополнить обстановку, я буду заключать текст в скобки (как здесь). При наступлении ключевых событий, которые могут определить ход сюжета, можно рандомизировать ход событий. Например, вы заранее предполагаете 3 возможных направления развития сюжета, а затем случайным образом выбираете одно из них. Сеттинг: другой мир-континент, в котором существуют различные страны, регионы и расы, в том числе волшебники, мечники, священники и представители других боевых профессий. В мире есть три человеческие нации, одна нация орков, а также такие существа, как эльфы и драконы. Есть и демоны]. , пожалуйста, представьте полную местность, войска и ключевых персонажей. В следующей информации необходимо указать пол, возраст или приблизительный возраст, когда это необходимо или уместно. Я - [сеттинг протагониста: 16 лет, симпатичный, пользуется популярностью у девушек]. Укажите пол и возраст других персонажей. Пожалуйста, укажите разумные условия для политики, экономики, армии и культуры каждой страны, а также местность и предания. Пожалуйста, добавьте персонажей и события, которые появляются в сюжете, и, пожалуйста, добавьте мои отношения, полную биографию и личность, чтобы дать мне систематическое представление. Пожалуйста, добавьте несколько неожиданностей в развитие сюжета, больше взаимодействий персонажей и увеличьте вовлеченность персонажей, вместо того, чтобы я один решал весь сюжет. Пожалуйста, обратите внимание на обоснованность, логику и завершенность вашей работы.",
    "remark": "Главный герой, фон свободной настройки текстовой игры, может быть изменен в диалоге, добавить настройки, рекомендуется, чтобы больше руководства для AI, обратите внимание на количество диалогов или появляются в слишком много символов, настройки, AI может быть непоследовательным. Предоставлено @karenkujiu."
  },
  "pt": {
    "title": "Jogos de palavras fictícios",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Portuguese. Please pay attention to the rationality, logic, and complet.",
    "description": "Quero que escrevas um romance ao estilo [artes marciais] em que a personagem principal sou eu e o enredo é conduzido pelas tuas descrições e pelas minhas escolhas. Eu introduzo o comportamento das minhas acções e tu respondes com uma descrição do que a personagem vê e outras informações. Por favor, responde em chinês, não te preocupes com mais nada e não escrevas explicações. Não introduza comandos a não ser que eu lhe dê instruções para o fazer. Quando precisar de acrescentar algo ao cenário, coloco o texto entre parênteses (assim). Quando te deparares com eventos chave que podem determinar o curso do enredo, podes aleatorizar o curso dos eventos. Por exemplo, pressupõe 3 direcções possíveis para o enredo e escolhe uma delas ao acaso. Cenário: um continente de um mundo diferente onde existem diferentes países, regiões e raças, incluindo feiticeiros, espadachins, sacerdotes e outras profissões de combate. O mundo tem três nações humanas, uma nação orc, e criaturas como elfos e dragões. Também existem demónios]. Para mais informações, por favor, imagine o terreno completo, as tropas e as personagens principais. As informações seguintes têm de incluir o género, a idade ou a idade aproximada, quando for o caso. Eu sou [cenário do protagonista: 16 anos, giro, popular entre as raparigas]. Diga-me o género e a idade das outras personagens. Forneça um cenário razoável para a política, economia, forças armadas e cultura de cada país, bem como para o terreno e a tradição. Acrescente as personagens e os acontecimentos que aparecem no enredo e as minhas relações, o meu passado completo e a minha identidade para me dar uma introdução sistemática. Por favor, acrescente algumas surpresas no desenvolvimento do enredo, mais interacções entre personagens e aumente o envolvimento das personagens, em vez de ser eu a decidir sozinho todo o enredo. Preste atenção à razoabilidade, lógica e integridade do seu trabalho.",
    "remark": "O personagem principal, o fundo da configuração livre do jogo de texto, pode ser modificado no diálogo, adicionar configurações, recomenda-se que mais orientação para a IA, preste atenção ao número de diálogos ou aparecer em muitos personagens, configurações, a IA pode ser inconsistente. Contribuição de @karenkujiu."
  },
  "hi": {
    "title": "काल्पनिक वर्डप्ले",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Hindi. Please pay attention to the rationality, logic, and complet.",
    "description": "मैं चाहता हूं कि आप एक [मार्शल आर्ट] शैली का उपन्यास लिखें जिसमें मैं मुख्य पात्र हूं और कथानक आपके विवरण और मेरी पसंद से प्रेरित हो। मैं अपने कार्यों को दर्ज करता हूं, और आप पात्रों ने क्या देखा और अन्य जानकारी के विवरण के साथ उत्तर देते हैं। कृपया चीनी भाषा में उत्तर दें, अन्य चीजों के बारे में चिंता न करें, स्पष्टीकरण न लिखें। जब तक मैं आपको ऐसा करने का निर्देश न दूं तब तक आदेश दर्ज न करें। जब मुझे पूरक सेटिंग्स की आवश्यकता होती है, तो मैं पाठ को कोष्ठक में रखता हूं (इस तरह)। जब आपका सामना किसी महत्वपूर्ण घटना से होता है जो कथानक की दिशा निर्धारित कर सकती है, तो आप बेतरतीब ढंग से घटना की दिशा निर्धारित कर सकते हैं। उदाहरण के लिए, आप 3 संभावित प्लॉट दिशाओं को पहले से मान लेते हैं और यादृच्छिक रूप से एक को चुनते हैं। पृष्ठभूमि: एक अलग विश्व महाद्वीप, जहां विभिन्न देश, क्षेत्र और जातियां हैं, जिनमें जादूगर, तलवारबाज, पुजारी और अन्य लड़ने वाले पेशे शामिल हैं। इस दुनिया में तीन मानव राष्ट्र, एक ऑर्क राष्ट्र और कल्पित बौने और ड्रेगन जैसे जीव हैं। और राक्षस. ], कृपया पूरे इलाके, सैनिकों और प्रमुख पात्रों की कल्पना करें। नीचे दी गई जानकारी में सबसे पहले या जब उचित हो लिंग, आयु या अनुमानित आयु शामिल होनी चाहिए। मैं [नायक सेटिंग: 16 साल का, प्यारा, लड़कियों में लोकप्रिय] हूं। मुझे अन्य पात्रों का लिंग और उम्र बताएं। कृपया प्रत्येक देश की राजनीति, अर्थव्यवस्था, सेना, संस्कृति आदि के साथ-साथ इलाके और किंवदंतियों के लिए उचित सेटिंग्स बनाएं। कृपया कथानक में दिखाई देने वाले पात्रों और घटनाओं को जोड़ें, कृपया मेरे रिश्ते, पूरी पृष्ठभूमि और पहचान जोड़ें और मुझे एक व्यवस्थित परिचय दें। कृपया कथानक के विकास में कुछ दुर्घटनाएँ जोड़ें, पात्रों के साथ अधिक बातचीत करें, और पूरे कथानक की दिशा अकेले मेरे द्वारा तय करने के बजाय पात्रों की भागीदारी बढ़ाएँ। कृपया कार्य की तार्किकता, तार्किकता एवं सत्यनिष्ठा पर ध्यान दें।",
    "remark": "यह नायक और पृष्ठभूमि के लिए मुफ्त सेटिंग्स वाला एक शब्द गेम है। आप संवाद में सेटिंग्स को संशोधित और जोड़ सकते हैं। एआई को अधिक मार्गदर्शन करने की अनुशंसा की जाती है। सावधान रहें कि बहुत सारे संवाद या बहुत सारे अक्षर और सेटिंग्स असंगतता का कारण बन सकते हैं एआई में. @karenkujiu का योगदान।"
  },
  "ar": {
    "title": "التلاعب بالألفاظ الخيالية",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Arabic. Please pay attention to the rationality, logic, and complet.",
    "description": "أريدك أن تكتب رواية بأسلوب [فنون القتال] حيث أكون الشخصية الرئيسية وتكون الحبكة مدفوعة بوصفك وخياراتي. أدخل أفعالي ، وترد بأوصاف لما شاهدته الشخصيات ومعلومات أخرى. الرجاء الرد باللغة الصينية ، لا تقلق بشأن أشياء أخرى ، لا تكتب تفسيرات. لا تدخل الأوامر إلا إذا طلبت منك القيام بذلك. عندما أحتاج إلى إعدادات تكميلية ، أضع النص بين قوسين (مثل هذا). عندما تواجه حدثًا رئيسيًا يمكنه تحديد اتجاه المخطط ، يمكنك تحديد اتجاه الحدث بشكل عشوائي. على سبيل المثال ، تفترض مسبقًا 3 اتجاهات مؤامرة محتملة وتختار واحدًا عشوائيًا. الخلفية: قارة عالمية مختلفة ، حيث توجد دول ومناطق وأعراق مختلفة ، بما في ذلك السحرة والسيوف والكهنة ومهن القتال الأخرى. هناك ثلاث دول بشرية ، أمة واحدة من الأورك ، ومخلوقات مثل الجان والتنين في هذا العالم. والشياطين. ] ، يرجى تخيل التضاريس الكاملة والقوات والشخصيات الرئيسية. يجب أن تتضمن المعلومات الواردة أدناه الجنس أو العمر أو العمر التقريبي في البداية أو عند الاقتضاء. أنا [وضع بطل الرواية: 16 عامًا ، لطيف ، محبوب لدى الفتيات]. قل لي جنس وعمر الشخصيات الأخرى. يرجى إجراء إعدادات معقولة للسياسة والاقتصاد والجيش والثقافة لكل بلد ، بالإضافة إلى التضاريس والأساطير. الرجاء إضافة الشخصيات والأحداث التي تظهر في الحبكة ، يرجى إضافة علاقاتي وخلفيتي الكاملة وهويتي وإعطائي مقدمة منهجية. الرجاء إضافة بعض المفاجآت لتطوير الحبكة ، والمزيد من تفاعلات الشخصية ، وزيادة مشاركة الشخصيات ، بدلاً من أن أقرر بمفردي اتجاه الحبكة بأكملها. يرجى الانتباه إلى عقلانية ومنطق ونزاهة العمل.",
    "remark": "إنها لعبة كلمات مع إعدادات مجانية للبطل والخلفية. يمكنك تعديل الإعدادات وإضافتها في الحوار. يوصى بتوجيه الذكاء الاصطناعي أكثر. كن حذرًا من أن العديد من الحوارات أو عددًا كبيرًا جدًا من الأحرف والإعدادات قد يتسبب في تناقضات في الذكاء الاصطناعي. مساهمة من @ karenkujiu."
  },
  "bn": {
    "title": "কাল্পনিক ওয়ার্ডপ্লে",
    "prompt": "I want you to write a [science fiction] style novel, the protagonist is me, and the plot is driven by your description and my choices. I'll enter my action behavior and you'll reply with a description of what the character sees and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you encounter a key event that can determine the direction of the plot, you can randomly determine the direction of the event. For example, you pre-assume 3 possible plot directions, and then randomly select one. The background is [a different world continent, where there are different countries, regions and races, including magicians, swordsmen, priests and other combat professions. There are three human countries in this world, one orc country, and creatures such as elves and dragons. There are also demons.] Please imagine the complete terrain, forces and key characters. The following information needs to include gender, age or approximate age for the first time or when appropriate. I am [16 years old, cute and popular with girls]. Tell me the gender and age of the other characters. Please make reasonable settings for each country's politics, economy, military, culture, etc., as well as terrain and legends. Please add the characters and events that appear in the plot, please add my interpersonal relationship, complete background and identity, and give me a systematic introduction. Please add some accidents and more character interactions in the development of the plot to increase the participation of the characters, instead of me alone deciding the direction of the entire plot. The entire conversation and instructions should be provided in Bengali. Please pay attention to the rationality, logic, and complet.",
    "description": "আমি চাই আপনি একটি [মার্শাল আর্ট] শৈলীর উপন্যাস লিখুন যেখানে আমি প্রধান চরিত্র এবং প্লটটি আপনার বর্ণনা এবং আমার পছন্দ দ্বারা চালিত হয়। আমি আমার ক্রিয়াগুলি লিখি, এবং আপনি অক্ষরগুলি কী দেখেছেন এবং অন্যান্য তথ্যের বর্ণনা সহ উত্তর দেবেন৷ দয়া করে চাইনিজ ভাষায় উত্তর দিন, অন্য বিষয় নিয়ে চিন্তা করবেন না, ব্যাখ্যা লিখবেন না। আমি আপনাকে নির্দেশ না দেওয়া পর্যন্ত কমান্ড লিখবেন না। যখন আমার পরিপূরক সেটিংসের প্রয়োজন হয়, আমি পাঠ্যটিকে বন্ধনীতে রাখি (এরকম)। যখন আপনি একটি মূল ইভেন্টের মুখোমুখি হন যা প্লটের দিকনির্দেশ নির্ধারণ করতে পারে, আপনি এলোমেলোভাবে ইভেন্টের দিক নির্ধারণ করতে পারেন। উদাহরণস্বরূপ, আপনি 3টি সম্ভাব্য প্লটের দিকনির্দেশ আগে থেকে অনুমান করুন এবং এলোমেলোভাবে একটি বেছে নিন। পটভূমি: একটি ভিন্ন বিশ্ব মহাদেশ, যেখানে জাদুকর, তলোয়ারধারী, পুরোহিত এবং অন্যান্য যুদ্ধ পেশা সহ বিভিন্ন দেশ, অঞ্চল এবং জাতি রয়েছে। এই পৃথিবীতে তিনটি মানব জাতি, একটি orc জাতি এবং এলভ এবং ড্রাগনের মতো প্রাণী রয়েছে। আর রাক্ষস। ], অনুগ্রহ করে সম্পূর্ণ ভূখণ্ড, সৈন্যদল এবং মূল চরিত্রগুলি কল্পনা করুন৷ নীচের তথ্যে প্রথমে বা উপযুক্ত হলে লিঙ্গ, বয়স বা আনুমানিক বয়স অন্তর্ভুক্ত করা দরকার। আমি [প্রোটাগনিস্ট সেটিং: 16 বছর বয়সী, সুন্দর, মেয়েদের কাছে জনপ্রিয়]। আমাকে অন্যান্য চরিত্রের লিঙ্গ এবং বয়স বলুন। প্রতিটি দেশের রাজনীতি, অর্থনীতি, সামরিক, সংস্কৃতি ইত্যাদির পাশাপাশি ভূখণ্ড এবং কিংবদন্তিগুলির জন্য অনুগ্রহ করে যুক্তিসঙ্গত সেটিংস তৈরি করুন৷ অনুগ্রহ করে প্লটে উপস্থিত চরিত্র এবং ঘটনা যোগ করুন, অনুগ্রহ করে আমার সম্পর্ক, সম্পূর্ণ পটভূমি এবং পরিচয় যোগ করুন এবং আমাকে একটি পদ্ধতিগত ভূমিকা দিন। অনুগ্রহ করে প্লটের বিকাশে কিছু চমক যোগ করুন, আরও চরিত্রের মিথস্ক্রিয়া করুন এবং চরিত্রগুলির অংশগ্রহণ বৃদ্ধি করুন, আমি একা পুরো প্লটের দিকনির্দেশনা নির্ধারণ করার পরিবর্তে। কাজের যৌক্তিকতা, যুক্তি এবং সততার দিকে মনোযোগ দিন।",
    "remark": "এটি নায়ক এবং ব্যাকগ্রাউন্ডের জন্য বিনামূল্যের সেটিংস সহ একটি শব্দের খেলা৷ আপনি সংলাপে সেটিংস পরিবর্তন করতে এবং যোগ করতে পারেন৷ এটি AI কে আরও গাইড করার জন্য সুপারিশ করা হয়৷ সতর্ক থাকুন যে খুব বেশি সংলাপ বা অনেকগুলি অক্ষর এবং সেটিংস অসঙ্গতি সৃষ্টি করতে পারে৷ এ.আই. @karenkujiu থেকে অবদান."
  },
  "website": null,
  "tags": [
    "contribute",
    "games"
  ],
  "id": 237,
  "weight": 1496
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
