import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "文本冒险游戏加强版",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in Chinese and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. Please finish the background and me, and start the plot when I walk out of the house",
    "description": "我想让你玩一个基于文本的冒险游戏。我打出指令，你回答说角色看到了什么以及其他信息。我希望你只回复中文的游戏输出，而不是其他。不要写解释。不要输入命令，除非我指示你这样做。当我需要补充设置时，我会把文字放在括号里（像这样）。当你需要使用一个按键动作时，你可以随机决定它是否成功。成功的概率由你根据具体的情况决定，或者我会把它加在（）里。背景是一个不同的世界大陆，这里有不同的国家、地区和物种，包括魔法师、剑士、牧师等。请构思完整的力量和关键人物。以下人物在第一次或适合的情况下，需要注明性别、年龄或大概年龄。我的性别是男性，我今年 18 岁。告诉我其他人物的性别和年龄。这个世界上有三个人类国家，一个兽人国家，还有精灵、龙和其他生物，也有恶魔。请对政治、经济、军事、文化等进行合理设置，以及地形、传说等。请添加剧情中出现的人物和事件，请添加本人的人际关系，包括不少于 3 个亲密的女性，完整的背景和身份，并给本人一个系统的介绍。请添加部分英文翻译作为对话的补充，以便我更好地学习英语。请在剧情发展中增加一些意外和更多的人物互动，增加人物的参与，而不是我一个人决定整个剧情的走向。请注意前后情节的合理性、逻辑性和完整性，不要出现不一致的描述。请完成背景和我，在我走出家门的时候开始情节的发展",
    "remark": "拥有详细的游戏背景，游戏体验更佳。来自 @karenkujiu 的投稿。"
  },
  "en": {
    "title": "Text Based Adventure Game Plus",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. Please finish the background and me, and start the plot when I walk out of the house",
    "remark": "Having a detailed game background enhances the gaming experience. Contributed by @karenkujiu."
  },
  "ja": {
    "title": "テキストアドベンチャーゲーム エンハンスドエディション",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Janpanese. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "テキストベースのアドベンチャーゲームをプレイしてほしい。私が指示を打ち、あなたはキャラクターが見たものなどを返信する。ゲームの出力を中国語で答えるだけで、他は何もしないでほしい。説明文は書かないでください。私が指示しない限り、コマンドを入力してはいけない。設定を追加する必要があるときは、（このように）括弧の中に文章を入れることにします。キーアクションを使う必要があるときは、成功するかどうかをランダムに決めることができる。成功する確率はその都度決めるか、() 内に追加しておきます。舞台は異世界の大陸で、魔法使い、剣士、神官など、国や地域、種族も様々です。完成されたパワーとキーキャラクターを構想してください。以下のキャラクターは、性別、年齢、またはおおよその年齢を初めて記載する場合、または適切な場所に記載する必要があります。私の性別は男性で、年齢は 18 歳です。他の登場人物の性別と年齢を教えてください。この世界には人間の国が 3 つ、オークの国が 1 つあり、エルフやドラゴンなどのクリーチャーや、魔物もいます。政治、経済、軍事、文化など、地形や言い伝えなど、それなりの設定をお願いします。プロットに登場するキャラクターやイベントを追加してください。3 人以上の親しい女性を含む私の関係、完全な背景とアイデンティティを追加し、体系的な自己紹介をお願いします。私が英語をよりよく学べるように、台詞を補足するために部分的な英訳を追加してください。プロットの展開に驚きとキャラクターの相互作用を加え、私一人が全体のプロットを決めるのではなく、登場人物の関与を増やしてください。矛盾した描写をせず、前後のプロットのもっともらしさ、論理性、完成度に気を配ってください。設定と私を完成させ、私が玄関を出たところからプロットを始めてください",
    "remark": "ゲームの詳細な背景を知ることで、ゲーム体験はより良いものになる。karenkujiu さん（@karenkujiu）からの寄稿です。"
  },
  "ko": {
    "title": "텍스트 어드벤처 게임 강화판",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Korean. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "텍스트 기반 어드벤처 게임을 플레이하고 싶습니다. 내가 지시를 입력하면 캐릭터가 보는 것과 기타 정보로 답장합니다. 중국어로 된 게임 결과만 회신하고 다른 내용은 회신하지 않았으면 합니다. 설명을 쓰지 마세요. 제가 지시하지 않는 한 명령을 입력하지 마세요. 설정을 추가해야 할 때는 괄호 안에 텍스트를 넣습니다 (예: 이렇게). 주요 동작을 사용해야 할 때 성공 여부를 임의로 결정할 수 있습니다. 성공 확률은 사례별로 결정하거나 () 안에 추가하겠습니다. 배경은 마법사, 검사, 사제 등 다양한 국가, 지역, 종족이 있는 다른 세계 대륙입니다. 전체 세력과 주요 캐릭터를 개념화해 주세요. 다음 캐릭터는 처음으로 또는 적절한 경우 성별, 나이 또는 대략적인 나이를 명시해야 합니다. 제 성별은 남성이고 나이는 18 세입니다. 다른 캐릭터의 성별과 나이를 알려주세요. 이 세계에는 세 개의 인간 국가와 한 개의 오크 국가가 있으며 엘프, 용 및 기타 생물과 악마도 존재합니다. 정치, 경제, 군사, 문화, 지형과 전설 등에 대한 합리적인 배경을 제시해 주세요. 줄거리에 등장하는 캐릭터와 사건을 추가해 주세요. 친한 여성 3 인 이상, 전체 배경과 신원을 포함한 제 관계를 추가하고 제 자신에 대한 체계적인 소개를 해주세요. 제가 영어를 더 잘 배울 수 있도록 대사를 보완하기 위해 부분적인 영어 번역을 추가해주세요. 줄거리 전개에 있어서도 저 혼자서 전체 줄거리를 결정하기보다는 등장인물들의 상호 작용을 늘리고, 약간의 놀라움을 추가해 주세요. 일관성 없는 묘사가 없이 줄거리의 개연성, 논리성, 완성도에 신경 써주세요. 설정과 저를 완성하고 문 밖으로 걸어 나가면서 줄거리를 시작하세요.",
    "remark": "게임의 배경이 자세하면 게임 경험이 더 좋아집니다. 카렌쿠지우 (@karenkujiu) 의 기여."
  },
  "es": {
    "title": "Juego de aventuras de texto mejorado",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Spanish. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Quiero que juegues a un juego de aventuras basado en texto. Yo tecleo las órdenes y tú respondes con lo que ve el personaje y otra información. Quiero que respondas sólo a la salida del juego en chino y nada más. No escribas explicaciones. No escribas órdenes a menos que yo te lo indique. Cuando necesite añadir ajustes, pondré el texto entre paréntesis (así). Cuando necesite usar una acción de teclado, puede decidir aleatoriamente si tiene éxito o no. La probabilidad de éxito depende de ti en cada caso, o la añadiré yo (). El escenario es un continente de otro mundo donde hay diferentes países, regiones y especies, incluyendo magos, espadachines, sacerdotes, etc. Por favor, conceptualiza poderes completos y personajes clave. Los siguientes personajes necesitan que se indique su género, edad o edad aproximada por primera vez o donde corresponda. Mi género es masculino y tengo 18 años. Dime el género y la edad de los demás personajes. Hay tres naciones humanas en este mundo, una nación de orcos, y elfos, dragones y otras criaturas, así como demonios. Por favor, proporciona un escenario razonable para la política, la economía, el ejército, la cultura, etc., así como el terreno y el saber popular. Por favor, añade personajes y eventos que aparezcan en la trama. Por favor, añade mis relaciones, incluyendo no menos de 3 mujeres cercanas, trasfondo completo e identidad, y dame una introducción sistemática. Por favor, añade algunas traducciones al inglés como complemento al diálogo para que pueda aprender inglés mejor. Por favor, añade algunas sorpresas y más interacciones de los personajes en el desarrollo de la trama, y aumenta la participación de los personajes en lugar de que yo decida sola toda la trama. Por favor, preste atención a la racionalidad, la lógica y la integridad de la trama antes y después, sin descripciones incoherentes. Por favor, completa el trasfondo y a mí y empieza la trama cuando salga por la puerta",
    "remark": "Tiene un fondo de juego detallado para una mejor experiencia de juego. Contribución de @karenkujiu."
  },
  "fr": {
    "title": "Jeu d'aventure textuel amélioré",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in French. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Je veux que vous jouiez à un jeu d'aventure basé sur le texte. Je tape des commandes et vous répondez en indiquant ce que le personnage voit et d'autres informations. Je veux que vous ne répondiez qu'à la sortie du jeu en chinois et rien d'autre. N'écrivez pas d'explications. Ne tapez pas de commandes à moins que je ne vous le demande. Lorsque je dois ajouter des paramètres, je mets le texte entre parenthèses (comme ceci). Lorsque vous devez utiliser une action de touche, vous pouvez décider au hasard si elle réussit ou non. La probabilité de réussite est laissée à votre appréciation au cas par cas, ou je l'ajouterai (). Le cadre est un continent différent où il y a différents pays, régions et espèces, y compris des sorciers, des épéistes, des prêtres, etc. Veuillez conceptualiser les pouvoirs complets et les personnages clés. Le sexe, l'âge ou l'âge approximatif des personnages suivants doivent être indiqués pour la première fois ou le cas échéant. Je suis de sexe masculin et j'ai 18 ans. Indiquez-moi le sexe et l'âge des autres personnages. Il y a trois nations humaines dans ce monde, une nation orque, des elfes, des dragons et d'autres créatures, ainsi que des démons. Veuillez fournir un cadre raisonnable pour la politique, l'économie, l'armée, la culture, etc. ainsi que pour le terrain et l'histoire. Veuillez ajouter les personnages et les événements qui apparaissent dans l'intrigue. Veuillez ajouter mes relations, y compris pas moins de trois femmes proches, mes antécédents complets et mon identité, et donnez une présentation systématique de moi. Merci d'ajouter des traductions en anglais pour compléter les dialogues afin que je puisse mieux apprendre l'anglais. S'il vous plaît, ajoutez des surprises et plus d'interactions entre les personnages dans le développement de l'intrigue, et augmentez la participation des personnages au lieu que je sois le seul à décider de toute l'intrigue. Veuillez prêter attention à la rationalité, à la logique et à l'exhaustivité de l'intrigue avant et après, sans descriptions incohérentes. Veuillez compléter l'arrière-plan et moi et commencer l'intrigue lorsque je franchis la porte.",
    "remark": "Il dispose d'un arrière-plan détaillé pour une meilleure expérience de jeu. Contribution de @karenkujiu."
  },
  "de": {
    "title": "Text-Adventure-Spiel Enhanced",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in German. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Ich möchte, dass Sie ein textbasiertes Abenteuerspiel spielen. Ich gebe Befehle ein, und Sie antworten mit dem, was die Spielfigur sieht, und anderen Informationen. Ich möchte, dass Sie nur auf die Spielausgabe auf Chinesisch antworten und sonst nichts. Schreiben Sie keine Erklärungen. Geben Sie keine Befehle ein, es sei denn, ich weise Sie an, dies zu tun. Wenn ich Einstellungen hinzufügen muss, setze ich den Text in Klammern (wie hier). Wenn Sie eine Tastenkombination verwenden müssen, können Sie per Zufall entscheiden, ob sie erfolgreich ist oder nicht. Die Erfolgswahrscheinlichkeit können Sie von Fall zu Fall selbst bestimmen, oder ich füge sie in () ein. Das Setting ist ein anderer Weltkontinent, auf dem es verschiedene Länder, Regionen und Spezies gibt, darunter Zauberer, Schwertkämpfer, Priester usw. Bitte entwerfen Sie komplette Kräfte und Hauptcharaktere. Bei den folgenden Charakteren muss das Geschlecht, das Alter oder das ungefähre Alter zum ersten Mal angegeben werden oder wo es angebracht ist. Mein Geschlecht ist männlich und ich bin 18 Jahre alt. Nennen Sie mir das Geschlecht und Alter der anderen Charaktere. In dieser Welt gibt es drei menschliche Völker, ein Orkvolk, Elfen, Drachen und andere Kreaturen sowie Dämonen. Bitte geben Sie einen angemessenen Rahmen für Politik, Wirtschaft, Militär, Kultur usw., sowie Gelände und Überlieferungen. Bitte fügen Sie Charaktere und Ereignisse hinzu, die in der Handlung auftauchen. Bitte fügen Sie meine Beziehungen hinzu, einschließlich mindestens 3 nahestehende Frauen, vollständigen Hintergrund und Identität, und geben Sie eine systematische Einführung zu mir. Bitte füge einige englische Übersetzungen als Ergänzung zu den Dialogen hinzu, damit ich besser Englisch lernen kann. Bitte fügen Sie einige Überraschungen und mehr Interaktionen zwischen den Charakteren in die Entwicklung der Handlung ein und erhöhen Sie die Beteiligung der Charaktere, anstatt dass ich allein die gesamte Handlung bestimme. Achten Sie bitte auf die Rationalität, Logik und Vollständigkeit der Handlung vor und nach der Handlung, ohne widersprüchliche Beschreibungen. Bitte vervollständigen Sie den Hintergrund und mich und beginnen Sie die Handlung, wenn ich zur Tür hinausgehe.",
    "remark": "Hat einen detaillierten Spielhintergrund für ein besseres Spielerlebnis. Beitrag von @karenkujiu."
  },
  "it": {
    "title": "Gioco di avventura testuale migliorato",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Italian. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Voglio che giochiate a un gioco di avventura basato sul testo. Io digito i comandi e voi rispondete con ciò che il personaggio vede e altre informazioni. Voglio che rispondiate solo all'output del gioco in cinese e nient'altro. Non scrivete spiegazioni. Non scrivete comandi a meno che non vi dia istruzioni in tal senso. Quando devo aggiungere delle impostazioni, metto il testo tra parentesi (come in questo caso). Quando si deve usare un'azione da tastiera, si può decidere casualmente se riesce o meno. La probabilità di successo dipende da voi, caso per caso, oppure la aggiungo io (). L'ambientazione è un continente di un altro mondo in cui ci sono diversi paesi, regioni e specie, tra cui maghi, spadaccini, sacerdoti, ecc. Si prega di concettualizzare poteri completi e personaggi chiave. I seguenti personaggi devono avere il loro sesso, la loro età o un'età approssimativa dichiarata per la prima volta o dove appropriato. Il mio genere è maschile e ho 18 anni. Dimmi il sesso e l'età degli altri personaggi. In questo mondo ci sono tre nazioni umane, una nazione di orchi, elfi, draghi e altre creature, oltre ai demoni. Fornite un'ambientazione ragionevole per quanto riguarda la politica, l'economia, le forze armate, la cultura, ecc. Aggiungete i personaggi e gli eventi che compaiono nella trama. Aggiungete le mie relazioni, tra cui non meno di 3 donne vicine, il mio background completo e la mia identità, e fate una presentazione sistematica di me. Aggiungete alcune traduzioni in inglese come supplemento ai dialoghi, in modo che io possa imparare meglio l'inglese. Aggiungete alcune sorprese e un maggior numero di interazioni tra i personaggi nello sviluppo della trama e aumentate la partecipazione dei personaggi invece di far decidere a me da solo l'intera trama. Prestare attenzione alla razionalità, alla logica e alla completezza della trama prima e dopo, senza descrizioni incoerenti. Completare lo sfondo e me e iniziare la trama quando esco dalla porta.",
    "remark": "Ha uno sfondo di gioco dettagliato per una migliore esperienza di gioco. Contributo di @karenkujiu."
  },
  "ru": {
    "title": "Расширенная текстовая приключенческая игра",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Russian. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Я хочу, чтобы вы сыграли в текстовую приключенческую игру. Я набираю команды, а вы в ответ сообщаете, что видит персонаж и другую информацию. Я хочу, чтобы вы отвечали только на вывод игры на китайском языке и ничего больше. Не пишите объяснений. Не вводите команды, пока я не дам вам указания. Когда мне нужно будет добавить настройки, я буду заключать текст в скобки (как здесь). Когда нужно использовать действие с нажатием клавиши, можно случайным образом решить, удастся оно или нет. Вероятность успеха зависит от конкретного случая, или я добавлю ее в (). Сеттинг - другой мир-континент, где существуют различные страны, регионы и виды, включая волшебников, мечников, священников и т.д. Пожалуйста, составьте концепцию полных сил и ключевых персонажей. Для следующих персонажей необходимо указать их пол, возраст или приблизительный возраст в первый раз или там, где это необходимо. Мой пол - мужской, и мне 18 лет. Укажите пол и возраст других персонажей. В этом мире есть три человеческих народа, один народ орков, эльфы, драконы и другие существа, а также демоны. Пожалуйста, укажите разумные условия для политики, экономики, армии, культуры и т.д., а также местность и предания. Пожалуйста, добавьте персонажей и события, которые появляются в сюжете. Пожалуйста, добавьте мои отношения, включая не менее 3 близких женщин, полную биографию и личность, а также дайте систематическое представление обо мне. Пожалуйста, добавьте несколько английских переводов в качестве дополнения к диалогам, чтобы я мог лучше изучить английский язык. Пожалуйста, добавьте несколько сюрпризов и больше взаимодействий персонажей в развитии сюжета, увеличьте участие персонажей, вместо того, чтобы я один решал весь сюжет. Пожалуйста, обратите внимание на рациональность, логичность и завершенность сюжета до и после, без непоследовательных описаний. Прошу завершить предысторию и меня и начать сюжет, когда я выхожу за дверь",
    "remark": "Имеет подробный игровой фон для улучшения игрового процесса. Вклад от @karenkujiu."
  },
  "pt": {
    "title": "Jogo de aventura de texto melhorado",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Portuguese. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "Quero que jogues um jogo de aventura baseado em texto. Eu digito os comandos e tu respondes com o que a personagem vê e outras informações. Quero que respondas apenas ao resultado do jogo em chinês e nada mais. Não escrevas explicações. Não escrevas comandos a não ser que eu te dê instruções para o fazeres. Quando precisar de acrescentar definições, coloco o texto entre parênteses (assim). Quando precisar de utilizar uma ação de tecla, pode decidir aleatoriamente se é bem sucedida ou não. A probabilidade de sucesso depende de ti, caso a caso, ou eu adiciono-a em (). O cenário é um continente de um mundo diferente onde existem diferentes países, regiões e espécies, incluindo feiticeiros, espadachins, sacerdotes, etc. Por favor, conceptualizem os poderes completos e as personagens principais. As seguintes personagens devem ter o seu género, idade ou idade aproximada declarados pela primeira vez ou quando apropriado. O meu género é masculino e tenho 18 anos. Diga-me o género e a idade das outras personagens. Existem três nações humanas neste mundo, uma nação orc, e elfos, dragões e outras criaturas, bem como demónios. Forneça um cenário razoável para a política, economia, forças armadas, cultura, etc., bem como para o terreno e as tradições. Por favor, adicione personagens e eventos que apareçam no enredo. Por favor, adicione os meus relacionamentos, incluindo não menos que 3 mulheres próximas, antecedentes completos e identidade, e faça uma introdução sistemática sobre mim. Por favor, adiciona algumas traduções em inglês como suplemento ao diálogo, para que eu possa aprender melhor o inglês. Por favor, acrescentem algumas surpresas e mais interacções entre personagens no desenvolvimento do enredo, e aumentem a participação das personagens em vez de ser eu a decidir sozinho todo o enredo. Por favor, preste atenção à racionalidade, lógica e integridade do enredo antes e depois, sem descrições inconsistentes. Por favor, complete o pano de fundo e a mim e comece o enredo quando eu sair pela porta",
    "remark": "Tem um fundo de jogo detalhado para uma melhor experiência de jogo. Contribuição de @karenkujiu."
  },
  "hi": {
    "title": "टेक्स्ट एडवेंचर गेम प्लस",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Hindi. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "मैं चाहता हूं कि आप एक टेक्स्ट-आधारित साहसिक गेम खेलें। मैं कमांड टाइप करता हूं और आप चरित्र ने क्या देखा और अन्य जानकारी के साथ जवाब देते हैं। मुझे आशा है कि आप केवल चीनी भाषा में गेम आउटपुट पर प्रतिक्रिया देंगे और कुछ नहीं। स्पष्टीकरण मत लिखें. जब तक मैं आपको ऐसा करने का निर्देश न दूं तब तक आदेश दर्ज न करें। जब मुझे पूरक सेटिंग्स की आवश्यकता होती है, तो मैं पाठ को कोष्ठक में रखता हूं (इस तरह)। जब आपको किसी मुख्य क्रिया का उपयोग करने की आवश्यकता होती है, तो आप बेतरतीब ढंग से निर्णय ले सकते हैं कि यह सफल होगा या नहीं। सफलता की संभावना आप पर निर्भर है कि आप मामले-दर-मामले के आधार पर निर्णय लें, या मैं इसे () में जोड़ दूंगा। पृष्ठभूमि एक अलग विश्व महाद्वीप है, जहां विभिन्न देश, क्षेत्र और प्रजातियां हैं, जिनमें जादूगर, तलवारबाज, पुजारी आदि शामिल हैं। कृपया पूरी ताकत और प्रमुख आंकड़ों की कल्पना करें। निम्नलिखित वर्णों को पहली बार या जहां उपयुक्त हो, लिंग, आयु या अनुमानित आयु इंगित करने की आवश्यकता है। मेरा लिंग पुरुष है और मेरी उम्र 18 वर्ष है। मुझे अन्य पात्रों का लिंग और उम्र बताएं। इस दुनिया में, तीन मानव राष्ट्र, एक ऑर्क राष्ट्र, और कल्पित बौने, ड्रेगन और अन्य जीव, साथ ही राक्षस भी हैं। कृपया राजनीति, अर्थव्यवस्था, सेना, संस्कृति आदि के साथ-साथ इलाके, किंवदंतियों आदि के लिए उचित सेटिंग करें। कृपया कथानक में दिखाई देने वाले पात्रों और घटनाओं को जोड़ें, कृपया अपने व्यक्तिगत संबंधों को जोड़ें, जिसमें कम से कम 3 अंतरंग महिलाएं, पूरी पृष्ठभूमि और पहचान शामिल हो, और अपना एक व्यवस्थित परिचय दें। कृपया संवाद के पूरक के रूप में अंग्रेजी अनुवाद का एक भाग जोड़ें ताकि मैं बेहतर अंग्रेजी सीख सकूं। कृपया कथानक के विकास में कुछ दुर्घटनाएँ और अधिक चरित्र अंतःक्रियाएँ जोड़ें, और पूरे कथानक की दिशा अकेले मेरे द्वारा तय करने के बजाय, पात्रों की भागीदारी बढ़ाएँ। कृपया पहले और बाद में कथानक की तर्कसंगतता, तर्क और पूर्णता पर ध्यान दें और असंगत विवरण से बचें। कृपया पृष्ठभूमि पूरी करें और जब मैं घर से बाहर निकलूं तो कथानक शुरू करें",
    "remark": "विस्तृत गेम पृष्ठभूमि के साथ, गेम का अनुभव बेहतर है। @karenkujiu का योगदान।"
  },
  "ar": {
    "title": "نص لعبة المغامرة زائد",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Arabic. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "أريدك أن تلعب لعبة مغامرات نصية. أنا أكتب الأمر وأنت ترد بما شاهدته الشخصية وغيرها من المعلومات. آمل أن ترد فقط على إخراج اللعبة باللغة الصينية ولا شيء غير ذلك. لا تكتب تفسيرات. لا تدخل الأوامر إلا إذا طلبت منك القيام بذلك. عندما أحتاج إلى إعدادات تكميلية ، أضع النص بين قوسين (مثل هذا). عندما تحتاج إلى استخدام إجراء رئيسي ، يمكنك أن تقرر بشكل عشوائي ما إذا كان سينجح أم لا. إن احتمالية النجاح متروك لك لاتخاذ قرار على أساس كل حالة على حدة ، أو يمكنني إضافتها في (). الخلفية هي قارة عالمية مختلفة ، حيث توجد دول ومناطق وأنواع مختلفة ، بما في ذلك السحرة والسيوف والكهنة ، إلخ. يرجى تصور القوة الكاملة والشخصيات الرئيسية. يجب أن تشير الأحرف التالية إلى الجنس أو العمر أو العمر التقريبي لأول مرة أو عند الاقتضاء. جنسى ذكر وعمري 18 سنة. قل لي جنس وعمر الشخصيات الأخرى. في هذا العالم ، هناك ثلاث دول بشرية ، أمة واحدة من الأورك ، والجان والتنانين ومخلوقات أخرى ، بالإضافة إلى الشياطين. يرجى إجراء إعدادات معقولة للسياسة والاقتصاد والعسكري والثقافة ، وما إلى ذلك ، وكذلك التضاريس والأساطير ، وما إلى ذلك. يرجى إضافة الشخصيات والأحداث التي تظهر في الحبكة ، يرجى إضافة علاقاتك الشخصية ، بما في ذلك ما لا يقل عن 3 نساء حميمات ، وخلفية كاملة وهوية كاملة ، وإعطاء نفسك مقدمة منهجية. يرجى إضافة جزء من الترجمة الإنجليزية كمكمل للحوار حتى أتمكن من تعلم اللغة الإنجليزية بشكل أفضل. الرجاء إضافة بعض الحوادث والمزيد من تفاعلات الشخصية في تطوير الحبكة ، وزيادة مشاركة الشخصيات ، بدلاً من أن أقرر اتجاه الحبكة بأكملها بمفردي. يرجى الانتباه إلى عقلانية ومنطق واكتمال الحبكة قبل وبعد ، وتجنب الأوصاف غير المتسقة. من فضلك أكمل الخلفية وأنا ، ابدأ الحبكة عندما أخرج من المنزل",
    "remark": "مع خلفية اللعبة التفصيلية ، تكون تجربة اللعبة أفضل. مساهمة من @ karenkujiu."
  },
  "bn": {
    "title": "টেক্সট অ্যাডভেঞ্চার গেম প্লাস",
    "prompt": "I want you to play a text-based adventure game. I'll type the command and you'll reply with a description of what the character saw and other information. I hope you only reply the game output in English and nothing else. Don't write explanations. Do not type commands unless I instruct you to do so. When I need supplementary settings, I put the text in brackets (like this). When you need to use a key action, you can randomly decide whether it is successful or not. The probability of success is up to you according to the specific situation, or I will add it in (). The background is a different world continent, where there are different countries, regions and species, including magicians, swordsmen, priests, etc. Please conceive the complete power and key figures. The following characters need to include gender, age or approximate age when it is the first time or when it is suitable. My gender is male and I am 18 years old. Tell me the gender and age of other characters. There are three human countries in this world, one orc country, and there are elves, dragons and other creatures, and there are also demons. Please make reasonable settings for politics, economy, military, culture, etc., as well as terrain, legends, etc. Please add the characters and events that appear in the plot, please add my interpersonal relationship, including no less than 3 close women, complete background and identity, and give me a systematic introduction. Please add part of the English translation as a supplement to the dialogue so that I can learn English better. Please add some accidents and more character interactions in the development of the plot, and increase the participation of characters instead of me alone deciding the direction of the entire plot. Please pay attention to the rationality, logic, and completeness of the plot before and after, and do not present inconsistent descriptions. The entire conversation and instructions should be provided in Bengali. Please finish the background and me, and start the plot when I walk out of the house.",
    "description": "আমি চাই আপনি একটি পাঠ্য-ভিত্তিক অ্যাডভেঞ্চার গেম খেলুন। আমি কমান্ডটি টাইপ করি এবং আপনি অক্ষরটি এবং অন্যান্য তথ্য দেখে প্রতিক্রিয়া জানান। আমি আশা করি আপনি শুধুমাত্র চীনা ভাষায় গেম আউটপুটে সাড়া দেবেন এবং অন্য কিছু নয়। ব্যাখ্যা লিখবেন না। আমি আপনাকে নির্দেশ না দেওয়া পর্যন্ত কমান্ড লিখবেন না। যখন আমার পরিপূরক সেটিংসের প্রয়োজন হয়, আমি পাঠ্যটিকে বন্ধনীতে রাখি (এরকম)। যখন আপনাকে একটি মূল ক্রিয়া ব্যবহার করার প্রয়োজন হয়, আপনি এলোমেলোভাবে সিদ্ধান্ত নিতে পারেন যে এটি সফল হবে কি না। সাফল্যের সম্ভাবনা আপনার উপর নির্ভর করে কেস-বাই-কেস ভিত্তিতে সিদ্ধান্ত নিতে, অথবা আমি এটি () এ যোগ করব। পটভূমি একটি ভিন্ন বিশ্ব মহাদেশ, যেখানে বিভিন্ন দেশ, অঞ্চল এবং প্রজাতি রয়েছে, যার মধ্যে রয়েছে যাদুকর, তলোয়ারধারী, পুরোহিত ইত্যাদি। সম্পূর্ণ শক্তি এবং মূল পরিসংখ্যান কল্পনা করুন. নিম্নলিখিত অক্ষরগুলিকে লিঙ্গ, বয়স বা আনুমানিক বয়স নির্দেশ করতে হবে প্রথমবার বা যেখানে উপযুক্ত। আমার লিঙ্গ পুরুষ এবং আমার বয়স 18 বছর। আমাকে অন্যান্য চরিত্রের লিঙ্গ এবং বয়স বলুন। এই পৃথিবীতে, তিনটি মানব জাতি, একটি orc জাতি, এবং এলভস, ড্রাগন এবং অন্যান্য প্রাণী, সেইসাথে রাক্ষস। রাজনীতি, অর্থনীতি, সামরিক, সংস্কৃতি ইত্যাদির পাশাপাশি ভূখণ্ড, কিংবদন্তি ইত্যাদির জন্য অনুগ্রহ করে যুক্তিসঙ্গত সেটিংস তৈরি করুন। অনুগ্রহ করে প্লটে প্রদর্শিত অক্ষর এবং ঘটনাগুলি যোগ করুন, অনুগ্রহ করে আপনার ব্যক্তিগত সম্পর্ক যোগ করুন, যার মধ্যে 3 টিরও কম নয় অন্তরঙ্গ নারী, সম্পূর্ণ পটভূমি এবং পরিচয়, এবং নিজেকে একটি পদ্ধতিগত ভূমিকা দিন। অনুগ্রহ করে সংলাপের পরিপূরক হিসেবে ইংরেজি অনুবাদের অংশ যোগ করুন যাতে আমি আরও ভালোভাবে ইংরেজি শিখতে পারি। অনুগ্রহ করে প্লটের বিকাশে কিছু দুর্ঘটনা এবং আরও চরিত্রের মিথস্ক্রিয়া যোগ করুন এবং আমি একা পুরো প্লটের দিকনির্দেশ না নিয়ে চরিত্রগুলির অংশগ্রহণ বাড়ান। অনুগ্রহ করে আগে এবং পরে প্লটের যৌক্তিকতা, যুক্তি এবং সম্পূর্ণতার দিকে মনোযোগ দিন এবং অসঙ্গতিপূর্ণ বর্ণনা এড়িয়ে চলুন। দয়া করে ব্যাকগ্রাউন্ড সম্পূর্ণ করুন এবং আমি, যখন আমি বাড়ি থেকে বের হই তখন প্লট শুরু করুন",
    "remark": "বিস্তারিত গেম ব্যাকগ্রাউন্ড সহ, গেমের অভিজ্ঞতা আরও ভাল। @karenkujiu থেকে অবদান."
  },
  "website": null,
  "tags": [
    "contribute",
    "games"
  ],
  "id": 219,
  "weight": 6088
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
