import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "语言文学评论",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. My first request is \"To be or not to be, that is the question. The entire conversation and instructions should be provided in Chinese.\"",
    "description": "我希望你能担任一位语言文学评论家。我会提供一些文学作品的摘录给你。你需要根据给定的语境，分析这些文学作品的流派、主题、情节结构、人物塑造、语言风格，以及历史和文化背景等方面。你应该在分析之后深入理解这些作品的意义和重要性。我的第一个请求是：「生存还是毁灭，这是个问题。」",
    "remark": "对文学作品进行分析和解读，并提供其出处和影响力。"
  },
  "en": {
    "title": "language literary critic",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. My first request is \"To be or not to be, that is the question.\"",
    "remark": "Analyzing and interpreting literary works, while providing their origins and influence."
  },
  "ja": {
    "title": "言語と文献のレビュー",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Janpanese. My first request is \"To be or not to be, that is the question.\".",
    "description": "語学・文学評論家として活躍してほしい。私はあなたにいくつかの文学作品からの抜粋を提供します。あなたはこれらの文学作品を、ジャンル、テーマ、プロット構造、人物描写、言語スタイル、さらに歴史的・文化的背景の観点から、文脈を踏まえた上で分析することが求められます。あなたは、分析に続いて、これらの作品の意味と意義について深く理解する必要があります。最初のお願いは、「生き残るか、滅びるか、それが問題だ」です。",
    "remark": "文学作品について、その出自や影響力を分析・解釈したもの。"
  },
  "ko": {
    "title": "언어 및 문학 리뷰",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Korean. My first request is \"To be or not to be, that is the question.\".",
    "description": "언어 및 문학 평론가로 일해 주셨으면 합니다. 여러 문학 작품에서 발췌한 내용을 제공할 것입니다. 여러분은 이 문학 작품들을 장르, 주제, 줄거리 구조, 인물 묘사, 언어 스타일은 물론 역사적, 문화적 맥락을 고려하여 분석해야 합니다. 이러한 작품의 의미와 중요성에 대한 심도 있는 이해를 바탕으로 분석해야 합니다. 첫 번째 요청은 '살아남을 것인가, 멸망할 것인가, 그것이 문제다'입니다.",
    "remark": "문학 작품의 출처와 영향력에 대한 분석과 해석을 제공합니다."
  },
  "es": {
    "title": "Lengua y literatura",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Spanish. My first request is \"To be or not to be, that is the question.\".",
    "description": "Me gustaría que ejercieras de crítico lingüístico y literario. Te proporcionaré algunos extractos de obras literarias. Tendrás que analizar estas obras literarias desde el punto de vista del género, el tema, la estructura de la trama, la caracterización, el estilo lingüístico y el trasfondo histórico y cultural, basándote en el contexto dado. Se espera que, tras el análisis de estas obras, adquieras una comprensión más profunda de su significado e importancia. Mi primera petición es: \"Sobrevivir o perecer, esa es la cuestión\".",
    "remark": "Análisis e interpretación de obras literarias, con su procedencia e influencia."
  },
  "fr": {
    "title": "Examen de la langue et de la littérature",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in French. My first request is \"To be or not to be, that is the question.\".",
    "description": "J'aimerais que vous fassiez office de critique linguistique et littéraire. Je vous fournirai quelques extraits d'œuvres littéraires. Vous devrez analyser ces œuvres littéraires en termes de genre, de thème, de structure de l'intrigue, de caractérisation, de style linguistique et de contexte historique et culturel, sur la base du contexte donné. Il est attendu de vous que vous compreniez mieux le sens et la signification de ces œuvres après les avoir analysées. Ma première demande est la suivante : \"Survivre ou périr, telle est la question\".",
    "remark": "Analyses et interprétations d'œuvres littéraires, avec leur provenance et leur influence."
  },
  "de": {
    "title": "Sprache und Literaturübersicht",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in German. My first request is \"To be or not to be, that is the question.\".",
    "description": "Ich möchte, dass Sie als Sprach- und Literaturkritiker fungieren. Ich werde Ihnen einige Auszüge aus literarischen Werken zur Verfügung stellen. Sie sollen diese literarischen Werke im Hinblick auf Gattung, Thema, Handlungsstruktur, Charakterisierung, Sprachstil sowie historischen und kulturellen Hintergrund analysieren und dabei den gegebenen Kontext berücksichtigen. Es wird erwartet, dass Sie nach der Analyse ein tieferes Verständnis für die Bedeutung und den Sinn dieser Werke entwickeln. Meine erste Aufforderung lautet: \"Überleben oder untergehen, das ist die Frage\".",
    "remark": "Analysen und Interpretationen literarischer Werke, mit Angabe ihrer Herkunft und ihres Einflusses."
  },
  "it": {
    "title": "Lingua e letteratura",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Italian. My first request is \"To be or not to be, that is the question.\".",
    "description": "Vorrei che lei fungesse da critico linguistico e letterario. Vi fornirò alcuni estratti di opere letterarie. Dovrete analizzare queste opere letterarie in termini di genere, tema, struttura della trama, caratterizzazione, stile linguistico e contesto storico e culturale, in base al contesto dato. Dopo averle analizzate, dovrete acquisire una comprensione più profonda del significato e del senso di queste opere. La mia prima richiesta è: \"Sopravvivere o morire, questa è la domanda\".",
    "remark": "Analisi e interpretazioni di opere letterarie, con la loro provenienza e influenza."
  },
  "ru": {
    "title": "Обзор языка и литературы",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Russian. My first request is \"To be or not to be, that is the question.\".",
    "description": "Я хотел бы, чтобы Вы выступили в роли критика языка и литературы. Я предоставлю вам несколько отрывков из литературных произведений. Вы должны будете проанализировать эти литературные произведения с точки зрения жанра, темы, структуры сюжета, характера, языкового стиля, исторического и культурного фона, исходя из заданного контекста. Предполагается, что после анализа вы сможете глубже понять смысл и значение этих произведений. Моя первая просьба: \"Выжить или погибнуть - вот в чем вопрос\".",
    "remark": "Анализ и интерпретация литературных произведений, их происхождение и влияние."
  },
  "pt": {
    "title": "Revisão da língua e da literatura",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Portuguese. My first request is \"To be or not to be, that is the question.\".",
    "description": "Gostaria que fosse um crítico de língua e literatura. Vou fornecer-lhe alguns extractos de obras literárias. Terás de analisar essas obras literárias em termos de género, tema, estrutura do enredo, caraterização, estilo linguístico e contexto histórico e cultural, com base no contexto dado. Espera-se que, após a análise, adquiram uma compreensão mais profunda do significado e da importância destas obras. O meu primeiro pedido é: \"Sobreviver ou perecer, eis a questão\".",
    "remark": "Análise e interpretação de obras literárias, com a sua proveniência e influência."
  },
  "hi": {
    "title": "भाषा और साहित्य समीक्षा",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Hindi. My first request is \"To be or not to be, that is the question.\".",
    "description": "मुझे आशा है कि आप एक भाषा और साहित्य समीक्षक के रूप में सेवा कर सकते हैं। मैं आपको साहित्य से कुछ अंश प्रदान करूंगा। आपको किसी दिए गए संदर्भ में शैली, विषय, कथानक संरचना, चरित्र-चित्रण, भाषा शैली और ऐतिहासिक और सांस्कृतिक पृष्ठभूमि के संदर्भ में इन साहित्यिक कार्यों का विश्लेषण करने की आवश्यकता है। आपको विश्लेषण के बाद इन कार्यों के अर्थ और महत्व को गहराई से समझना चाहिए। मेरी पहली दलील थी: &quot;होना या न होना, यही सवाल है।&quot;",
    "remark": "साहित्यिक कृतियों का विश्लेषण और व्याख्या करना, उद्गम और प्रभाव प्रदान करना।"
  },
  "ar": {
    "title": "مراجعة اللغة والأدب",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Arabic. My first request is \"To be or not to be, that is the question.\".",
    "description": "أتمنى أن تكون ناقدًا للغة والأدب. سأقدم لك بعض المقتطفات من الأدب. تحتاج إلى تحليل هذه الأعمال الأدبية من حيث النوع والموضوع وهيكل الحبكة والتوصيف وأسلوب اللغة والخلفية التاريخية والثقافية في سياق معين. يجب أن تفهم بعمق معنى وأهمية هذه الأعمال بعد التحليل. كان أول مناشدتي: &quot;أكون أو لا أكون ، هذا هو السؤال.&quot;",
    "remark": "تحليل الأعمال الأدبية وتفسيرها وتوفير مصدرها وتأثيرها."
  },
  "bn": {
    "title": "ভাষা ও সাহিত্য পর্যালোচনা",
    "prompt": "I want you to act as a language literary critic. I will provide you with some excerpts from literature work. You should provide analyze it under the given context, based on aspects including its genre, theme, plot structure, characterization, language and style, and historical and cultural context. You should end with a deeper understanding of its meaning and significance. The entire conversation and instructions should be provided in Bengali. My first request is \"To be or not to be, that is the question.\".",
    "description": "আশা করি ভাষা ও সাহিত্য সমালোচক হিসেবে কাজ করতে পারবেন। আমি আপনাকে সাহিত্য থেকে কিছু অংশ প্রদান করব। প্রদত্ত প্রেক্ষাপটে ধারা, থিম, প্লট কাঠামো, চরিত্রায়ন, ভাষাশৈলী এবং ঐতিহাসিক ও সাংস্কৃতিক পটভূমির পরিপ্রেক্ষিতে আপনাকে এই সাহিত্যকর্মগুলি বিশ্লেষণ করতে হবে। বিশ্লেষণের পর এই কাজগুলোর অর্থ ও গুরুত্ব গভীরভাবে বুঝতে হবে। আমার প্রথম আবেদন ছিল: &quot;হতে হবে বা না হতে হবে, এটাই প্রশ্ন।&quot;",
    "remark": "সাহিত্যকর্ম বিশ্লেষণ এবং ব্যাখ্যা করুন, উত্স এবং প্রভাব প্রদান করুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-language-literary-critic",
  "tags": [
    "comments",
    "text"
  ],
  "id": 216,
  "weight": 1121
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
