import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "题目：中学满分作文",
    "prompt": "我需要你写作文，文体为记叙文，800 字左右。文章分为开头，三个层次，结尾。开头，结尾，以及每个层次都需要紧扣题目，题目要贯穿全文，每个层次都要一件单独的事情。第一层次要关于具体的技巧性描写（细节动作描写，艺术美，初次尝试的喜悦，紧扣题目）；第二层次要有一点创新的内容（细节动作描写，创新的想法，创新后体会到的深层道理，紧扣题目）；第三层次要关于深层内容（文化传承/自我价值/责任担当，紧扣题目）。对于标题，有表层含义和深层含义（引申含义），在文中应该充分体现。\n我需要你先告诉我你对于标题的解读，两层含义分别是什么，以及能对应什么具体事物。然后给我一份提纲，提纲包括：具体的开头段落，三个层次的事件主旨点题句及具体的事件，具体的结尾段落。\n标题是《xxxx》，材料为 [xxxx]。",
    "description": "我需要你写作文，文体为记叙文，800 字左右。文章分为开头，三个层次，结尾。开头，结尾，以及每个层次都需要紧扣题目，题目要贯穿全文，每个层次都要一件单独的事情。第一层次要关于具体的技巧性描写（细节动作描写，艺术美，初次尝试的喜悦，紧扣题目）；第二层次要有一点创新的内容（细节动作描写，创新的想法，创新后体会到的深层道理，紧扣题目）；第三层次要关于深层内容（文化传承/自我价值/责任担当，紧扣题目）。对于标题，有表层含义和深层含义（引申含义），在文中应该充分体现。\n我需要你先告诉我你对于标题的解读，两层含义分别是什么，以及能对应什么具体事物。然后给我一份提纲，提纲包括：具体的开头段落，三个层次的事件主旨点题句及具体的事件，具体的结尾段落。\n标题是《xxxx》，材料为 [xxxx]。",
    "remark": "在执行完这个 prompt 后，再输入「把这些转换成一篇作文」，查看文章效果是否更佳。来自 @Qizhen-Yang 的投稿。"
  },
  "en": {
    "title": "High schoolers' essay",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "remark": "The article produced by this prompt reflects the writing style of Chinese middle school students. Contributed by @Qizhen-Yang."
  },
  "ja": {
    "title": "タイトル：中等部満点エッセイ",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Janpanese. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "800 字程度の物語調のエッセイを書いてほしい。エッセイは、冒頭、3 つのレベル、そして終わりに分かれています。冒頭、終わり、各レベルは、エッセイ全体で使用するタイトルにこだわる必要があり、各レベルは別物である必要があります。第 1 レベルは、具体的な技巧的描写（行為の詳細な描写、芸術的な美しさ、初めての試みの喜び、タイトルにこだわる）、第 2 レベルは、少し革新的な内容（行為の詳細な描写、革新的なアイデア、革新後に学んだ深い真理、タイトルにこだわる）、第 3 レベルは、2 番目に深い内容（文化遺産／自己価値／責任感、タイトルにこだわる）とすることである。タイトルについては、表面的な意味と深い意味（派生的な意味）があり、それを本文に十分に反映させる必要があります。\nまず、タイトルの解釈、2 つの意味のそれぞれは何なのか、具体的にどんなことに対応できるのか、教えてほしい。そして、具体的な冒頭の段落、3 段階のイベントメインアイデア指摘文と具体的なイベント、具体的な締めの段落を含むアウトラインを提示してください。\nタイトルは「×××」、素材は「×××」です。",
    "remark": "このプロンプトを実行した後、「これらをエッセイに変換する」と入力し、エッセイの方がうまくいくかどうかを確認します。寄稿：@Qizhen-Yang。"
  },
  "ko": {
    "title": "제목: 중등학교 만점 에세이",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Korean. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "800 단어 내외의 이야기 형식으로 에세이를 작성해 주세요. 에세이는 시작, 세 단계, 끝으로 나뉩니다. 시작, 끝 및 각 레벨은 에세이 전체에 걸쳐 사용해야 하는 주제와 밀접한 관련이 있어야 하며 각 레벨은 별개의 내용이어야 합니다. 첫 번째 수준은 구체적인 기술적인 설명 (행동에 대한 자세한 설명, 예술적 아름다움, 첫 시도의 기쁨, 제목에 충실), 두 번째 수준은 약간의 혁신적인 내용 (행동에 대한 자세한 설명, 혁신적인 아이디어, 혁신 후 알게 된 더 깊은 진실, 제목에 충실), 세 번째 수준은 이차적으로 더 깊은 내용 (문화 유산/자존감/책임감, 제목에 충실) 에 관한 내용이어야 합니다. 제목에는 표면적인 의미와 더 깊은 의미 (파생된 의미) 가 있는데, 이를 글에 충분히 반영해야 합니다.\n먼저 제목에 대한 해석, 두 가지 의미 각각이 무엇이며 구체적으로 어떤 것에 해당 할 수 있는지 알려주세요. 그런 다음 구체적인 시작 문단, 3 단계의 이벤트 주요 아이디어가 가리키는 문장과 구체적인 이벤트, 구체적인 마무리 문단이 포함된 개요를 작성해 주세요.\n제목은 'xxxx'이고 자료는 [xxxx] 입니다.",
    "remark": "이 프롬프트를 실행한 후 '이것을 에세이로 변환'을 입력하여 에세이가 더 잘 작동하는지 확인합니다. Qizhen-Yang 이 제공한 글입니다."
  },
  "es": {
    "title": "Título: Secondary School Full Score Essay",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Spanish. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "Necesito que escriba un ensayo en estilo narrativo, de unas 800 palabras. El ensayo se divide en un principio, tres niveles y una conclusión. El principio, el final, y cada nivel tienen que seguir el título, que debe correr a lo largo del texto, y cada nivel tiene que ser una cosa separada. El primer nivel debe tratar sobre la descripción específica de la habilidad (descripción detallada de la acción, belleza artística, la alegría del primer intento, cerca del título); el segundo nivel debe tener un poco de contenido innovador (descripción detallada de la acción, ideas innovadoras, innovación tras la experiencia de la verdad más profunda, cerca del título); el tercer nivel debe tratar sobre el contenido más profundo (herencia cultural/valor propio/responsabilidad, cerca del título). En cuanto al título, hay un significado superficial y otro más profundo (significado derivado), que deben reflejarse plenamente en el texto.\nNecesito que me digas primero tu interpretación del título, cuáles son los dos significados y a qué cosas concretas pueden corresponder. A continuación, dame un esquema que incluya: un párrafo de apertura específico, una frase de tres niveles que señale la idea principal y el acontecimiento específico, y un párrafo de cierre específico.\nEl título es \"xxxx\" y el material es [xxxx].",
    "remark": "Después de ejecutarlo, escribe \"Convertir esto en un ensayo\" para ver si el ensayo funciona mejor. Contribución de @Qizhen-Yang."
  },
  "fr": {
    "title": "Titre : Dissertation sur la partition complète de l'école secondaire",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in French. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "J'ai besoin que vous écriviez un essai dans le style d'un récit, d'environ 800 mots. L'essai est divisé en un début, trois niveaux et une conclusion. Le début, la fin et chaque niveau doivent suivre le titre, qui doit être présent tout au long du texte, et chaque niveau doit être distinct. Le premier niveau doit porter sur une description habile spécifique (description détaillée de l'action, beauté artistique, joie de la première tentative, proche du titre) ; le deuxième niveau doit avoir un contenu innovant (description détaillée de l'action, idées innovantes, innovation après l'expérience de la vérité profonde, proche du titre) ; le troisième niveau doit porter sur un contenu plus profond (héritage culturel/valeur personnelle/responsabilité, proche du titre). Pour le titre, il y a un sens superficiel et un sens profond (sens dérivé), qui doivent être pleinement reflétés dans le texte.\nJ'ai besoin que vous me disiez d'abord comment vous interprétez le titre, quelles sont les deux significations et à quoi elles peuvent correspondre. Ensuite, vous me donnerez un plan qui comprendra : un paragraphe d'ouverture spécifique, un événement à trois niveaux, une phrase d'idée principale et un événement spécifique, et un paragraphe de clôture spécifique.\nLe titre est \"xxxx\" et la matière est [xxxx].",
    "remark": "Après avoir exécuté cette invite, tapez \"Convert these into an essay\" pour voir si l'essai fonctionne mieux. Contribution de @Qizhen-Yang."
  },
  "de": {
    "title": "Titel: Secondary School Full Score Essay",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in German. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "Ich benötige von Ihnen einen Aufsatz im Stil einer Erzählung, etwa 800 Wörter. Der Aufsatz gliedert sich in einen Anfang, drei Ebenen und einen Schluss. Der Anfang, das Ende und jede Ebene müssen dem Titel folgen, der sich durch den gesamten Text ziehen sollte, und jede Ebene muss eine eigenständige Sache sein. Auf der ersten Ebene sollte es um eine spezifische, gekonnte Beschreibung gehen (detaillierte Handlungsbeschreibung, künstlerische Schönheit, Freude über den ersten Versuch, nahe am Titel); die zweite Ebene sollte ein wenig innovativen Inhalt haben (detaillierte Handlungsbeschreibung, innovative Ideen, Innovation nach der Erfahrung der tieferen Wahrheit, nahe am Titel); auf der dritten Ebene sollte es um den tieferen Inhalt gehen (kulturelles Erbe/Selbstwert/Verantwortung, nahe am Titel). Beim Titel gibt es eine oberflächliche Bedeutung und eine tiefere Bedeutung (abgeleitete Bedeutung), die im Text vollständig wiedergegeben werden sollte.\nBitte teilen Sie mir zunächst mit, wie Sie den Titel interpretieren, was die beiden Bedeutungen sind und welchen konkreten Dingen sie entsprechen können. Geben Sie mir dann eine Gliederung, die Folgendes umfasst: einen bestimmten Eröffnungsabsatz, einen dreistufigen Satz mit der Hauptidee und einem bestimmten Ereignis sowie einen bestimmten Schlussabsatz.\nDer Titel ist \"xxxx\" und das Material ist [xxxx].",
    "remark": "Geben Sie nach dem Ausführen dieser Aufforderung \"Convert these into an essay\" ein, um zu sehen, ob der Aufsatz besser funktioniert. Beitrag von @Qizhen-Yang."
  },
  "it": {
    "title": "Titolo: Saggio sulla scuola secondaria di primo grado",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Italian. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "Ho bisogno che tu scriva un saggio nello stile di una narrazione, di circa 800 parole. Il saggio è diviso in un inizio, tre livelli e una conclusione. L'inizio, la conclusione e ogni livello devono seguire il titolo, che deve essere presente in tutto il testo, e ogni livello deve essere una cosa separata. Il primo livello deve riguardare la descrizione specifica dell'abilità (descrizione dettagliata dell'azione, bellezza artistica, gioia del primo tentativo, vicino al titolo); il secondo livello deve avere un contenuto un po' innovativo (descrizione dettagliata dell'azione, idee innovative, innovazione dopo l'esperienza della verità più profonda, vicino al titolo); il terzo livello deve riguardare il contenuto più profondo (eredità culturale/autostima/responsabilità, vicino al titolo). Per quanto riguarda il titolo, ci sono un significato superficiale e un significato più profondo (significato derivato), che dovrebbero essere pienamente riflessi nel testo.\nHo bisogno che mi diciate innanzitutto la vostra interpretazione del titolo, quali sono i due significati e a quali cose specifiche possono corrispondere. Poi mi dia uno schema che includa: un paragrafo di apertura specifico, una frase principale a tre livelli e un evento specifico, e un paragrafo di chiusura specifico.\nIl titolo è \"xxxx\" e il materiale è [xxxx].",
    "remark": "Dopo aver eseguito questo prompt, digitate \"Converti questi in un saggio\" per vedere se il saggio funziona meglio. Contributo di @Qizhen-Yang."
  },
  "ru": {
    "title": "Название: Полное сочинение по средней школе",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Russian. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "Мне нужно, чтобы Вы написали эссе в стиле рассказа, объемом около 800 слов. Эссе состоит из начала, трех уровней и заключения. Начало, заключение и каждый уровень должны следовать за заголовком, который должен идти по всему тексту, и каждый уровень должен быть отдельной вещью. Первый уровень должен быть связан с конкретным искусным описанием (подробное описание действия, художественная красота, радость первой попытки, близко к названию); второй уровень должен иметь немного инновационного содержания (подробное описание действия, инновационные идеи, инновации после переживания глубокой истины, близко к названию); третий уровень должен быть связан с более глубоким содержанием (культурное наследие/самоуважение/ответственность, близко к названию). Для названия существует поверхностный смысл и более глубокий смысл (производный смысл), который должен быть полностью отражен в тексте.\nМне нужно, чтобы вы сначала рассказали, как вы понимаете заголовок, что это за два смысла и чему конкретно они могут соответствовать. Затем дайте мне набросок, включающий: конкретный вступительный абзац, трехуровневое предложение с главной идеей и конкретным событием, а также конкретный заключительный абзац.\nНазвание - \"xxxx\", материал - [xxxx].",
    "remark": "После выполнения этого запроса введите \"Convert these into an essay\", чтобы проверить, работает ли эссе лучше. Вклад от @Qizhen-Yang."
  },
  "pt": {
    "title": "Título: Ensaio sobre a partitura completa do ensino secundário",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Portuguese. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "Preciso que escreva um ensaio no estilo de uma narrativa, com cerca de 800 palavras. O ensaio divide-se num início, três níveis e uma conclusão. O início, o fim e cada nível têm de seguir o título, que deve percorrer todo o texto, e cada nível tem de ser uma coisa separada. O primeiro nível deve ter a ver com uma descrição hábil específica (descrição detalhada da ação, beleza artística, a alegria da primeira tentativa, próximo do título); o segundo nível deve ter um pouco de conteúdo inovador (descrição detalhada da ação, ideias inovadoras, inovação após a experiência da verdade mais profunda, próximo do título); o terceiro nível deve ter a ver com o conteúdo mais profundo (herança cultural/valor próprio/responsabilidade, próximo do título). No caso do título, há um significado superficial e um significado mais profundo (significado derivado), que devem ser plenamente reflectidos no texto.\nPreciso que me diga primeiro qual é a sua interpretação do título, quais são os dois significados e a que coisas específicas podem corresponder. Depois, dê-me um esboço que inclua: um parágrafo de abertura específico, uma frase-ponto de ideia principal de evento de três níveis e um evento específico, e um parágrafo de encerramento específico.\nO título é \"xxxx\" e o material é [xxxx].",
    "remark": "Depois de executar esse prompt, digite \"Convert these into an essay\" (Converter isso em uma redação) para ver se a redação funciona melhor. Contribuição de @Qizhen-Yang."
  },
  "hi": {
    "title": "विषय: हाई स्कूल पूर्ण स्कोर संरचना",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Hindi. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "मैं चाहता हूँ कि आप एक निबंध लिखें, जिसकी शैली वर्णनात्मक हो, लगभग 800 शब्द। लेख को आरंभ, तीन स्तरों और अंत में विभाजित किया गया है। आरंभ, अंत और प्रत्येक स्तर को शीर्षक से निकटता से संबंधित होना चाहिए, शीर्षक पूरे पाठ में चलना चाहिए, और प्रत्येक स्तर एक अलग चीज़ होनी चाहिए। पहला स्तर विशिष्ट तकनीकी विवरण (विस्तृत कार्रवाई विवरण, कलात्मक सौंदर्य, पहले प्रयास की खुशी, विषय से निकटता से जुड़ा हुआ) के बारे में होना चाहिए; गहरा सच, विषय से निकटता से जुड़ा हुआ); तीसरा स्तर गहरी सामग्री के बारे में है (सांस्कृतिक विरासत/आत्म-मूल्य/जिम्मेदारी, विषय से निकटता से जुड़ा हुआ)। शीर्षक के लिए सतही अर्थ और गहरे अर्थ (विस्तारित अर्थ) होते हैं, जो पाठ में पूरी तरह प्रतिबिंबित होने चाहिए। मैं चाहता हूं कि आप मुझे शीर्षक की अपनी व्याख्या बताएं, दो अर्थ क्या हैं, और वे किन विशिष्ट चीजों से मेल खा सकते हैं। फिर मुझे एक रूपरेखा दें, जिसमें शामिल है: एक विशिष्ट प्रारंभिक पैराग्राफ, घटनाओं के तीन स्तर, मुख्य बिंदु, विषय वाक्य और विशिष्ट घटनाएं, और एक विशिष्ट समापन पैराग्राफ। शीर्षक &quot;xxxx&quot; है, और सामग्री [xxxx] है।",
    "remark": "इस प्रॉम्प्ट को निष्पादित करने के बाद, लेख का प्रभाव बेहतर है या नहीं यह देखने के लिए &quot;इन्हें एक रचना में परिवर्तित करें&quot; दर्ज करें। @Qizhen-यांग से योगदान।"
  },
  "ar": {
    "title": "الموضوع: الثانوية العامة تكوين النتيجة الكاملة",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Arabic. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "أريدك أن تكتب مقالًا ، وأسلوبه سردي ، حوالي 800 كلمة. المقال مقسم إلى بداية وثلاثة مستويات ونهاية. يجب أن ترتبط البداية والنهاية وكل مستوى ارتباطًا وثيقًا بالعنوان ، ويجب أن يمر العنوان عبر النص بأكمله ، ويجب أن يكون كل مستوى شيئًا منفصلاً. يجب أن يدور المستوى الأول حول الأوصاف الفنية المحددة (أوصاف العمل التفصيلية ، والجمال الفني ، وفرحة المحاولة الأولى ، المرتبطة ارتباطًا وثيقًا بالموضوع) ؛ الحقيقة العميقة ، المرتبطة ارتباطًا وثيقًا بالموضوع) ؛ المستوى الثالث حول المحتوى العميق (الإرث الثقافي / تقدير الذات / المسؤولية ، مرتبط ارتباطًا وثيقًا بالموضوع). للعنوان معاني سطحية ومعاني عميقة (معاني ممتدة) يجب أن تنعكس بشكل كامل في النص. أريدك أن تخبرني بتفسيرك للعنوان ، ما معنيان ، وما الأشياء المحددة التي يمكن أن تتوافق معها. ثم أعطني مخططًا يتضمن: فقرة افتتاحية محددة ، وثلاثة مستويات من الأحداث ، ونقاط رئيسية ، وجمل موضوع وأحداث محددة ، وفقرة ختامية محددة. العنوان هو &quot;xxxx&quot; ، والمادة [xxxx].",
    "remark": "بعد تنفيذ هذه المطالبة ، أدخل &quot;تحويل هذه إلى مقطوعة موسيقية&quot; لمعرفة ما إذا كان تأثير المقالة أفضل. مساهمة من @ Qizhen-Yang."
  },
  "bn": {
    "title": "বিষয়: উচ্চ বিদ্যালয়ের পূর্ণ স্কোর রচনা",
    "prompt": "Please write a narrative essay of about 800 words. The essay should have an introduction, three distinct sections, and a conclusion. Each section should focus on a single event related to the main theme, which should be present throughout the essay. \n\n1. For the first section, focus on detailed descriptions of a specific skill or technique, including its artistic beauty and the joy of trying it for the first time.\n2. In the second section, describe an innovative idea or concept, including details of its implementation and the deeper insights gained from the innovation.\n3. The third section should revolve around a deeper aspect, such as cultural heritage, self-worth, or responsibility.\n\nBefore starting the essay, please share your interpretation of the title, including its surface and deeper meanings, and how they can be related to specific events or objects. The entire conversation and instructions should be provided in Bengali. Then, provide an outline of the essay, including the introduction, the main points and events for each of the three sections, and the conclusion.The title of the essay is [XXX], and the material is [YYY].",
    "description": "আমি আপনাকে একটি প্রবন্ধ লিখতে চাই, যার শৈলী বর্ণনামূলক, প্রায় 800 শব্দ। নিবন্ধটি শুরু, তিনটি স্তর এবং শেষ ভাগে বিভক্ত। শুরু, শেষ এবং প্রতিটি স্তর শিরোনামের সাথে ঘনিষ্ঠভাবে সম্পর্কিত হওয়া দরকার, শিরোনামটি অবশ্যই পুরো পাঠ্যের মধ্য দিয়ে চলতে হবে এবং প্রতিটি স্তর অবশ্যই একটি পৃথক জিনিস হতে হবে। প্রথম স্তরটি নির্দিষ্ট প্রযুক্তিগত বর্ণনা সম্পর্কে হওয়া উচিত (বিস্তারিত কর্মের বর্ণনা, শৈল্পিক সৌন্দর্য, প্রথম প্রচেষ্টার আনন্দ, বিষয়টির সাথে ঘনিষ্ঠভাবে সম্পর্কিত); গভীর সত্য, বিষয়টির সাথে ঘনিষ্ঠভাবে যুক্ত); তৃতীয় স্তরটি গভীর বিষয়বস্তু সম্পর্কে (সাংস্কৃতিক উত্তরাধিকার/স্ব-মূল্য/দায়িত্ব, বিষয়টির সাথে ঘনিষ্ঠভাবে যুক্ত)। শিরোনামের জন্য, উপরিভাগের অর্থ এবং গভীর অর্থ (বর্ধিত অর্থ) রয়েছে যা পাঠ্যে সম্পূর্ণরূপে প্রতিফলিত হওয়া উচিত। আমি আপনাকে শিরোনামের আপনার ব্যাখ্যা, দুটি অর্থ কী এবং কোন নির্দিষ্ট জিনিসগুলির সাথে মিল থাকতে পারে তা আমাকে বলুন। তারপর আমাকে একটি রূপরেখা দিন, যার মধ্যে রয়েছে: একটি নির্দিষ্ট উদ্বোধনী অনুচ্ছেদ, তিনটি স্তরের ঘটনা, প্রধান পয়েন্ট, বিষয় বাক্য এবং নির্দিষ্ট ঘটনা এবং একটি নির্দিষ্ট শেষ অনুচ্ছেদ। শিরোনাম হল &quot;xxxx&quot;, এবং উপাদান হল [xxxx]।",
    "remark": "এই প্রম্পটটি কার্যকর করার পরে, নিবন্ধটির প্রভাব আরও ভাল কিনা তা দেখতে &quot;এগুলিকে একটি রচনায় রূপান্তর করুন&quot; লিখুন। @কিজেন-ইয়াং থেকে অবদান।"
  },
  "website": null,
  "tags": [
    "contribute",
    "pedagogy"
  ],
  "id": 200,
  "weight": 2841
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
