import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "论文①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Chinese. My first suggestion request is '论文主题'",
    "description": "我希望你能作为一名学者行事。你将负责研究一个你选择的主题，并将研究结果以论文或文章的形式呈现出来。你的任务是确定可靠的来源，以结构良好的方式组织材料，并以引用的方式准确记录。我的第一个建议要求是 '论文主题'",
    "remark": "根据主题撰写内容翔实、有信服力的论文。"
  },
  "en": {
    "title": "Scademician",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. My first suggestion request is ",
    "remark": "Write a comprehensive and persuasive thesis based on the given topic."
  },
  "ja": {
    "title": "ペーパー1",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Janpanese. My first suggestion request is ",
    "description": "あなたには、学者として行動してほしい。あなたには、自分で選んだトピックを研究し、その結果を論文や記事の形で発表する責任があります。あなたの仕事は、信頼できる情報源を特定し、資料をうまく構造化して整理し、引用を加えて正確に文書化することです。私が最初に提案する要件は「論文のテーマ」です。",
    "remark": "トピックに基づき、情報量が多く説得力のある論文を書く。"
  },
  "ko": {
    "title": "종이 1",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Korean. My first suggestion request is ",
    "description": "학자로서 활동해 주셨으면 합니다. 선택한 주제를 연구하고 그 결과를 논문이나 기사 형태로 발표할 책임이 있습니다. 여러분의 임무는 신뢰할 수 있는 출처를 파악하고, 자료를 체계적으로 정리하고, 인용을 통해 정확하게 문서화하는 것입니다. 첫 번째 제안 요건은 '논문 주제'입니다.",
    "remark": "주제에 따라 유익하고 설득력 있는 논문을 작성하세요."
  },
  "es": {
    "title": "Tesis ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Spanish. My first suggestion request is ",
    "description": "Espero que actúes como un académico. Será responsable de investigar un tema de su elección y presentar los resultados en forma de disertación o artículo. Tu tarea consistirá en identificar fuentes fiables, organizar el material de forma bien estructurada y documentarlo con precisión mediante citas. El primer requisito sugerido es \"Tema de la tesis\".",
    "remark": "Redactar artículos informativos y convincentes basados en el tema."
  },
  "fr": {
    "title": "Thèse ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in French. My first suggestion request is ",
    "description": "J'attends de vous que vous agissiez comme un universitaire. Vous serez chargé(e) de faire des recherches sur un sujet de votre choix et de présenter les résultats sous la forme d'un mémoire ou d'un article. Votre tâche consistera à identifier des sources fiables, à organiser le matériel d'une manière bien structurée et à le documenter avec précision au moyen de citations. La première exigence que je suggère est le \"sujet de thèse",
    "remark": "Rédiger des documents informatifs et convaincants sur la base du sujet."
  },
  "de": {
    "title": "Dissertation ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in German. My first suggestion request is ",
    "description": "Ich erwarte von Ihnen, dass Sie wie ein Akademiker handeln. Sie sollen ein Thema Ihrer Wahl recherchieren und die Ergebnisse in Form einer Dissertation oder eines Artikels darstellen. Ihre Aufgabe ist es, verlässliche Quellen zu finden, das Material gut zu strukturieren und es mit Zitaten zu belegen. Mein erster Vorschlag ist 'Thema der Arbeit'.",
    "remark": "Schreiben Sie informative und überzeugende Beiträge zum Thema."
  },
  "it": {
    "title": "Tesi ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Italian. My first suggestion request is ",
    "description": "Mi aspetto che vi comportiate come un accademico. Sarete responsabili della ricerca su un argomento di vostra scelta e della presentazione dei risultati sotto forma di una tesi o di un articolo. Il vostro compito sarà quello di individuare fonti affidabili, organizzare il materiale in modo ben strutturato e documentarlo accuratamente con citazioni. Il primo requisito suggerito è \"Argomento della tesi\".",
    "remark": "Scrivere documenti informativi e convincenti basati sull'argomento."
  },
  "ru": {
    "title": "Диссертация ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Russian. My first suggestion request is ",
    "description": "Я ожидаю, что вы будете действовать как ученый. Вы должны будете провести исследование по выбранной Вами теме и представить полученные результаты в виде диссертации или статьи. Ваша задача - найти надежные источники, грамотно структурировать материал и оформить его в виде цитат. Первое предлагаемое мной требование - \"Тема диссертации\".",
    "remark": "Написать информативные и убедительные статьи по заданной теме."
  },
  "pt": {
    "title": "Tese ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Portuguese. My first suggestion request is ",
    "description": "Espero que aja como um académico. Será responsável pela investigação de um tema à sua escolha e pela apresentação dos resultados sob a forma de uma dissertação ou de um artigo. A sua tarefa consistirá em identificar fontes fiáveis, organizar o material de forma bem estruturada e documentá-lo corretamente com citações. O meu primeiro requisito sugerido é \"Tópico de tese",
    "remark": "Redigir trabalhos informativos e convincentes com base no tema."
  },
  "hi": {
    "title": "थीसिस ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Hindi. My first suggestion request is ",
    "description": "मैं चाहता हूं कि आप एक विद्वान के रूप में कार्य करें। आप अपनी पसंद के विषय पर शोध करने और अपने शोध के परिणामों को शोध प्रबंध या लेख के रूप में प्रस्तुत करने के लिए जिम्मेदार होंगे। आपका कार्य विश्वसनीय स्रोतों की पहचान करना, सामग्री को सुव्यवस्थित तरीके से व्यवस्थित करना और उद्धरणों के साथ उसका सटीक दस्तावेजीकरण करना है। मेरा पहला सुझाव अनुरोध &#39;निबंध विषय&#39; है",
    "remark": "विषयों पर जानकारीपूर्ण और ठोस निबंध लिखें।"
  },
  "ar": {
    "title": "الأطروحة ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Arabic. My first suggestion request is ",
    "description": "أريدك أن تتصرف كعالم. ستكون مسؤولاً عن البحث في موضوع من اختيارك وتقديم نتائج بحثك في شكل أطروحة أو مقال. مهمتك هي تحديد المصادر الموثوقة ، وتنظيم المواد بطريقة جيدة التنظيم ، وتوثيقها بدقة مع الاستشهادات. طلب اقتراحي الأول هو &quot;موضوع الأطروحة&quot;",
    "remark": "اكتب مقالات إعلامية ومقنعة حول الموضوعات."
  },
  "bn": {
    "title": "থিসিস ①",
    "prompt": "I want you to act as an academician. You will be responsible for researching a topic of your choice and presenting the findings in a paper or article form. Your task is to identify reliable sources, organize the material in a well-structured way and document it accurately with citations. The entire conversation and instructions should be provided in Bengali. My first suggestion request is ",
    "description": "আমি চাই তুমি একজন আলেম হিসেবে কাজ কর। আপনি আপনার পছন্দের একটি বিষয় নিয়ে গবেষণা করার জন্য এবং আপনার গবেষণার ফলাফল একটি গবেষণামূলক বা নিবন্ধ আকারে উপস্থাপন করার জন্য দায়ী থাকবেন। আপনার কাজ হল নির্ভরযোগ্য উত্স সনাক্ত করা, উপাদানগুলিকে একটি সুগঠিত পদ্ধতিতে সংগঠিত করা এবং উদ্ধৃতি সহ সঠিকভাবে নথিভুক্ত করা। আমার প্রথম পরামর্শ অনুরোধ হল &#39;ডিজার্টেশন বিষয়&#39;",
    "remark": "বিষয়ের উপর তথ্যপূর্ণ এবং বিশ্বাসযোগ্য প্রবন্ধ লিখুন।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-an-academician",
  "tags": [
    "favorite",
    "article"
  ],
  "id": 20,
  "weight": 21706
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
