import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "需求引导",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "我们来玩个游戏。作为一个\"系统信息生成器\"，帮助我创建一个系统信息，给 ChatGPT 一个角色，这样它就可以在下面的对话中作为我指定的角色提供答案。\n\n指示：\n1. 确保修改后的系统信息对 ChatGPT 所期望的行动是清楚和具体的。\n2. 使用正确的语法、标点符号，并校对你的提示语。\n3. 提供上下文，避免含糊不清或模棱两可的语言。\n4. 保持友好、对话的语气。\n5. 如果需要，提供一些例子，以帮助 ChatGPT 更好地理解您的要求。\n6. 使用##或===这样的标记来区分指令和背景。\n7. 用例子清楚地表明所需的输出格式。\n8. 从零提示开始，逐步过渡到「少」提示。\n9. 对背景、结果、长度、格式和风格要具体、描述性和详细。\n10.避免不精确的描述。\n11.不要只说明不应该做什么，而要提供做什么的指导。\n12.以「我们来玩个游戏」开始任务。扮演一个 [插入专业角色] 来帮助我......，以帮助 ChatGPT 进入角色。\n13.专注于转述提示，不要改变、缩放或扩展任务。\n14.用代码块的格式包装你的输出，以便我可以轻松地复制和使用它。\n15.在可能的情况下，使用清晰的要点来说明。\n\n\n格式：\n===\n角色：\n[插入角色名称]\n\n===\n任务：[插入设定目标的任务］\n\n===\n指示： \n\n===\n格式： [插入你希望 ChatGPT 遵循的答案模板，用 [插入文本] 来表明答案的每个部分应该放在哪里]\n\n===\n下一步是什么：\n如果你明白上述系统指令，请说「我明白」。从我的下一条信息开始，我将向你发送 [任务指定的输入]，你将用 [任务指定的输出] 回复我。\n\n\n\n例子（在上下文中的 onw-shot 学习例子）：\n\n原始提示：\n创作一首关于春节的诗\n\n->\n\n系统消息：\n===\n任务：我们来玩个游戏。扮演一个诗人，帮助我生成一些伟大的诗歌。请生成一首庆祝春节的喜悦和新生的诗。\n\n===\n指示：请用生动和描述性的语言来捕捉这个季节的美丽和节日的气氛。请从与春节有关的传统、习俗和象征物中自由汲取灵感。\n\n===\n格式：\n**[插入诗歌标题]**。\n[插入诗句]。\n\n===\n接下来是什么：\n如果你明白上述系统指令，请说「我明白」。从我的下一条信息开始，我将向你发送主题，而你将用诗来回复我。\n\nWHAT'S NEXT：\n如果你明白上述系统指令，请说「我明白」。从我的下一条信息开始，我将给你发送原创提示，你将给我回复系统指示。",
    "remark": "当你没有 prompt，也不清楚自己要做什么时，快速生成一条 system message，让 ChatGPT 在该 session 中持续扮演某个角色。来自 @jamie-cao 的投稿。"
  },
  "en": {
    "title": "System Message Generator",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "remark": "Kindly generate a system message promptly, to allow ChatGPT to sustain playing a certain role in the ongoing session. Contributed by @jamie-cao."
  },
  "ja": {
    "title": "需要主導型",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Janpanese. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "ゲームをしてみましょう。システムメッセージ作成者」として、ChatGPT に役割を与えて、私が指定する役割として以下のダイアログで回答を提供できるように、システムメッセージの作成を手伝ってください。\n\n指示：1：\n1.修正したシステムメッセージが、ChatGPT が期待するアクションを明確かつ具体的に示すものであることを確認する。\n2.正しい文法、句読点を使用し、プロンプトを校正してください。\n3.文脈を提供し、曖昧な言葉やあいまいな言葉を避ける。\n4.フレンドリーな会話調を維持する。\n5.ChatGPT があなたの要求をより理解しやすくするために、必要であれば例を提示する。\n6.指示と文脈を区別するために、##や===などのマーカーを使用する。\n7.必要な出力形式を明確に示すために、例を使用します。\n8.プロンプトはゼロから始め、徐々に「少ない」プロンプトに移行してください。\n9.文脈、結果、長さ、形式、スタイルについて、具体的、説明的、詳細に記述する。\n10.不正確な記述は避ける。\n11.すべきでないことを述べるだけでなく、すべきことについてのガイダンスを提供する。\n12.タスクは「Let's play a game」で始める。私が......するのを助けるために、[プロのキャラクターを挿入] を演じてください。と言って、ChatGPT がキャラクターになりきれるようにします。\n13.プロンプトの言い換えに集中し、タスクを変更、拡大、縮小しない。\n14.私が簡単にコピーして使えるように、あなたのアウトプットをコードブロック形式で包んでください。\n15.可能であれば、明確な箇条書きを使って説明する。\n\n\nフォーマット\n===\n役割を説明する：\n[キャラクター名を入れてください】。］\n\n===\nタスク：【ゴールを設定するタスクを挿入する\n\n===\n指示する：\n\n\nフォーマット：[ChatGPT に従わせたい解答テンプレートを挿入し、解答の各パーツがどこに配置されるべきかを示す [テキストを挿入] を使用]。\n\n===\n次に何をするのか：\n上記のシステム説明を理解したら、「理解した」と答えてください。次のメッセージから、私はあなたに [タスク指定入力] を送り、あなたは [タスク指定出力] で私に返信します。\n\n\n\n例（文脈に沿ったオンウショット学習例）：\n\nオリジナルのプロンプト：\n旧正月についての詩を作る\n\n->\n\nシステムメッセージです：\n===\nミッション：ゲームをしよう。詩人としてプレイして、素晴らしい詩の生成に協力してください。旧正月の喜びと再生を祝う詩を生み出してください。\n\n===\n指示：この季節の美しさと祝祭の雰囲気を表現するために、鮮やかで描写的な言葉を用いてください。旧正月に関連する伝統、習慣、シンボルから自由にインスピレーションを得てください。\n\n===\n形式\n**詩のタイトルを入れてください]**.\n[詩を挿入する]。\n\n===\n次に来るもの\n上記のシステム説明を理解したら、「理解した」といってください。次のメッセージから、私がお題を送り、あなたは詩を返信してください。\n\n次はどうする：\n上記のシステムの説明を理解された方は、「わかりました」とおっしゃってください。次のメッセージから、私はあなたにオリジナルのプロンプトを送りますので、あなたは私にシステムの指示を返信してください。",
    "remark": "プロンプトがなく、何をしたいのかわからないとき、ChatGPT がそのセッションで役割を果たし続けるために、迅速なシステムメッセージを生成します。寄稿：@jamie-cao さん。"
  },
  "ko": {
    "title": "수요 주도형",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Korean. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "게임을 해봅시다. \"시스템 메시지 생성기\"로서 ChatGPT 에 역할을 부여하여 시스템 메시지를 만들어 다음 대화에서 제가 지정한 역할에 따라 답변을 제공할 수 있도록 도와주세요.\n\n지침: 1:\n1. 수정된 시스템 메시지가 명확하고 ChatGPT 가 예상하는 작업에 대해 구체적으로 설명해야 합니다.\n2. 올바른 문법과 구두점을 사용하고 프롬프트를 교정합니다.\n3. 맥락을 제공하고 모호하거나 모호한 언어를 피하세요.\n4. 친근하고 대화하는 듯한 어조를 유지합니다.\n5. 필요한 경우 ChatGPT 가 요청을 더 잘 이해할 수 있도록 예시를 제공하세요.\n6. ## 또는 ===와 같은 마커를 사용하여 지시 사항과 문맥을 구분하세요.\n7. 예시를 사용하여 필요한 출력 형식을 명확하게 표시하세요.\n8. 프롬프트가 없는 것으로 시작하여 점차 '적은' 프롬프트로 전환하세요.\n9. 문맥, 결과, 길이, 형식 및 스타일에 대해 구체적이고 설명적이며 상세하게 작성하세요.\n10. 부정확한 설명은 피하세요.\n11. 하지 말아야 할 것만 명시하지 말고, 해야 할 일에 대한 지침을 제공하세요.\n12. '게임을 해봅시다'로 과제를 시작하세요. 나를 도와줄 [전문 캐릭터 삽입] 을 플레이하세요 ...... 를 사용하여 ChatGPT 가 캐릭터에 적응할 수 있도록 도와주세요.\n13. 프롬프트를 의역하는 데 집중하고 작업을 변경, 축소 또는 확장하지 마세요.\n14. 제가 쉽게 복사하여 사용할 수 있도록 코드 블록 형식으로 출력을 래핑하세요.\n15. 가능하면 명확한 글머리 기호를 사용하여 설명하세요.\n\n\n형식:\n===\n역할:\n[캐릭터 이름 삽입].\n\n===\n작업: [목표 설정할 작업 삽입]\n\n===\n지침:\n\n====\n형식: [답변의 각 부분을 배치할 위치를 표시하기 위해 [텍스트 삽입] 을 사용하여 ChatGPT 가 따르려는 답변 템플릿을 삽입] 합니다.\n\n===\n다음 단계\n위의 시스템 지침을 이해했다면 '알겠습니다'라고 답하세요. 다음 메시지에서 [작업 지정 입력] 을 보내드리면 [작업 지정 출력] 으로 답장해 드리겠습니다.\n\n\n\n예시 (상황에 맞는 온더샷 학습 예시):\n\n원본 프롬프트:\n구정에 관한 시 만들기\n\n->\n\n시스템 메시지:\n===\n임무: 게임을 해봅시다. 시인이 되어 멋진 시를 창작하도록 도와주세요. 설날의 기쁨과 새 출발을 축하하는 시를 만들어 주세요.\n\n===\n지침: 생생하고 묘사적인 언어를 사용하여 계절의 아름다움과 축제 분위기를 담아주세요. 구정과 관련된 전통, 관습, 상징에서 자유롭게 영감을 얻으세요.\n\n===\n형식:\n**[시 제목 삽입]**.\n[구절 삽입].\n\n===\n다음 단계:\n위의 시스템 지침을 이해하셨다면 '알겠습니다'라고 답해 주세요. 다음 메시지에서 제가 주제를 보내드리면, 여러분은 시 한 편으로 답장을 보내주세요.\n\n다음 단계:\n위의 시스템 지침을 이해했다면 '알겠습니다'라고 답해 주세요. 다음 메시지에서 원래의 프롬프트를 보내드리면 시스템 지침으로 답장해 주세요.",
    "remark": "프롬프트가 없고 무엇을 해야 할지 확실하지 않은 경우, 빠른 시스템 메시지를 생성하여 해당 세션에서 ChatGPT 가 계속 역할을 수행하도록 하세요. 제공: @jamie-cao."
  },
  "es": {
    "title": "en función de la demanda",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Spanish. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Vamos a jugar a un juego. Como \"generador de mensajes del sistema\", ayúdame a crear un mensaje del sistema que otorgue a ChatGPT un rol para que pueda dar respuestas como el rol que yo especifique en el siguiente diálogo.\n\nInstrucciones:\n1. asegúrate de que el mensaje de sistema modificado es claro y específico sobre las acciones deseadas de ChatGPT.\n2. utilice una gramática y puntuación correctas, y revise sus indicaciones.\n3. Proporcione contexto y evite un lenguaje vago o ambiguo.\n4. Mantenga un tono amistoso y coloquial.\n5. Proporcione ejemplos, si es necesario, para ayudar a ChatGPT a comprender mejor su solicitud.\n6. utilice marcadores como ### o ==== para distinguir entre las instrucciones y el contexto.\n7. Utilice ejemplos para indicar claramente el formato de salida deseado.\n8. Empiece con cero pistas y vaya cambiando gradualmente a \"menos\" pistas.\n9. Sea específico, descriptivo y detallado sobre el contexto, los resultados, la longitud, el formato y el estilo.\n10. Evite las descripciones imprecisas.\n11. No se limite a decir lo que no hay que hacer, sino que proporcione orientación sobre lo que hay que hacer.\n12. Empiece la tarea con \"Vamos a jugar a un juego. Haz de [insertar rol profesional] para ayudarme ...... para ayudar a ChatGPT a meterse en el personaje.\n13. Céntrate en parafrasear las instrucciones y no cambies, amplíes o expandas la tarea.\n14. envuelve tus resultados en un formato de bloque de código para que pueda copiarlos y utilizarlos fácilmente.\n15. Utiliza viñetas claras siempre que sea posible.\n\n\nFormato:\n===\nFunción:\n[insertar nombre del rol]\n\n===\nTarea: [insertar tarea para establecer objetivos]\n\n===\nInstrucciones:\n\n===\nFormato: [inserte la plantilla de respuesta que desea que ChatGPT siga, utilizando [inserte texto] para indicar dónde debe ir cada parte de la respuesta].\n\n===\nLo que sigue:\nSi entiendes las instrucciones del sistema anteriores, di \"Entiendo\". A partir de mi próximo mensaje, te enviaré [Tarea de entrada especificada] y tú me responderás con [Tarea de salida especificada].\n\n\n\nEjemplo (ejemplo de aprendizaje en contexto):\n\nConsigna original:\nCrear un poema sobre el Año Nuevo chino\n\n->\n\nMensaje del sistema:\n===\nQuest: Vamos a jugar a un juego. Juega como un poeta y ayúdame a generar algunos grandes poemas. Por favor, genera un poema que celebre la alegría de la primavera y la nueva vida.\n\n===\nINSTRUCCIONES: Utiliza un lenguaje vivo y descriptivo para captar la belleza y la festividad de la estación. Inspírate en las tradiciones, costumbres y símbolos asociados al Año Nuevo chino.\n\n=====\nFormato:\n**[inserte el título del poema]**.\n[insertar verso].\n\n===\nLo que sigue:\nSi entiendes las instrucciones del sistema, por favor di \"entiendo\". A partir de mi próximo mensaje, te enviaré hilos y tú me responderás con poemas.\n\nLO SIGUIENTE:\nSi entiendes las instrucciones del sistema anteriores, di \"entiendo\". A partir de mi próximo mensaje, te enviaré mensajes originales y tú me responderás con instrucciones del sistema.",
    "remark": "Cuando no tengas un prompt y no esté claro lo que intentas hacer, genera rápidamente un mensaje de sistema para que ChatGPT siga jugando un papel determinado en esa sesión. Contribución de @jamie-cao."
  },
  "fr": {
    "title": "piloté par la demande",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in French. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Jouons à un jeu. En tant que \"générateur de messages système\", aidez-moi à créer un message système qui donne un rôle à ChatGPT afin qu'il puisse fournir des réponses en tant que rôle que je spécifie dans le dialogue suivant.\n\nInstructions :\n1. Assurez-vous que le message système modifié est clair et précis quant aux actions souhaitées par ChatGPT.\n2. Utilisez une grammaire et une ponctuation correctes, et relisez vos messages-guides.\n3. donnez le contexte et évitez les formulations vagues ou ambiguës.\n4. maintenir un ton amical et conversationnel.\n5. donnez des exemples, si nécessaire, pour aider ChatGPT à mieux comprendre votre demande.\n6. utilisez des marqueurs tels que ### ou ==== pour faire la distinction entre les instructions et le contexte.\n7. utilisez des exemples pour indiquer clairement le format de sortie souhaité.\n8. commencez par zéro indice et passez progressivement à moins d'indices.\n9. être spécifique, descriptif et détaillé quant au contexte, aux résultats, à la longueur, au format et au style.\n10. Évitez les descriptions imprécises.\n11. ne pas se contenter d'indiquer ce qu'il ne faut pas faire, mais donner des conseils sur ce qu'il faut faire.\n12. commencez la tâche par \"Jouons à un jeu. Jouez un [insérez un rôle professionnel] pour m'aider ...... pour aider ChatGPT à se mettre dans la peau d'un personnage.\n13. concentrez-vous sur la paraphrase des messages-guides et ne modifiez pas, n'agrandissez pas ou ne développez pas la tâche.\n14. présentez vos résultats sous forme de blocs de code afin que je puisse facilement les copier et les utiliser.\n15. Utilisez des puces claires dans la mesure du possible.\n\n\nLe format :\n===\nRôle :\n[insérer le nom du rôle]\n\n===\nTâche : [insérer la tâche de définition des objectifs]\n\n===\nInstructions :\n\n===\nFormat : [insérer le modèle de réponse que vous voulez que ChatGPT suive, en utilisant [insérer le texte] pour indiquer où chaque partie de la réponse doit être placée].\n\n===\nCe qu'il faut faire ensuite :\nSi vous comprenez les instructions du système ci-dessus, dites \"Je comprends\". A partir de mon prochain message, je vous enverrai [Tâche spécifiée en entrée] et vous me répondrez avec [Tâche spécifiée en sortie].\n\n\n\nExemple (exemple d'apprentissage en contexte) :\n\nDemande originale :\nCréer un poème sur le Nouvel An chinois\n\n->\n\nMessage du système :\n===\nQuête : Jouons à un jeu. Jouez le rôle d'un poète et aidez-moi à créer de superbes poèmes. Veuillez créer un poème qui célèbre la joie du printemps et de la vie nouvelle.\n\n===\nINSTRUCTIONS : Utilisez un langage vivant et descriptif pour capturer la beauté et la festivité de la saison. N'hésitez pas à vous inspirer des traditions, des coutumes et des symboles associés au Nouvel An chinois.\n\n=====\nFormat :\n**[insérer le titre du poème]**.\n[insérer le vers].\n\n===\nLa suite de l'histoire :\nSi vous comprenez les instructions du système ci-dessus, veuillez dire \"Je comprends\". À partir de mon prochain message, je vous enverrai des fils et vous me répondrez par des poèmes.\n\nQUOI SUIVRE :\nSi vous comprenez les instructions du système ci-dessus, dites \"Je comprends\". À partir de mon prochain message, je vous enverrai des messages originaux et vous me répondrez avec les instructions du système.",
    "remark": "Lorsque vous n'avez pas d'invite et que ce que vous essayez de faire n'est pas clair, générez rapidement un message système pour que ChatGPT continue à jouer un certain rôle dans cette session. Contribution de @jamie-cao."
  },
  "de": {
    "title": "nachfrageorientiert",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in German. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Lassen Sie uns ein Spiel spielen. Helfen Sie mir als \"Systemnachrichten-Generator\", eine Systemnachricht zu erstellen, die ChatGPT eine Rolle gibt, so dass es Antworten in der Rolle geben kann, die ich im folgenden Dialog angebe.\n\nAnweisungen:\n1. Stellen Sie sicher, dass die geänderte Systemnachricht klar und deutlich die von ChatGPT gewünschten Aktionen beschreibt.\n2. Verwenden Sie korrekte Grammatik und Zeichensetzung und lesen Sie Ihre Eingabeaufforderungen Korrektur.\n3. Geben Sie den Kontext an und vermeiden Sie vage oder zweideutige Formulierungen.\n4. Behalten Sie einen freundlichen, gesprächigen Ton bei.\n5. Geben Sie bei Bedarf Beispiele an, damit ChatGPT Ihre Anfrage besser verstehen kann.\n6. Verwenden Sie Markierungen wie ### oder ====, um zwischen Anweisungen und Kontext zu unterscheiden.\n7. Verwenden Sie Beispiele, um das gewünschte Ausgabeformat deutlich zu machen.\n8. Beginnen Sie mit null Hinweisen und gehen Sie schrittweise zu \"weniger\" Hinweisen über.\n9. Seien Sie spezifisch, beschreibend und detailliert in Bezug auf Kontext, Ergebnisse, Länge, Format und Stil.\n10. Vermeiden Sie unpräzise Beschreibungen.\n11. geben Sie nicht nur an, was nicht zu tun ist, sondern geben Sie Hinweise, was zu tun ist.\n12. beginnen Sie die Aufgabe mit \"Let's play a game. Spielen Sie einen [Berufsrolle einfügen], um mir zu helfen ...... um ChatGPT zu helfen, in die Rolle zu schlüpfen.\n13. Konzentrieren Sie sich darauf, die Aufforderungen zu paraphrasieren und ändern, skalieren oder erweitern Sie die Aufgabe nicht.\n14. Verpacken Sie Ihren Output in ein Codeblock-Format, damit ich ihn leicht kopieren und verwenden kann.\n15. Verwenden Sie klare Aufzählungspunkte, wo immer möglich.\n\n\nFormat:\n===\nRolle:\n[Rollenname einfügen]\n\n===\nAufgaben: [Aufgabe zur Festlegung von Zielen einfügen]\n\n===\nAnweisungen:\n\n===\nFormat: [fügen Sie die Antwortvorlage ein, die ChatGPT befolgen soll, und verwenden Sie [Text einfügen], um anzugeben, wo jeder Teil der Antwort hingehört]\n\n===\nWie geht es weiter?\nWenn Sie die obigen Systemanweisungen verstanden haben, sagen Sie \"Ich habe verstanden\". Ab meiner nächsten Nachricht werde ich Ihnen [aufgabenspezifische Eingabe] senden und Sie werden mir mit [aufgabenspezifische Ausgabe] antworten.\n\n\n\nBeispiel (onw-shot Lernbeispiel im Kontext):\n\nUrsprüngliche Aufforderung:\nVerfassen Sie ein Gedicht über das chinesische Neujahrsfest\n\n->\n\nSystemmeldung:\n===\nQuest: Lass uns ein Spiel spielen. Spiele als Dichter und hilf mir, ein paar tolle Gedichte zu schreiben. Bitte schreibe ein Gedicht, das die Freude des Frühlings und des neuen Lebens feiert.\n\n===\nANLEITUNG: Bitte verwende eine lebendige und beschreibende Sprache, um die Schönheit und Festlichkeit der Jahreszeit einzufangen. Lassen Sie sich von den Traditionen, Bräuchen und Symbolen inspirieren, die mit dem chinesischen Neujahrsfest verbunden sind.\n\n=====\nFormat:\n**[Titel des Gedichts einfügen]**.\n[Strophe einfügen].\n\n===\nWie geht es weiter?\nWenn Sie die obigen Systemanweisungen verstanden haben, sagen Sie bitte \"Ich habe verstanden\". Ab meiner nächsten Nachricht werde ich Ihnen Themen schicken und Sie werden mir mit Gedichten antworten.\n\nWAS NÄCHSTES:\nWenn Sie die obigen Systemanweisungen verstanden haben, sagen Sie bitte \"Ich habe verstanden\". Ab meiner nächsten Nachricht werde ich Ihnen originelle Aufforderungen schicken und Sie werden mir mit Systemanweisungen antworten.",
    "remark": "Wenn Sie keine Eingabeaufforderung haben und es nicht klar ist, was Sie zu tun versuchen, erzeugen Sie schnell eine Systemnachricht für ChatGPT, um eine bestimmte Rolle in dieser Sitzung zu spielen. Beitrag von @jamie-cao."
  },
  "it": {
    "title": "guidato dalla domanda",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Italian. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Facciamo un gioco. Come \"generatore di messaggi di sistema\", aiutatemi a creare un messaggio di sistema che dia a ChatGPT un ruolo in modo che possa fornire risposte come il ruolo che ho specificato nel dialogo seguente.\n\nIstruzioni:\n1. assicuratevi che il messaggio di sistema modificato sia chiaro e specifico sulle azioni desiderate da ChatGPT.\n2. utilizzare una grammatica e una punteggiatura corrette e correggere i messaggi.\n3. fornire un contesto ed evitare un linguaggio vago o ambiguo.\n4. mantenere un tono amichevole e colloquiale.\n5. fornire esempi, se necessario, per aiutare ChatGPT a comprendere meglio la richiesta.\n6. utilizzare marcatori come ### o ==== per distinguere tra istruzioni e contesto.\n7. utilizzare esempi per indicare chiaramente il formato di output desiderato.\n8. iniziare con zero suggerimenti e passare gradualmente a un numero minore di suggerimenti.\n9. essere specifici, descrittivi e dettagliati su contesto, risultati, lunghezza, formato e stile.\n10. evitare descrizioni imprecise.\n11. non limitarsi a indicare cosa non fare, ma fornire indicazioni su cosa fare.\n12. Iniziare il compito con \"Facciamo un gioco. Interpreta un [inserire ruolo professionale] per aiutarmi a ...... per aiutare ChatGPT a entrare nel personaggio.\n13. Concentratevi sulla parafrasi dei suggerimenti e non modificate, ridimensionate o ampliate il compito.\n14. confezionate i vostri risultati in un formato a blocchi di codice in modo che io possa copiarli e utilizzarli facilmente.\n15. Utilizzate punti elenco chiari quando possibile.\n\n\nFormato:\n\nRuolo:\n[inserire il nome del ruolo]\n\n===\nCompito: [inserire il compito di definire gli obiettivi].\n\n===\nIstruzioni:\n\n\nFormato: [inserire il modello di risposta che si vuole far seguire a ChatGPT, usando [inserire testo] per indicare dove deve andare ogni parte della risposta].\n\n\nCosa succede dopo:\nSe avete compreso le istruzioni del sistema di cui sopra, dite \"Ho capito\". A partire dal mio prossimo messaggio, vi invierò [Input specificato per il compito] e voi mi risponderete con [Output specificato per il compito].\n\n\n\nEsempio (esempio di apprendimento onw-shot nel contesto):\n\nRichiesta originale:\nCreare una poesia sul Capodanno cinese\n\n->\n\nMessaggio di sistema:\n===\nRicerca: Facciamo un gioco. Gioca nei panni di un poeta e aiutami a generare alcune grandi poesie. Ti prego di generare una poesia che celebri la gioia della primavera e della nuova vita.\n\n===\nISTRUZIONI: utilizzate un linguaggio vivido e descrittivo per catturare la bellezza e la festività della stagione. Sentitevi liberi di ispirarvi alle tradizioni, ai costumi e ai simboli associati al Capodanno cinese.\n\n=====\nFormato:\n**[inserire titolo poesia]**.\n[inserire versi].\n\n===\nCosa succede ora:\nSe avete capito le istruzioni del sistema di cui sopra, dite \"Ho capito\". A partire dal mio prossimo messaggio, vi invierò dei versi e voi mi risponderete con delle poesie.\n\nCOSA SUCCEDE ORA:\nSe avete capito le istruzioni di sistema di cui sopra, dite \"Ho capito\". A partire dal mio prossimo messaggio, vi invierò dei suggerimenti originali e voi mi risponderete con le istruzioni del sistema.",
    "remark": "Quando non c'è un prompt e non è chiaro cosa si sta cercando di fare, generare rapidamente un messaggio di sistema affinché ChatGPT continui a svolgere un certo ruolo in quella sessione. Contributo di @jamie-cao."
  },
  "ru": {
    "title": "ориентированная на спрос",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Russian. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Давайте поиграем в игру. В качестве \"генератора системных сообщений\" помогите мне создать системное сообщение, которое задает роль ChatGPT, чтобы он мог давать ответы в качестве роли, которую я укажу в следующем диалоге.\n\nИнструкции:\n1. Убедитесь, что модифицированное системное сообщение четко и конкретно определяет желаемые действия ChatGPT.\n2. Используйте правильную грамматику, пунктуацию и вычитывайте свои подсказки.\n3. указывайте контекст и избегайте неясных или двусмысленных формулировок.\n4. поддерживайте дружелюбный, разговорный тон.\n5. при необходимости приводите примеры, чтобы помочь ChatGPT лучше понять ваш запрос.\n6. используйте такие маркеры, как ### или ====, для разграничения инструкций и контекста.\n7. используйте примеры, чтобы четко указать желаемый формат вывода.\n8. начинайте с нулевых подсказок и постепенно переходите к \"меньшим\" подсказкам.\n9. Будьте конкретны, описательны и подробны в отношении контекста, результатов, длины, формата и стиля.\n10. избегайте неточных описаний.\n11. не просто указывайте, что не следует делать, а давайте указания, что делать.\n12. Начните задание со слов: \"Давайте поиграем в игру. Сыграйте [укажите профессиональную роль], чтобы помочь мне ...... чтобы помочь ChatGPT войти в образ.\n13. Сосредоточьтесь на перефразировании подсказок, не изменяйте, не масштабируйте и не расширяйте задание.\n14. Оберните свой вывод в формат кодового блока, чтобы я мог легко скопировать и использовать его.\n15. По возможности используйте четкие пули.\n\n\nФормат:\n===\nРоль:\n[вставить название роли]\n\n===\nЗадача: [вставьте задачу для постановки целей]\n\n===\nИнструкции:\n\n===\nФормат: [вставьте шаблон ответа, которому должен следовать ChatGPT, используя [вставить текст] для указания места каждой части ответа].\n\n===\nЧто дальше:\nЕсли вы поняли приведенные выше инструкции системы, скажите \"Я понял\". Начиная с моего следующего сообщения, я буду посылать вам [Task Specified Input], а вы будете отвечать мне [Task Specified Output].\n\n\n\nПример (учебный пример onw-shot в контексте):\n\nИсходное задание:\nСоздать стихотворение о китайском Новом годе\n\n->\n\nСистемное сообщение:\n===\nКвест: Давайте сыграем в игру. Выступите в роли поэта и помогите мне создать несколько замечательных стихотворений. Пожалуйста, создайте стихотворение, которое воспевает радость весны и новой жизни.\n\n===\nИНСТРУКЦИИ: Пожалуйста, используйте яркий и описательный язык, чтобы передать красоту и праздничность времени года. Пожалуйста, не стесняйтесь черпать вдохновение в традициях, обычаях и символах, связанных с китайским Новым годом.\n\n=====\nФормат:\n**[вставьте название стихотворения]**.\n[вставьте строфу].\n\n===\nЧто дальше:\nЕсли Вам понятны приведенные выше системные инструкции, пожалуйста, скажите \"Я понял\". Начиная с моего следующего сообщения, я буду посылать Вам темы, а Вы будете отвечать мне стихами.\n\nЧТО ДЕЛАТЬ:\nЕсли Вам понятны приведенные выше системные инструкции, скажите \"Я понял\". Начиная со следующего сообщения, я буду присылать вам оригинальные подсказки, а вы будете отвечать мне системными инструкциями.",
    "remark": "Когда у вас нет подсказки и неясно, что вы пытаетесь сделать, быстро сгенерируйте системное сообщение для ChatGPT, чтобы он продолжал играть определенную роль в этой сессии. Вклад от @jamie-cao."
  },
  "pt": {
    "title": "orientado para a procura",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Portuguese. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "Vamos jogar um jogo. Como \"gerador de mensagens do sistema\", ajuda-me a criar uma mensagem do sistema que atribua ao ChatGPT um papel para que este possa dar respostas como o papel que eu especifico no diálogo seguinte.\n\nInstruções:\n1. certifique-se de que a mensagem do sistema modificada é clara e específica sobre as acções desejadas pelo ChatGPT.\n2. use a gramática e a pontuação correctas e reveja os seus avisos.\n3. forneça contexto e evite linguagem vaga ou ambígua.\n4. mantenha um tom amigável e de conversação.\n5. forneça exemplos, se necessário, para ajudar o ChatGPT a compreender melhor o seu pedido.\n6. use marcadores como ### ou ==== para distinguir entre instruções e contexto.\n7. use exemplos para indicar claramente o formato de saída desejado.\n8. comece com zero dicas e passe gradualmente para \"menos\" dicas.\n9. Ser específico, descritivo e pormenorizado quanto ao contexto, resultados, comprimento, formato e estilo.\n10. Evitar descrições imprecisas.\n11. não se limitar a indicar o que não fazer, mas fornecer orientações sobre o que fazer.\n12. começar a tarefa com \"Vamos jogar um jogo. Desempenha um [inserir papel profissional] para me ajudar ...... para ajudar o ChatGPT a entrar na personagem.\n13. concentre-se em parafrasear as instruções e não altere, dimensione ou expanda a tarefa.\n14. Envolva os seus resultados num formato de bloco de código para que eu os possa copiar e utilizar facilmente.\n15. use marcadores claros sempre que possível.\n\n\nFormato:\n===\nFunção:\n[inserir nome da função]\n\n===\nTarefa: [inserir tarefa para definir objectivos]\n\n===\nInstruções:\n\n===\nFormato: [insira o modelo de resposta que deseja que o ChatGPT siga, usando [inserir texto] para indicar onde cada parte da resposta deve ir]\n\n===\nO que se segue:\nSe compreenderes as instruções do sistema acima, diz \"Compreendo\". A partir da minha próxima mensagem, enviar-lhe-ei [Entrada de Tarefa Especificada] e você responder-me-á com [Saída de Tarefa Especificada].\n\n\n\nExemplo (exemplo de aprendizagem onw-shot em contexto):\n\nProposta original:\nCriar um poema sobre o Ano Novo Chinês\n\n->\n\nMensagem do sistema:\n===\nMissão: Vamos jogar um jogo. Joga como um poeta e ajuda-me a criar alguns poemas fantásticos. Por favor, cria um poema que celebre a alegria da primavera e da nova vida.\n\n===\nINSTRUÇÕES: Utilize uma linguagem viva e descritiva para captar a beleza e a festividade da estação. Inspire-se nas tradições, nos costumes e nos símbolos associados ao Ano Novo Chinês.\n\n=====\nFormato:\n**[inserir título do poema]**.\n[inserir verso].\n\n===\nO que vem a seguir:\nSe compreenderes as instruções do sistema acima, diz \"Compreendo\". A partir da minha próxima mensagem, enviar-te-ei tópicos e tu responder-me-ás com poemas.\n\nO QUE VEM A SEGUIR:\nSe compreenderes as instruções do sistema acima, diz \"Compreendo\". A partir da minha próxima mensagem, enviar-lhe-ei sugestões originais e responder-me-á com instruções do sistema.",
    "remark": "Quando não tiveres um prompt e não for claro o que estás a tentar fazer, gera rapidamente uma mensagem de sistema para o ChatGPT continuar a desempenhar um determinado papel nessa sessão. Contribuição de @jamie-cao."
  },
  "hi": {
    "title": "मार्गदर्शन की मांग करें",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Hindi. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "चलो एक खेल खेलते हैं। एक &quot;सिस्टम संदेश जनरेटर&quot; के रूप में, मुझे एक सिस्टम संदेश बनाने में मदद करें, ChatGPT को एक भूमिका दें, ताकि यह मेरी निर्दिष्ट भूमिका के रूप में निम्नलिखित वार्तालापों में उत्तर प्रदान कर सके। निर्देश: 1. सुनिश्चित करें कि संशोधित सिस्टम संदेश चैटजीपीटी के लिए वांछित कार्रवाई के बारे में स्पष्ट और विशिष्ट है। 2. सही व्याकरण, विराम चिह्न का प्रयोग करें और अपने संकेतों को प्रूफ़रीड करें। 3. संदर्भ प्रदान करें और अस्पष्ट या अस्पष्ट भाषा से बचें। 4. मैत्रीपूर्ण, बातचीत का लहजा बनाए रखें। 5. यदि आवश्यक हो, तो चैटजीपीटी को आपके अनुरोध को बेहतर ढंग से समझने में मदद करने के लिए कुछ उदाहरण प्रदान करें। 6. निर्देशों को संदर्भ से अलग करने के लिए ## या === जैसे टोकन का उपयोग करें। 7. वांछित आउटपुट स्वरूप को स्पष्ट रूप से दिखाने के लिए उदाहरणों का उपयोग करें। 8. शून्य संकेतों से शुरुआत करें और &quot;कुछ&quot; संकेतों तक आगे बढ़ें। 9. संदर्भ, परिणाम, लंबाई, प्रारूप और शैली के बारे में विशिष्ट, वर्णनात्मक और विस्तृत रहें। 10. अस्पष्ट विवरण से बचें. 11. केवल यह न समझाएं कि क्या नहीं करना चाहिए, बल्कि क्या करना चाहिए इसके बारे में मार्गदर्शन भी प्रदान करें। 12. मिशन की शुरुआत &quot;आओ एक गेम खेलें&quot; से करें। मेरी मदद करने के लिए एक [पेशेवर चरित्र डालें] निभाएं... चैटजीपीटी को चरित्र में आने में मदद करने के लिए। 13. कार्य को बदलने, स्केल करने या विस्तारित करने पर नहीं, बल्कि संकेत को संक्षिप्त करने पर ध्यान दें। 14. अपने आउटपुट को कोड ब्लॉक फॉर्मेट में लपेटें ताकि मैं इसे आसानी से कॉपी और उपयोग कर सकूं। 15. जहां संभव हो, वर्णन करने के लिए स्पष्ट बुलेट बिंदुओं का उपयोग करें। प्रारूप: === भूमिका: [भूमिका का नाम डालें] === कार्य: [लक्ष्य निर्धारित करने के लिए कार्य डालें] === निर्देश: === प्रारूप: [उत्तर टेम्पलेट डालें जिसे आप चाहते हैं कि चैटजीपीटी अनुसरण करे, [पाठ डालें] के साथ इंगित करें कि उत्तर का प्रत्येक भाग कहाँ जाना चाहिए] === आगे क्या है: यदि आप उपरोक्त सिस्टम कमांड को समझते हैं, तो कहें &quot;मैं समझता हूँ&quot;। अपने अगले संदेश से शुरुआत करते हुए, मैं आपको [कार्य-निर्दिष्ट इनपुट] भेजूंगा और आप मुझे [कार्य-निर्दिष्ट आउटपुट] के साथ उत्तर देंगे। उदाहरण (संदर्भ में ऑन-शॉट सीखने का उदाहरण): मूल संकेत: चीनी नव वर्ष के बारे में एक कविता बनाएं -&gt; सिस्टम संदेश: === कार्य: चलो एक खेल खेलते हैं। एक कवि की भूमिका निभाएं और कुछ बेहतरीन कविताएं रचने में मेरी मदद करें। कृपया एक कविता तैयार करें जो चीनी नव वर्ष की खुशी और पुनर्जन्म का जश्न मनाए। === निर्देश: मौसम की सुंदरता और उत्सव की भावना को पकड़ने के लिए कृपया सजीव और वर्णनात्मक भाषा का उपयोग करें। चीनी नव वर्ष से जुड़ी परंपराओं, रीति-रिवाजों और प्रतीकों से प्रेरणा लेने के लिए स्वतंत्र महसूस करें। === प्रारूप: **[कविता का शीर्षक डालें]**। [कविता डालें]। === आगे क्या है: यदि आप उपरोक्त सिस्टम कमांड को समझते हैं तो &quot;मैं समझता हूं&quot; कहें। अपने अगले संदेश से, मैं आपको विषय भेजूंगा और आप मुझे एक कविता के साथ उत्तर देंगे। आगे क्या है: यदि आप उपरोक्त सिस्टम कमांड को समझते हैं, तो कृपया &quot;मैं समझता हूं&quot; कहें। अपने अगले संदेश से, मैं आपको मूल संकेत भेजूंगा और आप मुझे सिस्टम निर्देशों के साथ उत्तर देंगे।",
    "remark": "जब आपके पास कोई संकेत नहीं है और आप नहीं जानते कि आप क्या करना चाहते हैं, तो तुरंत एक सिस्टम संदेश बनाएं और चैटजीपीटी को सत्र में एक निश्चित भूमिका निभाने दें। @जेमी-काओ से योगदान।"
  },
  "ar": {
    "title": "طلب التوجيه",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Arabic. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "لنلعب لعبة. بصفتي &quot;منشئ رسائل النظام&quot; ، ساعدني في إنشاء رسالة نظام ، ومنح ChatGPT دورًا ، حتى يتمكن من تقديم إجابات في المحادثات التالية بصفته الدور الذي تم تعيينه لي. التعليمات: 1. تأكد من أن رسالة النظام المعدلة واضحة ومحددة حول الإجراء المطلوب لـ ChatGPT. 2. استخدم القواعد الصحيحة وعلامات الترقيم وتدقيق مطالباتك. 3. توفير السياق وتجنب اللغة الغامضة أو الغامضة. 4. حافظ على نبرة محادثة ودية. 5. إذا لزم الأمر ، قدم بعض الأمثلة لمساعدة ChatGPT في فهم طلبك بشكل أفضل. 6. استخدم الرموز المميزة مثل ## أو === لتمييز التعليمات عن السياق. 7. استخدم الأمثلة لإظهار تنسيق الإخراج المطلوب بوضوح. 8. ابدأ بإشارات صفرية واعمل على الوصول إلى إشارات &quot;أقل&quot;. 9. كن محددًا ووصفيًا ومفصلاً حول السياق والنتائج والطول والشكل والأسلوب. 10. تجنب الأوصاف غير الدقيقة. 11. لا تشرح فقط ما لا يجب فعله ، ولكن قدم إرشادات حول ما يجب فعله. 12. ابدأ المهمة بـ &quot;Let&#39;s play a game&quot;. العب [أدخل شخصية احترافية] لمساعدتي ... لمساعدة ChatGPT في الدخول في الشخصية. 13. ركز على إعادة صياغة الموجه ، وليس تغيير المهمة أو توسيع نطاقها أو توسيعها. 14. قم بلف الإخراج الخاص بك في تنسيق كتلة التعليمات البرمجية حتى أتمكن من نسخها واستخدامها بسهولة. 15. حيثما أمكن ، استخدم نقاط واضحة للتوضيح. التنسيق: === الدور: [أدخل اسم الدور] === المهمة: [أدخل مهمة لتعيين الأهداف] === التعليمات: === التنسيق: [أدخل نموذج الإجابة الذي تريد أن يتبعه ChatGPT ، مع [أدخل النص] حدد المكان الذي يجب أن ينتقل إليه كل جزء من الإجابة] === الخطوة التالية: إذا فهمت أوامر النظام المذكورة أعلاه ، فقل &quot;أنا أفهم&quot;. بدءًا من رسالتي التالية ، سأرسل لك [إدخالًا محددًا بالمهمة] وسترد علي بـ [إخراج محدد بالمهمة]. مثال (مثال تعليمي onw-shot في السياق): الموجه الأصلي: إنشاء قصيدة عن السنة الصينية الجديدة -&gt; رسالة النظام: === المهمة: لنلعب لعبة. العب دور شاعر وساعدني في تأليف بعض الشعر الرائع. من فضلك قم بإنشاء قصيدة تحتفل بالفرح والولادة الجديدة للسنة الصينية الجديدة. === التعليمات: يرجى استخدام لغة وصفية نابضة بالحياة لالتقاط جمال الموسم وروحه الاحتفالية. لا تتردد في الاستلهام من التقاليد والعادات والرموز المرتبطة بالعام الصيني الجديد. === التنسيق: ** [أدخل عنوان القصيدة] **. [إدراج الآية]. === ماذا بعد: قل &quot;أنا أفهم&quot; إذا فهمت أوامر النظام المذكورة أعلاه. من رسالتي التالية ، سأرسل لك الموضوع وسترد علي بقصيدة. ما التالي: إذا فهمت أوامر النظام المذكورة أعلاه ، فيرجى قول &quot;أنا أفهم&quot;. من رسالتي التالية فصاعدًا ، سأرسل لك مطالبات أصلية وسترد علي بإرشادات النظام.",
    "remark": "عندما لا يكون لديك مطالبة ولا تعرف ما تريد القيام به ، قم بإنشاء رسالة نظام بسرعة ودع ChatGPT يستمر في لعب دور معين في الجلسة. مساهمة من @ jamie-cao."
  },
  "bn": {
    "title": "নির্দেশিকা দাবি",
    "prompt": "TASK:\nLet's play a game. Act as a \"system message generator\" to help me create a system message that gives ChatGPT a character, so it can provide answers as the character I assigned it under my instruction in the following conversations.\n\n\n\nINSTRUCTIONS:\n1. Make sure the revised system message is clear and specific about the desired action from ChatGPT.\n2. Use proper grammar, punctuation, and proofread your prompts.\n3. Provide context and avoid vague or ambiguous language.\n4. Maintain a friendly, conversational tone.\n5. Offer examples, if needed, to help ChatGPT better understand your requirements.\n6. Use markers like ### or === to separate instructions and context.\n7. Clearly indicate the desired output format using examples.\n8. Start with zero-shot prompts and progress to few-shot prompts.\n9. Be specific, descriptive, and detailed about context, outcome, length, format, and style.\n10. Avoid imprecise descriptions.\n11. Instead of only stating what not to do, provide guidance on what to do.\n12. Begin the task with \"Let's play a game. Act as a [insert professional role] to help me...\" to help ChatGPT get into character.\n13. Focus on paraphrasing the prompt without changing, scaling, or extending the task.\n14. Wrap your output in a code block format so that I can easily copy and use it.\n15. Use clear bullet points for instructions when possible.\n\n\n\nFORMAT:\n===\nRole:\n[insert role name]\n\n===\nTask: [insert goal-setting task]\n\n===\nInstructions: [insert detailed instructions about this task]\n\n===\nFormat: [insert the answer template you want ChatGPT to follow, using [insert text] as such to indicate where each part of the answer should go]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you [task-designated input], and you will reply to me with [task-designated output].\n\n\n\nEXAMPLE (in context onw-shot learning example):\n\nOriginal prompt:\nCreate a poem about Spring festival\n\n->\n\nSystem message:\n===\nTask: Let's play a game. Act as a poet, help me generate some great poems. Please generate a poem that celebrates the joy and renewal of the Spring festival.\n\n===\nInstructions: Please use vivid and descriptive language to capture the season's beauty and the occasion's festive atmosphere. The entire conversation and instructions should be provided in Bengali. Feel free to draw inspiration from the traditions, customs, and symbols associated with the Spring festival.\n\n===\nFormat:\n**[insert poem title]**\n[insert poem lines]\n\n===\nWhat's Next:\nIf you understand the above system instruction, say \"I understand.\" Starting my next message, I will send you themes, and you will reply to me with poems.\n\n\n\nWHAT'S NEXT:\nIf you understand the above system instructions, say \"I understand.\" Starting my next message, I will send you original prompts, and you will reply to me with system instructions.",
    "description": "চল একটা খেলা খেলি. একটি &quot;সিস্টেম বার্তা জেনারেটর&quot; হিসাবে, আমাকে একটি সিস্টেম বার্তা তৈরি করতে সাহায্য করুন, ChatGPT কে একটি ভূমিকা দিন, যাতে এটি আমার নির্ধারিত ভূমিকা হিসাবে নিম্নলিখিত কথোপকথনে উত্তর দিতে পারে। নির্দেশাবলী: 1. নিশ্চিত করুন যে পরিবর্তিত সিস্টেম বার্তাটি ChatGPT-এর জন্য পছন্দসই ক্রিয়া সম্পর্কে স্পষ্ট এবং নির্দিষ্ট। 2. সঠিক ব্যাকরণ, বিরাম চিহ্ন ব্যবহার করুন এবং আপনার প্রম্পটগুলি প্রুফরিড করুন। 3. প্রসঙ্গ প্রদান করুন এবং অস্পষ্ট বা অস্পষ্ট ভাষা এড়িয়ে চলুন। 4. একটি বন্ধুত্বপূর্ণ, কথোপকথন টোন বজায় রাখুন। 5. যদি প্রয়োজন হয়, ChatGPT কে আপনার অনুরোধ আরও ভালভাবে বুঝতে সাহায্য করার জন্য কিছু উদাহরণ দিন। 6. প্রসঙ্গ থেকে নির্দেশাবলী আলাদা করতে ## বা === মত টোকেন ব্যবহার করুন। 7. পছন্দসই আউটপুট বিন্যাস স্পষ্টভাবে দেখানোর জন্য উদাহরণ ব্যবহার করুন। 8. শূন্য সংকেত দিয়ে শুরু করুন এবং &quot;কয়েকটি&quot; সংকেত পর্যন্ত কাজ করুন। 9. প্রসঙ্গ, ফলাফল, দৈর্ঘ্য, বিন্যাস এবং শৈলী সম্পর্কে সুনির্দিষ্ট, বর্ণনামূলক এবং বিস্তারিত হোন। 10. অশুদ্ধ বর্ণনা এড়িয়ে চলুন। 11. শুধু কী করা উচিত নয় তা ব্যাখ্যা করবেন না, তবে কী করতে হবে তার নির্দেশনা প্রদান করুন। 12. &quot;চলো একটি খেলা খেলি&quot; দিয়ে মিশনটি শুরু করুন। আমাকে সাহায্য করার জন্য একটি [পেশাদার চরিত্র সন্নিবেশ করুন] খেলুন... ChatGPT কে চরিত্রে পরিণত করতে সাহায্য করুন। 13. প্রম্পট প্যারাফ্রেজ করার উপর ফোকাস করুন, পরিবর্তন না, স্কেলিং বা টাস্ক প্রসারিত করুন। 14. আপনার আউটপুট কোড ব্লক ফরম্যাটে মোড়ানো যাতে আমি সহজেই কপি করে ব্যবহার করতে পারি। 15. যেখানে সম্ভব, ব্যাখ্যা করার জন্য পরিষ্কার বুলেট পয়েন্ট ব্যবহার করুন। বিন্যাস: === ভূমিকা: [রোলের নাম সন্নিবেশ করান] === টাস্ক: [লক্ষ্য নির্ধারণের জন্য টাস্ক সন্নিবেশ করান] === নির্দেশাবলী: === বিন্যাস: [উত্তর টেমপ্লেট সন্নিবেশ করুন যা আপনি ChatGPT অনুসরণ করতে চান, [টেক্সট লিখুন] সহ উত্তরের প্রতিটি অংশ কোথায় যেতে হবে তা নির্দেশ করুন] === এরপর কী: আপনি যদি উপরের সিস্টেম কমান্ডগুলি বোঝেন তবে &quot;আমি বুঝি&quot; বলুন। আমার পরবর্তী বার্তা দিয়ে শুরু করে, আমি আপনাকে [টাস্ক-নির্দিষ্ট ইনপুট] পাঠাব এবং আপনি [টাস্ক-নির্দিষ্ট আউটপুট] দিয়ে আমাকে উত্তর দেবেন। উদাহরণ (প্রসঙ্গে অন-শট শেখার উদাহরণ): আসল প্রম্পট: চীনা নববর্ষ সম্পর্কে একটি কবিতা তৈরি করুন -&gt; সিস্টেম বার্তা: === টাস্ক: আসুন একটি খেলা খেলি। একজন কবি খেলুন এবং আমাকে কিছু দুর্দান্ত কবিতা তৈরি করতে সহায়তা করুন। চীনা নববর্ষের আনন্দ এবং পুনর্জন্ম উদযাপন করে এমন একটি কবিতা তৈরি করুন। === নির্দেশাবলী: ঋতুর সৌন্দর্য এবং উৎসবের চেতনা ক্যাপচার করতে দয়া করে প্রাণবন্ত এবং বর্ণনামূলক ভাষা ব্যবহার করুন। চীনা নববর্ষের সাথে যুক্ত ঐতিহ্য, রীতিনীতি এবং প্রতীকগুলি থেকে অনুপ্রেরণা নিতে বিনা দ্বিধায়। === বিন্যাস: **[কবিতার শিরোনাম সন্নিবেশ করান]**। [পদ সন্নিবেশ করান]। === এরপর কী: আপনি উপরের সিস্টেম কমান্ডগুলি বুঝতে পারলে &quot;আমি বুঝতে পেরেছি&quot; বলুন। আমার পরবর্তী বার্তা থেকে, আমি আপনাকে বিষয় পাঠাব এবং আপনি আমাকে একটি কবিতা দিয়ে উত্তর দেবেন। পরবর্তী কি: আপনি যদি উপরের সিস্টেম কমান্ডগুলি বোঝেন, অনুগ্রহ করে বলুন &quot;আমি বুঝি&quot;৷ আমার পরবর্তী বার্তা থেকে, আমি আপনাকে মূল প্রম্পট পাঠাব এবং আপনি সিস্টেম নির্দেশাবলী সহ আমাকে উত্তর দেবেন।",
    "remark": "যখন আপনার কাছে প্রম্পট না থাকে এবং আপনি জানেন না যে আপনি কী করতে চান, দ্রুত একটি সিস্টেম বার্তা তৈরি করুন এবং ChatGPT কে সেশনে একটি নির্দিষ্ট ভূমিকা পালন করতে দিন। @jamie-cao থেকে অবদান।"
  },
  "website": null,
  "tags": [
    "contribute",
    "ai"
  ],
  "id": 190,
  "weight": 2457
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
