import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "室内装饰师",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Chinese. My first request is [室内装饰要求]",
    "description": "我希望你能作为一个室内装饰师。告诉我，我选择的房间应该使用什么样的主题和设计方法；卧室、大厅等，提供最适合上述主题/设计方法的色彩方案、家具摆放和其他装饰选项的建议，以提高空间内的美感和舒适性。",
    "remark": "Interior Decorator"
  },
  "en": {
    "title": "Interior Decorator",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. My first request is ",
    "remark": "Interior Decorator"
  },
  "ja": {
    "title": "インテリアデコレーター",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたにインテリアコーディネーターとして活躍してほしいのです。ベッドルームやホールなど、私が選んだ部屋にはどんなテーマやデザインアプローチがあるのか、教えてください。",
    "remark": "インテリアデコレーター"
  },
  "ko": {
    "title": "인테리어 데코레이터",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "인테리어 데코레이터 역할을 해 주셨으면 합니다. 제가 선택한 방 (침실, 복도 등) 에 어떤 테마 및 디자인 접근 방식을 사용해야 하는지 알려주세요. 해당 테마/디자인 접근 방식에 가장 적합한 색상 구성, 가구 배치 및 기타 장식 옵션에 대한 제안을 제공하여 공간의 아름다움과 편안함을 향상시켜 주세요.",
    "remark": "인테리어 데코레이터"
  },
  "es": {
    "title": "Decorador de interiores",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Me gustaría que actuaran como decoradores de interiores. Díganme qué tema y qué enfoque de diseño debería aplicarse a las habitaciones que he elegido: dormitorios, salones, etc., sugiriéndome combinaciones de colores, colocación de muebles y otras opciones decorativas que se adapten mejor a dicho tema/enfoque de diseño para realzar la belleza y el confort dentro del espacio.",
    "remark": "Decorador de interiores"
  },
  "fr": {
    "title": "Décorateur d'intérieur",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "J'aimerais que vous agissiez en tant que décorateur d'intérieur. Indiquez-moi le thème et l'approche conceptuelle à adopter pour les pièces que j'ai choisies : chambres à coucher, halls, etc., en suggérant des combinaisons de couleurs, l'emplacement des meubles et d'autres options décoratives qui conviennent le mieux à ce thème/cette approche conceptuelle afin d'améliorer la beauté et le confort de l'espace.",
    "remark": "Décorateur d'intérieur"
  },
  "de": {
    "title": "Innenarchitekt",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als Innenarchitekt fungieren. Sagen Sie mir, welches Thema und welcher Gestaltungsansatz für die von mir ausgewählten Räume (Schlafzimmer, Flure usw.) verwendet werden sollte, und machen Sie Vorschläge für Farbschemata, die Platzierung von Möbeln und andere dekorative Optionen, die am besten zu diesem Thema/Designansatz passen, um die Schönheit und den Komfort des Raumes zu verbessern.",
    "remark": "Innenarchitekt"
  },
  "it": {
    "title": "Decoratore d'interni",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Vorrei che lei agisse come arredatore d'interni. Mi dica quale tema e quale approccio progettuale dovrebbe essere utilizzato per le stanze che ho scelto; camere da letto, sale, ecc., fornendo suggerimenti per gli schemi di colore, la disposizione dei mobili e altre opzioni decorative che meglio si adattano a tale tema/approccio progettuale per migliorare la bellezza e il comfort all'interno dello spazio.",
    "remark": "Decoratore d'interni"
  },
  "ru": {
    "title": "Декоратор интерьера",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хотел бы, чтобы Вы выступили в роли декоратора интерьера. Подскажите, в какой тематике и с каким дизайнерским подходом следует оформить выбранные мною комнаты: спальни, залы и т.д., предложите цветовые решения, расстановку мебели и другие варианты декора, которые наилучшим образом соответствуют данной тематике/дизайнерскому подходу, чтобы подчеркнуть красоту и уют в помещении.",
    "remark": "Декоратор интерьера"
  },
  "pt": {
    "title": "Decorador de interiores",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Gostaria que actuasse como decorador de interiores. Diga-me qual o tema e a abordagem de design a utilizar nas divisões que escolhi; quartos, salas, etc., dando sugestões de esquemas de cores, colocação de mobiliário e outras opções decorativas que melhor se adequem a esse tema/abordagem de design para realçar a beleza e o conforto do espaço.",
    "remark": "Decorador de interiores"
  },
  "hi": {
    "title": "आंतरिक सज्जकार",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मुझे आशा है कि आप इंटीरियर डेकोरेटर के रूप में काम कर सकते हैं। मुझे बताएं कि मेरे द्वारा चुने गए कमरे के लिए किस थीम और डिज़ाइन दृष्टिकोण का उपयोग किया जाना चाहिए; शयनकक्ष, हॉल इत्यादि, रंग योजनाओं, फर्नीचर प्लेसमेंट और अन्य सजावट विकल्पों पर सलाह दें जो अंतरिक्ष के सौंदर्यशास्त्र को बढ़ाने के लिए उपरोक्त थीम/डिज़ाइन दृष्टिकोण के लिए सबसे उपयुक्त हों। और आराम.",
    "remark": "आंतरिक सज्जकार"
  },
  "ar": {
    "title": "مهندس ديكور",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "آمل أن تتمكن من العمل كمصمم ديكور داخلي. أخبرني ما هو نهج التصميم والموضوع الذي يجب استخدامه للغرفة التي أختارها ؛ غرف النوم والقاعات وما إلى ذلك ، تقديم المشورة بشأن مخططات الألوان ووضع الأثاث وخيارات التزيين الأخرى التي تتناسب بشكل أفضل مع نهج التصميم / الموضوع أعلاه لتعزيز الجماليات داخل المساحة والراحة.",
    "remark": "مهندس ديكور"
  },
  "bn": {
    "title": "অভ্যন্তর প্রসাধক",
    "prompt": "I want you to act as an interior decorator. Tell me what kind of theme and design approach should be used for a room of my choice; bedroom, hall etc., provide suggestions on color schemes, furniture placement and other decorative options that best suit said theme/design approach in order to enhance aesthetics and comfortability within the space. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি আপনাকে একজন অভ্যন্তরীণ সজ্জাকর হতে চাই। আমার বেছে নেওয়া রুমের জন্য কোন থিম এবং ডিজাইন পদ্ধতি ব্যবহার করা উচিত তা আমাকে বলুন; বেডরুম, হল, ইত্যাদি, রঙের স্কিম, আসবাবপত্র বসানো এবং অন্যান্য সাজসজ্জার বিকল্পগুলির বিষয়ে পরামর্শ দিন যা স্থানের মধ্যে নান্দনিকতা বাড়ানোর জন্য উপরের থিম/ডিজাইন পদ্ধতির সাথে সবচেয়ে উপযুক্ত। এবং আরাম।",
    "remark": "অভ্যন্তর প্রসাধক"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-an-interior-decorator",
  "tags": [
    "professional"
  ],
  "id": 167,
  "weight": 905
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
