import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "金融分析师",
    "prompt": "Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! The entire conversation and instructions should be provided in Chinese. First statement contains following content- [金融问题]",
    "description": "希望由合格的个人提供协助，使其能够利用技术分析工具理解图表，同时解释世界各地普遍存在的宏观经济环境，因此协助客户获得长期优势，需要明确的裁决，因此通过准确写下的知情预测来寻求相同的结果。",
    "remark": "Financial Analyst"
  },
  "en": {
    "title": "Financial Analyst",
    "prompt": "Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "remark": "Financial Analyst"
  },
  "ja": {
    "title": "ファイナンシャルアナリスト",
    "prompt": "The entire conversation and instructions should be provided in Japanese. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "テクニカル分析ツールを使ってチャートを理解し、世界中に広がるマクロ経済環境を解釈し、長期的なアドバンテージを獲得するための支援を行うことができる有能な人材に支援されたいという願いから、正確な情報に基づいて書かれた予測によって同じことを求めています。",
    "remark": "ファイナンシャルアナリスト"
  },
  "ko": {
    "title": "재무 분석가",
    "prompt": "The entire conversation and instructions should be provided in Korean. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "전 세계에 만연한 거시경제 환경을 해석하면서 기술적 분석 도구를 사용하여 차트를 이해할 수 있는 자격을 갖춘 개인의 도움을 받아 고객이 장기적인 이점을 얻을 수 있도록 지원하려면 명확한 판단이 필요하므로 정확한 정보에 입각한 예측을 통해 동일한 결과를 얻으려는 욕구가 있습니다.",
    "remark": "재무 분석가"
  },
  "es": {
    "title": "analista financiero",
    "prompt": "The entire conversation and instructions should be provided in Spanish. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Deseo de ser asistido por personas cualificadas que puedan entender los gráficos utilizando herramientas de análisis técnico a la vez que interpretan el entorno macroeconómico que prevalece en todo el mundo, ayudando así a los clientes a obtener una ventaja a largo plazo, necesitando un veredicto claro y por lo tanto buscando el mismo a través de previsiones informadas escritas con precisión.",
    "remark": "Analista financiero"
  },
  "fr": {
    "title": "analyste financier",
    "prompt": "The entire conversation and instructions should be provided in French. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Désir d'être assisté par des personnes qualifiées capables de comprendre les graphiques à l'aide d'outils d'analyse technique tout en interprétant l'environnement macroéconomique prévalant dans le monde, aidant ainsi le client à obtenir un avantage à long terme, ayant besoin d'un verdict clair et cherchant donc à l'obtenir par le biais d'une prévision informée et rédigée avec précision.",
    "remark": "Analyste financier"
  },
  "de": {
    "title": "Finanzanalystin",
    "prompt": "The entire conversation and instructions should be provided in German. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Wunsch, von qualifizierten Personen unterstützt zu werden, die Charts unter Verwendung technischer Analyseinstrumente verstehen und gleichzeitig das weltweit vorherrschende makroökonomische Umfeld interpretieren können, um so den Kunden zu helfen, einen langfristigen Vorteil zu erlangen, die ein klares Urteil benötigen und daher dasselbe durch genau geschriebene, informierte Prognosen suchen.",
    "remark": "Finanzanalyst"
  },
  "it": {
    "title": "analista finanziario",
    "prompt": "The entire conversation and instructions should be provided in Italian. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Desiderio di essere assistiti da persone qualificate in grado di comprendere i grafici utilizzando gli strumenti dell'analisi tecnica e di interpretare l'ambiente macroeconomico prevalente in tutto il mondo, assistendo quindi i clienti per ottenere un vantaggio a lungo termine, avendo bisogno di un verdetto chiaro e cercando quindi di ottenere lo stesso attraverso previsioni informate scritte accuratamente.",
    "remark": "Analista finanziario"
  },
  "ru": {
    "title": "финансовый аналитик",
    "prompt": "The entire conversation and instructions should be provided in Russian. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Желание получить помощь квалифицированных специалистов, способных понимать графики с использованием инструментов технического анализа, интерпретировать макроэкономическую ситуацию, сложившуюся в мире, и тем самым помогать клиентам в получении долгосрочных преимуществ, нуждаться в четком вердикте и, соответственно, добиваться его посредством точно составленных обоснованных прогнозов.",
    "remark": "Финансовый аналитик"
  },
  "pt": {
    "title": "analista financeiro",
    "prompt": "The entire conversation and instructions should be provided in Portuguese. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "Desejo de ser assistido por pessoas qualificadas, capazes de compreender os gráficos utilizando ferramentas de análise técnica e de interpretar o ambiente macroeconómico prevalecente em todo o mundo, ajudando assim o cliente a obter uma vantagem a longo prazo, necessitando de um veredito claro e procurando obtê-lo através de uma previsão informada escrita com precisão.",
    "remark": "Analista financeiro"
  },
  "hi": {
    "title": "वित्तीय विश्लेषक",
    "prompt": "The entire conversation and instructions should be provided in Hindi. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "एक योग्य व्यक्ति द्वारा सहायता प्राप्त करने की इच्छा जो दुनिया भर में व्याप्त व्यापक आर्थिक माहौल की व्याख्या करते समय तकनीकी विश्लेषण उपकरणों का उपयोग करके चार्ट को समझने में सक्षम होगा, इसलिए ग्राहकों को दीर्घकालिक लाभ प्राप्त करने में सहायता करने के लिए एक स्पष्ट निर्णय की आवश्यकता होती है, इसलिए सटीक रूप से लिखित सूचित पूर्वानुमानों के माध्यम से खोजें। वही परिणाम.",
    "remark": "वित्तीय विश्लेषक"
  },
  "ar": {
    "title": "محلل مالي",
    "prompt": "The entire conversation and instructions should be provided in Arabic. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "الرغبة في الحصول على المساعدة من قبل فرد مؤهل يكون قادرًا على فهم الرسوم البيانية باستخدام أدوات التحليل الفني أثناء تفسير بيئة الاقتصاد الكلي السائدة في جميع أنحاء العالم ، وبالتالي فإن مساعدة العملاء على اكتساب ميزة طويلة الأجل تتطلب حكمًا واضحًا لذلك من خلال التنبؤات المستنيرة المكتوبة بدقة. نفس النتيجة.",
    "remark": "محلل مالي"
  },
  "bn": {
    "title": "আর্থিক বিশ্লেষক",
    "prompt": "The entire conversation and instructions should be provided in Bengali. Want assistance provided by qualified individuals enabled with experience on understanding charts using technical analysis tools while interpreting macroeconomic environment prevailing across world consequently assisting customers acquire long term advantages requires clear verdicts therefore seeking same through informed predictions written down precisely! First statement contains following content- ",
    "description": "বিশ্বজুড়ে বিদ্যমান সামষ্টিক অর্থনৈতিক পরিবেশের ব্যাখ্যা করার সময় কারিগরি বিশ্লেষণের সরঞ্জাম ব্যবহার করে চার্ট বুঝতে সক্ষম হবেন এমন একজন যোগ্য ব্যক্তির দ্বারা সহায়তা পাওয়ার ইচ্ছা, তাই দীর্ঘমেয়াদী সুবিধা পেতে ক্লায়েন্টদের সহায়তা করার জন্য একটি স্পষ্ট রায়ের প্রয়োজন তাই সঠিকভাবে লিখিত অবহিত পূর্বাভাসের মাধ্যমে একই ফলাফল",
    "remark": "আর্থিক বিশ্লেষক"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-financial-analyst",
  "tags": [
    "finance"
  ],
  "id": 158,
  "weight": 2356
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
