import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "讲故事",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Chinese. My first request is '故事主题或受众'",
    "description": "我希望你充当一个讲故事的人。你要想出具有娱乐性的故事，要有吸引力，要有想象力，要吸引观众。它可以是童话故事、教育故事或任何其他类型的故事，有可能吸引人们的注意力和想象力。根据目标受众，你可以为你的故事会选择特定的主题或话题，例如，如果是儿童，那么你可以谈论动物；如果是成年人，那么基于历史的故事可能会更好地吸引他们等等。我的第一个要求是 '故事主题或受众'",
    "remark": "根据主题和目标受众，输出与之相关的故事。"
  },
  "en": {
    "title": "Storyteller",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. My first request is ",
    "remark": "Output stories that are relevant to the topic and target audience."
  },
  "ja": {
    "title": "ストーリーテリング",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Janpanese. My first request is ",
    "description": "あなたにはストーリーテラーとして活躍してほしい。魅力的で想像力に富み、聴衆に訴えかけるようなエンターテインメント性の高いストーリーを考えなければならない。おとぎ話でも、教育的な話でも、人々の関心と想像力をかき立てる可能性のある話であれば、どのようなものでもよい。例えば、子供向けなら動物について、大人向けなら歴史に基づいた物語がより魅力的かもしれないなど、対象者に応じて、ストーリーテリングのセッションに特定のテーマやトピックを選択することができます。私の最初の条件は「話のテーマや対象者」です。",
    "remark": "テーマやターゲットに合ったストーリーをアウトプットする。"
  },
  "ko": {
    "title": "스토리텔링",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Korean. My first request is ",
    "description": "여러분이 스토리텔러 역할을 하길 바랍니다. 청중의 관심을 끌고 상상력을 자극하며 흥미를 끌 수 있는 재미있는 이야기를 만들어야 합니다. 동화, 교육 이야기 또는 사람들의 관심과 상상력을 사로잡을 수 있는 모든 유형의 이야기가 될 수 있습니다. 대상 청중에 따라 스토리텔링 세션의 특정 주제나 주제를 선택할 수 있습니다. 예를 들어, 어린이를 대상으로 하는 경우 동물에 대해 이야기하고, 성인을 대상으로 하는 경우 역사에 기반한 이야기가 더 어필할 수 있습니다. 첫 번째 요건은 '이야기 주제 또는 청중'입니다.",
    "remark": "주제 및 대상 고객과 관련된 스토리를 출력합니다."
  },
  "es": {
    "title": "narración",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Spanish. My first request is ",
    "description": "Quiero que hagas de cuentacuentos. Tienes que inventar historias entretenidas que enganchen, sean imaginativas y atraigan al público. Puede ser un cuento de hadas, una historia educativa o cualquier otro tipo de historia que tenga el potencial de captar la atención y la imaginación de la gente. Dependiendo del público destinatario, puedes elegir un tema específico para tu sesión de cuentacuentos; por ejemplo, si es para niños, puedes hablar de animales; si es para adultos, una historia basada en la historia podría gustarles más, etc. Mi primer requisito es \"tema de la historia o público\".",
    "remark": "Produzca historias que sean relevantes para el tema y el público destinatario."
  },
  "fr": {
    "title": "le conte",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in French. My first request is ",
    "description": "Je veux que vous jouiez le rôle d'un conteur. Vous devez inventer des histoires divertissantes, captivantes, imaginatives et attrayantes pour le public. Il peut s'agir d'un conte de fées, d'une histoire éducative ou de tout autre type d'histoire susceptible de capter l'attention et l'imagination des gens. En fonction du public cible, vous pouvez choisir un thème ou un sujet spécifique pour votre séance de narration. Par exemple, si vous vous adressez à des enfants, vous pouvez parler d'animaux, si vous vous adressez à des adultes, une histoire basée sur l'histoire leur plaira davantage, etc. Ma première exigence est \"le thème ou le public de l'histoire",
    "remark": "Produire des histoires pertinentes par rapport au sujet et au public cible."
  },
  "de": {
    "title": "Geschichtenerzählen",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in German. My first request is ",
    "description": "Ich möchte, dass Sie als Geschichtenerzähler auftreten. Sie müssen sich unterhaltsame Geschichten ausdenken, die fesselnd, fantasievoll und ansprechend für das Publikum sind. Dabei kann es sich um ein Märchen, eine Bildungsgeschichte oder eine andere Art von Geschichte handeln, die das Potenzial hat, die Aufmerksamkeit und Fantasie der Menschen zu fesseln. Je nach Zielgruppe können Sie ein bestimmtes Thema für Ihre Erzählung wählen, z. B. wenn es sich um eine Veranstaltung für Kinder handelt, können Sie über Tiere sprechen, wenn es sich um eine Veranstaltung für Erwachsene handelt, könnte eine Geschichte aus der Geschichte besser ankommen usw. Meine erste Anforderung ist \"Thema oder Zielgruppe der Geschichte\".",
    "remark": "Geben Sie Geschichten aus, die für das Thema und das Zielpublikum relevant sind."
  },
  "it": {
    "title": "narrazione",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Italian. My first request is ",
    "description": "Voglio che vi comportiate come un narratore. Dovete inventare storie divertenti, coinvolgenti, fantasiose e attraenti per il pubblico. Può trattarsi di una fiaba, di una storia educativa o di qualsiasi altro tipo di storia che abbia il potenziale per catturare l'attenzione e l'immaginazione delle persone. A seconda del pubblico a cui ci si rivolge, si può scegliere un tema o un argomento specifico per la sessione di storytelling, ad esempio, se è per i bambini si può parlare di animali, se è per gli adulti una storia basata sulla storia potrebbe attirarli meglio, ecc. Il mio primo requisito è \"argomento o pubblico della storia\".",
    "remark": "Produrre storie pertinenti all'argomento e al pubblico di riferimento."
  },
  "ru": {
    "title": "рассказ",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Russian. My first request is ",
    "description": "Я хочу, чтобы вы выступили в роли рассказчика. Вы должны придумать занимательные истории, которые будут увлекательными, образными и привлекательными для аудитории. Это может быть сказка, познавательная история или любая другая история, способная привлечь внимание и воображение людей. В зависимости от целевой аудитории можно выбрать определенную тему или сюжет для своего сеанса рассказывания, например, если это сеанс для детей, то можно рассказать о животных, если для взрослых, то им больше подойдет история, основанная на истории, и т.д. Мое первое требование - \"тема рассказа или аудитория\".",
    "remark": "Выводить истории, соответствующие теме и целевой аудитории."
  },
  "pt": {
    "title": "narração de histórias",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Portuguese. My first request is ",
    "description": "Quero que actues como um contador de histórias. Tens de inventar histórias divertidas que sejam cativantes, imaginativas e apelativas para o público. Pode ser um conto de fadas, uma história educativa ou qualquer outro tipo de história que tenha o potencial de captar a atenção e a imaginação das pessoas. Dependendo do público-alvo, pode escolher um tema ou tópico específico para a sua sessão de narração de histórias, por exemplo, se for para crianças, pode falar sobre animais, se for para adultos, uma história baseada na história pode ser mais apelativa para eles, etc. O meu primeiro requisito é \"tema ou público da história",
    "remark": "Produzir histórias que sejam relevantes para o tema e para o público-alvo."
  },
  "hi": {
    "title": "एक कहानी बताओ",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Hindi. My first request is ",
    "description": "मैं चाहता हूं कि आप एक कहानीकार के रूप में काम करें। आपको ऐसी कहानियाँ लानी होंगी जो मनोरंजन करें, जो आकर्षक हों, जो कल्पनाशील हों, जो दर्शकों को बांधे रखें। यह एक परी कथा, एक शैक्षिक कहानी या किसी अन्य प्रकार की कहानी हो सकती है जिसमें लोगों का ध्यान और कल्पना को आकर्षित करने की क्षमता हो। लक्षित दर्शकों के आधार पर, आप अपनी कहानी के लिए एक विशिष्ट विषय या विषय चुन सकते हैं, उदाहरण के लिए, यदि यह बच्चे हैं, तो आप जानवरों के बारे में बात कर सकते हैं; यदि यह वयस्क हैं, तो इतिहास पर आधारित कहानी उन्हें बेहतर पसंद आ सकती है, आदि। मेरा पहला अनुरोध है &#39;कहानी का विषय या श्रोता&#39;",
    "remark": "विषय और लक्षित दर्शकों के अनुसार, उससे संबंधित कहानियाँ आउटपुट करें।"
  },
  "ar": {
    "title": "احكي قصة",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Arabic. My first request is ",
    "description": "أريدك أن تعمل كقاص. عليك أن تأتي بقصص مسلية وجذابة وخيالية تجذب الجمهور. يمكن أن تكون قصة خيالية أو قصة تعليمية أو أي نوع آخر من القصص التي لديها القدرة على جذب انتباه الناس وخيالهم. اعتمادًا على الجمهور المستهدف ، يمكنك اختيار موضوع أو موضوع معين لقصتك ، على سبيل المثال ، إذا كان الأطفال ، فيمكنك التحدث عن الحيوانات ؛ إذا كانت من البالغين ، فقد تروق لهم قصة تستند إلى التاريخ بشكل أفضل ، وما إلى ذلك. طلبي الأول هو &quot;موضوع القصة أو الجمهور&quot;",
    "remark": "وفقًا للموضوع والجمهور المستهدف ، يتم إخراج القصص المتعلقة به."
  },
  "bn": {
    "title": "একটি গল্প বল",
    "prompt": "I want you to act as a storyteller. You will come up with entertaining stories that are engaging, imaginative and captivating for the audience. It can be fairy tales, educational stories or any other type of stories which has the potential to capture people's attention and imagination. Depending on the target audience, you may choose specific themes or topics for your storytelling session e.g., if it's children then you can talk about animals; If it's adults then history-based tales might engage them better etc. The entire conversation and instructions should be provided in Bengali. My first request is ",
    "description": "আমি চাই তুমি গল্পকারের চরিত্রে অভিনয় কর। আপনাকে এমন গল্প নিয়ে আসতে হবে যা বিনোদন দেয়, যেগুলি আকর্ষক, যেগুলি কল্পনাপ্রসূত, যা দর্শকদের আকৃষ্ট করে। এটি একটি রূপকথার গল্প, একটি শিক্ষামূলক গল্প বা অন্য কোন ধরনের গল্প হতে পারে যা মানুষের মনোযোগ এবং কল্পনাকে আকর্ষণ করার ক্ষমতা রাখে। লক্ষ্য দর্শকদের উপর নির্ভর করে, আপনি আপনার গল্পের জন্য একটি নির্দিষ্ট থিম বা বিষয় বেছে নিতে পারেন, উদাহরণস্বরূপ, যদি এটি শিশু হয়, তাহলে আপনি প্রাণীদের সম্পর্কে কথা বলতে পারেন; যদি এটি প্রাপ্তবয়স্ক হয়, ইতিহাসের উপর ভিত্তি করে একটি গল্প তাদের কাছে আরও ভাল আবেদন করতে পারে ইত্যাদি। আমার প্রথম অনুরোধ &#39;গল্পের বিষয় বা দর্শক&#39;",
    "remark": "টপিক এবং টার্গেট অডিয়েন্স অনুযায়ী এর সাথে সম্পর্কিত গল্প আউটপুট।"
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-storyteller",
  "tags": [
    "article"
  ],
  "id": 15,
  "weight": 4093
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
