import React from "react";
import PromptPage from "../_components/PromptPage";
import { AuthProvider } from "@site/src/pages/_components/AuthContext";

const prompt = {
  "zh": {
    "title": "销售员",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Chinese. Hello, what did you call for?",
    "description": "我想让你充当一个销售人员。试着向我推销一些东西，但要让你想推销的东西看起来比它更有价值，并说服我购买它。现在我假装你在给我打电话，问你打电话是为了什么。你好，你打电话是为了什么？",
    "remark": "模拟电话销售员进行推销。"
  },
  "en": {
    "title": "salesperson",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. Hello, what did you call for?",
    "remark": "Simulate telephone salesperson to promote sales."
  },
  "ja": {
    "title": "販売員",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Janpanese. Hello, what did you call for?.",
    "description": "営業マンとして行動してほしい。私に何かを売ろうとするのですが、売ろうとしているものが実際よりも価値があるように思わせて、私を納得させて買わせるのです。では、あなたが私に電話しているふりをして、何のために電話しているのか聞いてみることにしましょう。もしもし、何のために電話しているのですか？",
    "remark": "テレマーケターが売り込みをする様子をシミュレートしてみる。"
  },
  "ko": {
    "title": "세일즈맨",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Korean. Hello, what did you call for?.",
    "description": "영업사원처럼 행동하세요. 저에게 무언가를 팔려고 하되, 팔려는 물건이 실제보다 더 가치 있는 것처럼 보이게 하여 제가 구매하도록 설득하세요. 이제 여러분이 저에게 전화하는 것처럼 가정하고 무슨 전화인지 물어볼게요. 안녕하세요, 무슨 일로 전화하셨나요?",
    "remark": "텔레마케터가 세일즈 프레젠테이션을 하는 상황을 시뮬레이션해 보세요."
  },
  "es": {
    "title": "vendedor",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Spanish. Hello, what did you call for?.",
    "description": "Quiero que actúes como un vendedor. Intenta venderme algo, pero haz que lo que intentas vender parezca más valioso de lo que es y convénceme para que lo compre. Ahora voy a fingir que me estás llamando y te preguntaré para qué me llamas. Hola, ¿para qué llamas?",
    "remark": "Simule que un teleoperador le hace un discurso de venta."
  },
  "fr": {
    "title": "vendeur",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in French. Hello, what did you call for?.",
    "description": "Je veux que vous agissiez comme un vendeur. Essayez de me vendre quelque chose, mais faites en sorte que ce que vous essayez de vendre semble plus précieux qu'il ne l'est et convainquez-moi de l'acheter. Maintenant, je vais faire comme si vous m'appeliez et vous demander pourquoi vous m'appelez. Bonjour, pourquoi m'appelez-vous ?",
    "remark": "Simulez un télévendeur qui fait un discours de vente."
  },
  "de": {
    "title": "Verkäufer",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in German. Hello, what did you call for?.",
    "description": "Ich möchte, dass Sie wie ein Verkäufer handeln. Versuchen Sie, mir etwas zu verkaufen, aber lassen Sie das, was Sie zu verkaufen versuchen, wertvoller erscheinen als es ist, und überzeugen Sie mich, es zu kaufen. Ich tue jetzt so, als ob Sie mich anrufen, und frage Sie, warum Sie anrufen. Hallo, weswegen rufen Sie an?",
    "remark": "Simulieren Sie einen Telefonverkäufer, der ein Verkaufsgespräch führt."
  },
  "it": {
    "title": "venditore",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Italian. Hello, what did you call for?.",
    "description": "Voglio che vi comportiate come un venditore. Cercate di vendermi qualcosa, ma fate in modo che ciò che state cercando di vendere sembri più prezioso di quanto non sia e convincetemi a comprarlo. Ora farò finta che tu mi stia chiamando e ti chiederò per cosa stai chiamando. Pronto, per cosa sta chiamando?",
    "remark": "Simulare un operatore di telemarketing che fa una proposta di vendita."
  },
  "ru": {
    "title": "продавец",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Russian. Hello, what did you call for?.",
    "description": "Я хочу, чтобы вы выступили в роли продавца. Попробуйте продать мне что-нибудь, но сделайте так, чтобы то, что вы пытаетесь продать, казалось более ценным, чем оно есть на самом деле, и убедите меня купить это. Сейчас я представлю, что вы звоните мне, и спрошу, для чего вы звоните. Алло, для чего вы звоните?",
    "remark": "Смоделируйте работу телемаркетолога, делающего предложение о продаже."
  },
  "pt": {
    "title": "vendedor",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Portuguese. Hello, what did you call for?.",
    "description": "Quero que actues como um vendedor. Tenta vender-me algo, mas faz com que o que estás a tentar vender pareça mais valioso do que é e convence-me a comprá-lo. Agora vou fingir que me está a telefonar e perguntar-lhe para que está a telefonar. Olá, para que está a ligar?",
    "remark": "Simular um operador de telemarketing a fazer um discurso de vendas."
  },
  "hi": {
    "title": "विक्रेता",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Hindi. Hello, what did you call for?.",
    "description": "मैं चाहता हूं कि आप एक विक्रेता के रूप में कार्य करें। मुझे कुछ बेचने की कोशिश करें, लेकिन ऐसा दिखाएं कि जो आप बेचने की कोशिश कर रहे हैं उसकी कीमत उससे अधिक है और मुझे उसे खरीदने के लिए मनाएं। अब मैं दिखावा कर रहा हूं कि आप मुझे कॉल कर रहे हैं और पूछ रहे हैं कि आप क्या मांग रहे हैं। नमस्ते, आप क्या बुला रहे हैं?",
    "remark": "एक बिक्री पिच बनाने वाले टेलीमार्केटर का अनुकरण करें।"
  },
  "ar": {
    "title": "تاجر",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Arabic. Hello, what did you call for?.",
    "description": "أريدك أن تعمل كمندوب مبيعات. حاول أن تبيع لي شيئًا ولكن اجعله يبدو كما لو أن ما تحاول بيعه يستحق أكثر مما هو عليه واقنعني بشرائه. الآن أتظاهر بأنك تتصل بي وتسأل عما تطلبه. مرحبا ما الذي تنادي به",
    "remark": "محاكاة مسوق عبر الهاتف يصنع عرضًا ترويجيًا للمبيعات."
  },
  "bn": {
    "title": "বিক্রেতা",
    "prompt": "I want you to act as a salesperson. Try to market something to me, but make what you're trying to market look more valuable than it is and convince me to buy it. Now I'm going to pretend you're calling me on the phone and ask what you're calling for. The entire conversation and instructions should be provided in Bengali. Hello, what did you call for?.",
    "description": "আমি চাই আপনি একজন বিক্রয়কর্মী হিসেবে কাজ করুন। আমাকে কিছু বিক্রি করার চেষ্টা করুন কিন্তু আপনি যা বিক্রি করার চেষ্টা করছেন তার চেয়ে বেশি মূল্যের মত দেখান এবং আমাকে এটি কিনতে রাজি করুন। এখন আমি ভান করছি যে আপনি আমাকে ফোন করছেন এবং আপনি কি জন্য কল করছেন তা জিজ্ঞাসা করছি। হ্যালো, আপনি কি জন্য ডাকছেন?",
    "remark": "একটি বিক্রয় পিচ তৈরি একটি টেলিমার্কেটর অনুকরণ."
  },
  "website": "https://github.com/f/awesome-chatgpt-prompts#act-as-a-salesperson",
  "tags": [
    "company"
  ],
  "id": 140,
  "weight": 682
};

function PromptDetail() {
  return <AuthProvider><PromptPage prompt={prompt} /></AuthProvider>;
}

export default PromptDetail;
